<?php
/**
 * Description: It's a fallback archive template.
 *
 * @package WordPress
 * @subpackage tnc_infinity
 * @since TNC Infinity 1.0
 */
get_header();

if( !empty( esc_html( get_theme_mod( 'tncinf_selected_archive_page_template' ) ) ) ) {
  $tncinf_selected_archive_page_template = esc_html( get_theme_mod( 'tncinf_selected_archive_page_template', 'archive_page_without_sidebar' ) );

  switch ( $tncinf_selected_archive_page_template ) {
    case "archive_page_without_sidebar":
      get_template_part('template-parts/content', 'archive');
      break;
    case "archive_page_with_right_sidebar":
      get_template_part('template-parts/content', 'archive-sidebar');
      break;
    default:
    get_template_part('template-parts/content', 'archive');
  }
} else {
  get_template_part('template-parts/content', 'archive');
}

get_footer(); 

?>