<?php
/**
 * Description: It's a 404 page template.
 *
 * @package WordPress
 * @subpackage tnc_infinity
 * @since TNC Infinity 1.0
 */
get_header();
$tncinf_common_page_template_parts = new ClassCommonPageTemplateParts();
?>


<div class="tncinf-blog-page-banner-wrapper">  
  <?php echo $tncinf_common_page_template_parts->tncinf_full_width_banner_with_search_form('404'); ?>
</div>

<div id="tncinf-notfound">
  <div class="tncinf-notfound">
      <h1><?php esc_html_e( 'Oops!', 'tnc-infinity')?></h1>
      <h2><?php esc_html_e( '404 - Page not found', 'tnc-infinity' ); ?></h2>
      <p><?php esc_html_e('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'tnc-infinity'); ?></p>
      <a href="<?php echo esc_url ( home_url() ); ?>"><?php esc_html_e('Go To Homepage', 'tnc-infinity'); ?></a>
  </div>
</div>

<?php
  $tncinf_show_hide_subscribe_button = get_theme_mod('tncinf_show_hide_subscribe_button', true );
  if( $tncinf_show_hide_subscribe_button  == true ) :
?>
  <div class="tncinf-newsletter-subscribe-linkable-button-wrapper">
    <?php echo $tncinf_common_page_template_parts->tncinf_newsletter_subscribe_linkable_button(); ?>
  </div>
<?php endif; ?>




<?php
get_footer(); 