<?php

class Square_Icon_Manager {

    private static $instance = null;

    public static function instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        $this->init();
    }

    public function init() {
        add_filter('square_register_icon', array($this, 'icons'));
    }

    public function icons() {
        $icons_args = array(
            'square-fontawesome-icon' => array(
                'name' => 'square-fontawesome-icon',
                'label' => esc_html__('Font Awesome', 'square'),
                'prefix' => '',
                'displayPrefix' => '',
                'url' => get_template_directory_uri() . '/css/font-awesome-6.3.0.css',
                'icons' => $this->font_awesome_icon_array(),
            )
        );

        return $icons_args;
    }

    public function font_awesome_icon_array() {
        return array("fa-solid fa-0", "fa-solid fa-1", "fa-solid fa-2", "fa-solid fa-3", "fa-solid fa-4", "fa-solid fa-5", "fa-solid fa-6", "fa-solid fa-7", "fa-solid fa-8", "fa-solid fa-9", "fa-solid fa-fill-drip", "fa-solid fa-arrows-to-circle", "fa-solid fa-circle-chevron-right", "fa-solid fa-at", "fa-solid fa-trash-can", "fa-solid fa-text-height", "fa-solid fa-user-xmark", "fa-solid fa-stethoscope", "fa-solid fa-message", "fa-solid fa-info", "fa-solid fa-down-left-and-up-right-to-center", "fa-solid fa-explosion", "fa-solid fa-file-lines", "fa-solid fa-wave-square", "fa-solid fa-ring", "fa-solid fa-building-un", "fa-solid fa-dice-three", "fa-solid fa-calendar-days", "fa-solid fa-anchor-circle-check", "fa-solid fa-building-circle-arrow-right", "fa-solid fa-volleyball", "fa-solid fa-arrows-up-to-line", "fa-solid fa-sort-down", "fa-solid fa-circle-minus", "fa-solid fa-door-open", "fa-solid fa-right-from-bracket", "fa-solid fa-atom", "fa-solid fa-soap", "fa-solid fa-icons", "fa-solid fa-microphone-lines-slash", "fa-solid fa-bridge-circle-check", "fa-solid fa-pump-medical", "fa-solid fa-fingerprint", "fa-solid fa-hand-point-right", "fa-solid fa-magnifying-glass-location", "fa-solid fa-forward-step", "fa-solid fa-face-smile-beam", "fa-solid fa-flag-checkered", "fa-solid fa-football", "fa-solid fa-school-circle-exclamation", "fa-solid fa-crop", "fa-solid fa-angles-down", "fa-solid fa-users-rectangle", "fa-solid fa-people-roof", "fa-solid fa-people-line", "fa-solid fa-beer-mug-empty", "fa-solid fa-diagram-predecessor", "fa-solid fa-arrow-up-long", "fa-solid fa-fire-flame-simple", "fa-solid fa-person", "fa-solid fa-laptop", "fa-solid fa-file-csv", "fa-solid fa-menorah", "fa-solid fa-truck-plane", "fa-solid fa-record-vinyl", "fa-solid fa-face-grin-stars", "fa-solid fa-bong", "fa-solid fa-spaghetti-monster-flying", "fa-solid fa-arrow-down-up-across-line", "fa-solid fa-spoon", "fa-solid fa-jar-wheat", "fa-solid fa-envelopes-bulk", "fa-solid fa-file-circle-exclamation", "fa-solid fa-circle-h", "fa-solid fa-pager", "fa-solid fa-address-book", "fa-solid fa-strikethrough", "fa-solid fa-k", "fa-solid fa-landmark-flag", "fa-solid fa-pencil", "fa-solid fa-backward", "fa-solid fa-caret-right", "fa-solid fa-comments", "fa-solid fa-paste", "fa-solid fa-code-pull-request", "fa-solid fa-clipboard-list", "fa-solid fa-truck-ramp-box", "fa-solid fa-user-check", "fa-solid fa-vial-virus", "fa-solid fa-sheet-plastic", "fa-solid fa-blog", "fa-solid fa-user-ninja", "fa-solid fa-person-arrow-up-from-line", "fa-solid fa-scroll-torah", "fa-solid fa-broom-ball", "fa-solid fa-toggle-off", "fa-solid fa-box-archive", "fa-solid fa-person-drowning", "fa-solid fa-arrow-down-9-1", "fa-solid fa-face-grin-tongue-squint", "fa-solid fa-spray-can", "fa-solid fa-truck-monster", "fa-solid fa-w", "fa-solid fa-earth-africa", "fa-solid fa-rainbow", "fa-solid fa-circle-notch", "fa-solid fa-tablet-screen-button", "fa-solid fa-paw", "fa-solid fa-cloud", "fa-solid fa-trowel-bricks", "fa-solid fa-face-flushed", "fa-solid fa-hospital-user", "fa-solid fa-tent-arrow-left-right", "fa-solid fa-gavel", "fa-solid fa-binoculars", "fa-solid fa-microphone-slash", "fa-solid fa-box-tissue", "fa-solid fa-motorcycle", "fa-solid fa-bell-concierge", "fa-solid fa-pen-ruler", "fa-solid fa-people-arrows", "fa-solid fa-mars-and-venus-burst", "fa-solid fa-square-caret-right", "fa-solid fa-scissors", "fa-solid fa-sun-plant-wilt", "fa-solid fa-toilets-portable", "fa-solid fa-hockey-puck", "fa-solid fa-table", "fa-solid fa-magnifying-glass-arrow-right", "fa-solid fa-tachograph-digital", "fa-solid fa-users-slash", "fa-solid fa-clover", "fa-solid fa-reply", "fa-solid fa-star-and-crescent", "fa-solid fa-house-fire", "fa-solid fa-square-minus", "fa-solid fa-helicopter", "fa-solid fa-compass", "fa-solid fa-square-caret-down", "fa-solid fa-file-circle-question", "fa-solid fa-laptop-code", "fa-solid fa-swatchbook", "fa-solid fa-prescription-bottle", "fa-solid fa-bars", "fa-solid fa-people-group", "fa-solid fa-hourglass-end", "fa-solid fa-heart-crack", "fa-solid fa-square-up-right", "fa-solid fa-face-kiss-beam", "fa-solid fa-film", "fa-solid fa-ruler-horizontal", "fa-solid fa-people-robbery", "fa-solid fa-lightbulb", "fa-solid fa-caret-left", "fa-solid fa-circle-exclamation", "fa-solid fa-school-circle-xmark", "fa-solid fa-arrow-right-from-bracket", "fa-solid fa-circle-chevron-down", "fa-solid fa-unlock-keyhole", "fa-solid fa-cloud-showers-heavy", "fa-solid fa-headphones-simple", "fa-solid fa-sitemap", "fa-solid fa-circle-dollar-to-slot", "fa-solid fa-memory", "fa-solid fa-road-spikes", "fa-solid fa-fire-burner", "fa-solid fa-flag", "fa-solid fa-hanukiah", "fa-solid fa-feather", "fa-solid fa-volume-low", "fa-solid fa-comment-slash", "fa-solid fa-cloud-sun-rain", "fa-solid fa-compress", "fa-solid fa-wheat-awn", "fa-solid fa-ankh", "fa-solid fa-hands-holding-child", "fa-solid fa-asterisk", "fa-solid fa-square-check", "fa-solid fa-peseta-sign", "fa-solid fa-heading", "fa-solid fa-ghost", "fa-solid fa-list", "fa-solid fa-square-phone-flip", "fa-solid fa-cart-plus", "fa-solid fa-gamepad", "fa-solid fa-circle-dot", "fa-solid fa-face-dizzy", "fa-solid fa-egg", "fa-solid fa-house-medical-circle-xmark", "fa-solid fa-campground", "fa-solid fa-folder-plus", "fa-solid fa-futbol", "fa-solid fa-paintbrush", "fa-solid fa-lock", "fa-solid fa-gas-pump", "fa-solid fa-hot-tub-person", "fa-solid fa-map-location", "fa-solid fa-house-flood-water", "fa-solid fa-tree", "fa-solid fa-bridge-lock", "fa-solid fa-sack-dollar", "fa-solid fa-pen-to-square", "fa-solid fa-car-side", "fa-solid fa-share-nodes", "fa-solid fa-heart-circle-minus", "fa-solid fa-hourglass-half", "fa-solid fa-microscope", "fa-solid fa-sink", "fa-solid fa-bag-shopping", "fa-solid fa-arrow-down-z-a", "fa-solid fa-mitten", "fa-solid fa-person-rays", "fa-solid fa-users", "fa-solid fa-eye-slash", "fa-solid fa-flask-vial", "fa-solid fa-hand", "fa-solid fa-om", "fa-solid fa-worm", "fa-solid fa-house-circle-xmark", "fa-solid fa-plug", "fa-solid fa-chevron-up", "fa-solid fa-hand-spock", "fa-solid fa-stopwatch", "fa-solid fa-face-kiss", "fa-solid fa-bridge-circle-xmark", "fa-solid fa-face-grin-tongue", "fa-solid fa-chess-bishop", "fa-solid fa-face-grin-wink", "fa-solid fa-ear-deaf", "fa-solid fa-road-circle-check", "fa-solid fa-dice-five", "fa-solid fa-square-rss", "fa-solid fa-land-mine-on", "fa-solid fa-i-cursor", "fa-solid fa-stamp", "fa-solid fa-stairs", "fa-solid fa-i", "fa-solid fa-hryvnia-sign", "fa-solid fa-pills", "fa-solid fa-face-grin-wide", "fa-solid fa-tooth", "fa-solid fa-v", "fa-solid fa-bangladeshi-taka-sign", "fa-solid fa-bicycle", "fa-solid fa-staff-snake", "fa-solid fa-head-side-cough-slash", "fa-solid fa-truck-medical", "fa-solid fa-wheat-awn-circle-exclamation", "fa-solid fa-snowman", "fa-solid fa-mortar-pestle", "fa-solid fa-road-barrier", "fa-solid fa-school", "fa-solid fa-igloo", "fa-solid fa-joint", "fa-solid fa-angle-right", "fa-solid fa-horse", "fa-solid fa-q", "fa-solid fa-g", "fa-solid fa-notes-medical", "fa-solid fa-temperature-half", "fa-solid fa-dong-sign", "fa-solid fa-capsules", "fa-solid fa-poo-storm", "fa-solid fa-face-frown-open", "fa-solid fa-hand-point-up", "fa-solid fa-money-bill", "fa-solid fa-bookmark", "fa-solid fa-align-justify", "fa-solid fa-umbrella-beach", "fa-solid fa-helmet-un", "fa-solid fa-bullseye", "fa-solid fa-bacon", "fa-solid fa-hand-point-down", "fa-solid fa-arrow-up-from-bracket", "fa-solid fa-folder", "fa-solid fa-file-waveform", "fa-solid fa-radiation", "fa-solid fa-chart-simple", "fa-solid fa-mars-stroke", "fa-solid fa-vial", "fa-solid fa-gauge", "fa-solid fa-wand-magic-sparkles", "fa-solid fa-e", "fa-solid fa-pen-clip", "fa-solid fa-bridge-circle-exclamation", "fa-solid fa-user", "fa-solid fa-school-circle-check", "fa-solid fa-dumpster", "fa-solid fa-van-shuttle", "fa-solid fa-building-user", "fa-solid fa-square-caret-left", "fa-solid fa-highlighter", "fa-solid fa-key", "fa-solid fa-bullhorn", "fa-solid fa-globe", "fa-solid fa-synagogue", "fa-solid fa-person-half-dress", "fa-solid fa-road-bridge", "fa-solid fa-location-arrow", "fa-solid fa-c", "fa-solid fa-tablet-button", "fa-solid fa-building-lock", "fa-solid fa-pizza-slice", "fa-solid fa-money-bill-wave", "fa-solid fa-chart-area", "fa-solid fa-house-flag", "fa-solid fa-person-circle-minus", "fa-solid fa-ban", "fa-solid fa-camera-rotate", "fa-solid fa-spray-can-sparkles", "fa-solid fa-star", "fa-solid fa-repeat", "fa-solid fa-cross", "fa-solid fa-box", "fa-solid fa-venus-mars", "fa-solid fa-arrow-pointer", "fa-solid fa-maximize", "fa-solid fa-charging-station", "fa-solid fa-shapes", "fa-solid fa-shuffle", "fa-solid fa-person-running", "fa-solid fa-mobile-retro", "fa-solid fa-grip-lines-vertical", "fa-solid fa-spider", "fa-solid fa-hands-bound", "fa-solid fa-file-invoice-dollar", "fa-solid fa-plane-circle-exclamation", "fa-solid fa-x-ray", "fa-solid fa-spell-check", "fa-solid fa-slash", "fa-solid fa-computer-mouse", "fa-solid fa-arrow-right-to-bracket", "fa-solid fa-shop-slash", "fa-solid fa-server", "fa-solid fa-virus-covid-slash", "fa-solid fa-shop-lock", "fa-solid fa-hourglass-start", "fa-solid fa-blender-phone", "fa-solid fa-building-wheat", "fa-solid fa-person-breastfeeding", "fa-solid fa-right-to-bracket", "fa-solid fa-venus", "fa-solid fa-passport", "fa-solid fa-thumbtack-slash", "fa-solid fa-heart-pulse", "fa-solid fa-people-carry-box", "fa-solid fa-temperature-high", "fa-solid fa-microchip", "fa-solid fa-crown", "fa-solid fa-weight-hanging", "fa-solid fa-xmarks-lines", "fa-solid fa-file-prescription", "fa-solid fa-weight-scale", "fa-solid fa-user-group", "fa-solid fa-arrow-up-a-z", "fa-solid fa-chess-knight", "fa-solid fa-face-laugh-squint", "fa-solid fa-wheelchair", "fa-solid fa-circle-arrow-up", "fa-solid fa-toggle-on", "fa-solid fa-person-walking", "fa-solid fa-l", "fa-solid fa-fire", "fa-solid fa-bed-pulse", "fa-solid fa-shuttle-space", "fa-solid fa-face-laugh", "fa-solid fa-folder-open", "fa-solid fa-heart-circle-plus", "fa-solid fa-code-fork", "fa-solid fa-city", "fa-solid fa-microphone-lines", "fa-solid fa-pepper-hot", "fa-solid fa-unlock", "fa-solid fa-colon-sign", "fa-solid fa-headset", "fa-solid fa-store-slash", "fa-solid fa-road-circle-xmark", "fa-solid fa-user-minus", "fa-solid fa-mars-stroke-up", "fa-solid fa-champagne-glasses", "fa-solid fa-clipboard", "fa-solid fa-house-circle-exclamation", "fa-solid fa-file-arrow-up", "fa-solid fa-wifi", "fa-solid fa-bath", "fa-solid fa-underline", "fa-solid fa-user-pen", "fa-solid fa-signature", "fa-solid fa-stroopwafel", "fa-solid fa-bold", "fa-solid fa-anchor-lock", "fa-solid fa-building-ngo", "fa-solid fa-manat-sign", "fa-solid fa-not-equal", "fa-solid fa-border-top-left", "fa-solid fa-map-location-dot", "fa-solid fa-jedi", "fa-solid fa-square-poll-vertical", "fa-solid fa-mug-hot", "fa-solid fa-car-battery", "fa-solid fa-gift", "fa-solid fa-dice-two", "fa-solid fa-chess-queen", "fa-solid fa-glasses", "fa-solid fa-chess-board", "fa-solid fa-building-circle-check", "fa-solid fa-person-chalkboard", "fa-solid fa-mars-stroke-right", "fa-solid fa-hand-back-fist", "fa-solid fa-square-caret-up", "fa-solid fa-cloud-showers-water", "fa-solid fa-chart-bar", "fa-solid fa-hands-bubbles", "fa-solid fa-less-than-equal", "fa-solid fa-train", "fa-solid fa-eye-low-vision", "fa-solid fa-crow", "fa-solid fa-sailboat", "fa-solid fa-window-restore", "fa-solid fa-square-plus", "fa-solid fa-torii-gate", "fa-solid fa-frog", "fa-solid fa-bucket", "fa-solid fa-image", "fa-solid fa-microphone", "fa-solid fa-cow", "fa-solid fa-caret-up", "fa-solid fa-screwdriver", "fa-solid fa-folder-closed", "fa-solid fa-house-tsunami", "fa-solid fa-square-nfi", "fa-solid fa-arrow-up-from-ground-water", "fa-solid fa-martini-glass", "fa-solid fa-square-binary", "fa-solid fa-rotate-left", "fa-solid fa-table-columns", "fa-solid fa-lemon", "fa-solid fa-head-side-mask", "fa-solid fa-handshake", "fa-solid fa-gem", "fa-solid fa-dolly", "fa-solid fa-smoking", "fa-solid fa-minimize", "fa-solid fa-monument", "fa-solid fa-snowplow", "fa-solid fa-angles-right", "fa-solid fa-cannabis", "fa-solid fa-circle-play", "fa-solid fa-tablets", "fa-solid fa-ethernet", "fa-solid fa-euro-sign", "fa-solid fa-chair", "fa-solid fa-circle-check", "fa-solid fa-circle-stop", "fa-solid fa-compass-drafting", "fa-solid fa-plate-wheat", "fa-solid fa-icicles", "fa-solid fa-person-shelter", "fa-solid fa-neuter", "fa-solid fa-id-badge", "fa-solid fa-marker", "fa-solid fa-face-laugh-beam", "fa-solid fa-helicopter-symbol", "fa-solid fa-universal-access", "fa-solid fa-circle-chevron-up", "fa-solid fa-lari-sign", "fa-solid fa-volcano", "fa-solid fa-person-walking-dashed-line-arrow-right", "fa-solid fa-sterling-sign", "fa-solid fa-viruses", "fa-solid fa-square-person-confined", "fa-solid fa-user-tie", "fa-solid fa-arrow-down-long", "fa-solid fa-tent-arrow-down-to-line", "fa-solid fa-certificate", "fa-solid fa-reply-all", "fa-solid fa-suitcase", "fa-solid fa-person-skating", "fa-solid fa-filter-circle-dollar", "fa-solid fa-camera-retro", "fa-solid fa-circle-arrow-down", "fa-solid fa-file-import", "fa-solid fa-square-arrow-up-right", "fa-solid fa-box-open", "fa-solid fa-scroll", "fa-solid fa-spa", "fa-solid fa-location-pin-lock", "fa-solid fa-pause", "fa-solid fa-hill-avalanche", "fa-solid fa-temperature-empty", "fa-solid fa-bomb", "fa-solid fa-registered", "fa-solid fa-address-card", "fa-solid fa-scale-unbalanced-flip", "fa-solid fa-subscript", "fa-solid fa-diamond-turn-right", "fa-solid fa-burst", "fa-solid fa-house-laptop", "fa-solid fa-face-tired", "fa-solid fa-money-bills", "fa-solid fa-smog", "fa-solid fa-crutch", "fa-solid fa-font-awesome", "fa-solid fa-cloud-arrow-up", "fa-solid fa-palette", "fa-solid fa-arrows-turn-right", "fa-solid fa-vest", "fa-solid fa-ferry", "fa-solid fa-arrows-down-to-people", "fa-solid fa-seedling", "fa-solid fa-left-right", "fa-solid fa-boxes-packing", "fa-solid fa-circle-arrow-left", "fa-solid fa-group-arrows-rotate", "fa-solid fa-bowl-food", "fa-solid fa-candy-cane", "fa-solid fa-arrow-down-wide-short", "fa-solid fa-cloud-bolt", "fa-solid fa-text-slash", "fa-solid fa-face-smile-wink", "fa-solid fa-file-word", "fa-solid fa-file-powerpoint", "fa-solid fa-arrows-left-right", "fa-solid fa-house-lock", "fa-solid fa-cloud-arrow-down", "fa-solid fa-children", "fa-solid fa-chalkboard", "fa-solid fa-user-large-slash", "fa-solid fa-envelope-open", "fa-solid fa-handshake-simple-slash", "fa-solid fa-mattress-pillow", "fa-solid fa-guarani-sign", "fa-solid fa-arrows-rotate", "fa-solid fa-fire-extinguisher", "fa-solid fa-cruzeiro-sign", "fa-solid fa-greater-than-equal", "fa-solid fa-shield-halved", "fa-solid fa-book-atlas", "fa-solid fa-virus", "fa-solid fa-envelope-circle-check", "fa-solid fa-layer-group", "fa-solid fa-arrows-to-dot", "fa-solid fa-archway", "fa-solid fa-heart-circle-check", "fa-solid fa-house-chimney-crack", "fa-solid fa-file-zipper", "fa-solid fa-square", "fa-solid fa-martini-glass-empty", "fa-solid fa-couch", "fa-solid fa-cedi-sign", "fa-solid fa-italic", "fa-solid fa-table-cells-column-lock", "fa-solid fa-church", "fa-solid fa-comments-dollar", "fa-solid fa-democrat", "fa-solid fa-z", "fa-solid fa-person-skiing", "fa-solid fa-road-lock", "fa-solid fa-a", "fa-solid fa-temperature-arrow-down", "fa-solid fa-feather-pointed", "fa-solid fa-p", "fa-solid fa-snowflake", "fa-solid fa-newspaper", "fa-solid fa-rectangle-ad", "fa-solid fa-circle-arrow-right", "fa-solid fa-filter-circle-xmark", "fa-solid fa-locust", "fa-solid fa-sort", "fa-solid fa-list-ol", "fa-solid fa-person-dress-burst", "fa-solid fa-money-check-dollar", "fa-solid fa-vector-square", "fa-solid fa-bread-slice", "fa-solid fa-language", "fa-solid fa-face-kiss-wink-heart", "fa-solid fa-filter", "fa-solid fa-question", "fa-solid fa-file-signature", "fa-solid fa-up-down-left-right", "fa-solid fa-house-chimney-user", "fa-solid fa-hand-holding-heart", "fa-solid fa-puzzle-piece", "fa-solid fa-money-check", "fa-solid fa-star-half-stroke", "fa-solid fa-code", "fa-solid fa-whiskey-glass", "fa-solid fa-building-circle-exclamation", "fa-solid fa-magnifying-glass-chart", "fa-solid fa-arrow-up-right-from-square", "fa-solid fa-cubes-stacked", "fa-solid fa-won-sign", "fa-solid fa-virus-covid", "fa-solid fa-austral-sign", "fa-solid fa-f", "fa-solid fa-leaf", "fa-solid fa-road", "fa-solid fa-taxi", "fa-solid fa-person-circle-plus", "fa-solid fa-chart-pie", "fa-solid fa-bolt-lightning", "fa-solid fa-sack-xmark", "fa-solid fa-file-excel", "fa-solid fa-file-contract", "fa-solid fa-fish-fins", "fa-solid fa-building-flag", "fa-solid fa-face-grin-beam", "fa-solid fa-object-ungroup", "fa-solid fa-poop", "fa-solid fa-location-pin", "fa-solid fa-kaaba", "fa-solid fa-toilet-paper", "fa-solid fa-helmet-safety", "fa-solid fa-eject", "fa-solid fa-circle-right", "fa-solid fa-plane-circle-check", "fa-solid fa-face-rolling-eyes", "fa-solid fa-object-group", "fa-solid fa-chart-line", "fa-solid fa-mask-ventilator", "fa-solid fa-arrow-right", "fa-solid fa-signs-post", "fa-solid fa-cash-register", "fa-solid fa-person-circle-question", "fa-solid fa-h", "fa-solid fa-tarp", "fa-solid fa-screwdriver-wrench", "fa-solid fa-arrows-to-eye", "fa-solid fa-plug-circle-bolt", "fa-solid fa-heart", "fa-solid fa-mars-and-venus", "fa-solid fa-house-user", "fa-solid fa-dumpster-fire", "fa-solid fa-house-crack", "fa-solid fa-martini-glass-citrus", "fa-solid fa-face-surprise", "fa-solid fa-bottle-water", "fa-solid fa-circle-pause", "fa-solid fa-toilet-paper-slash", "fa-solid fa-apple-whole", "fa-solid fa-kitchen-set", "fa-solid fa-r", "fa-solid fa-temperature-quarter", "fa-solid fa-cube", "fa-solid fa-bitcoin-sign", "fa-solid fa-shield-dog", "fa-solid fa-solar-panel", "fa-solid fa-lock-open", "fa-solid fa-elevator", "fa-solid fa-money-bill-transfer", "fa-solid fa-money-bill-trend-up", "fa-solid fa-house-flood-water-circle-arrow-right", "fa-solid fa-square-poll-horizontal", "fa-solid fa-circle", "fa-solid fa-backward-fast", "fa-solid fa-recycle", "fa-solid fa-user-astronaut", "fa-solid fa-plane-slash", "fa-solid fa-trademark", "fa-solid fa-basketball", "fa-solid fa-satellite-dish", "fa-solid fa-circle-up", "fa-solid fa-mobile-screen-button", "fa-solid fa-volume-high", "fa-solid fa-users-rays", "fa-solid fa-wallet", "fa-solid fa-clipboard-check", "fa-solid fa-file-audio", "fa-solid fa-burger", "fa-solid fa-wrench", "fa-solid fa-bugs", "fa-solid fa-rupee-sign", "fa-solid fa-file-image", "fa-solid fa-circle-question", "fa-solid fa-plane-departure", "fa-solid fa-handshake-slash", "fa-solid fa-book-bookmark", "fa-solid fa-code-branch", "fa-solid fa-hat-cowboy", "fa-solid fa-bridge", "fa-solid fa-phone-flip", "fa-solid fa-truck-front", "fa-solid fa-cat", "fa-solid fa-anchor-circle-exclamation", "fa-solid fa-truck-field", "fa-solid fa-route", "fa-solid fa-clipboard-question", "fa-solid fa-panorama", "fa-solid fa-comment-medical", "fa-solid fa-teeth-open", "fa-solid fa-file-circle-minus", "fa-solid fa-tags", "fa-solid fa-wine-glass", "fa-solid fa-forward-fast", "fa-solid fa-face-meh-blank", "fa-solid fa-square-parking", "fa-solid fa-house-signal", "fa-solid fa-bars-progress", "fa-solid fa-faucet-drip", "fa-solid fa-cart-flatbed", "fa-solid fa-ban-smoking", "fa-solid fa-terminal", "fa-solid fa-mobile-button", "fa-solid fa-house-medical-flag", "fa-solid fa-basket-shopping", "fa-solid fa-tape", "fa-solid fa-bus-simple", "fa-solid fa-eye", "fa-solid fa-face-sad-cry", "fa-solid fa-audio-description", "fa-solid fa-person-military-to-person", "fa-solid fa-file-shield", "fa-solid fa-user-slash", "fa-solid fa-pen", "fa-solid fa-tower-observation", "fa-solid fa-file-code", "fa-solid fa-signal", "fa-solid fa-bus", "fa-solid fa-heart-circle-xmark", "fa-solid fa-house-chimney", "fa-solid fa-window-maximize", "fa-solid fa-face-frown", "fa-solid fa-prescription", "fa-solid fa-shop", "fa-solid fa-floppy-disk", "fa-solid fa-vihara", "fa-solid fa-scale-unbalanced", "fa-solid fa-sort-up", "fa-solid fa-comment-dots", "fa-solid fa-plant-wilt", "fa-solid fa-diamond", "fa-solid fa-face-grin-squint", "fa-solid fa-hand-holding-dollar", "fa-solid fa-chart-diagram", "fa-solid fa-bacterium", "fa-solid fa-hand-pointer", "fa-solid fa-drum-steelpan", "fa-solid fa-hand-scissors", "fa-solid fa-hands-praying", "fa-solid fa-arrow-rotate-right", "fa-solid fa-web-awesome", "fa-solid fa-biohazard", "fa-solid fa-location-crosshairs", "fa-solid fa-mars-double", "fa-solid fa-child-dress", "fa-solid fa-users-between-lines", "fa-solid fa-lungs-virus", "fa-solid fa-face-grin-tears", "fa-solid fa-phone", "fa-solid fa-calendar-xmark", "fa-solid fa-child-reaching", "fa-solid fa-head-side-virus", "fa-solid fa-user-gear", "fa-solid fa-arrow-up-1-9", "fa-solid fa-door-closed", "fa-solid fa-shield-virus", "fa-solid fa-dice-six", "fa-solid fa-mosquito-net", "fa-solid fa-file-fragment", "fa-solid fa-bridge-water", "fa-solid fa-person-booth", "fa-solid fa-text-width", "fa-solid fa-hat-wizard", "fa-solid fa-pen-fancy", "fa-solid fa-person-digging", "fa-solid fa-trash", "fa-solid fa-gauge-simple", "fa-solid fa-book-medical", "fa-solid fa-poo", "fa-solid fa-quote-right", "fa-solid fa-shirt", "fa-solid fa-cubes", "fa-solid fa-divide", "fa-solid fa-tenge-sign", "fa-solid fa-headphones", "fa-solid fa-hands-holding", "fa-solid fa-hands-clapping", "fa-solid fa-republican", "fa-solid fa-arrow-left", "fa-solid fa-person-circle-xmark", "fa-solid fa-ruler", "fa-solid fa-align-left", "fa-solid fa-dice-d6", "fa-solid fa-restroom", "fa-solid fa-j", "fa-solid fa-users-viewfinder", "fa-solid fa-file-video", "fa-solid fa-up-right-from-square", "fa-solid fa-table-cells", "fa-solid fa-file-pdf", "fa-solid fa-book-bible", "fa-solid fa-o", "fa-solid fa-suitcase-medical", "fa-solid fa-user-secret", "fa-solid fa-otter", "fa-solid fa-person-dress", "fa-solid fa-comment-dollar", "fa-solid fa-business-time", "fa-solid fa-table-cells-large", "fa-solid fa-book-tanakh", "fa-solid fa-phone-volume", "fa-solid fa-hat-cowboy-side", "fa-solid fa-clipboard-user", "fa-solid fa-child", "fa-solid fa-lira-sign", "fa-solid fa-satellite", "fa-solid fa-plane-lock", "fa-solid fa-tag", "fa-solid fa-comment", "fa-solid fa-cake-candles", "fa-solid fa-envelope", "fa-solid fa-angles-up", "fa-solid fa-paperclip", "fa-solid fa-arrow-right-to-city", "fa-solid fa-ribbon", "fa-solid fa-lungs", "fa-solid fa-arrow-up-9-1", "fa-solid fa-litecoin-sign", "fa-solid fa-border-none", "fa-solid fa-circle-nodes", "fa-solid fa-parachute-box", "fa-solid fa-indent", "fa-solid fa-truck-field-un", "fa-solid fa-hourglass", "fa-solid fa-mountain", "fa-solid fa-user-doctor", "fa-solid fa-circle-info", "fa-solid fa-cloud-meatball", "fa-solid fa-camera", "fa-solid fa-square-virus", "fa-solid fa-meteor", "fa-solid fa-car-on", "fa-solid fa-sleigh", "fa-solid fa-arrow-down-1-9", "fa-solid fa-hand-holding-droplet", "fa-solid fa-water", "fa-solid fa-calendar-check", "fa-solid fa-braille", "fa-solid fa-prescription-bottle-medical", "fa-solid fa-landmark", "fa-solid fa-truck", "fa-solid fa-crosshairs", "fa-solid fa-person-cane", "fa-solid fa-tent", "fa-solid fa-vest-patches", "fa-solid fa-check-double", "fa-solid fa-arrow-down-a-z", "fa-solid fa-money-bill-wheat", "fa-solid fa-cookie", "fa-solid fa-arrow-rotate-left", "fa-solid fa-hard-drive", "fa-solid fa-face-grin-squint-tears", "fa-solid fa-dumbbell", "fa-solid fa-rectangle-list", "fa-solid fa-tarp-droplet", "fa-solid fa-house-medical-circle-check", "fa-solid fa-person-skiing-nordic", "fa-solid fa-calendar-plus", "fa-solid fa-plane-arrival", "fa-solid fa-circle-left", "fa-solid fa-train-subway", "fa-solid fa-chart-gantt", "fa-solid fa-indian-rupee-sign", "fa-solid fa-crop-simple", "fa-solid fa-money-bill-1", "fa-solid fa-left-long", "fa-solid fa-dna", "fa-solid fa-virus-slash", "fa-solid fa-minus", "fa-solid fa-chess", "fa-solid fa-arrow-left-long", "fa-solid fa-plug-circle-check", "fa-solid fa-street-view", "fa-solid fa-franc-sign", "fa-solid fa-volume-off", "fa-solid fa-hands-asl-interpreting", "fa-solid fa-gear", "fa-solid fa-droplet-slash", "fa-solid fa-mosque", "fa-solid fa-mosquito", "fa-solid fa-star-of-david", "fa-solid fa-person-military-rifle", "fa-solid fa-cart-shopping", "fa-solid fa-vials", "fa-solid fa-plug-circle-plus", "fa-solid fa-place-of-worship", "fa-solid fa-grip-vertical", "fa-solid fa-hexagon-nodes", "fa-solid fa-arrow-turn-up", "fa-solid fa-u", "fa-solid fa-square-root-variable", "fa-solid fa-clock", "fa-solid fa-backward-step", "fa-solid fa-pallet", "fa-solid fa-faucet", "fa-solid fa-baseball-bat-ball", "fa-solid fa-s", "fa-solid fa-timeline", "fa-solid fa-keyboard", "fa-solid fa-caret-down", "fa-solid fa-house-chimney-medical", "fa-solid fa-temperature-three-quarters", "fa-solid fa-mobile-screen", "fa-solid fa-plane-up", "fa-solid fa-piggy-bank", "fa-solid fa-battery-half", "fa-solid fa-mountain-city", "fa-solid fa-coins", "fa-solid fa-khanda", "fa-solid fa-sliders", "fa-solid fa-folder-tree", "fa-solid fa-network-wired", "fa-solid fa-map-pin", "fa-solid fa-hamsa", "fa-solid fa-cent-sign", "fa-solid fa-flask", "fa-solid fa-person-pregnant", "fa-solid fa-wand-sparkles", "fa-solid fa-ellipsis-vertical", "fa-solid fa-ticket", "fa-solid fa-power-off", "fa-solid fa-right-long", "fa-solid fa-flag-usa", "fa-solid fa-laptop-file", "fa-solid fa-tty", "fa-solid fa-diagram-next", "fa-solid fa-person-rifle", "fa-solid fa-house-medical-circle-exclamation", "fa-solid fa-closed-captioning", "fa-solid fa-person-hiking", "fa-solid fa-venus-double", "fa-solid fa-images", "fa-solid fa-calculator", "fa-solid fa-people-pulling", "fa-solid fa-n", "fa-solid fa-cable-car", "fa-solid fa-cloud-rain", "fa-solid fa-building-circle-xmark", "fa-solid fa-ship", "fa-solid fa-arrows-down-to-line", "fa-solid fa-download", "fa-solid fa-face-grin", "fa-solid fa-delete-left", "fa-solid fa-eye-dropper", "fa-solid fa-file-circle-check", "fa-solid fa-forward", "fa-solid fa-mobile", "fa-solid fa-face-meh", "fa-solid fa-align-center", "fa-solid fa-book-skull", "fa-solid fa-id-card", "fa-solid fa-outdent", "fa-solid fa-heart-circle-exclamation", "fa-solid fa-house", "fa-solid fa-calendar-week", "fa-solid fa-laptop-medical", "fa-solid fa-b", "fa-solid fa-file-medical", "fa-solid fa-dice-one", "fa-solid fa-kiwi-bird", "fa-solid fa-arrow-right-arrow-left", "fa-solid fa-rotate-right", "fa-solid fa-utensils", "fa-solid fa-arrow-up-wide-short", "fa-solid fa-mill-sign", "fa-solid fa-bowl-rice", "fa-solid fa-skull", "fa-solid fa-tower-broadcast", "fa-solid fa-truck-pickup", "fa-solid fa-up-long", "fa-solid fa-stop", "fa-solid fa-code-merge", "fa-solid fa-upload", "fa-solid fa-hurricane", "fa-solid fa-mound", "fa-solid fa-toilet-portable", "fa-solid fa-compact-disc", "fa-solid fa-file-arrow-down", "fa-solid fa-caravan", "fa-solid fa-shield-cat", "fa-solid fa-bolt", "fa-solid fa-glass-water", "fa-solid fa-oil-well", "fa-solid fa-vault", "fa-solid fa-mars", "fa-solid fa-toilet", "fa-solid fa-plane-circle-xmark", "fa-solid fa-yen-sign", "fa-solid fa-ruble-sign", "fa-solid fa-sun", "fa-solid fa-guitar", "fa-solid fa-face-laugh-wink", "fa-solid fa-horse-head", "fa-solid fa-bore-hole", "fa-solid fa-industry", "fa-solid fa-circle-down", "fa-solid fa-arrows-turn-to-dots", "fa-solid fa-florin-sign", "fa-solid fa-arrow-down-short-wide", "fa-solid fa-less-than", "fa-solid fa-angle-down", "fa-solid fa-car-tunnel", "fa-solid fa-head-side-cough", "fa-solid fa-grip-lines", "fa-solid fa-thumbs-down", "fa-solid fa-user-lock", "fa-solid fa-arrow-right-long", "fa-solid fa-anchor-circle-xmark", "fa-solid fa-ellipsis", "fa-solid fa-chess-pawn", "fa-solid fa-kit-medical", "fa-solid fa-person-through-window", "fa-solid fa-toolbox", "fa-solid fa-hands-holding-circle", "fa-solid fa-bug", "fa-solid fa-credit-card", "fa-solid fa-car", "fa-solid fa-hand-holding-hand", "fa-solid fa-book-open-reader", "fa-solid fa-mountain-sun", "fa-solid fa-arrows-left-right-to-line", "fa-solid fa-dice-d20", "fa-solid fa-truck-droplet", "fa-solid fa-file-circle-xmark", "fa-solid fa-temperature-arrow-up", "fa-solid fa-medal", "fa-solid fa-bed", "fa-solid fa-square-h", "fa-solid fa-podcast", "fa-solid fa-temperature-full", "fa-solid fa-bell", "fa-solid fa-superscript", "fa-solid fa-plug-circle-xmark", "fa-solid fa-star-of-life", "fa-solid fa-phone-slash", "fa-solid fa-paint-roller", "fa-solid fa-handshake-angle", "fa-solid fa-location-dot", "fa-solid fa-file", "fa-solid fa-greater-than", "fa-solid fa-person-swimming", "fa-solid fa-arrow-down", "fa-solid fa-droplet", "fa-solid fa-eraser", "fa-solid fa-earth-americas", "fa-solid fa-person-burst", "fa-solid fa-dove", "fa-solid fa-battery-empty", "fa-solid fa-socks", "fa-solid fa-inbox", "fa-solid fa-section", "fa-solid fa-gauge-high", "fa-solid fa-envelope-open-text", "fa-solid fa-hospital", "fa-solid fa-wine-bottle", "fa-solid fa-chess-rook", "fa-solid fa-bars-staggered", "fa-solid fa-dharmachakra", "fa-solid fa-hotdog", "fa-solid fa-person-walking-with-cane", "fa-solid fa-drum", "fa-solid fa-ice-cream", "fa-solid fa-heart-circle-bolt", "fa-solid fa-fax", "fa-solid fa-paragraph", "fa-solid fa-check-to-slot", "fa-solid fa-star-half", "fa-solid fa-boxes-stacked", "fa-solid fa-link", "fa-solid fa-ear-listen", "fa-solid fa-tree-city", "fa-solid fa-play", "fa-solid fa-font", "fa-solid fa-table-cells-row-lock", "fa-solid fa-rupiah-sign", "fa-solid fa-magnifying-glass", "fa-solid fa-table-tennis-paddle-ball", "fa-solid fa-person-dots-from-line", "fa-solid fa-trash-can-arrow-up", "fa-solid fa-naira-sign", "fa-solid fa-cart-arrow-down", "fa-solid fa-walkie-talkie", "fa-solid fa-file-pen", "fa-solid fa-receipt", "fa-solid fa-square-pen", "fa-solid fa-suitcase-rolling", "fa-solid fa-person-circle-exclamation", "fa-solid fa-chevron-down", "fa-solid fa-battery-full", "fa-solid fa-skull-crossbones", "fa-solid fa-code-compare", "fa-solid fa-list-ul", "fa-solid fa-school-lock", "fa-solid fa-tower-cell", "fa-solid fa-down-long", "fa-solid fa-ranking-star", "fa-solid fa-chess-king", "fa-solid fa-person-harassing", "fa-solid fa-brazilian-real-sign", "fa-solid fa-landmark-dome", "fa-solid fa-arrow-up", "fa-solid fa-tv", "fa-solid fa-shrimp", "fa-solid fa-list-check", "fa-solid fa-jug-detergent", "fa-solid fa-circle-user", "fa-solid fa-user-shield", "fa-solid fa-wind", "fa-solid fa-car-burst", "fa-solid fa-y", "fa-solid fa-person-snowboarding", "fa-solid fa-truck-fast", "fa-solid fa-fish", "fa-solid fa-user-graduate", "fa-solid fa-circle-half-stroke", "fa-solid fa-clapperboard", "fa-solid fa-circle-radiation", "fa-solid fa-baseball", "fa-solid fa-jet-fighter-up", "fa-solid fa-diagram-project", "fa-solid fa-copy", "fa-solid fa-volume-xmark", "fa-solid fa-hand-sparkles", "fa-solid fa-grip", "fa-solid fa-share-from-square", "fa-solid fa-child-combatant", "fa-solid fa-gun", "fa-solid fa-square-phone", "fa-solid fa-plus", "fa-solid fa-expand", "fa-solid fa-computer", "fa-solid fa-xmark", "fa-solid fa-arrows-up-down-left-right", "fa-solid fa-chalkboard-user", "fa-solid fa-peso-sign", "fa-solid fa-building-shield", "fa-solid fa-baby", "fa-solid fa-users-line", "fa-solid fa-quote-left", "fa-solid fa-tractor", "fa-solid fa-trash-arrow-up", "fa-solid fa-arrow-down-up-lock", "fa-solid fa-lines-leaning", "fa-solid fa-ruler-combined", "fa-solid fa-copyright", "fa-solid fa-equals", "fa-solid fa-blender", "fa-solid fa-teeth", "fa-solid fa-shekel-sign", "fa-solid fa-map", "fa-solid fa-rocket", "fa-solid fa-photo-film", "fa-solid fa-folder-minus", "fa-solid fa-hexagon-nodes-bolt", "fa-solid fa-store", "fa-solid fa-arrow-trend-up", "fa-solid fa-plug-circle-minus", "fa-solid fa-sign-hanging", "fa-solid fa-bezier-curve", "fa-solid fa-bell-slash", "fa-solid fa-tablet", "fa-solid fa-school-flag", "fa-solid fa-fill", "fa-solid fa-angle-up", "fa-solid fa-drumstick-bite", "fa-solid fa-holly-berry", "fa-solid fa-chevron-left", "fa-solid fa-bacteria", "fa-solid fa-hand-lizard", "fa-solid fa-notdef", "fa-solid fa-disease", "fa-solid fa-briefcase-medical", "fa-solid fa-genderless", "fa-solid fa-chevron-right", "fa-solid fa-retweet", "fa-solid fa-car-rear", "fa-solid fa-pump-soap", "fa-solid fa-video-slash", "fa-solid fa-battery-quarter", "fa-solid fa-radio", "fa-solid fa-baby-carriage", "fa-solid fa-traffic-light", "fa-solid fa-thermometer", "fa-solid fa-vr-cardboard", "fa-solid fa-hand-middle-finger", "fa-solid fa-percent", "fa-solid fa-truck-moving", "fa-solid fa-glass-water-droplet", "fa-solid fa-display", "fa-solid fa-face-smile", "fa-solid fa-thumbtack", "fa-solid fa-trophy", "fa-solid fa-person-praying", "fa-solid fa-hammer", "fa-solid fa-hand-peace", "fa-solid fa-rotate", "fa-solid fa-spinner", "fa-solid fa-robot", "fa-solid fa-peace", "fa-solid fa-gears", "fa-solid fa-warehouse", "fa-solid fa-arrow-up-right-dots", "fa-solid fa-splotch", "fa-solid fa-face-grin-hearts", "fa-solid fa-dice-four", "fa-solid fa-sim-card", "fa-solid fa-transgender", "fa-solid fa-mercury", "fa-solid fa-arrow-turn-down", "fa-solid fa-person-falling-burst", "fa-solid fa-award", "fa-solid fa-ticket-simple", "fa-solid fa-building", "fa-solid fa-angles-left", "fa-solid fa-qrcode", "fa-solid fa-clock-rotate-left", "fa-solid fa-face-grin-beam-sweat", "fa-solid fa-file-export", "fa-solid fa-shield", "fa-solid fa-arrow-up-short-wide", "fa-solid fa-comment-nodes", "fa-solid fa-house-medical", "fa-solid fa-golf-ball-tee", "fa-solid fa-circle-chevron-left", "fa-solid fa-house-chimney-window", "fa-solid fa-pen-nib", "fa-solid fa-tent-arrow-turn-left", "fa-solid fa-tents", "fa-solid fa-wand-magic", "fa-solid fa-dog", "fa-solid fa-carrot", "fa-solid fa-moon", "fa-solid fa-wine-glass-empty", "fa-solid fa-cheese", "fa-solid fa-yin-yang", "fa-solid fa-music", "fa-solid fa-code-commit", "fa-solid fa-temperature-low", "fa-solid fa-person-biking", "fa-solid fa-broom", "fa-solid fa-shield-heart", "fa-solid fa-gopuram", "fa-solid fa-earth-oceania", "fa-solid fa-square-xmark", "fa-solid fa-hashtag", "fa-solid fa-up-right-and-down-left-from-center", "fa-solid fa-oil-can", "fa-solid fa-t", "fa-solid fa-hippo", "fa-solid fa-chart-column", "fa-solid fa-infinity", "fa-solid fa-vial-circle-check", "fa-solid fa-person-arrow-down-to-line", "fa-solid fa-voicemail", "fa-solid fa-fan", "fa-solid fa-person-walking-luggage", "fa-solid fa-up-down", "fa-solid fa-cloud-moon-rain", "fa-solid fa-calendar", "fa-solid fa-trailer", "fa-solid fa-bahai", "fa-solid fa-sd-card", "fa-solid fa-dragon", "fa-solid fa-shoe-prints", "fa-solid fa-circle-plus", "fa-solid fa-face-grin-tongue-wink", "fa-solid fa-hand-holding", "fa-solid fa-plug-circle-exclamation", "fa-solid fa-link-slash", "fa-solid fa-clone", "fa-solid fa-person-walking-arrow-loop-left", "fa-solid fa-arrow-up-z-a", "fa-solid fa-fire-flame-curved", "fa-solid fa-tornado", "fa-solid fa-file-circle-plus", "fa-solid fa-book-quran", "fa-solid fa-anchor", "fa-solid fa-border-all", "fa-solid fa-face-angry", "fa-solid fa-cookie-bite", "fa-solid fa-arrow-trend-down", "fa-solid fa-rss", "fa-solid fa-draw-polygon", "fa-solid fa-scale-balanced", "fa-solid fa-gauge-simple-high", "fa-solid fa-shower", "fa-solid fa-desktop", "fa-solid fa-m", "fa-solid fa-table-list", "fa-solid fa-comment-sms", "fa-solid fa-book", "fa-solid fa-user-plus", "fa-solid fa-check", "fa-solid fa-battery-three-quarters", "fa-solid fa-house-circle-check", "fa-solid fa-angle-left", "fa-solid fa-diagram-successor", "fa-solid fa-truck-arrow-right", "fa-solid fa-arrows-split-up-and-left", "fa-solid fa-hand-fist", "fa-solid fa-cloud-moon", "fa-solid fa-briefcase", "fa-solid fa-person-falling", "fa-solid fa-image-portrait", "fa-solid fa-user-tag", "fa-solid fa-rug", "fa-solid fa-earth-europe", "fa-solid fa-cart-flatbed-suitcase", "fa-solid fa-rectangle-xmark", "fa-solid fa-baht-sign", "fa-solid fa-book-open", "fa-solid fa-book-journal-whills", "fa-solid fa-handcuffs", "fa-solid fa-triangle-exclamation", "fa-solid fa-database", "fa-solid fa-share", "fa-solid fa-bottle-droplet", "fa-solid fa-mask-face", "fa-solid fa-hill-rockslide", "fa-solid fa-right-left", "fa-solid fa-paper-plane", "fa-solid fa-road-circle-exclamation", "fa-solid fa-dungeon", "fa-solid fa-align-right", "fa-solid fa-money-bill-1-wave", "fa-solid fa-life-ring", "fa-solid fa-hands", "fa-solid fa-calendar-day", "fa-solid fa-water-ladder", "fa-solid fa-arrows-up-down", "fa-solid fa-face-grimace", "fa-solid fa-wheelchair-move", "fa-solid fa-turn-down", "fa-solid fa-person-walking-arrow-right", "fa-solid fa-square-envelope", "fa-solid fa-dice", "fa-solid fa-bowling-ball", "fa-solid fa-brain", "fa-solid fa-bandage", "fa-solid fa-calendar-minus", "fa-solid fa-circle-xmark", "fa-solid fa-gifts", "fa-solid fa-hotel", "fa-solid fa-earth-asia", "fa-solid fa-id-card-clip", "fa-solid fa-magnifying-glass-plus", "fa-solid fa-thumbs-up", "fa-solid fa-user-clock", "fa-solid fa-hand-dots", "fa-solid fa-file-invoice", "fa-solid fa-window-minimize", "fa-solid fa-mug-saucer", "fa-solid fa-brush", "fa-solid fa-file-half-dashed", "fa-solid fa-mask", "fa-solid fa-magnifying-glass-minus", "fa-solid fa-ruler-vertical", "fa-solid fa-user-large", "fa-solid fa-train-tram", "fa-solid fa-user-nurse", "fa-solid fa-syringe", "fa-solid fa-cloud-sun", "fa-solid fa-stopwatch-20", "fa-solid fa-square-full", "fa-solid fa-magnet", "fa-solid fa-jar", "fa-solid fa-note-sticky", "fa-solid fa-bug-slash", "fa-solid fa-arrow-up-from-water-pump", "fa-solid fa-bone", "fa-solid fa-table-cells-row-unlock", "fa-solid fa-user-injured", "fa-solid fa-face-sad-tear", "fa-solid fa-plane", "fa-solid fa-tent-arrows-down", "fa-solid fa-exclamation", "fa-solid fa-arrows-spin", "fa-solid fa-print", "fa-solid fa-turkish-lira-sign", "fa-solid fa-dollar-sign", "fa-solid fa-x", "fa-solid fa-magnifying-glass-dollar", "fa-solid fa-users-gear", "fa-solid fa-person-military-pointing", "fa-solid fa-building-columns", "fa-solid fa-umbrella", "fa-solid fa-trowel", "fa-solid fa-d", "fa-solid fa-stapler", "fa-solid fa-masks-theater", "fa-solid fa-kip-sign", "fa-solid fa-hand-point-left", "fa-solid fa-handshake-simple", "fa-solid fa-jet-fighter", "fa-solid fa-square-share-nodes", "fa-solid fa-barcode", "fa-solid fa-plus-minus", "fa-solid fa-video", "fa-solid fa-graduation-cap", "fa-solid fa-hand-holding-medical", "fa-solid fa-person-circle-check", "fa-solid fa-turn-up", "fa-regular fa-trash-can", "fa-regular fa-message", "fa-regular fa-file-lines", "fa-regular fa-calendar-days", "fa-regular fa-hand-point-right", "fa-regular fa-face-smile-beam", "fa-regular fa-face-grin-stars", "fa-regular fa-address-book", "fa-regular fa-comments", "fa-regular fa-paste", "fa-regular fa-face-grin-tongue-squint", "fa-regular fa-face-flushed", "fa-regular fa-square-caret-right", "fa-regular fa-square-minus", "fa-regular fa-compass", "fa-regular fa-square-caret-down", "fa-regular fa-face-kiss-beam", "fa-regular fa-lightbulb", "fa-regular fa-flag", "fa-regular fa-square-check", "fa-regular fa-circle-dot", "fa-regular fa-face-dizzy", "fa-regular fa-futbol", "fa-regular fa-pen-to-square", "fa-regular fa-hourglass-half", "fa-regular fa-eye-slash", "fa-regular fa-hand", "fa-regular fa-hand-spock", "fa-regular fa-face-kiss", "fa-regular fa-face-grin-tongue", "fa-regular fa-chess-bishop", "fa-regular fa-face-grin-wink", "fa-regular fa-face-grin-wide", "fa-regular fa-face-frown-open", "fa-regular fa-hand-point-up", "fa-regular fa-bookmark", "fa-regular fa-hand-point-down", "fa-regular fa-folder", "fa-regular fa-user", "fa-regular fa-square-caret-left", "fa-regular fa-star", "fa-regular fa-chess-knight", "fa-regular fa-face-laugh-squint", "fa-regular fa-face-laugh", "fa-regular fa-folder-open", "fa-regular fa-clipboard", "fa-regular fa-chess-queen", "fa-regular fa-hand-back-fist", "fa-regular fa-square-caret-up", "fa-regular fa-chart-bar", "fa-regular fa-window-restore", "fa-regular fa-square-plus", "fa-regular fa-image", "fa-regular fa-folder-closed", "fa-regular fa-lemon", "fa-regular fa-handshake", "fa-regular fa-gem", "fa-regular fa-circle-play", "fa-regular fa-circle-check", "fa-regular fa-circle-stop", "fa-regular fa-id-badge", "fa-regular fa-face-laugh-beam", "fa-regular fa-registered", "fa-regular fa-address-card", "fa-regular fa-face-tired", "fa-regular fa-font-awesome", "fa-regular fa-face-smile-wink", "fa-regular fa-file-word", "fa-regular fa-file-powerpoint", "fa-regular fa-envelope-open", "fa-regular fa-file-zipper", "fa-regular fa-square", "fa-regular fa-snowflake", "fa-regular fa-newspaper", "fa-regular fa-face-kiss-wink-heart", "fa-regular fa-star-half-stroke", "fa-regular fa-file-excel", "fa-regular fa-face-grin-beam", "fa-regular fa-object-ungroup", "fa-regular fa-circle-right", "fa-regular fa-face-rolling-eyes", "fa-regular fa-object-group", "fa-regular fa-heart", "fa-regular fa-face-surprise", "fa-regular fa-circle-pause", "fa-regular fa-circle", "fa-regular fa-circle-up", "fa-regular fa-file-audio", "fa-regular fa-file-image", "fa-regular fa-circle-question", "fa-regular fa-face-meh-blank", "fa-regular fa-eye", "fa-regular fa-face-sad-cry", "fa-regular fa-file-code", "fa-regular fa-window-maximize", "fa-regular fa-face-frown", "fa-regular fa-floppy-disk", "fa-regular fa-comment-dots", "fa-regular fa-face-grin-squint", "fa-regular fa-hand-pointer", "fa-regular fa-hand-scissors", "fa-regular fa-face-grin-tears", "fa-regular fa-calendar-xmark", "fa-regular fa-file-video", "fa-regular fa-file-pdf", "fa-regular fa-comment", "fa-regular fa-envelope", "fa-regular fa-hourglass", "fa-regular fa-calendar-check", "fa-regular fa-hard-drive", "fa-regular fa-face-grin-squint-tears", "fa-regular fa-rectangle-list", "fa-regular fa-calendar-plus", "fa-regular fa-circle-left", "fa-regular fa-money-bill-1", "fa-regular fa-clock", "fa-regular fa-keyboard", "fa-regular fa-closed-captioning", "fa-regular fa-images", "fa-regular fa-face-grin", "fa-regular fa-face-meh", "fa-regular fa-id-card", "fa-regular fa-sun", "fa-regular fa-face-laugh-wink", "fa-regular fa-circle-down", "fa-regular fa-thumbs-down", "fa-regular fa-chess-pawn", "fa-regular fa-credit-card", "fa-regular fa-bell", "fa-regular fa-file", "fa-regular fa-hospital", "fa-regular fa-chess-rook", "fa-regular fa-star-half", "fa-regular fa-chess-king", "fa-regular fa-circle-user", "fa-regular fa-copy", "fa-regular fa-share-from-square", "fa-regular fa-copyright", "fa-regular fa-map", "fa-regular fa-bell-slash", "fa-regular fa-hand-lizard", "fa-regular fa-face-smile", "fa-regular fa-hand-peace", "fa-regular fa-face-grin-hearts", "fa-regular fa-building", "fa-regular fa-face-grin-beam-sweat", "fa-regular fa-moon", "fa-regular fa-calendar", "fa-regular fa-face-grin-tongue-wink", "fa-regular fa-clone", "fa-regular fa-face-angry", "fa-regular fa-rectangle-xmark", "fa-regular fa-paper-plane", "fa-regular fa-life-ring", "fa-regular fa-face-grimace", "fa-regular fa-calendar-minus", "fa-regular fa-circle-xmark", "fa-regular fa-thumbs-up", "fa-regular fa-window-minimize", "fa-regular fa-square-full", "fa-regular fa-note-sticky", "fa-regular fa-face-sad-tear", "fa-regular fa-hand-point-left", "fa-brands fa-monero", "fa-brands fa-hooli", "fa-brands fa-yelp", "fa-brands fa-cc-visa", "fa-brands fa-lastfm", "fa-brands fa-shopware", "fa-brands fa-creative-commons-nc", "fa-brands fa-aws", "fa-brands fa-redhat", "fa-brands fa-yoast", "fa-brands fa-cloudflare", "fa-brands fa-ups", "fa-brands fa-pixiv", "fa-brands fa-wpexplorer", "fa-brands fa-dyalog", "fa-brands fa-bity", "fa-brands fa-stackpath", "fa-brands fa-buysellads", "fa-brands fa-first-order", "fa-brands fa-modx", "fa-brands fa-guilded", "fa-brands fa-vnv", "fa-brands fa-square-js", "fa-brands fa-microsoft", "fa-brands fa-qq", "fa-brands fa-orcid", "fa-brands fa-java", "fa-brands fa-invision", "fa-brands fa-creative-commons-pd-alt", "fa-brands fa-centercode", "fa-brands fa-glide-g", "fa-brands fa-drupal", "fa-brands fa-jxl", "fa-brands fa-dart-lang", "fa-brands fa-hire-a-helper", "fa-brands fa-creative-commons-by", "fa-brands fa-unity", "fa-brands fa-whmcs", "fa-brands fa-rocketchat", "fa-brands fa-vk", "fa-brands fa-untappd", "fa-brands fa-mailchimp", "fa-brands fa-css3-alt", "fa-brands fa-square-reddit", "fa-brands fa-vimeo-v", "fa-brands fa-contao", "fa-brands fa-square-font-awesome", "fa-brands fa-deskpro", "fa-brands fa-brave", "fa-brands fa-sistrix", "fa-brands fa-square-instagram", "fa-brands fa-battle-net", "fa-brands fa-the-red-yeti", "fa-brands fa-square-hacker-news", "fa-brands fa-edge", "fa-brands fa-threads", "fa-brands fa-napster", "fa-brands fa-square-snapchat", "fa-brands fa-google-plus-g", "fa-brands fa-artstation", "fa-brands fa-markdown", "fa-brands fa-sourcetree", "fa-brands fa-google-plus", "fa-brands fa-diaspora", "fa-brands fa-foursquare", "fa-brands fa-stack-overflow", "fa-brands fa-github-alt", "fa-brands fa-phoenix-squadron", "fa-brands fa-pagelines", "fa-brands fa-algolia", "fa-brands fa-red-river", "fa-brands fa-creative-commons-sa", "fa-brands fa-safari", "fa-brands fa-google", "fa-brands fa-square-font-awesome-stroke", "fa-brands fa-atlassian", "fa-brands fa-linkedin-in", "fa-brands fa-digital-ocean", "fa-brands fa-nimblr", "fa-brands fa-chromecast", "fa-brands fa-evernote", "fa-brands fa-hacker-news", "fa-brands fa-creative-commons-sampling", "fa-brands fa-adversal", "fa-brands fa-creative-commons", "fa-brands fa-watchman-monitoring", "fa-brands fa-fonticons", "fa-brands fa-weixin", "fa-brands fa-shirtsinbulk", "fa-brands fa-codepen", "fa-brands fa-git-alt", "fa-brands fa-lyft", "fa-brands fa-rev", "fa-brands fa-windows", "fa-brands fa-wizards-of-the-coast", "fa-brands fa-square-viadeo", "fa-brands fa-meetup", "fa-brands fa-centos", "fa-brands fa-adn", "fa-brands fa-cloudsmith", "fa-brands fa-opensuse", "fa-brands fa-pied-piper-alt", "fa-brands fa-square-dribbble", "fa-brands fa-codiepie", "fa-brands fa-node", "fa-brands fa-mix", "fa-brands fa-steam", "fa-brands fa-cc-apple-pay", "fa-brands fa-scribd", "fa-brands fa-debian", "fa-brands fa-openid", "fa-brands fa-instalod", "fa-brands fa-files-pinwheel", "fa-brands fa-expeditedssl", "fa-brands fa-sellcast", "fa-brands fa-square-twitter", "fa-brands fa-r-project", "fa-brands fa-delicious", "fa-brands fa-freebsd", "fa-brands fa-vuejs", "fa-brands fa-accusoft", "fa-brands fa-ioxhost", "fa-brands fa-fonticons-fi", "fa-brands fa-app-store", "fa-brands fa-cc-mastercard", "fa-brands fa-itunes-note", "fa-brands fa-golang", "fa-brands fa-kickstarter", "fa-brands fa-grav", "fa-brands fa-weibo", "fa-brands fa-uncharted", "fa-brands fa-firstdraft", "fa-brands fa-square-youtube", "fa-brands fa-wikipedia-w", "fa-brands fa-wpressr", "fa-brands fa-angellist", "fa-brands fa-galactic-republic", "fa-brands fa-nfc-directional", "fa-brands fa-skype", "fa-brands fa-joget", "fa-brands fa-fedora", "fa-brands fa-stripe-s", "fa-brands fa-meta", "fa-brands fa-laravel", "fa-brands fa-hotjar", "fa-brands fa-bluetooth-b", "fa-brands fa-square-letterboxd", "fa-brands fa-sticker-mule", "fa-brands fa-creative-commons-zero", "fa-brands fa-hips", "fa-brands fa-css", "fa-brands fa-behance", "fa-brands fa-reddit", "fa-brands fa-discord", "fa-brands fa-chrome", "fa-brands fa-app-store-ios", "fa-brands fa-cc-discover", "fa-brands fa-wpbeginner", "fa-brands fa-confluence", "fa-brands fa-shoelace", "fa-brands fa-mdb", "fa-brands fa-dochub", "fa-brands fa-accessible-icon", "fa-brands fa-ebay", "fa-brands fa-amazon", "fa-brands fa-unsplash", "fa-brands fa-yarn", "fa-brands fa-square-steam", "fa-brands fa-500px", "fa-brands fa-square-vimeo", "fa-brands fa-asymmetrik", "fa-brands fa-font-awesome", "fa-brands fa-gratipay", "fa-brands fa-apple", "fa-brands fa-hive", "fa-brands fa-gitkraken", "fa-brands fa-keybase", "fa-brands fa-apple-pay", "fa-brands fa-padlet", "fa-brands fa-amazon-pay", "fa-brands fa-square-github", "fa-brands fa-stumbleupon", "fa-brands fa-fedex", "fa-brands fa-phoenix-framework", "fa-brands fa-shopify", "fa-brands fa-neos", "fa-brands fa-square-threads", "fa-brands fa-hackerrank", "fa-brands fa-researchgate", "fa-brands fa-swift", "fa-brands fa-angular", "fa-brands fa-speakap", "fa-brands fa-angrycreative", "fa-brands fa-y-combinator", "fa-brands fa-empire", "fa-brands fa-envira", "fa-brands fa-google-scholar", "fa-brands fa-square-gitlab", "fa-brands fa-studiovinari", "fa-brands fa-pied-piper", "fa-brands fa-wordpress", "fa-brands fa-product-hunt", "fa-brands fa-firefox", "fa-brands fa-linode", "fa-brands fa-goodreads", "fa-brands fa-square-odnoklassniki", "fa-brands fa-jsfiddle", "fa-brands fa-sith", "fa-brands fa-themeisle", "fa-brands fa-page4", "fa-brands fa-hashnode", "fa-brands fa-react", "fa-brands fa-cc-paypal", "fa-brands fa-squarespace", "fa-brands fa-cc-stripe", "fa-brands fa-creative-commons-share", "fa-brands fa-bitcoin", "fa-brands fa-keycdn", "fa-brands fa-opera", "fa-brands fa-itch-io", "fa-brands fa-umbraco", "fa-brands fa-galactic-senate", "fa-brands fa-ubuntu", "fa-brands fa-draft2digital", "fa-brands fa-stripe", "fa-brands fa-houzz", "fa-brands fa-gg", "fa-brands fa-dhl", "fa-brands fa-square-pinterest", "fa-brands fa-xing", "fa-brands fa-blackberry", "fa-brands fa-creative-commons-pd", "fa-brands fa-playstation", "fa-brands fa-quinscape", "fa-brands fa-less", "fa-brands fa-blogger-b", "fa-brands fa-opencart", "fa-brands fa-vine", "fa-brands fa-signal-messenger", "fa-brands fa-paypal", "fa-brands fa-gitlab", "fa-brands fa-typo3", "fa-brands fa-reddit-alien", "fa-brands fa-yahoo", "fa-brands fa-dailymotion", "fa-brands fa-affiliatetheme", "fa-brands fa-pied-piper-pp", "fa-brands fa-bootstrap", "fa-brands fa-odnoklassniki", "fa-brands fa-nfc-symbol", "fa-brands fa-mintbit", "fa-brands fa-ethereum", "fa-brands fa-speaker-deck", "fa-brands fa-creative-commons-nc-eu", "fa-brands fa-patreon", "fa-brands fa-avianex", "fa-brands fa-ello", "fa-brands fa-gofore", "fa-brands fa-bimobject", "fa-brands fa-brave-reverse", "fa-brands fa-facebook-f", "fa-brands fa-square-google-plus", "fa-brands fa-web-awesome", "fa-brands fa-mandalorian", "fa-brands fa-first-order-alt", "fa-brands fa-osi", "fa-brands fa-google-wallet", "fa-brands fa-d-and-d-beyond", "fa-brands fa-periscope", "fa-brands fa-fulcrum", "fa-brands fa-cloudscale", "fa-brands fa-forumbee", "fa-brands fa-mizuni", "fa-brands fa-schlix", "fa-brands fa-square-xing", "fa-brands fa-bandcamp", "fa-brands fa-wpforms", "fa-brands fa-cloudversify", "fa-brands fa-usps", "fa-brands fa-megaport", "fa-brands fa-magento", "fa-brands fa-spotify", "fa-brands fa-optin-monster", "fa-brands fa-fly", "fa-brands fa-square-bluesky", "fa-brands fa-aviato", "fa-brands fa-itunes", "fa-brands fa-cuttlefish", "fa-brands fa-blogger", "fa-brands fa-flickr", "fa-brands fa-viber", "fa-brands fa-soundcloud", "fa-brands fa-digg", "fa-brands fa-tencent-weibo", "fa-brands fa-letterboxd", "fa-brands fa-symfony", "fa-brands fa-maxcdn", "fa-brands fa-etsy", "fa-brands fa-facebook-messenger", "fa-brands fa-audible", "fa-brands fa-think-peaks", "fa-brands fa-bilibili", "fa-brands fa-erlang", "fa-brands fa-x-twitter", "fa-brands fa-cotton-bureau", "fa-brands fa-dashcube", "fa-brands fa-42-group", "fa-brands fa-stack-exchange", "fa-brands fa-elementor", "fa-brands fa-square-pied-piper", "fa-brands fa-creative-commons-nd", "fa-brands fa-palfed", "fa-brands fa-superpowers", "fa-brands fa-resolving", "fa-brands fa-xbox", "fa-brands fa-square-web-awesome-stroke", "fa-brands fa-searchengin", "fa-brands fa-tiktok", "fa-brands fa-square-facebook", "fa-brands fa-renren", "fa-brands fa-linux", "fa-brands fa-glide", "fa-brands fa-linkedin", "fa-brands fa-hubspot", "fa-brands fa-deploydog", "fa-brands fa-twitch", "fa-brands fa-flutter", "fa-brands fa-ravelry", "fa-brands fa-mixer", "fa-brands fa-square-lastfm", "fa-brands fa-vimeo", "fa-brands fa-mendeley", "fa-brands fa-uniregistry", "fa-brands fa-figma", "fa-brands fa-creative-commons-remix", "fa-brands fa-cc-amazon-pay", "fa-brands fa-dropbox", "fa-brands fa-instagram", "fa-brands fa-cmplid", "fa-brands fa-upwork", "fa-brands fa-facebook", "fa-brands fa-gripfire", "fa-brands fa-jedi-order", "fa-brands fa-uikit", "fa-brands fa-fort-awesome-alt", "fa-brands fa-phabricator", "fa-brands fa-ussunnah", "fa-brands fa-earlybirds", "fa-brands fa-trade-federation", "fa-brands fa-autoprefixer", "fa-brands fa-whatsapp", "fa-brands fa-square-upwork", "fa-brands fa-slideshare", "fa-brands fa-google-play", "fa-brands fa-viadeo", "fa-brands fa-line", "fa-brands fa-google-drive", "fa-brands fa-servicestack", "fa-brands fa-simplybuilt", "fa-brands fa-bitbucket", "fa-brands fa-imdb", "fa-brands fa-deezer", "fa-brands fa-raspberry-pi", "fa-brands fa-jira", "fa-brands fa-docker", "fa-brands fa-screenpal", "fa-brands fa-bluetooth", "fa-brands fa-gitter", "fa-brands fa-d-and-d", "fa-brands fa-microblog", "fa-brands fa-cc-diners-club", "fa-brands fa-gg-circle", "fa-brands fa-pied-piper-hat", "fa-brands fa-kickstarter-k", "fa-brands fa-yandex", "fa-brands fa-readme", "fa-brands fa-html5", "fa-brands fa-sellsy", "fa-brands fa-square-web-awesome", "fa-brands fa-sass", "fa-brands fa-wirsindhandwerk", "fa-brands fa-buromobelexperte", "fa-brands fa-salesforce", "fa-brands fa-octopus-deploy", "fa-brands fa-medapps", "fa-brands fa-ns8", "fa-brands fa-pinterest-p", "fa-brands fa-apper", "fa-brands fa-fort-awesome", "fa-brands fa-waze", "fa-brands fa-bluesky", "fa-brands fa-cc-jcb", "fa-brands fa-snapchat", "fa-brands fa-fantasy-flight-games", "fa-brands fa-rust", "fa-brands fa-wix", "fa-brands fa-square-behance", "fa-brands fa-supple", "fa-brands fa-webflow", "fa-brands fa-rebel", "fa-brands fa-css3", "fa-brands fa-staylinked", "fa-brands fa-kaggle", "fa-brands fa-space-awesome", "fa-brands fa-deviantart", "fa-brands fa-cpanel", "fa-brands fa-goodreads-g", "fa-brands fa-square-git", "fa-brands fa-square-tumblr", "fa-brands fa-trello", "fa-brands fa-creative-commons-nc-jp", "fa-brands fa-get-pocket", "fa-brands fa-perbyte", "fa-brands fa-grunt", "fa-brands fa-weebly", "fa-brands fa-connectdevelop", "fa-brands fa-leanpub", "fa-brands fa-black-tie", "fa-brands fa-themeco", "fa-brands fa-python", "fa-brands fa-android", "fa-brands fa-bots", "fa-brands fa-free-code-camp", "fa-brands fa-hornbill", "fa-brands fa-js", "fa-brands fa-ideal", "fa-brands fa-git", "fa-brands fa-dev", "fa-brands fa-sketch", "fa-brands fa-yandex-international", "fa-brands fa-cc-amex", "fa-brands fa-uber", "fa-brands fa-github", "fa-brands fa-php", "fa-brands fa-alipay", "fa-brands fa-youtube", "fa-brands fa-skyatlas", "fa-brands fa-firefox-browser", "fa-brands fa-replyd", "fa-brands fa-suse", "fa-brands fa-jenkins", "fa-brands fa-twitter", "fa-brands fa-rockrms", "fa-brands fa-pinterest", "fa-brands fa-buffer", "fa-brands fa-npm", "fa-brands fa-yammer", "fa-brands fa-btc", "fa-brands fa-dribbble", "fa-brands fa-stumbleupon-circle", "fa-brands fa-internet-explorer", "fa-brands fa-stubber", "fa-brands fa-telegram", "fa-brands fa-old-republic", "fa-brands fa-odysee", "fa-brands fa-square-whatsapp", "fa-brands fa-node-js", "fa-brands fa-edge-legacy", "fa-brands fa-slack", "fa-brands fa-medrt", "fa-brands fa-usb", "fa-brands fa-tumblr", "fa-brands fa-vaadin", "fa-brands fa-quora", "fa-brands fa-square-x-twitter", "fa-brands fa-reacteurope", "fa-brands fa-medium", "fa-brands fa-amilia", "fa-brands fa-mixcloud", "fa-brands fa-flipboard", "fa-brands fa-viacoin", "fa-brands fa-critical-role", "fa-brands fa-sitrox", "fa-brands fa-discourse", "fa-brands fa-joomla", "fa-brands fa-mastodon", "fa-brands fa-airbnb", "fa-brands fa-wolf-pack-battalion", "fa-brands fa-buy-n-large", "fa-brands fa-gulp", "fa-brands fa-creative-commons-sampling-plus", "fa-brands fa-strava", "fa-brands fa-ember", "fa-brands fa-canadian-maple-leaf", "fa-brands fa-teamspeak", "fa-brands fa-pushed", "fa-brands fa-wordpress-simple", "fa-brands fa-nutritionix", "fa-brands fa-wodu", "fa-brands fa-google-pay", "fa-brands fa-intercom", "fa-brands fa-zhihu", "fa-brands fa-korvue", "fa-brands fa-pix", "fa-brands fa-steam-symbol");
    }

}

Square_Icon_Manager::instance();
