<?php

/**
 * Square functions and definitions.
 *
 * @package Square
 */
if (!defined('SQUARE_VERSION')) {
    $square_get_theme = wp_get_theme();
    $square_version = $square_get_theme->Version;
    define('SQUARE_VERSION', $square_version);
}


if (!function_exists('square_setup')):

    //Sets up theme defaults and registers support for various WordPress features.
    function square_setup() {
        // Make theme available for translation.
        load_theme_textdomain('square', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        //Let WordPress manage the document title.
        add_theme_support('title-tag');

        //Support for woocommerce
        add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');

        //Enable support for Post Thumbnails on posts and pages.
        add_theme_support('post-thumbnails');
        add_image_size('square-about-thumb', 400, 420, true);
        add_image_size('square-blog-thumb', 800, 420, true);

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(array(
            'primary' => esc_html__('Primary Menu', 'square'),
        ));

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'style',
            'script',
            'navigation-widgets'
        ));

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('square_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        add_theme_support('custom-logo', array(
            'height' => 60,
            'width' => 300,
            'flex-height' => true,
            'flex-width' => true,
            'header-text' => array('.sq-site-title', '.sq-site-description'),
        ));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        // Add support for responsive embedded content.
        add_theme_support('responsive-embeds');

        // Add support editor style.
        add_theme_support('editor-styles');

        // Add support for Block Styles.
        add_theme_support('wp-block-styles');

        /*
         * This theme styles the visual editor to resemble the theme style,
         * specifically font, colors, icons, and column width.
         */
        add_editor_style(array('css/editor-style.css'));
    }

endif; // square_setup
add_action('after_setup_theme', 'square_setup');

function square_content_width() {
    $GLOBALS['content_width'] = apply_filters('square_content_width', 800);
}

add_action('after_setup_theme', 'square_content_width', 0);

//Enables the Excerpt meta box in Page edit screen.
function square_add_excerpt_support_for_pages() {
    add_post_type_support('page', 'excerpt');
}

add_action('init', 'square_add_excerpt_support_for_pages');

//If Custom Logo is uploaded, remove the backward compatibility for header image
function square_remove_header_image() {
    $custom_logo_enabled = get_theme_mod('square_custom_logo_enabled', false);
    if (!$custom_logo_enabled && has_custom_logo()) {
        set_theme_mod('square_custom_logo_enabled', true);
        set_theme_mod('header_image', '');
    }
}

add_action('init', 'square_remove_header_image');

//Register widget area.
function square_widgets_init() {
    register_sidebar(array(
        'name' => esc_html__('Right Sidebar', 'square'),
        'id' => 'square-right-sidebar',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Left Sidebar', 'square'),
        'id' => 'square-left-sidebar',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Shop Sidebar', 'square'),
        'id' => 'square-shop-sidebar',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 1', 'square'),
        'id' => 'square-footer1',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 2', 'square'),
        'id' => 'square-footer2',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 3', 'square'),
        'id' => 'square-footer3',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Footer 4', 'square'),
        'id' => 'square-footer4',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));

    register_sidebar(array(
        'name' => esc_html__('About Footer', 'square'),
        'id' => 'square-about-footer',
        'description' => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));
}

add_action('widgets_init', 'square_widgets_init');

if (!function_exists('square_fonts_url')):

    /**
     * Register Google fonts for Square.
     *
     * @since Square 1.0
     *
     * @return string Google fonts URL for the theme.
     */
    function square_fonts_url() {
        $fonts_url = '';
        $fonts = $customizer_font_family = array();
        $subsets = 'latin,latin-ext';
        $all_fonts = square_all_fonts();
        $google_fonts = square_google_fonts();

        $customizer_fonts = apply_filters('square_customizer_fonts', array(
            'square_body_family' => 'Open Sans',
            'square_menu_family' => 'Roboto Condensed',
            'square_h_family' => 'Roboto Condensed'
        ));

        foreach ($customizer_fonts as $key => $value) {
            $font = get_theme_mod($key, $value);
            if (array_key_exists($font, $google_fonts)) {
                $customizer_font_family[] = $font;
            }
        }

        if ($customizer_font_family) {
            $customizer_font_family = array_unique($customizer_font_family);
            foreach ($customizer_font_family as $font_family) {
                if (isset($all_fonts[$font_family]['variants'])) {
                    $variants_array = $all_fonts[$font_family]['variants'];
                    $variants_keys = array_keys($variants_array);
                    $variants = implode(',', $variants_keys);

                    $fonts[] = $font_family . ':' . str_replace('italic', 'i', $variants);
                }
            }

            if ($fonts) {
                $fonts_url = add_query_arg(array(
                    'family' => urlencode(implode('|', $fonts)),
                    'subset' => urlencode($subsets),
                    'display' => 'swap',
                ), 'https://fonts.googleapis.com/css');
            }
        }

        return $fonts_url;
    }

endif;

/**
 * Enqueue scripts and styles.
 */
function square_scripts() {
    wp_enqueue_script('modernizr', get_template_directory_uri() . '/js/modernizr.js', array(), SQUARE_VERSION, true);
    wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), SQUARE_VERSION, true);
    wp_enqueue_script('jquery-superfish', get_template_directory_uri() . '/js/jquery.superfish.js', array('jquery'), SQUARE_VERSION, true);

    if (is_page_template('templates/home-template.php') || is_front_page()) {
        wp_enqueue_script('square-draggabilly', get_template_directory_uri() . '/js/draggabilly.pkgd.min.js', array('jquery'), SQUARE_VERSION, true);
        wp_enqueue_script('square-elastiStack', get_template_directory_uri() . '/js/elastiStack.js', array('jquery'), SQUARE_VERSION, true);
    }

    wp_enqueue_script('square-custom', get_template_directory_uri() . '/js/square-custom.js', array('jquery'), SQUARE_VERSION, true);
    wp_localize_script('square-custom', 'square_localize', array(
        'is_rtl' => is_rtl() ? 'true' : 'false'
    ));

    wp_enqueue_style('animate', get_template_directory_uri() . '/css/animate.css', array(), SQUARE_VERSION);
    wp_enqueue_style('font-awesome-v4-shims', get_template_directory_uri() . '/css/v4-shims.css', array(), SQUARE_VERSION);
    wp_enqueue_style('font-awesome-6.3.0', get_template_directory_uri() . '/css/font-awesome-6.3.0.css', array(), SQUARE_VERSION);
    wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), SQUARE_VERSION);
    wp_enqueue_style('square-style', get_stylesheet_uri(), array(), SQUARE_VERSION);
    wp_style_add_data('square-style', 'rtl', 'replace');
    wp_add_inline_style('square-style', square_dymanic_styles());
    wp_enqueue_style('wp-block-library');

    $fonts_url = square_fonts_url();
    $load_font_locally = get_theme_mod('square_load_google_font_locally', false);
    if ($fonts_url && $load_font_locally) {
        require_once get_theme_file_path('inc/wptt-webfont-loader.php');
        $fonts_url = wptt_get_webfont_url($fonts_url);
    }

    // Load Fonts if necessary.
    if ($fonts_url) {
        wp_enqueue_style('square-fonts', $fonts_url, array(), NULL);
    }

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('wp_enqueue_scripts', 'square_scripts');

add_action('wp_print_scripts', function () {
    if (!is_admin()) {
        return;
    }
    if (function_exists('get_current_screen') && get_current_screen() && get_current_screen()->is_block_editor() && get_current_screen()->base === 'post') {
        echo '<style id="square-admin-css-vars">';
        echo square_dymanic_styles();
        echo '</style>';
    }
});

/**
 * Enqueue admin style
 */
function square_admin_scripts() {
    wp_enqueue_media();
    wp_enqueue_style('square-admin-style', get_template_directory_uri() . '/inc/css/admin-style.css', array(), SQUARE_VERSION);
    wp_enqueue_script('square-admin-scripts', get_template_directory_uri() . '/inc/js/admin-scripts.js', array('jquery'), SQUARE_VERSION, true);

    $fonts_url = square_fonts_url();

    // Load Fonts if necessary.
    if ($fonts_url && function_exists('get_current_screen') && get_current_screen() && get_current_screen()->is_block_editor() && get_current_screen()->base === 'post') {
        wp_enqueue_style('square-fonts', $fonts_url, array(), NULL);
    }
}

add_action('admin_enqueue_scripts', 'square_admin_scripts');
add_action('elementor/editor/before_enqueue_scripts', 'square_admin_scripts');

if (!function_exists('wp_body_open')) {

    function wp_body_open() {
        do_action('wp_body_open');
    }

}

add_filter('template_include', 'square_frontpage_template', 9999);

function square_frontpage_template($template) {
    $enable_frontpage = get_theme_mod('square_enable_frontpage', false);
    $new_template = locate_template(array('templates/home-template.php'));

    if ($enable_frontpage && is_front_page()) {
        if ('' != $new_template) {
            return $new_template;
        }
    }

    if ($enable_frontpage && 'page' == get_option('show_on_front') && !get_option('page_on_front')) {
        if ('' != $new_template) {
            return $new_template;
        }
    }

    return $template;
}

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/square-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Load Woocommerce additions
 */
require get_template_directory() . '/inc/woo-functions.php';

/**
 * Load Custom Metabox
 */
require get_template_directory() . '/inc/square-metabox.php';

/**
 * Welcome Page.
 */
require get_template_directory() . '/welcome/welcome.php';

/**
 * Dynamic Styles additions.
 */
require get_template_directory() . '/inc/style.php';

/**
 * Starter Content additions.
 */
require get_template_directory() . '/inc/starter-content.php';
/**
 * Widgets additions.
 */
require get_template_directory() . '/inc/widgets/widget-fields.php';
require get_template_directory() . '/inc/widgets/widget-contact-info.php';
require get_template_directory() . '/inc/widgets/widget-personal-info.php';
require get_template_directory() . '/inc/widgets/widget-latest-post.php';
