<?php
/**
 * The framework has its own template hierarchy that can be used instead of the default WordPress 
 * template hierarchy.  It is not much different than the default.  It was built to extend the default by 
 * making it smarter and more flexible.  The goal is to give theme developers and end users an 
 * easy-to-override system that doesn't involve massive amounts of conditional tags within files.
 *
 * @package SpringBoardCore
 * @subpackage Functions
 */

/* Filter the date template. */
add_filter( 'date_template', 'sboard_date_template' );

/**
 * Overrides WP's default template for date-based archives. Better abstraction of templates than 
 * is_date() allows by checking for the year, month, week, day, hour, and minute.
 *
 * @since 0.6.0
 * @uses locate_template() Checks for template in child and parent theme.
 * @param string $template
 * @return string $template Full path to file.
 */
function sboard_date_template( $template ) {
	$templates = array();

	/* If viewing a time-based archive. */
	if ( is_time() ) {

		/* If viewing a minutely archive. */
		if ( get_query_var( 'minute' ) )
			$templates[] = 'minute.php';

		/* If viewing an hourly archive. */
		elseif ( get_query_var( 'hour' ) )
			$templates[] = 'hour.php';

		/* Catchall for any time-based archive. */
		$templates[] = 'time.php';
	}

	/* If viewing a daily archive. */
	elseif ( is_day() )
		$templates[] = 'day.php';

	/* If viewing a weekly archive. */
	elseif ( get_query_var( 'w' ) )
		$templates[] = 'week.php';

	/* If viewing a monthly archive. */
	elseif ( is_month() )
		$templates[] = 'month.php';

	/* If viewing a yearly archive. */
	elseif ( is_year() )
		$templates[] = 'year.php';

	/* Catchall template for date-based archives. */
	$templates[] = 'date.php';

	/* Fall back to the basic archive template. */
	$templates[] = 'archive.php';

	/* Return the found template. */
	return locate_template( $templates );
}

?>
