<?php
/**
 * Deprecated functions that should be avoided in favor of newer functions. Also handles removed 
 * functions to avoid errors. Developers should not use these functions in their parent themes and users 
 * should not use these functions in their child themes.  The functions below will all be removed at some 
 * point in a future release.  If your theme is using one of these, you should use the listed alternative or 
 * remove it from your theme if necessary.
 *
 * @package SpringBoardCore
 * @subpackage Functions
 */

/**
 * @since 0.2.0
 * @deprecated 0.7.0
 */
function sboard_after_single() {
	_deprecated_function( __FUNCTION__, '0.7', "do_atomic( 'after_singular' )" );
	sboard_after_singular();
}

/**
 * @since 0.2.0
 * @deprecated 0.7.0
 */
function sboard_after_page() {
	_deprecated_function( __FUNCTION__, '0.7', "do_atomic( 'after_singular' )" );
	sboard_after_singular();
}

/**
 * @since 0.2.2
 * @deprecated 0.8.0
 */
function sboard_comment_author() {
	_deprecated_function( __FUNCTION__, '0.8', 'sboard_comment_author_shortcode()' );
	return sboard_comment_author_shortcode();
}

/**
 * @since 0.4.0
 * @deprecated 1.0.0
 */
function sboard_theme_settings() {
	_deprecated_function( __FUNCTION__, '1.0.0', 'sboard_get_default_theme_settings()' );
	return apply_filters( sboard_get_prefix() . '_settings_args', sboard_get_default_theme_settings() );
}

/**
 * @since 0.4.0
 * @deprecated 1.0.0
 */
function sboard_doctype() {
	_deprecated_function( __FUNCTION__, '1.0.0', '' );
	if ( !preg_match( "/MSIE 6.0/", esc_attr( $_SERVER['HTTP_USER_AGENT'] ) ) )
		$doctype = '<' . '?xml version="1.0" encoding="' . get_bloginfo( 'charset' ) . '"?>' . "\n";

	$doctype .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' . "\n";
	echo apply_atomic( 'doctype', $doctype );
}

/**
 * @since 0.4.0
 * @deprecated 1.0.0
 */
function sboard_meta_content_type() {
	_deprecated_function( __FUNCTION__, '1.0.0', '' );
	$content_type = '<meta http-equiv="Content-Type" content="' . get_bloginfo( 'html_type' ) . '; charset=' . get_bloginfo( 'charset' ) . '" />' . "\n";
	echo apply_atomic( 'meta_content_type', $content_type );
}

/**
 * @since 0.4.0
 * @deprecated 1.0.0
 */
function sboard_head_pingback() {
	_deprecated_function( __FUNCTION__, '1.0.0', '' );
	$pingback = '<link rel="pingback" href="' . get_bloginfo( 'pingback_url' ) . '" />' . "\n";
	echo apply_atomic( 'head_pingback', $pingback );
}

/**
 * @since 0.6.0
 * @deprecated 1.0.0
 */
function sboard_profile_uri() {
	_deprecated_function( __FUNCTION__, '1.0.0', '' );
	echo apply_atomic( 'profile_uri', 'http://gmpg.org/xfn/11' );
}

/**
 * @since 0.3.2
 * @deprecated 1.0.0
 */
function sboard_before_html() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_html' )" );
	do_atomic( 'before_html' );
}

/**
 * @since 0.3.2
 * @deprecated 1.0.0
 */
function sboard_after_html() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_html' )" );
	do_atomic( 'after_html' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_head() {
	_deprecated_function( __FUNCTION__, '1.0.0', 'wp_head' );
	do_atomic( 'head' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_before_header() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_header' )" );
	do_atomic( 'before_header' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_header() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'header' )" );
	do_atomic( 'header' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_after_header() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_header' )" );
	do_atomic( 'after_header' );
}

/**
 * @since 0.8.0
 * @deprecated 1.0.0
 */
function sboard_before_primary_menu() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_primary_menu' )" );
	do_atomic( 'before_primary_menu' );
}

/**
 * @since 0.8.0
 * @deprecated 1.0.0
 */
function sboard_after_primary_menu() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_primary_menu' )" );
	do_atomic( 'after_primary_menu' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_before_container() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_container' )" );
	do_atomic( 'before_container' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_before_content() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_content' )" );
	do_atomic( 'before_content' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_after_content() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_content' )" );
	do_atomic( 'after_content' );
}

/**
 * @since 0.5.0
 * @deprecated 1.0.0
 */
function sboard_before_entry() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_entry' )" );
	do_atomic( 'before_entry' );
}

/**
 * @since 0.5.0
 * @deprecated 1.0.0
 */
function sboard_after_entry() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_entry' )" );
	do_atomic( 'after_entry' );
}

/**
 * @since 0.7.0
 * @deprecated 1.0.0
 */
function sboard_after_singular() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_singular' )" );

	if ( is_singular( 'post' ) && !is_attachment() )
		do_action( 'sboard_after_single' );
	elseif ( is_page() )
		do_action( 'sboard_after_page' );

	do_atomic( 'after_singular' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_before_primary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_primary' )" );
	do_atomic( 'before_primary' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_after_primary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_primary' )" );
	do_atomic( 'after_primary' );
}

/**
 * @since 0.2.0
 * @deprecated 1.0.0
 */
function sboard_before_secondary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_secondary' )" );
	do_atomic( 'before_secondary' );
}

/**
 * @since 0.2.0
 * @deprecated 1.0.0
 */
function sboard_after_secondary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_secondary' )" );
	do_atomic( 'after_secondary' );
}

/**
 * @since 0.3.1
 * @deprecated 1.0.0
 */
function sboard_before_subsidiary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_subsidiary' )" );
	do_atomic( 'before_subsidiary' );
}

/**
 * @since 0.3.1
 * @deprecated 1.0.0
 */
function sboard_after_subsidiary() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_subsidiary' )" );
	do_atomic( 'after_subsidiary' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_after_container() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_container' )" );
	do_atomic( 'after_container' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_before_footer() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_footer' )" );
	do_atomic( 'before_footer' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_footer() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'footer' )" );
	do_atomic( 'footer' );
}

/**
 * @since 0.1.0
 * @deprecated 1.0.0
 */
function sboard_after_footer() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_footer' )" );
	do_atomic( 'after_footer' );
}

/**
 * @since 0.5.0
 * @deprecated 1.0.0
 */
function sboard_before_comment() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_comment' )" );
	do_atomic( 'before_comment' );
}

/**
 * @since 0.5.0
 * @deprecated 1.0.0
 */
function sboard_after_comment() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_comment' )" );
	do_atomic( 'after_comment' );
}

/**
 * @since 0.6.0
 * @deprecated 1.0.0
 */
function sboard_before_comment_list() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'before_comment_list' )" );
	do_atomic( 'before_comment_list' );
}

/**
 * @since 0.6.0
 * @deprecated 1.0.0
 */
function sboard_after_comment_list() {
	_deprecated_function( __FUNCTION__, '1.0.0', "do_atomic( 'after_comment_list' )" );
	do_atomic( 'after_comment_list' );
}

/* @deprecated 1.0.0. Backwards compatibility with old theme settings. */
// add_action( 'check_admin_referer', 'sboard_back_compat_update_settings' );

/**
 * Backwards compatibility function for updating child theme settings.  Do not use this function or the 
 * available hook in development.
 *
 * @since 1.0.0
 * @deprecated 1.0.0
 */
function sboard_back_compat_update_settings( $action ) {
// 	_deprecated_function( __FUNCTION__, '1.0.0' );

	$prefix = sboard_get_prefix();

	if ( "{$prefix}_theme_settings-options" == $action )
		do_action( "{$prefix}_update_settings_page" );
}

/**
 * @since 0.1.0
 * @deprecated 1.2.0
 */
function sboard_enqueue_script() {
	_deprecated_function( __FUNCTION__, '1.2.0', 'sboard_enqueue_scripts' );
	return;
}

/**
 * @since 1.0.0
 * @deprecated 1.2.0
 */
function sboard_admin_enqueue_style() {
	_deprecated_function( __FUNCTION__, '1.2.0', 'sboard_admin_enqueue_styles' );
	return;
}

/**
 * @since 0.7.0
 * @deprecated 1.2.0
 */
function sboard_settings_page_enqueue_style() {
	_deprecated_function( __FUNCTION__, '1.2.0', 'sboard_settings_page_enqueue_styles' );
	return;
}

/**
 * @since 0.7.0
 * @deprecated 1.2.0
 */
function sboard_settings_page_enqueue_script() {
	_deprecated_function( __FUNCTION__, '1.2.0', 'sboard_settings_page_enqueue_scripts' );
	return;
}

/* === Removed Functions === */

/* Functions removed in the 0.8 branch. */

function sboard_content_wrapper() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_handle_attachment() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_widget_class() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_before_ping_list() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_after_ping_list() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_pings_callback() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_pings_end_callback() {
	sboard_function_removed( __FUNCTION__ );
}

/* Functions removed in the 1.2 branch. */

function sboard_get_comment_form() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_before_comment_form() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_after_comment_form() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_get_utility_after_single() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_get_utility_after_page() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_create_post_meta_box() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box_args() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box_text() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box_select() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box_textarea() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_meta_box_radio() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_save_post_meta_box() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_create_settings_meta_boxes() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_footer_settings_meta_box() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_about_theme_meta_box() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_load_settings_page() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_page_nav() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_cat_nav() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_category_menu() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_search_form() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_class() {
	sboard_function_removed( __FUNCTION__ );
}

function is_sidebar_active() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_enqueue_style() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_add_theme_support() {
	sboard_function_removed( __FUNCTION__ );
}

function sboard_post_stylesheets() {
	sboard_function_removed( __FUNCTION__ );
}

/**
 * Message to display for removed functions.
 * @since 0.5.0
 */
function sboard_function_removed( $func = '' ) {
	die( sprintf( __( '<code>%1$s</code> &mdash; This function has been removed or replaced by another function.', sboard_get_textdomain() ), $func ) );
}

?>