<?php
/**
 * Creates a meta box for the theme settings page, which displays information settings the theme.  If a child theme 
 * is in use, an additional meta box will be added with its information.  To use this feature, the theme must 
 * support the 'settings' argument for 'sboard-core-theme-settings' feature.
 *
 * @package SpringBoardCore
 * @subpackage Admin
 */

/* Create the settings theme meta box on the 'add_meta_boxes' hook. */
add_action( 'add_meta_boxes', 'sboard_meta_box_theme_add_settings' );

/**
 * Adds the core settings theme meta box to the theme settings page.
 *
 * @since 1.2.0
 */
function sboard_meta_box_theme_add_settings() {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	$theme_data = sboard_get_theme_data();

	/* Adds the Settings box for the parent theme. */
	add_meta_box( 'sboard-core-settings-theme', sprintf( __( 'Settings %1$s', $domain ), $theme_data['Title'] ),
	'sboard_meta_box_theme_display_settings', sboard_get_settings_page_name(), 'normal', 'high' );

}

/**
 * Creates an information meta box with no settings settings the theme. The meta box will display
 * information settings both the parent theme and child theme. If a child theme is active, this function
 * will be called a second time.
 *
 * @since 1.2.0
 * @param $object Variable passed through the do_meta_boxes() call.
 * @param array $box Specific information settings the meta box being loaded.
 */
function sboard_meta_box_theme_display_settings( $object, $box ) {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	
	/* Grab theme information for the parent theme. */
	if ( 'sboard-core-settings-theme' == $box['id'] )
	$theme_data = sboard_get_theme_data();

	/* Grab theme information for the child theme. */
	elseif ( 'sboard-core-settings-child' == $box['id'] )
	$theme_data = sboard_get_theme_data( 'stylesheet' ); 
	
	global $theme_settings; $values = Array( 
		'set-activation'	=> Array (	'value' => 'yes', 'field' => 'activation',
										'section' => 'set-activate' ),
										
		'set-image'			=> Array (	'value' => 'http://www.google.com',
										'field' => 'image', 'section' => 'set-image' ),
										
		'set-text'			=> Array (	'value' => 'http://www.google.com', 
										'field' => 'text', 'section' => 'set-text' ),
										
		'set-long-input'	=> Array (	'value' => 'Long Input', 'field' => 'input-long',
		 								'section' => 'set-long-input',
										'misc' => 'Long Input (unit):' ), 
		
		'set-short-input'	=> Array (	'value' => 'Short Input', 'field' => 'input-short',
										'section' => 'set-short-input',
										'misc' => 'Short Input (unit):' ), 
										
		'set-text-field'	=> Array (	'value' => 'Text Field', 'field' => 'input-text-field',
										'section' => 'set-text-field'),
																		
		'set-checkbox'		=> Array (	'value' => 'on', 'field' => 'checkbox',
										'section' => 'set-checkbox',
										'misc' => 'Checkbox Question One'),

		'set-checkbox-next'	=> Array (	'value' => 'on', 'field' => 'checkbox',
										'section' => 'set-checkbox',
										'misc' => 'Checkbox Question Two'),
										
		'set-checkbox-third'=> Array (	'value' => 'off', 'field' => 'checkbox',
										'section' => 'set-checkbox',
										'misc' => 'Checkbox Question Three'),
										
		'do_media'			=> Array (	'value' => 'Add Image', 'field' => 'media',
										'section' => 'do_media'),
		'do_media_next'		=> Array (	'value' => 'Add Image', 'field' => 'media',
																		'section' => 'do_media_next'),
		'set-link'			=> Array (	'value' => 'http://www.google.com', 'field' => 'link',
										'section' => 'set-link') );
		
	$args = Array( 'target' => 'settings_page', 'values' => $values );
	do_action( "{$prefix}_establish_options", $args );
	//print_r($theme_settings);
	?>
	
	<style>
	.sboard_options_container img {
		max-width: 100%;
	}
	
	#sboard_theme_settings_container {
		overflow: hidden;
	}
	.sboard_options_container .form-table th {
		vertical-align: top;
		text-align: left;
		padding: 10px;
		width: 25%;
		line-height: 20px;
	}
	</style>
	
	<div id="sboard_theme_settings_container" class="sboard_options_container">
	<table class="form-table">
	<?php 
	$docs = 'no-docs';
	$text = 'A user-friendly, search-engine optimized parent theme, featuring 15 custom page templates and multiple widget-ready areas, allowing you to create any type of site you want.';
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Activation:', 'set-activate', $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Image:', 'set-image' , $docs, 'wordpress-icon-text.png' ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Text:', 'set-text', $docs, $text ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Long Input:', 'set-long-input', $docs ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Short Input:', 'set-short-input', $docs ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Text Field:', 'set-text-field', $docs ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Checkbox:', 'set-checkbox', $docs, 'Checkbox Question' ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Media:', 'do_media', $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Media 2:', 'do_media_next', $docs ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Link:', 'set-link' ) );

	?></table></div>
	<!--
	<script type="text/javascript" language="JavaScript">
		var container_height = $('#sboard_theme_settings_container').height();
		$(document).ready(function(){
			$(this).test_function(container_height);
		});
	</script>
	-->
	<?php
}

?>
