<?php
/**
 * Creates a meta box for the theme settings page, which displays information settings the theme.  If a child theme 
 * is in use, an additional meta box will be added with its information.  To use this feature, the theme must 
 * support the 'settings' argument for 'sboard-core-theme-settings' feature.
 *
 * @package SpringBoardCore
 * @subpackage Admin
 */

/* Create the settings theme meta box on the 'add_meta_boxes' hook. */
add_action( 'add_meta_boxes', 'sboard_meta_box_theme_add_logo' );

/**
 * Adds the core logo theme meta box to the theme logo page.
 *
 * @since 1.2.0
 */
function sboard_meta_box_theme_add_logo() {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	$theme_data = sboard_get_theme_data();

	/* Adds the Settings box for the parent theme. */
	add_meta_box( 'sboard-core-logo-theme', sprintf( __( 'Custom Logo', $domain ), $theme_data['Title'] ),
	'sboard_meta_box_theme_display_logo', sboard_get_settings_page_name(), 'normal', 'high' );

}

/**
 * Creates an information meta box with no logo settings the theme. The meta box will display
 * information settings both the parent theme and child theme. If a child theme is active, this function
 * will be called a second time.
 *
 * @since 1.2.0
 * @param $object Variable passed through the do_meta_boxes() call.
 * @param array $box Specific information settings the meta box being loaded.
 */
function sboard_meta_box_theme_display_logo( $object, $box ) {
	
	
	$settings_prefix = 'logo';
	$url = get_bloginfo('template_url');
	
	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	
	/* Grab theme information for the parent theme. */
	if ( 'sboard-core-settings-theme' == $box['id'] )
	$theme_data = sboard_get_theme_data();

	/* Grab theme information for the child theme. */
	elseif ( 'sboard-core-settings-child' == $box['id'] )
	$theme_data = sboard_get_theme_data( 'stylesheet' ); 
	
	global $theme_settings; $values = Array( 
		"{$settings_prefix}_activation"		=> Array (	'value' => 'yes', 'field' => 'activation',
											'section' => "{$settings_prefix}_activate" ),
										
		"{$settings_prefix}_preview"		=> Array (	'value' => 'http://www.google.com',
											'field' => 'image', 'section' => "{$settings_prefix}_preview" ),
										
		"{$settings_prefix}_description"	=> Array (	'value' => 'http://www.google.com', 
											'field' => 'text', 'section' => "{$settings_prefix}_description" ),
										
		"{$settings_prefix}_alternate"		=> Array (	'value' => 'Alternate', 'field' => 'input-long',
		 									'section' => "{$settings_prefix}_alternate",
											'misc' => '' ), 
										
		"{$settings_prefix}_upload_media"	=> Array (	'value' => 'Add Image', 'field' => 'media',
											'section' => "{$settings_prefix}_upload_media") );

		
	$args = Array( 'target' => 'settings_page', 'values' => $values );
	do_action( "{$prefix}_establish_options", $args );
	//print_r($theme_settings);
	?>
	
	<style>
	.sboard_options_container img {
		max-width: 100%;
	}
	
	#sboard_theme_logo_container {
		overflow: hidden;
	}
	.sboard_options_container .form-table th {
		vertical-align: top;
		text-align: left;
		padding: 10px;
		width: 25%;
		line-height: 20px;
	}
	</style>
	
	<div id="sboard_theme_logo_container" class="sboard_options_container">
	<table class="form-table">
	<?php 
	$docs = 'no-docs';
	$text = 'A user-friendly, search-engine optimized parent theme, featuring 15 custom page templates and multiple widget-ready areas, allowing you to create any type of site you want.';
	
	if( sboard_get_setting( "logo_upload_media" ) ){
		$image = sboard_get_setting( "logo_upload_media" );
	} elseif ( !sboard_get_setting( "logo_upload_media" ) ){
		$image = $url . '/library/images/wordpress-icon-text.png';
	}
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Use Custom Logo:', "{$settings_prefix}_activate", $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Preview:', "{$settings_prefix}_preview" , $docs, $image ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Description:', "{$settings_prefix}_description", $docs, $text ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Upload Image:', "{$settings_prefix}_upload_media", $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Image Alternate:', "{$settings_prefix}_alternate", $docs ) );

	?></table></div>
	<!--
	<script type="text/javascript" language="JavaScript">
		var container_height = $('#sboard_theme_settings_container').height();
		$(document).ready(function(){
			$(this).test_function(container_height);
		});
	</script>
	-->
	<?php
}

?>
