<?php
/**
 * Header Template
 *
 * The header template is generally used on every page of your site. Nearly all other
 * templates call it somewhere near the top of the file. It is used mostly as an opening
 * wrapper, which is closed with the footer.php file. It also executes key functions needed
 * by the theme, child themes, and plugins. 
 *
 * @package SpringBoard
 * @subpackage Template
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />
<title><?php sboard_document_title(); ?></title>

<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>" type="text/css" media="all" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php do_atomic( 'head' ); // @deprecated 0.9.0. Use 'wp_head'. ?>
<?php wp_head(); // wp_head ?>

</head>
<?php global $theme_settings;  
$background_repeat = sboard_get_setting( "background_repeat" );
switch ( $background_repeat ){
	case "Both":		$background_repeat = 'repeat';		break;
	case "Horizontal":	$background_repeat = 'repeat-x';	break;
	case "Vertical":	$background_repeat = 'repeat-y';	break;
	case "None":		$background_repeat = 'no-repeat';
}
?>
<?php if ( sboard_get_setting( "background_activation" ) == 'yes'){ ?>
<style>
body {
	background: <?php print sboard_get_setting( 'background_color' ); ?>;
	background-image:url("<?php print sboard_get_setting( 'background_upload_media' ); ?>");
	background-repeat: <?php print $background_repeat; ?>;
	}
</style>
<?php } ?>
<body class="<?php sboard_body_class(); ?>">

<?php do_atomic( 'before_html' ); // sboard_before_html ?>

<div id="body-container">


	<?php do_atomic( 'before_header' ); // sboard_before_header ?>

	<div id="header-container">

		<div id="header">
			
			<div class="springboard-header-left">
				
				<div class="site-logo" >
					<a href="<?php print home_url(); ?>" >
				<?php 
				
				if ( sboard_get_setting( "logo_activation" ) == 'no'): 
				do_atomic( 'header' );
				else: $logo = Array('url' => sboard_get_setting( "logo_upload_media" ), 
				'alt' => sboard_get_setting( "logo_alternate" ) );
				do_action('create_logo', $logo ); endif; ?></a>
				</div>
			</div>
			
			<div class="springboard-header-right">
				
					<?php
						if ( is_active_sidebar( 'header-widget' ) ) : ?>

							<div id="widget-columns" class="widget-area" role="complementary">
								<ul class="xoxo">
									<?php dynamic_sidebar( 'header-widget' ); ?>
								</ul>
							</div><!-- #secondary .widget-area -->

					<?php endif; ?>
			</div>

		</div><!-- #header -->

	</div><!-- #header-container -->

	<?php do_atomic( 'after_header' ); // sboard_after_header ?>

	<div id="container">

		<?php do_atomic( 'before_container' ); // sboard_before_container ?>
