<?php
/**
 * Template Name: Daily
 *
 * The Daily page template is used to show a list of your post archives by day. Each day a
 * post has been made is listed along with the number of posts for that particular day.
 *
 * @package SpringBoard
 * @subpackage Template
 * @deprecated 0.9.0 This template will eventually be moved to the SpringBoard page templates pack.
 */

get_header(); // Loads the header.php template. ?>

	<div id="content" class="hfeed content">

		<?php do_atomic( 'before_content' ); // sboard_before_content ?>

		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

			<div id="post-<?php the_ID(); ?>" class="<?php sboard_entry_class(); ?>">

				<?php do_atomic( 'before_entry' ); // sboard_before_entry ?>

				<div class="entry-content">

					<?php the_content(); ?>

					<ul class="xoxo daily-archives">
						<?php wp_get_archives( array( 'type' => 'daily', 'show_post_count' => true ) ); ?>
					</ul><!-- .xoxo .daily-archives -->

					<?php wp_link_pages( array( 'before' => '<p class="page-links pages">' . __( 'Pages:', sboard_get_textdomain() ), 'after' => '</p>' ) ); ?>

				</div><!-- .entry-content -->

				<?php do_atomic( 'after_entry' ); // sboard_after_entry ?>

			</div><!-- .hentry -->

			<?php do_atomic( 'after_singular' ); // sboard_after_singular ?>

			<?php comments_template( '/comments.php', true ); // Loads the comments.php template ?>

			<?php endwhile; ?>

		<?php else: ?>

			<?php get_template_part( 'loop-error' ); // Loads the loop-error.php template. ?>

		<?php endif; ?>

		<?php do_atomic( 'after_content' ); // sboard_after_content ?>

	</div><!-- .content .hfeed -->

<?php get_footer(); // Loads the footer.php template. ?>