<?php
/**
 * Handles the display and functionality of the theme settings page. This provides the needed hooks and
 * meta box calls for developers to create any number of theme settings needed. This file is only loaded if 
 * the theme supports the 'sboard-core-theme-settings' feature.
 *
 * Provides the ability for developers to add custom meta boxes to the theme settings page by using the 
 * add_meta_box() function.  Developers should register their meta boxes on the 'add_meta_boxes' hook 
 * and register the meta box for 'appearance_page_theme-settings'.  To validate/sanitize data from 
 * custom settings, devs should use the 'sanitize_option_{$prefix}_theme_settings' filter hook.
 *
 * @package SpringBoardCore
 * @subpackage Admin
 */

/* Hook the settings page function to 'admin_menu'. */
add_action( 'admin_menu', 'sboard_settings_page_init' );

/**
 * Initializes all the theme settings page functionality. This function is used to create the theme settings 
 * page, then use that as a launchpad for specific actions that need to be tied to the settings page.
 *
 * @since 0.7.0
 * @global string $sboard The global theme object.
 */
function sboard_settings_page_init() {
	global $sboard;
	
	/* Get theme information. */
	$theme = sboard_get_theme_data();
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();

	/* Register theme settings. */
	register_setting(
		"{$prefix}_theme_settings",		// Options group.
		"{$prefix}_theme_settings",		// Database option.
		'sboard_save_theme_settings'	// Validation callback function.
	);

	/* Create the theme settings page. */
	$sboard->settings_page = add_theme_page(
		sprintf( esc_html__( '%1$s Theme Settings', $domain ), $theme['Name'] ),	// Settings page name.
		esc_html__( 'Theme Settings', $domain ),				// Menu item name.
		sboard_settings_page_capability(),					// Required capability.
		'theme-settings',							// Screen name.
		'sboard_settings_page'						// Callback function.
	);

	/* Check if the settings page is being shown before running any functions for it. */
	if ( !empty( $sboard->settings_page ) ) {

		/* Filter the settings page capability so that it recognizes the 'edit_theme_options' cap. */
		add_filter( "option_page_capability_{$prefix}_theme_settings", 'sboard_settings_page_capability' );

		/* Add contextual help to the theme settings page. */
		add_contextual_help( $sboard->settings_page, sboard_settings_page_contextual_help() );

		/* Load the theme settings meta boxes. */
		add_action( "load-{$sboard->settings_page}", 'sboard_load_settings_page_meta_boxes' );

		/* Create a hook for adding meta boxes. */
		add_action( "load-{$sboard->settings_page}", 'sboard_settings_page_add_meta_boxes' );

		/* Load the JavaScript and stylesheets needed for the theme settings screen. */
		add_action( 'admin_enqueue_scripts', 'sboard_settings_page_enqueue_scripts' );
		add_action( 'admin_enqueue_scripts', 'sboard_settings_page_enqueue_styles' );
		add_action( "admin_head-{$sboard->settings_page}", 'sboard_settings_page_load_scripts' );
		
		add_action( "{$prefix}_create_settings_fields", 'create_settings_callback' );
		
		add_action('template_redirect', 'add_my_script');
	}
}

function create_settings_callback($args){
	global $theme_settings;
	$url = get_bloginfo('template_url');
	?><?php $postcount = 0; foreach ( $theme_settings
	[ $args[1] ][ 'settings_page' ] as $key => $values ){ $postcount++; 
		switch ($values['field']) { 
			
		/* ACTIVATION */
		case "activation": ?>
		<tr><th><b><?php if ( $postcount == 1 ) print $args[0]; ?>
		</b></th>
		<td><span><input type="radio" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" value="yes" 
			<?php if (	$theme_settings[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'yes'): 
			print 'CHECKED'; endif; ?> /> Yes 
			
			<input type="radio" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" value="no" 
			<?php if ($theme_settings[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'no'): 
			print 'CHECKED'; endif; ?> /> No </span></td></tr><?php break; ?>
		
		<?php /* IMAGE */ 
		case "image": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		
		</th><td><?php 
		$logo = Array('url' => $args[3], 'alt' => 'Options Image'); 
		do_action('create_logo', $logo ); ?></td></tr>
		<?php break; ?>
		
		<?php case "text": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td><?php print $args[3]; ?></td></tr><?php break; ?>
		
		<?php case "input-short": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			
			<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ]; ?>
			<input id="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'id' ]; ?>" 
			type="text" size="10" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" 
			value="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ]; ?>" />
			
			</td></tr><?php break; ?>
		
		<?php case "category-select": ?>
		<?php break; ?>
		
		<?php case "selection"?>
		<tr><th><?php if ( $postcount == 1 ) print $args[0]; ?></th>
		<td><select id="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'id' ]; ?>" 
			name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>">
			
			<?php foreach (	$theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ] as $value){
				print $value;
				?><option value="<?php print $value; ?>" 
					<?php if ($value == $theme_settings
					[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] ) {
					print 'SELECTED' ;  } ?> ><?php print $value; ?></option><?php
			}?>
		</select></td>
		
		<?php break; ?>
		<?php case "container": ?>
		<style>
		#background_preview_container {
		background: <?php print $theme_settings
		[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ][ 'color' ]; ?>;
		background-image:url("<?php print $theme_settings
		[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ][ 'background' ]; ?>");
		background-repeat: <?php print $theme_settings
		[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ][ 'repeat' ]; ?>;
		
		height: 225px;
		width: 100%;
		}
		</style>
		<tr><th><?php if ( $postcount == 1 ) print $args[0]; ?></th>
		
		<td>
		<div id="<?php print $args[1] . '_container' ?>" class="sboard_options_display_container">
		</div>
		</td>
		<?php break; ?>
		
		<?php case "choice": ?>
		
		<tr><th><?php if ( $postcount == 1 ) print $args[0]; ?></th>
		<td><span><input type="radio" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" value="yes" 
			<?php if (	$theme_settings[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'yes'): 
			print 'CHECKED'; endif; ?> /> Yes 
			
			<input type="radio" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" value="no" 
			<?php if ($theme_settings[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'no'): 
			print 'CHECKED'; endif; ?> /> No </span></td></tr>
			
		<?php break; ?>
		<?php case "input-long": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			
			<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ]; ?>
			<input id="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'id' ]; ?>" 
			type="text" size="20" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" 
			value="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ]; ?>" />
			
		</td></tr><?php break; ?>
		
		<?php case "input-text-field": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			<textarea rows="6" cols="20">At W3Schools you will find all the Web-building tutorials you need, from basic HTML to advanced XML, SQL, ASP, and PHP. 
			</textarea>
		</td></tr><?php break; ?>
		
		<?php case "checkbox": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			
			<?php $hidden_tag = $key . '_default'; ?>
			<input type="hidden" 
			id="<?php print sboard_settings_field_id( $hidden_tag ); ?>" 
			name="<?php print sboard_settings_field_name( $hidden_tag ); ?>" 
			value="hidden" />
			<p>
			<input type="checkbox" name="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" 
			id="<?php print	$theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'id' ]; ?>"
			<?php if ( sboard_get_setting( $hidden_tag ) ){
			if ($theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'on'){
				$checkbox_switch = 'CHECKED';
			} elseif ($theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ] == 'off'){
				$checkbox_switch = ''; }
			} elseif ( !sboard_get_setting( $hidden_tag ) ){
				if ( $values[ 'default' ] == 'on' ){
					$checkbox_switch = 'CHECKED';
				} elseif ( $values[ 'default' ] == 'off' ){
					$checkbox_switch = ''; }
			} print $checkbox_switch;
			?> ><span><?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'misc' ]; ?></span></p>
		</td></tr><?php break; ?>
		
		<?php case "media": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			<input id="<?php print $theme_settings
			[ $args[1] ][ 'settings_page' ][ $key ][ 'id' ]; ?>" 
			type="text" size="36" name="<?php print 	$theme_settings
				[ $args[1] ][ 'settings_page' ][ $key ][ 'name' ]; ?>" 
			value="<?php print $theme_settings
				[ $args[1] ][ 'settings_page' ][ $key ][ 'value' ]; ?>" />
				
			<input id="<?php print $key; ?>_upload_image_button" 
			type="button" name="" value="Upload Image" />
			<script type="text/javascript" language="JavaScript">
			(function($){
			    $.fn.<?php print $key; ?>_Upload_Logo = function() {
					$('#<?php print $key; ?>_upload_image_button').click(function() {
					 script = "#<?php print $theme_settings[ $args[1] ]
					[ 'settings_page' ][ $key ][ 'id' ]; ?>";
					 formfield = jQuery('#upload_image').attr('name');
					 tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
					 return false;
					});
			    };
			})(jQuery);
			$=jQuery.noConflict();
			$(document).ready(function(){
				$(this).<?php print $key; ?>_Upload_Logo();

			});
			</script>
			
		</td></tr><?php break; ?>
		
		<?php case "media-wlist": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>

		</td></tr><?php break; ?>
		
		<?php case "link": ?><tr><th><?php if ( $postcount == 1 ) print $args[0]; ?>
		</th><td>
			<a href="http://www.google.com">PageLink</a>
		</td></tr>
		
		<?php break; }
		
	}
	/*
	if ( is_array( $args ) ){
		if( !is_array( $args[ 'values' ] ) ): 
		$args['values'] = Array( $args['values'] => Array(
						'value' => true, 'field' => 'choice' ) ); endif;
		?><table class="form-table"><?php
		foreach ( $args['values'] as $key => $values ){
			?><tr>
				<th>
					<b><?php print $values[ 'label'] ?></b>
				</th><?php
			switch ($values['field']) {
			    case "input":
				?><td>
						<span><input type="radio" name="<?php print 
						sboard_settings_field_name( 'custom_logo' ); ?>" value="yes" 
						<?php if ($options['custom_logo'] == 'yes'): print 'CHECKED'; endif; ?> /> Yes 
						<input type="radio" name="<?php print 
						sboard_settings_field_name( 'custom_logo' ); ?>" value="no" 
						<?php if ($options['custom_logo'] == 'no'): print 'CHECKED'; endif; ?> /> No </span>


					</td>
				<?php
				break;
				case "featured":
				break;
			}
			?></tr><?php
		}
		?></table><?php
	}
	*/
	
}

/**
 * Returns the required capability for viewing and saving theme settings.
 *
 * @since 1.2.0
 */
function sboard_settings_page_capability() {
	return apply_filters( sboard_get_prefix() . '_settings_capability', 'edit_theme_options' );
}

/**
 * Returns the theme settings page name/hook as a string.
 *
 * @since 1.2.0
 */
function sboard_get_settings_page_name() {
	global $sboard;

	return ( isset( $sboard->settings_page ) ? $sboard->settings_page : 'appearance_page_theme-settings' );
}

/**
 * Provides a hook for adding meta boxes as seen on the post screen in the WordPress admin.  This addition 
 * is needed because normal plugin/theme pages don't have this hook by default.  The other goal of this 
 * function is to provide a way for themes to load and execute meta box code only on the theme settings 
 * page in the admin.  This way, they're not needlessly loading extra files.
 *
 * @since 1.2.0
 */
function sboard_settings_page_add_meta_boxes() {

	do_action( 'add_meta_boxes', sboard_get_settings_page_name(), sboard_get_theme_data() );
}

/**
 * Loads the meta boxes packaged with the framework on the theme settings page.  These meta boxes are 
 * merely loaded with this function.  Meta boxes are only loaded if the feature is supported by the theme.
 *
 * @since 1.2.0
 */
function sboard_load_settings_page_meta_boxes() {

	/* Get theme-supported meta boxes for the settings page. */
	$supports = get_theme_support( 'sboard-core-theme-settings' );

	/* If there are any supported meta boxes, load them. */
	if ( is_array( $supports[0] ) ) {

		/* Load the 'About' meta box if it is supported. */
		if ( in_array( 'about', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-about.php' );
		
		if ( in_array( 'logo', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-logo.php' );
		
		if ( in_array( 'header', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-header.php' );
		
		/*
		if ( in_array( 'header', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-header.php' );
		
		if ( in_array( 'background', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-background.php' );
		*/
			
		if ( in_array( 'background', $supports[0] ) )
			require_once( trailingslashit( SBOARD_ADMIN ) . 'meta-box-theme-background.php' );
	}
}

/**
 * Validation/Sanitization callback function for theme settings.  This just returns the data passed to it.  Theme
 * developers should validate/sanitize their theme settings on the "sanitize_option_{$prefix}_theme_settings" 
 * hook.  This function merely exists for backwards compatibility.
 *
 * @since 0.7.0
 * @param array $settings An array of the theme settings passed by the Settings API for validation.
 * @return array $settings The array of theme settings.
 */
function sboard_save_theme_settings( $settings ) {

	/* @deprecated 1.0.0. Developers should filter "sanitize_option_{$prefix}_theme_settings" instead. */
	return apply_filters( sboard_get_prefix() . '_validate_theme_settings', $settings );
}

/**
 * Displays the theme settings page and calls do_meta_boxes() to allow additional settings
 * meta boxes to be added to the page.
 *
 * @since 0.7.0
 * @global string $sboard The global theme object.
 */
function sboard_settings_page() {

	/* Get the theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	$theme_data = sboard_get_theme_data(); ?>

	<div class="wrap">

		<?php screen_icon(); ?>

		<h2><?php printf( __( '%1$s Theme Settings', $domain ), $theme_data['Name'] ); ?></h2>

		<?php if ( isset( $_GET['settings-updated'] ) && 'true' == esc_attr( $_GET['settings-updated'] ) ) echo '<div class="updated"><p><strong>' . __( 'Settings saved.', $domain ) . '</strong></p></div>'; ?>

		<div id="poststuff">

			<form method="post" action="options.php">

				<?php settings_fields( "{$prefix}_theme_settings" ); ?>
				<?php wp_nonce_field( 'closedpostboxes', 'closedpostboxesnonce', false ); ?>
				<?php wp_nonce_field( 'meta-box-order', 'meta-box-order-nonce', false ); ?>

				<div class="metabox-holder">
					<div class="post-box-container column-1 normal"><?php do_meta_boxes( sboard_get_settings_page_name(), 'normal', null ); ?></div>
					<div class="post-box-container column-2 side"><?php do_meta_boxes( sboard_get_settings_page_name(), 'side', null ); ?></div>
					<div class="post-box-container column-3 advanced"><?php do_meta_boxes( sboard_get_settings_page_name(), 'advanced', null ); ?></div>
				</div>

				<?php submit_button( esc_attr__( 'Update Settings', $domain ) ); ?>

			</form>

		</div><!-- #poststuff -->

	</div><!-- .wrap --><?php
}

/**
 * Creates a settings field id attribute for use on the theme settings page.  This is a helper function for use
 * with the WordPress settings API.
 *
 * @since 1.0.0
 */
function sboard_settings_field_id( $setting ) {
	return sboard_get_prefix() . '_theme_settings-' . sanitize_html_class( $setting );
}

/**
 * Creates a settings field name attribute for use on the theme settings page.  This is a helper function for 
 * use with the WordPress settings API.
 *
 * @since 1.0.0
 */
function sboard_settings_field_name( $setting ) {
	return sboard_get_prefix() . "_theme_settings[{$setting}]";
}

/**
 * Returns text for the contextual help tab on the theme settings page in the admin.  Theme authors can add 
 * a filter to the 'contextual_help' hook if they want to change the output of the help text.
 *
 * @since 1.2.0
 * @return string $help The contextual help text used on the theme settings page.
 */
function sboard_settings_page_contextual_help() {

	/* Set the $help variable to an empty string. */
	$help = '';

	/* Get the parent theme data. */
	$theme = sboard_get_theme_data();

	/* If the theme has provided a documentation or support URI, add them to the help text. */
	if ( !empty( $theme['Documentation URI'] ) || !empty( $theme['Support URI'] ) ) {

		/* Open an unordered list for the help text. */
		$help = '<ul>';

		/* Add the Documentation URI. */
		if ( !empty( $theme['Documentation URI'] ) )
			$help .= '<li><a href="' . esc_url( $theme['Documentation URI'] ) . '">' . __( 'Documentation', sboard_get_textdomain() ) . '</a></li>';

		/* Add the Support URI. */
		if ( !empty( $theme['Support URI'] ) )
			$help .= '<li><a href="' . esc_url( $theme['Support URI'] ) . '">' . __( 'Support', sboard_get_textdomain() ) . '</a></li>';

		/* Close the unordered list for the help text. */
		$help .= '</ul>';
	}

	/* Return the contextual help text for this screen. */
	return $help;
}

/**
 * Loads the required stylesheets for displaying the theme settings page in the WordPress admin.
 *
 * @since 1.2.0
 */
function sboard_settings_page_enqueue_styles( $hook_suffix ) {

	/* Load admin stylesheet if on the theme settings screen. */
	if ( $hook_suffix == sboard_get_settings_page_name() )
		wp_enqueue_style( 'sboard-core-admin' );
		wp_enqueue_style( 'thickbox' );
}

/**
 * Loads the JavaScript files required for managing the meta boxes on the theme settings
 * page, which allows users to arrange the boxes to their liking.
 *
 * @since 1.2.0
 * @param string $hook_suffix The current page being viewed.
 */
function sboard_settings_page_enqueue_scripts( $hook_suffix ) {

	if ( $hook_suffix == sboard_get_settings_page_name() ) {
		wp_enqueue_script( 'common' );
		wp_enqueue_script( 'wp-lists' );
		wp_enqueue_script( 'postbox' );
		wp_enqueue_script( 'media-upload' );
		wp_enqueue_script( 'thickbox' );
		$url = get_bloginfo('template_url');
		wp_enqueue_script( 'admin-settings', $url . '/library/js/admin-settings.js' );
	}
}


 
function add_my_script() {
	$url = get_bloginfo('template_url');
	wp_enqueue_script('my-script', $url . '/library/js/admin-functions.js', 
	Array( 'jquery' ), '1.0', true);
}

/**
 * Loads the JavaScript required for toggling the meta boxes on the theme settings page.
 *
 * @since 0.7.0
 */
function sboard_settings_page_load_scripts() { ?>
	<script type="text/javascript">
		//<![CDATA[
		jQuery(document).ready( function($) {
			$('.if-js-closed').removeClass('if-js-closed').addClass('closed');
			postboxes.add_postbox_toggles( '<?php echo sboard_get_settings_page_name(); ?>' );
		});
		//]]>
	</script><?php
}

?>
