<?php
/**
 * Creates a meta box for the theme settings page, which displays information logo the theme.  If a child theme 
 * is in use, an additional meta box will be added with its information.  To use this feature, the theme must 
 * support the 'logo' argument for 'sboard-core-theme-settings' feature.
 *
 * @package SpringBoardCore
 * @subpackage Admin
 */

/* Create the logo theme meta box on the 'add_meta_boxes' hook. */
add_action( 'add_meta_boxes', 'sboard_meta_box_theme_add_logo' );

/**
 * Adds the core logo theme meta box to the theme settings page.
 *
 * @since 1.2.0
 */
function sboard_meta_box_theme_add_logo() {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	$theme_data = sboard_get_theme_data();

	/* Adds the Logo box for the parent theme. */
	add_meta_box( 'sboard-core-logo-theme', sprintf( __( 'Logo', $domain ), $theme_data['Title'] ), 'sboard_meta_box_theme_display_logo', sboard_get_settings_page_name(), 'normal', 'high' );

	/* If the user is using a child theme, add an Logo box for it. 
	if ( is_child_theme() ) {
		$child_data = sboard_get_theme_data( 'stylesheet' );
		add_meta_box( 'sboard-core-logo-child', sprintf( __( 'Logo', $domain ), $child_data['Title'] ), 'sboard_meta_box_theme_display_logo', sboard_get_settings_page_name(), 'normal', 'high' );
	}
	*/
}

/**
 * Creates an information meta box with no settings logo the theme. The meta box will display
 * information logo both the parent theme and child theme. If a child theme is active, this function
 * will be called a second time.
 *
 * @since 1.2.0
 * @param $object Variable passed through the do_meta_boxes() call.
 * @param array $box Specific information logo the meta box being loaded.
 */
function sboard_meta_box_theme_display_logo( $object, $box ) {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	
	/* Grab theme information for the parent theme. */
	if ( 'sboard-core-logo-theme' == $box['id'] )
		$theme_data = sboard_get_theme_data();

	/* Grab theme information for the child theme. */
	elseif ( 'sboard-core-logo-child' == $box['id'] )
		$theme_data = sboard_get_theme_data( 'stylesheet' ); 
		
	if (sboard_get_setting( "logo_image_URL" ) ): 
	$get_logo_image = sboard_get_setting( "logo_image_URL" ); 
	$get_logo_alt = sboard_get_setting( "logo_image_alt" ); 
	else: $get_logo_image = 'Add Image URL Here Or Upload Your Image'; 
	$get_logo_alt = 'Custom Logo'; endif;
	$options['custom_logo'] = 'yes';
	$url = get_bloginfo('template_url');
	?>
	<style>
	.sboard_options_container img {
		max-width: 100%;
	}
	.sboard_options_container .form-table th {
		vertical-align: top;
		text-align: left;
		padding: 10px;
		width: 25%;
		line-height: 20px;
	}
	</style>
	<div class="sboard_options_container">
		<table class="form-table">
			<tr>
				<th>
					<b>Upload Logo</b>
				</th>
				<td>
					
					<span><input type="radio" name="<?php print 
					sboard_settings_field_name( 'custom_logo' ); ?>" value="yes" 
					<?php if ($options['custom_logo'] == 'yes'): print 'CHECKED'; endif; ?> /> Yes 
					<input type="radio" name="<?php print 
					sboard_settings_field_name( 'custom_logo' ); ?>" value="no" 
					<?php if ($options['custom_logo'] == 'no'): print 'CHECKED'; endif; ?> /> No </span>
					
					
				</td>
			</tr>
			<tr>
				<th>
					<?php _e( 'Preview:', $domain ); ?>
				</th>
				<td>
					
					<?php if ( sboard_get_setting( "logo_image_URL" ) ): 
					//do_atomic( 'header' );
					$logo = Array('url' => $get_logo_image, 'alt' => 'Alternate');
					do_action('create_logo', $logo ); else: $logo = Array('url' => 
					$url . '/library/images/wordpress-icon-text.png', 
					'alt' => 'Default Image'); do_action('create_logo', $logo );
					 endif; ?>
					
				</td>
			</tr>
			<tr>
				<th>
					<?php _e( 'Description:', $domain ); ?>
				</th>
				<td>
					<?php echo $theme_data['Description']; ?>
				</td>
			</tr>
			<tr>
				<th>
					<?php _e( 'Upload Image:', $domain ); ?>
				</th>
				<td>
					<input id="<?php print sboard_settings_field_id('logo_image_URL'); ?>" 
					type="text" size="26" name="<?php print sboard_settings_field_name('logo_image_URL'); ?>" 
					value="<?php print $get_logo_image; ?>" />
					<input id="upload_image_button" type="button" name="" value="Upload Image" />
				</td>
			</tr>
			<tr>
				<th>
					<?php _e( 'Image Tag Alternate:', $domain ); ?>
				</th>
				<td>
					<input id="<?php print sboard_settings_field_id('logo_image_alt'); ?>" 
					type="text" size="15" name="<?php print sboard_settings_field_name('logo_image_alt'); ?>" 
					value="<?php print $get_logo_alt; ?>" />
				</td>
			</tr>
		</table><!-- .form-table -->
		
		
		
		</td></tr>
		
	</div>
	<script type="text/javascript" language="JavaScript">
	(function($){
	    $.fn.Upload_Logo = function() {
			$('#upload_image_button').click(function() {
			 formfield = jQuery('#upload_image').attr('name');
			 tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');
			 return false;
			});
			window.send_to_editor = function(html) {
			 imgurl = jQuery('img',html).attr('src');
			 jQuery("#<?php print sboard_settings_field_id('logo_image_URL'); ?>").val(imgurl);
			 tb_remove();
			}
	    };
	})(jQuery);
	$=jQuery.noConflict();
	$(document).ready(function(){
		$(this).Upload_Logo();
		
	});
	</script>
	<?php 
}

?>
