<?php
/**
 * Creates a meta box for the theme settings page, which displays information settings the theme.  If a child theme 
 * is in use, an additional meta box will be added with its information.  To use this feature, the theme must 
 * support the 'settings' argument for 'sboard-core-theme-settings' feature.
 *
 * @package SpringBoardCore
 * @subpackage Admin
 */

/* Create the settings theme meta box on the 'add_meta_boxes' hook. */
add_action( 'add_meta_boxes', 'sboard_meta_box_theme_add_settings' );

/**
 * Adds the core settings theme meta box to the theme settings page.
 *
 * @since 1.2.0
 */
function sboard_meta_box_theme_add_settings() {

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	$theme_data = sboard_get_theme_data();

	/* Adds the Settings box for the parent theme. */
	add_meta_box( 'sboard-core-settings-theme', sprintf( __( 'Set Background', $domain ), $theme_data['Title'] ),
	'sboard_meta_box_theme_display_settings', sboard_get_settings_page_name(), 'normal', 'high' );

}

/**
 * Creates an information meta box with no settings settings the theme. The meta box will display
 * information settings both the parent theme and child theme. If a child theme is active, this function
 * will be called a second time.
 *
 * @since 1.2.0
 * @param $object Variable passed through the do_meta_boxes() call.
 * @param array $box Specific information settings the meta box being loaded.
 */
function sboard_meta_box_theme_display_settings( $object, $box ) {

	$settings_prefix = 'background';

	/* Get theme information. */
	$prefix = sboard_get_prefix();
	$domain = sboard_get_textdomain();
	
	/* Grab theme information for the parent theme. */
	if ( 'sboard-core-settings-theme' == $box['id'] )
	$theme_data = sboard_get_theme_data();

	/* Grab theme information for the child theme. */
	elseif ( 'sboard-core-settings-child' == $box['id'] )
	$theme_data = sboard_get_theme_data( 'stylesheet' ); 
	
	$background_url = sboard_get_setting( "{$settings_prefix}_upload_media" );
	$background_color = sboard_get_setting( "{$settings_prefix}_color" );
	$background_repeat = sboard_get_setting( "{$settings_prefix}_repeat" );
	/*
	$repeat_options = Array(	'Both'			=> 'repeat',
								'Horizontal'	=> 'repeat-x',
								'Vertical'		=> 'repeat-y',
								'None'			=> 'no-repeat'
							);
	$background_repeat = $repeat_options[ $background_repeat ];
	*/
	switch ( $background_repeat ){
		case "Both":		$background_repeat = 'repeat';		break;
		case "Horizontal":	$background_repeat = 'repeat-x';	break;
		case "Vertical":	$background_repeat = 'repeat-y';	break;
		case "None":		$background_repeat = 'no-repeat';
	}
	
	global $theme_settings; $values = Array( 
		"{$settings_prefix}_activation"		=> Array (	'value' => 'yes', 'field' => 'activation',
											'section' => "{$settings_prefix}_activate" ),
										
		"{$settings_prefix}_preview"		=> Array (	'value' => 'http://www.default.com',
											'field' => 'container', 'section' => "{$settings_prefix}_preview",
											'misc' => Array (	'background' => $background_url,
																'color' => $background_color,
																'repeat' => $background_repeat ) ),
										
		"{$settings_prefix}_description"	=> Array (	'value' => 'http://www.google.com', 
											'field' => 'text', 'section' => "{$settings_prefix}_description" ),
										
		"{$settings_prefix}_color"			=> Array (	'value' => '#FFFFFF', 'field' => 'input-long',
		 									'section' => "{$settings_prefix}_color",
											'misc' => '' ), 
										
		"{$settings_prefix}_upload_media"	=> Array (	'value' => 'Add Image', 'field' => 'media',
											'section' => "{$settings_prefix}_upload_media"), 
											
		"{$settings_prefix}_repeat"			=> Array ( 'field' => 'selection',
											'section' => "{$settings_prefix}_repeat",
											'value' => 'Both', 'misc' => 
											Array('Both', 'Horizontal', 
											'Vertical', 'None' ) ) );
											
											
	$args = Array( 'target' => 'settings_page', 'values' => $values );
	do_action( "{$prefix}_establish_options", $args );
	?>
	
	<style>
	.sboard_options_container img {
		max-width: 100%;
	}
	
	#sboard_theme_settings_container {
		overflow: hidden;
	}
	.sboard_options_container .form-table th {
		vertical-align: top;
		text-align: left;
		padding: 10px;
		width: 25%;
		line-height: 20px;
	}
	</style>
	<div id="sboard_theme_settings_container" class="sboard_options_container">
	<table class="form-table">
	<?php 
	$docs = 'no-docs';
	$text = 'A user-friendly, search-engine optimized parent theme, featuring 15 custom page templates and multiple widget-ready areas, allowing you to create any type of site you want.';
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Background:', "{$settings_prefix}_activate", $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Preview:', "{$settings_prefix}_preview" , $docs, 'wordpress-icon-text.png' ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Description:', "{$settings_prefix}_description", $docs, $text ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Set Media:', "{$settings_prefix}_upload_media", $docs ) ); 
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Repeat Options:', "{$settings_prefix}_repeat", $docs ) );
	
	do_action( "{$prefix}_create_settings_fields", 
	Array( 'Background Color:', "{$settings_prefix}_color", $docs ) );	

	?></table></div>
	<!--
	<script type="text/javascript" language="JavaScript">
		var container_height = $('#sboard_theme_settings_container').height();
		$(document).ready(function(){
			$(this).test_function(container_height);
		});
	</script>
	-->
	<?php
}

?>
