<?php
/**
 * @package splinter
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-header">
		<a href="<?php echo get_the_permalink($post->ID); ?>">
			<?php
				//Check for Featured Image
				if ( has_post_thumbnail() ) :
					$thumb_id = get_post_thumbnail_id();
					$thumb_url = wp_get_attachment_image_src($thumb_id,'full', true);
					printf(
						'<div class="entry-thumbnail" style="background-image: url(%1$s);">
						</div>',
						esc_url($thumb_url[0])
					);
				else :
					echo '<div class="spacer"></div>';
				endif;
			?>
			<h1 class="entry-title"><?php the_title(); ?></h1>

			<div class="entry-meta">
				<?php splinter_posted_on(); ?>
			</div><!-- .entry-meta -->
		</a>
	</div><!-- .entry-header -->

	<div class="entry-content">
		<?php 
			if ($pos=strpos($post->post_content, '<!--more-->')):
		 		the_content('',FALSE,'');
		 	else :
		 		the_excerpt();
		 	endif; 
			printf( 
				'<a href="%1$s" class="more-link"><span class="screen-reader-text" for="s">%2$s %3$s</span><i class="fa fa-angle-right" aria-hidden="true"></i></a>',
				esc_url( get_permalink() ),
				__( 'Continue reading:', 'splinter'),
				get_the_title()
			);
		?>
	</div><!-- .entry-content -->
	
</article><!-- #post-## -->