<?php
/**
 * @package splinter
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-header">
		<div class="spacer"></div>
		<a href="<?php echo get_the_permalink($post->ID); ?>">
			<?php
				printf(
					'<h1 class="entry-title">%1$s</h1>',
					get_the_title()
				);
			?>
		</a>

		<div class="entry-meta">
			<?php splinter_posted_on(); ?>
		</div><!-- .entry-meta -->
	</div><!-- .entry-header -->

	<div class="entry-content">
		<?php 
			the_content(); 
			printf( 
				'<a href="%1$s" class="more-link"><span class="screen-reader-text" for="s">%2$s %3$s</span><i class="fa fa-angle-right" aria-hidden="true"></i></a>',
				esc_url( get_permalink() ),
				__( 'Continue to:', 'splinter'),
				get_the_title()
			);
		?>
	</div><!-- .entry-content -->
	
</article><!-- #post-## -->