<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package splinter
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<header class="entry-header">
		<?php
		//Check for Featured Image
		if ( has_post_thumbnail() ) :
			printf(
				'<div class="entry-thumbnail">%1$s</div>',
				get_the_post_thumbnail($post->ID, 'full' )
			);
		else :
			echo '<div class="spacer"></div>';
		endif;
		?>
		<h1 class="entry-title"><?php the_title(); ?></h1>
		
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'splinter' ),
				'after'  => '</div>',
			) );
		?>
		
		<div class="sitemap">
			<h2><?php _e('Pages', 'splinter'); ?></h2>
			<ul>
			<?php wp_list_pages('title_li='); ?>
			</ul>

			<h2><?php _e('Recent Posts', 'splinter'); ?></h2>
			<ul>
			<?php
				$recent_posts = wp_get_recent_posts('posts_per_page=20');
				foreach( $recent_posts as $recent ){
					echo '<li><a href="' . get_permalink($recent["ID"]) . '">' .   $recent["post_title"].'</a> </li> ';
				}
			?>
			</ul>

			<h2><?php _e('Authors', 'splinter'); ?></h2>
			<ul>
				<?php wp_list_authors(); ?>
			</ul>

			<h2><?php _e('Categories', 'splinter'); ?></h2>
			<ul>
				<?php wp_list_categories(); ?>
			</ul>

			<h2><?php _e('Archives', 'splinter'); ?></h2>
			<ul>
				<?php wp_get_archives( array( 'type' => 'monthly', 'limit' => 12 ) ); ?>
			</ul>
		</div>
	</div><!-- .entry-content -->

	<?php splinter_entry_footer(); ?>
</article><!-- #post-## -->
