<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package splinter
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<header class="entry-header">
		<?php
		//Check for Featured Image
		if ( has_post_thumbnail() ) :
			printf(
				'<div class="entry-thumbnail">%1$s</div>',
				get_the_post_thumbnail($post->ID, 'full' )
			);
		else :
			echo '<div class="spacer"></div>';
		endif;
		?>
		<h1 class="entry-title"><?php the_title(); ?></h1>
		
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php the_content(); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'splinter' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<?php splinter_entry_footer(); ?>
</article><!-- #post-## -->
