/**
 * jQuery Animations
 *
 */

jQuery(function ($) {
    /**
    * Show Mobile Menu
    */
    $(".menu-toggle").click(function(){
    	$(".main-navigation").slideToggle(300);
    });

    /**
     * Calculate Dropdown Menu Location and Move if Hanging off of screen
     */

     $('.main-navigation .menu-item-has-children .menu-item-has-children').hover(function(){
        var docW = $(window).width();
        var parentUL = $(this);
        var positionLeft = parentUL.offset().left;
        var parentWidth = parentUL.width();
        var childUL = $("ul", this);
        var childULWidth = childUL.width();
        var positionRight = positionLeft + parentWidth + childULWidth;
        if(positionRight >= docW) {
            var offset = docW - positionRight;
            offset = parentWidth + "px";
            $("ul", this).css("right", offset);
        }
    });
    
    $('.main-navigation .menu-item-has-children').hover(function(){
    	var docW = $(window).width();
    	var parentUL = $(this);
    	var position = parentUL.position();
    	var parentWidth = parentUL.width();
    	var childUL = $("ul", this);
    	var childULWidth = childUL.width();
    	if(position.left + childULWidth >= docW) {
    		var positionRight = position.left + parentWidth;
    		var offset = docW - positionRight;
    		offset = offset + "px";
    		$("ul", this).css("right", offset);
    	}
    });


    /**
     * Focus styles for menus when using keyboard navigation
     */

    // Properly update the ARIA states on focus (keyboard) and mouse over events
    $( '[role="menubar"]' ).on( 'focus.aria  mouseenter.aria', '[aria-haspopup="true"]', function ( ev ) {
        $( ev.currentTarget ).attr( 'aria-expanded', true );
    } );

    // Properly update the ARIA states on blur (keyboard) and mouse out events
    $( '[role="menubar"]' ).on( 'blur.aria  mouseleave.aria', '[aria-haspopup="true"]', function ( ev ) {
        $( ev.currentTarget ).attr( 'aria-expanded', false );
    } );

});