<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package splinter
 */

if ( ! function_exists( 'splinter_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function splinter_posted_on() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	$posted_on = sprintf(
		_x( '%s', 'post date', 'splinter' ),
		$time_string
	);

	echo '<span class="posted-on">' . $posted_on . '</span>';

}
endif;

if ( ! function_exists( 'splinter_posted_on_short' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function splinter_posted_on_short() {
	$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	echo '<span class="posted-on">' . $time_string . '</span>';

}
endif;

if ( ! function_exists( 'splinter_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function splinter_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' == get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$categories_list = get_the_category_list( __( ', ', 'splinter' ) );
		$tags_list = get_the_tag_list( '', ', ', '' );
		if ( $categories_list || $tags_list ) {
			printf( '<footer class="entry-footer">');
		}
		if ( $categories_list && splinter_categorized_blog() ) {
			printf( '<div class="cat-links">' . __( 'Posted in %1$s', 'splinter' ) . '</div>', $categories_list );
		}
		if ( $tags_list && splinter_categorized_blog() ) {
			printf( '<div class="tag-links">' . __( 'Tags: %1$s', 'splinter' ) . '</div>', $tags_list );
		}
		if ( $categories_list || $tags_list ) {
			printf( '</footer>');
		}
	}

	edit_post_link( __( 'Edit', 'splinter' ), '<div class="edit-link">', '</div>' );
}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function splinter_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'splinter_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,

			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'splinter_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so splinter_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so splinter_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in splinter_categorized_blog.
 */
function splinter_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'splinter_categories' );
}
add_action( 'edit_category', 'splinter_category_transient_flusher' );
add_action( 'save_post',     'splinter_category_transient_flusher' );
