<?php
/**
 * Enqueue scripts and styles.
 */
function splinter_scripts() {

	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome/css/font-awesome.min.css', array(), '4.5.0', 'all' );

	wp_enqueue_style( 'splinter-google-font-biryani', '//fonts.googleapis.com/css?family=Biryani:400,900,300,700,200' );

	wp_enqueue_style( 'splinter-google-font-arimo', '//fonts.googleapis.com/css?family=Arimo:400,400italic,700,700italic' );
	
	wp_enqueue_style( 'splinter-style', get_stylesheet_uri(), array('font-awesome', 'splinter-google-font-biryani', 'splinter-google-font-arimo') );

	wp_enqueue_script( 'splinter-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	wp_enqueue_script( 'retina-js', get_template_directory_uri() . '/js/retina.min.js', array(), '20150407', true );

	wp_enqueue_script( 'splinter-animation', get_template_directory_uri() . '/js/animation-dist.js', array('jquery', 'jquery-color', 'jquery-effects-slide'), '20141205', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'splinter_scripts' );


/**
 * Enqueue the stylesheet.
 */
function splinter_customizer_stylesheet() {

    wp_register_style( 'splinter-customizer-css', get_template_directory_uri() . '/css/customizer.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'splinter-customizer-css' );

}
add_action( 'customize_controls_print_styles', 'splinter_customizer_stylesheet' );