<?php
/**
 * splinter Theme Customizer
 *
 * @package splinter
 */

/**
 * Add postMessage support for site title, description, header and background colors for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

/**
 * Customizer Sections, Settings and Controls
 */
if ( ! function_exists( 'splinter_customize_register' ) ) :

	function splinter_customize_register( $wp_customize ) {

		// Custom Logo Section
		$wp_customize->add_section( 'splinter_logos' , array(
		    'title'      => __( 'Logos', 'splinter' ),
		    'priority'   => 30,
		) );
		// Custom Header Logo Setting
		$wp_customize->add_setting( 'splinter_header_logo', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'splinter_header_logo', array(
			'label'      => __('Header Logo', 'splinter'),
			'section'    => 'splinter_logos',
			'settings'   => 'splinter_header_logo',
		)));
		// Custom Footer Logo Setting
		$wp_customize->add_setting( 'splinter_footer_logo', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'splinter_footer_logo', array(
			'label'      => __('Footer Logo', 'splinter'),
			'section'    => 'splinter_logos',
			'settings'   => 'splinter_footer_logo',
		)));


		// Social Networks Section
		$wp_customize->add_section( 'splinter_social_networks' , array(
		    'title'      => __( 'Social Networks', 'splinter' ),
		    'priority'   => 30,
		) );
		// Facebook Setting
		$wp_customize->add_setting( 'splinter_facebook_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_facebook_url',  array(
			'label'      => __('Facebook URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_facebook_url',
		));
		// Twitter Setting
		$wp_customize->add_setting( 'splinter_twitter_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_twitter_url',  array(
			'label'      => __('Twitter URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_twitter_url',
		));
		// Google Plus Setting
		$wp_customize->add_setting( 'splinter_google_plus_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_google_plus_url',  array(
			'label'      => __('Google Plus URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_google_plus_url',
		));
		// LinkedIn Setting
		$wp_customize->add_setting( 'splinter_linkedin_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_linkedin_url',  array(
			'label'      => __('LinkedIn URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_linkedin_url',
		));
		// Instagram Setting
		$wp_customize->add_setting( 'splinter_instagram_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_instagram_url',  array(
			'label'      => __('Instagram URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_instagram_url',
		));
		// Pinterest Setting
		$wp_customize->add_setting( 'splinter_pinterest_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_pinterest_url',  array(
			'label'      => __('Pinterest URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_pinterest_url',
		));
		// YouTube Setting
		$wp_customize->add_setting( 'splinter_youtube_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_youtube_url',  array(
			'label'      => __('YouTube URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_youtube_url',
		));
		// Vimeo Setting
		$wp_customize->add_setting( 'splinter_vimeo_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_vimeo_url',  array(
			'label'      => __('Vimeo URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_vimeo_url',
		));
		// Dribbble Setting
		$wp_customize->add_setting( 'splinter_dribbble_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_dribbble_url',  array(
			'label'      => __('Dribbble URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_dribbble_url',
		));
		// Behance Setting
		$wp_customize->add_setting( 'splinter_behance_url', array(
    		'default' 			=> '',
    		'sanitize_callback' => 'esc_url_raw',
    	) );
		$wp_customize->add_control( 'splinter_behance_url',  array(
			'label'      => __('Behance URL', 'splinter'),
			'section'    => 'splinter_social_networks',
			'settings'   => 'splinter_behance_url',
		));
	}

endif; //end splinter_customize_register
add_action( 'customize_register', 'splinter_customize_register' );

/**
 * Add HTML to customizer
 */
if ( ! function_exists( 'splinter_customizer_extra_html' ) ) :
	function splinter_customizer_extra_html() {
	?>
	<div id="customizer-extra-html">
		<!-- Custom Buttons -->
		<div id="more-themes-button-holder">
			<a href="<?php echo esc_url('https://www.wordskins.com'); ?>" target="_blank" class="button button-primary" id="more-themes-button"><?php _e('More Themes', 'splinter'); ?></a>
		</div>
	</div>
	<?php 
	} 
endif; //end splinter_customizer_extra_html
add_action( 'customize_controls_print_footer_scripts', 'splinter_customizer_extra_html', 1 );

/**
 * Enqueue script for custom customize control.
 */
if ( ! function_exists( 'splinter_custom_customize_enqueue' ) ) :
	function splinter_custom_customize_enqueue() {
		wp_enqueue_script( 'splinter-custom-customize', get_template_directory_uri() . '/js/customizer-dist.js', array( 'jquery', 'customize-controls' ), false, true );
	}
endif; //end splinter_custom_customize_enqueue
add_action( 'customize_controls_enqueue_scripts', 'splinter_custom_customize_enqueue' );