<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package splinter
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'splinter' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
		<div class="site-branding">
			<?php
			if(get_theme_mod('splinter_header_logo')) {
			?>
			<div class="site-logo">
			    <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url( get_theme_mod('splinter_header_logo') ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></a></h1>
			</div>
			<?php
			} else {
			?>
			<h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?></a></h1>
			<?php
			}
			?>
		    
			<h2 class="tagline"><?php echo esc_attr( get_bloginfo( 'description' ) ); ?></h2>
		</div><!-- .site-branding -->
		
		<button class="menu-toggle"><i class="fa fa-bars" aria-hidden="true"></i> <?php _e('Menu', 'splinter'); ?></button>

		<nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php _e( 'Main Menu', 'splinter' ); ?>">
			<?php
			if (has_nav_menu('header')) {
				wp_nav_menu( array( 
					'theme_location' => 'header', 
					'depth' => 3,
			        'container'      => false,
			        'menu_class'     => 'main-navigation',
			        'walker'         => new Aria_Walker_Nav_Menu(),
			        'items_wrap'     => '<ul id="%1$s" class="%2$s" role="menubar">%3$s</ul>',
				) );
			}
			?>
		</nav><!-- #site-navigation -->
	</header><!-- #masthead -->

	<div id="content" class="site-content">
