<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package splinter
 */
?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">

		<div class="inner">

			<div class="footer-widgets">

				<?php if ( is_active_sidebar( 'footer-1' ) ) : ?>
				 
				     <div class="widget-area footer-1">
				      <?php dynamic_sidebar( 'footer-1' ); ?>
				     </div><!-- #footer-1 .widget-area -->
				 
				<?php endif; ?>

				<?php if ( is_active_sidebar( 'footer-2' ) ) : ?>
				 
				     <div class="widget-area footer-2">
				      <?php dynamic_sidebar( 'footer-2' ); ?>
				     </div><!-- #footer-2 .widget-area -->
				 
				<?php endif; ?>

				<?php if ( is_active_sidebar( 'footer-3' ) ) : ?>
				 
				     <div class="widget-area footer-3">
				      <?php dynamic_sidebar( 'footer-3' ); ?>
				     </div><!-- #footer-3 .widget-area -->
				 
				<?php endif; ?>

				<div class="footer-info">
					<div class="footer-branding">
						<?php
						if(get_theme_mod('splinter_footer_logo')) {
						?>
						<div class="site-logo">
						    <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url( get_theme_mod('splinter_footer_logo') ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></a></h1>
						</div>
						<?php
						} else {
						?>
						<h1><?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?></h1>
						<?php
						}
						?>
						<div class="social-icons">
						<?php
						if (get_theme_mod('splinter_facebook_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-facebook social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_facebook_url') ), esc_html__('Go To Facebook', 'splinter') );
						}
						if (get_theme_mod('splinter_twitter_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-twitter social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_twitter_url') ), esc_html__('Go To Twitter', 'splinter') );
						}
						if (get_theme_mod('splinter_google_plus_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-google-plus social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_google_plus_url') ), esc_html__('Go To Google Plus', 'splinter') );
						}
						if (get_theme_mod('splinter_linkedin_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-linkedin social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_linkedin_url') ), esc_html__('Go To LinkedIn', 'splinter') );
						}
						if (get_theme_mod('splinter_instagram_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-instagram social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_instagram_url') ), esc_html__('Go To Instagram', 'splinter') );
						}
						if (get_theme_mod('splinter_pinterest_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-pinterest social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_pinterest_url') ), esc_html__('Go To Pinterest', 'splinter') );
						}
						if (get_theme_mod('splinter_youtube_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-youtube social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_youtube_url') ), esc_html__('Go To Youtube', 'splinter') );
						}
						if (get_theme_mod('splinter_vimeo_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-vimeo-square social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_vimeo_url') ), esc_html__('Go To Vimeo', 'splinter') );
						}
						if (get_theme_mod('splinter_dribbble_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-dribbble social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_dribbble_url') ), esc_html__('Go To Dribbble', 'splinter') );
						}
						if (get_theme_mod('splinter_behance_url')) {
							printf( '<a href="%1$s"><span class="screen-reader-text" for="s">%2$s</span><i class="fa fa-behance social-icon" aria-hidden="true"></i></a>', esc_url( get_theme_mod('splinter_behance_url') ), esc_html__('Go To Behance', 'splinter') );
						}
						?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="site-info">
			<div class="inner">
				<?php printf( __( 'Designed by <a href="%s" rel="designer">WordSkins.com</a>', 'splinter' ), esc_url( __( 'https://www.wordskins.com/', 'splinter' ) ) ); ?>
				<span class="sep"> | </span>
				<a href="<?php echo esc_url( __( 'http://wordpress.org/', 'splinter' ) ); ?>"><?php printf( __( 'Proudly powered by %s', 'splinter' ), 'WordPress' ); ?></a>
			</div>
		</div><!-- .site-info -->

	</footer><!-- #colophon -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
