<?php
function spinsoft_css() {
	$parent_style = 'spintech-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'spinsoft-style', get_stylesheet_uri(), array( $parent_style ));
	
	wp_enqueue_style('spinsoft-responsive',get_stylesheet_directory_uri().'/assets/css/responsive.css');
	wp_dequeue_style('spintech-responsive');
	
	wp_enqueue_script('jquery-counterup',get_stylesheet_directory_uri().'/assets/js/jquery.counterup.min.js');
	wp_enqueue_script('spinsoft-custom',get_stylesheet_directory_uri().'/assets/js/custom.js');

}
add_action( 'wp_enqueue_scripts', 'spinsoft_css',999);
   	


function spinsoft_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'spintech_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '060032',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'spintech_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'spinsoft_custom_header_setup' );

/**
 * Import Options From Parent Theme
 *
 */
function spinsoft_parent_theme_options() {
	$spintech_mods = get_option( 'theme_mods_spintech' );
	if ( ! empty( $spintech_mods ) ) {
		foreach ( $spintech_mods as $spintech_mod_k => $spintech_mod_v ) {
			set_theme_mod( $spintech_mod_k, $spintech_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'spinsoft_parent_theme_options' );

require( get_stylesheet_directory() . '/inc/customizer/customizer-pro/class-customize.php');