<?php
/**
 * Three column featured grid pattern.
 *
 * @package Spexo
 */

return array(
	'title'      => __( 'Three column featured grid', 'spexo' ),
	'content'    => '<!-- wp:group {"metadata":{"categories":["featured"],"patternName":"spexo/three-column-featured-grid","name":"Three column featured grid"},"style":{"spacing":{"padding":{"top":"var:preset|spacing|x-large","bottom":"var:preset|spacing|x-large"},"blockGap":"var:preset|spacing|large"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:var(--wp--preset--spacing--x-large);padding-bottom:var(--wp--preset--spacing--x-large)"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|x-small"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-bottom:var(--wp--preset--spacing--x-small)"><!-- wp:paragraph {"align":"center","style":{"typography":{"letterSpacing":"2px","textTransform":"uppercase"},"color":{"text":"#5729d9"},"spacing":{"margin":{"bottom":"var:preset|spacing|xx-small"}}},"fontSize":"x-small"} -->
<p class="has-text-align-center has-text-color has-x-small-font-size" style="color:#5729d9;margin-bottom:var(--wp--preset--spacing--xx-small);letter-spacing:2px;text-transform:uppercase">Complete Site Control</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"top":"0px"}},"typography":{"fontSize":"40px","lineHeight":"1.2"}}} -->
<h2 class="wp-block-heading has-text-align-center" style="margin-top:0px;font-size:40px;line-height:1.2">Build your website your way</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"15px"}}} -->
<p class="has-text-align-center" style="font-size:15px">Launch your site fast with the user-friendly Full Site Editor</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-large","left":"var:preset|spacing|x-large"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":139,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-1.svg" alt="" class="wp-image-139"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">Design with Freedom</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Unlock unlimited possibilities to shape your website’s appearance and functionality to suit your preferences.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":139,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-2.svg" alt="" class="wp-image-139"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">Lightning Speed</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Deliver blazing-fast page loads for an exceptional website user experience and improved SEO performance.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":866,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-3.svg" alt="" class="wp-image-866"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|x-small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--x-small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">SEO Friendly</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Achieve top search results and grow your audience with optimized, efficient code for better visibility and performance.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|x-large","left":"var:preset|spacing|x-large"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":139,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-5.svg" alt="" class="wp-image-139"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">Global Styles</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Maintain a consistent visual look across your website by defining typography, colors, and spacing in one place</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":139,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-4.svg" alt="" class="wp-image-139"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">Drag and Drop</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Bring your ideas to life quickly with easy, intuitive drag-and-drop interface customization for layouts and designs.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:image {"id":866,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":["rgb(87, 41, 217)","rgb(191, 24, 100)"]}}} -->
<figure class="wp-block-image size-large"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/featured-6.svg" alt="" class="wp-image-866"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"var:preset|spacing|small"},"padding":{"bottom":"10px"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.2"}},"fontSize":"medium"} -->
<h4 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--small);padding-bottom:10px;font-style:normal;font-weight:600;line-height:1.2">Creative Patterns</h4>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"15px"}}} -->
<p style="font-size:15px">Add a touch of creativity to your pages with Spexo’s unique, versatile, customizable, and elegant patterns.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->',
	'categories' => array( 'spexo', 'featured' ),
);
