<?php
/**
 * Hero content video icon pattern.
 *
 * @package Spexo
 */

return array(
	'title'      => __( 'Hero content video icon', 'spexo' ),
	'content'    => '<!-- wp:group {"metadata":{"name":"Hero Content","categories":["spexo"],"patternName":"spexo/hero-content"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","right":"var:preset|spacing|40","left":"var:preset|spacing|40"}}},"backgroundColor":"background-secondary","layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group alignfull has-background-secondary-background-color has-background" style="padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"},"padding":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:column {"verticalAlignment":"center","style":{"border":{"width":"0px","style":"none","radius":"20px"}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="border-style:none;border-width:0px;border-radius:20px"><!-- wp:cover {"url":"' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/hero-content-video-icon.jpg","id":303,"dimRatio":10,"overlayColor":"foreground","isUserOverlayColor":true,"minHeight":618,"minHeightUnit":"px","isDark":false,"className":"no-padding","style":{"spacing":{"blockGap":"0"},"border":{"radius":"20px"}}} -->
<div class="wp-block-cover is-light no-padding" style="border-radius:20px;min-height:618px"><span aria-hidden="true" class="wp-block-cover__background has-foreground-background-color has-background-dim-10 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-303" alt="" src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/hero-content-video-icon.jpg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group"><!-- wp:image {"id":104,"width":"100px","height":"97px","sizeSlug":"full","linkDestination":"custom","align":"center","className":"no-margin","style":{"color":{"duotone":["#fff","#cf2e2e"]}}} -->
<figure class="wp-block-image aligncenter size-full is-resized no-margin"><a href="#" target="_blank" rel="noreferrer noopener"><img src="' . trailingslashit( get_template_directory_uri() ) . 'assets/images/patterns/video-icon.png" alt="" class="wp-image-104" style="width:100px;height:97px"/></a></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"padding":{"bottom":"0","left":"var:preset|spacing|small"}}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="padding-bottom:0;padding-left:var(--wp--preset--spacing--small)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:paragraph {"align":"left","style":{"typography":{"letterSpacing":"2px","textTransform":"uppercase"},"color":{"text":"#5729d9"},"spacing":{"margin":{"bottom":"5px"}}},"fontSize":"x-small"} -->
<p class="has-text-align-left has-text-color has-x-small-font-size" style="color:#5729d9;margin-bottom:5px;letter-spacing:2px;text-transform:uppercase">About Our Company</p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"left","className":" ","style":{"typography":{"textTransform":"capitalize","fontSize":"40px","lineHeight":"1.2"},"spacing":{"margin":{"bottom":"0","top":"0"},"padding":{"top":"0","bottom":"var:preset|spacing|small"}}}} -->
<h2 class="wp-block-heading has-text-align-left" style="margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:var(--wp--preset--spacing--small);font-size:40px;line-height:1.2;text-transform:capitalize">Innovate Freely, Explore Boldly</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|small"}}}} -->
<p style="margin-bottom:var(--wp--preset--spacing--small)">We are storytellers of innovation, weaving digital experiences that turn visions into vibrant realities. Whether it’s designing sleek applications or engineering seamless platforms, we craft solutions that redefine possibilities. Every line of code and pixel we place is a step toward transforming bold ideas into game-changing solutions.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|small"}}}} -->
<p style="margin-bottom:var(--wp--preset--spacing--small)">Fueled by curiosity and driven by collaboration, we empower businesses to rise above the ordinary. From concept to completion, we deliver technology that resonates, inspires, and propels brands to new heights.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|small"}},"typography":{"fontStyle":"italic","fontWeight":"500"}}} -->
<p style="margin-bottom:var(--wp--preset--spacing--small);font-style:italic;font-weight:500">"Shaping the future, one innovation at a time."</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"","style":{"spacing":{"margin":{"top":"0px","bottom":"0px"},"blockGap":"0px","padding":{"top":"var:preset|spacing|xx-small"}}},"layout":{"type":"flex","justifyContent":"left","verticalAlignment":"center"}} -->
<div class="wp-block-buttons" style="margin-top:0px;margin-bottom:0px;padding-top:var(--wp--preset--spacing--xx-small)"><!-- wp:button {"className":"is-style-fill","style":{"typography":{"textTransform":"uppercase"}}} -->
<div class="wp-block-button is-style-fill" style="text-transform:uppercase"><a class="wp-block-button__link wp-element-button" href="#">Start Your Journey</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->',
	'categories' => array( 'spexo', 'about' ),
);
