<?php
/**
 * @author  Spexo
 * @since   1.0.0
 * @version 1.0.0
 */

$opt_name = TMPCODER_THEME_OPTION_NAME;

Redux::setSection( $opt_name,
    array(
        'title' => esc_html__( 'Typography','spexo' ),
        'id'    => 'tmpcoder_typography_options',
        'icon'  => 'el el-font',
    )
);

Redux::setSection( $opt_name, 
    array(
        'title'   => esc_html__( 'Desktop','spexo' ),
        'id'      => 'tmpcoder_section_typography_options',        
        'subsection' => true,
        'desc'    => "Set site fonts & headings for Desktop",
        'fields'  => array(
            array(
                'id'          => 'site_fonts_options',
		        'type'        => 'typography', 
		        'title'       => __('Site Fonts','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'letter-spacing' => true,
                'default'     => array(
		            'color'       => '#727272',
		            'font-style'  => '400', 
		            'font-family' => 'Poppins',
		            'google'      => true,
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_1',
		        'type'        => 'typography', 
		        'title'       => __('Heading 1 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '32px',
		            'letter-spacing' => '1px',
		            'line-height' => '48px'
		        ),
            ),
            array(
                'id'          => 'heading_2',
		        'type'        => 'typography', 
		        'title'       => __('Heading 2 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '26px',
		            'letter-spacing' => '1px',
		            'line-height' => '30px'
		        ),
            ),
            array(
                'id'          => 'heading_3',
		        'type'        => 'typography', 
		        'title'       => __('Heading 3 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '20px',
		            'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_4',
		        'type'        => 'typography', 
		        'title'       => __('Heading 4 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '17px',
		            'letter-spacing' => '1px',
		            'line-height' => '22px'
		        ),
            ),
            array(
                'id'          => 'heading_5',
		        'type'        => 'typography', 
		        'title'       => __('Heading 5 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '15px',
		            'letter-spacing' => '1px',
		            'line-height' => '20px'
		        ),
            ),
            array(
                'id'          => 'heading_6',
		        'type'        => 'typography', 
		        'title'       => __('Heading 6 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-backup' => false,
                'text-align'  => false,
                'text-transform' => true,
                'letter-spacing' => true,
		        'default'     => array(
		            'color'       => '#1d2327',
		            'font-style'  => '600', 
		            'font-family' => 'Poppins',
		            'font-size'   => '13px',
		            'letter-spacing' => '1px',
		            'line-height' => '16px'
		        ),
            ),
        )
    )
);

Redux::setSection( $opt_name, 
    array(
        'title'   => esc_html__( 'Tablet','spexo' ),
        'id'      => 'tmpcoder_section_typography_options_tablet',        
        'subsection' => true,
        'desc'    => "Set site fonts & headings for Tablet",
        'fields'  => array(
            array(
                'id'          => 'site_fonts_options_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Site Fonts','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_1_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 1 Font','spexo'),
		        'google'      => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '24px', 
                	'letter-spacing' => '1px',
		            'line-height' => '28px'
		        ),
            ),
            array(
                'id'          => 'heading_2_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 2 Font','spexo'),
		        'google'      => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '20px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_3_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 3 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '17px', 
                	'letter-spacing' => '1px',
		            'line-height' => '21px'
		        ),
            ),
            array(
                'id'          => 'heading_4_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 4 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '15px', 
                	'letter-spacing' => '1px',
		            'line-height' => '18px'
		        ),
            ),
            array(
                'id'          => 'heading_5_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 5 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_6_tablet',
		        'type'        => 'typography', 
		        'title'       => __('Heading 6 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
        )
    )
);

Redux::setSection( $opt_name, 
    array(
        'title'   => esc_html__( 'Mobile','spexo' ),
        'id'      => 'tmpcoder_section_typography_options_mobile',        
        'subsection' => true,
        'desc'    => "Set site fonts & headings for Mobile",
        'fields'  => array(
            array(
                'id'          => 'site_fonts_options_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Site Fonts','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_1_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 1 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_2_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 2 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_3_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 3 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_4_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 4 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_5_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 5 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
            array(
                'id'          => 'heading_6_mobile',
		        'type'        => 'typography', 
		        'title'       => __('Heading 6 Font','spexo'),
		        'google'      => true, 
                'all_styles'  => true, 
		        'output'      => array(),
		        'units'       =>'px',
		        'subtitle'    => __('Typography option with each property can be called individually.','spexo'),
                'subsets'     => false,
                'font-style' => false,
                'font-weight' => false,
                'text-transform' => false,
                'text-align' => false,
                'font-family' => false,
                'letter-spacing' => true,
                'color' => false,
                'default'     => array(
		            'font-size'   => '14px', 
                	'letter-spacing' => '1px',
		            'line-height' => '24px'
		        ),
            ),
        )
    )
);