<?php


/**


 * The Header for our theme.


 *


 * Displays all of the <head> section and everything up till <div id="main">


 *


 * @package DesignPromote


 * @subpackage Nursery


 * @since Nursery 1.0


 */


?><!DOCTYPE html>


<!--[if IE 7]>


<html class="ie ie7" <?php language_attributes(); ?>>


<![endif]-->


<!--[if IE 8]>


<html class="ie ie8" <?php language_attributes(); ?>>


<![endif]-->


<!--[if !(IE 7) | !(IE 8)  ]><!-->


<html <?php language_attributes(); ?>>


<!--<![endif]-->


<head>


	<meta charset="<?php bloginfo( 'charset' ); ?>">


	<meta name="viewport" content="width=device-width">


	<title><?php wp_title( '|', true, 'right' ); ?></title>


	<link rel="profile" href="http://gmpg.org/xfn/11">


	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">


	<!--[if lt IE 9]>


	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>


	<![endif]-->


	<?php wp_head(); ?>


</head>





<body <?php body_class(); ?>>


	<div id="page" class="hfeed site">


		<header id="masthead" class="site-header" role="banner">


			<a class="home-link" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">


				<h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>


				<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>


			</a>


			<?php if( !is_front_page() ): ?>


			<div id="navbar" class="navbar">


				<nav id="site-navigation" class="navigation main-navigation" role="navigation">


					<h3 class="menu-toggle"><?php _e( 'Menu', 'nursery' ); ?></h3>


					<a class="screen-reader-text skip-link" href="#content" title="<?php esc_attr_e( 'Skip to content', 'nursery' ); ?>"><?php _e( 'Skip to content', 'nursery' ); ?></a>


					<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>


					<?php //get_search_form(); ?>


				</nav><!-- #site-navigation -->


			</div><!-- #navbar -->


			<?php else: ?>


			<?php add_filter( 'the_content', 'nursery_front_page_content' ); ?>


			<?php endif; ?>


		</header><!-- #masthead -->





		<div id="main" class="site-main">


<script>


jQuery( document ).ready( function( $ ) {


	/*$( '.home-block' ).hover( function() {


		$( this ).animate({


			//width:'30%',


			//height:'+=4px',


			//left:'-2px',


			//padding:'+=2px',


			//marginLeft:'2px',


			//marginRight:'3px'


			//fontSize:'14px'


		}, 'slow' );


	}, function() {


		$( this ).animate({


			width:'320px',


			height:'320px',


			fontSize:'16px',


			//padding:'-=2px',


			margin:'5px'


		}, 'slow' );


	});*/


});


</script>


<style>


.home-block {


	background-image: url('http://www.sparklesnursery.com/wp-content/uploads/2013/09/logo-green-star.png');


	/*2. background-image: url('http://www.sparklesnursery.com/wp-content/uploads/2013/09/bg_star_of_the_week_copy.png');*/


	background-repeat: no-repeat;


	background-size: 200% 200%;


	-moz-transition: background-size 2s;


	-webkit-transition: background-size 2s;


	-o-transition:width  background-size 2s;


	transition: background-size 2s;


}


.home-block:hover {


	background-image: url('http://www.sparklesnursery.com/wp-content/uploads/2013/09/logo-green-star-hoover.png');


	background-size: 15% 15%;


}


</style>