<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package span
 */

?>
<!-- Start Post -->
<div <?php post_class( 'blog-post' );?> id="post-<?php the_ID(); ?>">
   <?php if( span_post_thumb() !== null ):?>
   <!-- Post format icon -->
   <div class="post-format">
      <span>
         <a href="<?php echo $link = span_post_format_link() ? $link : "javascript:void(0)";?>"><i class="<?php echo span_post_format_icon();?>"></i></a>
      </span>
   </div>
   <!-- Post feature-inner -->
   <?php
	// $blog_post	=	span_post_thumb( 'blog-posts' );
	// $full_blog	=	span_post_thumb( 'full-blog' );
	?>
   <div class="feature-inner"> <a class="lightbox" href="<?php echo span_post_thumb( 'full' );?>"><?php the_post_thumbnail( 'blog-post' );?></a> </div>
   <!-- End Post feature-inner -->
   <?php endif;?>
   <!-- Post Content -->
   <div class="post-content">
      <?php the_title( sprintf( '<h3 class="post-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
      <?php span_post_meta();?>
      <p>
         <?php the_excerpt();?>
      </p>
   </div>
   <!-- Post Content --> 
   
   <!-- Share social -->
   <div class="share">
      <?php span_post_share();?>
      <div class="pull-right"> <a class="btn btn-effect" href="<?php the_permalink();?>">
         <?php _e( 'Continue Reading' , 'span' );?>
         <i class="fa fa-angle-right"></i></a> </div>
   </div>
</div>
<?php return;?>
<article <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php span_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->

	<footer class="entry-footer">
		<?php span_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->

