<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package span
 */

?>

      <!-- Start Footer Section -->
      <footer>
        <div class="container">
          <div class="row footer-widgets">
            <!-- Start Contact Widget -->
            <div class="col-md-3 col-sm-6 col-xs-12">
            	<?php dynamic_sidebar( 'footer-A' );?>
            </div>
            <!-- .col-md-3 -->
            <!-- End Contact Widget -->
            <!-- Start Recent Posts Widget -->
            <div class="col-md-3 col-sm-6 col-xs-12">
            	<?php dynamic_sidebar( 'footer-B' );?>
            </div>
            <!-- .col-md-3 -->
            <!-- End Recent posts Widget -->
            <!-- Start Tags Widget -->
            <div class="col-md-3 col-sm-6 col-xs-12">
            	<?php dynamic_sidebar( 'footer-C' );?>
            </div>
            <!-- .col-md-3 -->
            <!-- End Twitter Widget -->
            <!-- Start Flickr Widget -->
            <div class="col-md-3 col-sm-6 col-xs-12">
            	<?php dynamic_sidebar( 'footer-D' );?>
            </div>
            <!-- .col-md-3 -->
            <!-- End Flickr Widget -->
          </div>
          <!-- .row -->        
        </div>
      </footer>
      <!-- End Footer Section -->
      <!-- Start Copyright -->
      <div class="copyright-section">
        <div class="container">
          <div class="row">
            <div class="col-sm-5">
              <p><?php 
				  $copyright = wp_kses( span_hopt( 'footer_copyright', span_tag_hierarchy(), '' ), array(
						'a' => array(
							'href' => array(),
							'title' => array()
						),
						'br' => array(),
						'em' => array(),
						'strong' => array(),
					) );
				  echo ! empty( $copyright ) ? $copyright : __( 'Span WordPress Multipurpose Theme by Blair Jersyer', 'span' );?></p>
            </div>
            <!-- .col-md-6 -->
            <div class="col-sm-7">
            <?php
				$menu_array		=	array(
					'theme_location'	=>	'footer',
					'container'			=>	false,
					'menu_class'		=>	'nav navbar-nav navbar-right',
					'items_wrap'		=>	'<ul id="%1$s" class="footer-nav">%3$s</ul>',
					'link_after'		=>	' /',
					'walker'				=>	new Span_Desktop_Menu_Walker
			  );
			  if( ! in_array( $menu_id	= span_hopt( 'footer_menu', span_tag_hierarchy(), NULL ), array( '', NULL ), TRUE ) ) { // Displays custom menu if it's set
				  $menu_array[ 'menu' ] 	=	$menu_id;
			  }
			  ?>
              <?php wp_nav_menu( $menu_array );?>
            </div>
            <!-- .col-md-6 -->
          </div>
          <!-- .row -->
        </div>
      </div>
      <!-- End Copyright -->
    </div>
<?php wp_footer(); ?>
</body>
</html>
