/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@remix-run/router/dist/router.js":
/*!*******************************************************!*\
  !*** ./node_modules/@remix-run/router/dist/router.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* binding */ AbortedDeferredError),
/* harmony export */   Action: () => (/* binding */ Action),
/* harmony export */   IDLE_BLOCKER: () => (/* binding */ IDLE_BLOCKER),
/* harmony export */   IDLE_FETCHER: () => (/* binding */ IDLE_FETCHER),
/* harmony export */   IDLE_NAVIGATION: () => (/* binding */ IDLE_NAVIGATION),
/* harmony export */   UNSAFE_DEFERRED_SYMBOL: () => (/* binding */ UNSAFE_DEFERRED_SYMBOL),
/* harmony export */   UNSAFE_DeferredData: () => (/* binding */ DeferredData),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* binding */ ErrorResponseImpl),
/* harmony export */   UNSAFE_convertRouteMatchToUiMatch: () => (/* binding */ convertRouteMatchToUiMatch),
/* harmony export */   UNSAFE_convertRoutesToDataRoutes: () => (/* binding */ convertRoutesToDataRoutes),
/* harmony export */   UNSAFE_decodePath: () => (/* binding */ decodePath),
/* harmony export */   UNSAFE_getResolveToMatches: () => (/* binding */ getResolveToMatches),
/* harmony export */   UNSAFE_invariant: () => (/* binding */ invariant),
/* harmony export */   UNSAFE_warning: () => (/* binding */ warning),
/* harmony export */   createBrowserHistory: () => (/* binding */ createBrowserHistory),
/* harmony export */   createHashHistory: () => (/* binding */ createHashHistory),
/* harmony export */   createMemoryHistory: () => (/* binding */ createMemoryHistory),
/* harmony export */   createPath: () => (/* binding */ createPath),
/* harmony export */   createRouter: () => (/* binding */ createRouter),
/* harmony export */   createStaticHandler: () => (/* binding */ createStaticHandler),
/* harmony export */   defer: () => (/* binding */ defer),
/* harmony export */   generatePath: () => (/* binding */ generatePath),
/* harmony export */   getStaticContextFromError: () => (/* binding */ getStaticContextFromError),
/* harmony export */   getToPathname: () => (/* binding */ getToPathname),
/* harmony export */   isDataWithResponseInit: () => (/* binding */ isDataWithResponseInit),
/* harmony export */   isDeferredData: () => (/* binding */ isDeferredData),
/* harmony export */   isRouteErrorResponse: () => (/* binding */ isRouteErrorResponse),
/* harmony export */   joinPaths: () => (/* binding */ joinPaths),
/* harmony export */   json: () => (/* binding */ json),
/* harmony export */   matchPath: () => (/* binding */ matchPath),
/* harmony export */   matchRoutes: () => (/* binding */ matchRoutes),
/* harmony export */   normalizePathname: () => (/* binding */ normalizePathname),
/* harmony export */   parsePath: () => (/* binding */ parsePath),
/* harmony export */   redirect: () => (/* binding */ redirect),
/* harmony export */   redirectDocument: () => (/* binding */ redirectDocument),
/* harmony export */   replace: () => (/* binding */ replace),
/* harmony export */   resolvePath: () => (/* binding */ resolvePath),
/* harmony export */   resolveTo: () => (/* binding */ resolveTo),
/* harmony export */   stripBasename: () => (/* binding */ stripBasename),
/* harmony export */   unstable_data: () => (/* binding */ data)
/* harmony export */ });
/**
 * @remix-run/router v1.19.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

////////////////////////////////////////////////////////////////////////////////
//#region Types and Constants
////////////////////////////////////////////////////////////////////////////////
/**
 * Actions represent the type of change to a location value.
 */
var Action;
(function (Action) {
  /**
   * A POP indicates a change to an arbitrary index in the history stack, such
   * as a back or forward navigation. It does not describe the direction of the
   * navigation, only that the current index changed.
   *
   * Note: This is the default action for newly created history objects.
   */
  Action["Pop"] = "POP";
  /**
   * A PUSH indicates a new entry being added to the history stack, such as when
   * a link is clicked and a new page loads. When this happens, all subsequent
   * entries in the stack are lost.
   */
  Action["Push"] = "PUSH";
  /**
   * A REPLACE indicates the entry at the current index in the history stack
   * being replaced by a new one.
   */
  Action["Replace"] = "REPLACE";
})(Action || (Action = {}));
const PopStateEventType = "popstate";
/**
 * Memory history stores the current location in memory. It is designed for use
 * in stateful non-browser environments like tests and React Native.
 */
function createMemoryHistory(options) {
  if (options === void 0) {
    options = {};
  }
  let {
    initialEntries = ["/"],
    initialIndex,
    v5Compat = false
  } = options;
  let entries; // Declare so we can access from createMemoryLocation
  entries = initialEntries.map((entry, index) => createMemoryLocation(entry, typeof entry === "string" ? null : entry.state, index === 0 ? "default" : undefined));
  let index = clampIndex(initialIndex == null ? entries.length - 1 : initialIndex);
  let action = Action.Pop;
  let listener = null;
  function clampIndex(n) {
    return Math.min(Math.max(n, 0), entries.length - 1);
  }
  function getCurrentLocation() {
    return entries[index];
  }
  function createMemoryLocation(to, state, key) {
    if (state === void 0) {
      state = null;
    }
    let location = createLocation(entries ? getCurrentLocation().pathname : "/", to, state, key);
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in memory history: " + JSON.stringify(to));
    return location;
  }
  function createHref(to) {
    return typeof to === "string" ? to : createPath(to);
  }
  let history = {
    get index() {
      return index;
    },
    get action() {
      return action;
    },
    get location() {
      return getCurrentLocation();
    },
    createHref,
    createURL(to) {
      return new URL(createHref(to), "http://localhost");
    },
    encodeLocation(to) {
      let path = typeof to === "string" ? parsePath(to) : to;
      return {
        pathname: path.pathname || "",
        search: path.search || "",
        hash: path.hash || ""
      };
    },
    push(to, state) {
      action = Action.Push;
      let nextLocation = createMemoryLocation(to, state);
      index += 1;
      entries.splice(index, entries.length, nextLocation);
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 1
        });
      }
    },
    replace(to, state) {
      action = Action.Replace;
      let nextLocation = createMemoryLocation(to, state);
      entries[index] = nextLocation;
      if (v5Compat && listener) {
        listener({
          action,
          location: nextLocation,
          delta: 0
        });
      }
    },
    go(delta) {
      action = Action.Pop;
      let nextIndex = clampIndex(index + delta);
      let nextLocation = entries[nextIndex];
      index = nextIndex;
      if (listener) {
        listener({
          action,
          location: nextLocation,
          delta
        });
      }
    },
    listen(fn) {
      listener = fn;
      return () => {
        listener = null;
      };
    }
  };
  return history;
}
/**
 * Browser history stores the location in regular URLs. This is the standard for
 * most web apps, but it requires some configuration on the server to ensure you
 * serve the same app at multiple URLs.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createbrowserhistory
 */
function createBrowserHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createBrowserLocation(window, globalHistory) {
    let {
      pathname,
      search,
      hash
    } = window.location;
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createBrowserHref(window, to) {
    return typeof to === "string" ? to : createPath(to);
  }
  return getUrlBasedHistory(createBrowserLocation, createBrowserHref, null, options);
}
/**
 * Hash history stores the location in window.location.hash. This makes it ideal
 * for situations where you don't want to send the location to the server for
 * some reason, either because you do cannot configure it or the URL space is
 * reserved for something else.
 *
 * @see https://github.com/remix-run/history/tree/main/docs/api-reference.md#createhashhistory
 */
function createHashHistory(options) {
  if (options === void 0) {
    options = {};
  }
  function createHashLocation(window, globalHistory) {
    let {
      pathname = "/",
      search = "",
      hash = ""
    } = parsePath(window.location.hash.substr(1));
    // Hash URL should always have a leading / just like window.location.pathname
    // does, so if an app ends up at a route like /#something then we add a
    // leading slash so all of our path-matching behaves the same as if it would
    // in a browser router.  This is particularly important when there exists a
    // root splat route (<Route path="*">) since that matches internally against
    // "/*" and we'd expect /#something to 404 in a hash router app.
    if (!pathname.startsWith("/") && !pathname.startsWith(".")) {
      pathname = "/" + pathname;
    }
    return createLocation("", {
      pathname,
      search,
      hash
    },
    // state defaults to `null` because `window.history.state` does
    globalHistory.state && globalHistory.state.usr || null, globalHistory.state && globalHistory.state.key || "default");
  }
  function createHashHref(window, to) {
    let base = window.document.querySelector("base");
    let href = "";
    if (base && base.getAttribute("href")) {
      let url = window.location.href;
      let hashIndex = url.indexOf("#");
      href = hashIndex === -1 ? url : url.slice(0, hashIndex);
    }
    return href + "#" + (typeof to === "string" ? to : createPath(to));
  }
  function validateHashLocation(location, to) {
    warning(location.pathname.charAt(0) === "/", "relative pathnames are not supported in hash history.push(" + JSON.stringify(to) + ")");
  }
  return getUrlBasedHistory(createHashLocation, createHashHref, validateHashLocation, options);
}
function invariant(value, message) {
  if (value === false || value === null || typeof value === "undefined") {
    throw new Error(message);
  }
}
function warning(cond, message) {
  if (!cond) {
    // eslint-disable-next-line no-console
    if (typeof console !== "undefined") console.warn(message);
    try {
      // Welcome to debugging history!
      //
      // This error is thrown as a convenience, so you can more easily
      // find the source for a warning that appears in the console by
      // enabling "pause on exceptions" in your JavaScript debugger.
      throw new Error(message);
      // eslint-disable-next-line no-empty
    } catch (e) {}
  }
}
function createKey() {
  return Math.random().toString(36).substr(2, 8);
}
/**
 * For browser-based histories, we combine the state and key into an object
 */
function getHistoryState(location, index) {
  return {
    usr: location.state,
    key: location.key,
    idx: index
  };
}
/**
 * Creates a Location object with a unique key from the given Path
 */
function createLocation(current, to, state, key) {
  if (state === void 0) {
    state = null;
  }
  let location = _extends({
    pathname: typeof current === "string" ? current : current.pathname,
    search: "",
    hash: ""
  }, typeof to === "string" ? parsePath(to) : to, {
    state,
    // TODO: This could be cleaned up.  push/replace should probably just take
    // full Locations now and avoid the need to run through this flow at all
    // But that's a pretty big refactor to the current test suite so going to
    // keep as is for the time being and just let any incoming keys take precedence
    key: to && to.key || key || createKey()
  });
  return location;
}
/**
 * Creates a string URL path from the given pathname, search, and hash components.
 */
function createPath(_ref) {
  let {
    pathname = "/",
    search = "",
    hash = ""
  } = _ref;
  if (search && search !== "?") pathname += search.charAt(0) === "?" ? search : "?" + search;
  if (hash && hash !== "#") pathname += hash.charAt(0) === "#" ? hash : "#" + hash;
  return pathname;
}
/**
 * Parses a string URL path into its separate pathname, search, and hash components.
 */
function parsePath(path) {
  let parsedPath = {};
  if (path) {
    let hashIndex = path.indexOf("#");
    if (hashIndex >= 0) {
      parsedPath.hash = path.substr(hashIndex);
      path = path.substr(0, hashIndex);
    }
    let searchIndex = path.indexOf("?");
    if (searchIndex >= 0) {
      parsedPath.search = path.substr(searchIndex);
      path = path.substr(0, searchIndex);
    }
    if (path) {
      parsedPath.pathname = path;
    }
  }
  return parsedPath;
}
function getUrlBasedHistory(getLocation, createHref, validateLocation, options) {
  if (options === void 0) {
    options = {};
  }
  let {
    window = document.defaultView,
    v5Compat = false
  } = options;
  let globalHistory = window.history;
  let action = Action.Pop;
  let listener = null;
  let index = getIndex();
  // Index should only be null when we initialize. If not, it's because the
  // user called history.pushState or history.replaceState directly, in which
  // case we should log a warning as it will result in bugs.
  if (index == null) {
    index = 0;
    globalHistory.replaceState(_extends({}, globalHistory.state, {
      idx: index
    }), "");
  }
  function getIndex() {
    let state = globalHistory.state || {
      idx: null
    };
    return state.idx;
  }
  function handlePop() {
    action = Action.Pop;
    let nextIndex = getIndex();
    let delta = nextIndex == null ? null : nextIndex - index;
    index = nextIndex;
    if (listener) {
      listener({
        action,
        location: history.location,
        delta
      });
    }
  }
  function push(to, state) {
    action = Action.Push;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex() + 1;
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    // try...catch because iOS limits us to 100 pushState calls :/
    try {
      globalHistory.pushState(historyState, "", url);
    } catch (error) {
      // If the exception is because `state` can't be serialized, let that throw
      // outwards just like a replace call would so the dev knows the cause
      // https://html.spec.whatwg.org/multipage/nav-history-apis.html#shared-history-push/replace-state-steps
      // https://html.spec.whatwg.org/multipage/structured-data.html#structuredserializeinternal
      if (error instanceof DOMException && error.name === "DataCloneError") {
        throw error;
      }
      // They are going to lose state here, but there is no real
      // way to warn them about it since the page will refresh...
      window.location.assign(url);
    }
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 1
      });
    }
  }
  function replace(to, state) {
    action = Action.Replace;
    let location = createLocation(history.location, to, state);
    if (validateLocation) validateLocation(location, to);
    index = getIndex();
    let historyState = getHistoryState(location, index);
    let url = history.createHref(location);
    globalHistory.replaceState(historyState, "", url);
    if (v5Compat && listener) {
      listener({
        action,
        location: history.location,
        delta: 0
      });
    }
  }
  function createURL(to) {
    // window.location.origin is "null" (the literal string value) in Firefox
    // under certain conditions, notably when serving from a local HTML file
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=878297
    let base = window.location.origin !== "null" ? window.location.origin : window.location.href;
    let href = typeof to === "string" ? to : createPath(to);
    // Treating this as a full URL will strip any trailing spaces so we need to
    // pre-encode them since they might be part of a matching splat param from
    // an ancestor route
    href = href.replace(/ $/, "%20");
    invariant(base, "No window.location.(origin|href) available to create URL for href: " + href);
    return new URL(href, base);
  }
  let history = {
    get action() {
      return action;
    },
    get location() {
      return getLocation(window, globalHistory);
    },
    listen(fn) {
      if (listener) {
        throw new Error("A history only accepts one active listener");
      }
      window.addEventListener(PopStateEventType, handlePop);
      listener = fn;
      return () => {
        window.removeEventListener(PopStateEventType, handlePop);
        listener = null;
      };
    },
    createHref(to) {
      return createHref(window, to);
    },
    createURL,
    encodeLocation(to) {
      // Encode a Location the same way window.location would
      let url = createURL(to);
      return {
        pathname: url.pathname,
        search: url.search,
        hash: url.hash
      };
    },
    push,
    replace,
    go(n) {
      return globalHistory.go(n);
    }
  };
  return history;
}
//#endregion

var ResultType;
(function (ResultType) {
  ResultType["data"] = "data";
  ResultType["deferred"] = "deferred";
  ResultType["redirect"] = "redirect";
  ResultType["error"] = "error";
})(ResultType || (ResultType = {}));
const immutableRouteKeys = new Set(["lazy", "caseSensitive", "path", "id", "index", "children"]);
function isIndexRoute(route) {
  return route.index === true;
}
// Walk the route tree generating unique IDs where necessary, so we are working
// solely with AgnosticDataRouteObject's within the Router
function convertRoutesToDataRoutes(routes, mapRouteProperties, parentPath, manifest) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  if (manifest === void 0) {
    manifest = {};
  }
  return routes.map((route, index) => {
    let treePath = [...parentPath, String(index)];
    let id = typeof route.id === "string" ? route.id : treePath.join("-");
    invariant(route.index !== true || !route.children, "Cannot specify children on an index route");
    invariant(!manifest[id], "Found a route id collision on id \"" + id + "\".  Route " + "id's must be globally unique within Data Router usages");
    if (isIndexRoute(route)) {
      let indexRoute = _extends({}, route, mapRouteProperties(route), {
        id
      });
      manifest[id] = indexRoute;
      return indexRoute;
    } else {
      let pathOrLayoutRoute = _extends({}, route, mapRouteProperties(route), {
        id,
        children: undefined
      });
      manifest[id] = pathOrLayoutRoute;
      if (route.children) {
        pathOrLayoutRoute.children = convertRoutesToDataRoutes(route.children, mapRouteProperties, treePath, manifest);
      }
      return pathOrLayoutRoute;
    }
  });
}
/**
 * Matches the given routes to a location and returns the match data.
 *
 * @see https://reactrouter.com/utils/match-routes
 */
function matchRoutes(routes, locationArg, basename) {
  if (basename === void 0) {
    basename = "/";
  }
  return matchRoutesImpl(routes, locationArg, basename, false);
}
function matchRoutesImpl(routes, locationArg, basename, allowPartial) {
  let location = typeof locationArg === "string" ? parsePath(locationArg) : locationArg;
  let pathname = stripBasename(location.pathname || "/", basename);
  if (pathname == null) {
    return null;
  }
  let branches = flattenRoutes(routes);
  rankRouteBranches(branches);
  let matches = null;
  for (let i = 0; matches == null && i < branches.length; ++i) {
    // Incoming pathnames are generally encoded from either window.location
    // or from router.navigate, but we want to match against the unencoded
    // paths in the route definitions.  Memory router locations won't be
    // encoded here but there also shouldn't be anything to decode so this
    // should be a safe operation.  This avoids needing matchRoutes to be
    // history-aware.
    let decoded = decodePath(pathname);
    matches = matchRouteBranch(branches[i], decoded, allowPartial);
  }
  return matches;
}
function convertRouteMatchToUiMatch(match, loaderData) {
  let {
    route,
    pathname,
    params
  } = match;
  return {
    id: route.id,
    pathname,
    params,
    data: loaderData[route.id],
    handle: route.handle
  };
}
function flattenRoutes(routes, branches, parentsMeta, parentPath) {
  if (branches === void 0) {
    branches = [];
  }
  if (parentsMeta === void 0) {
    parentsMeta = [];
  }
  if (parentPath === void 0) {
    parentPath = "";
  }
  let flattenRoute = (route, index, relativePath) => {
    let meta = {
      relativePath: relativePath === undefined ? route.path || "" : relativePath,
      caseSensitive: route.caseSensitive === true,
      childrenIndex: index,
      route
    };
    if (meta.relativePath.startsWith("/")) {
      invariant(meta.relativePath.startsWith(parentPath), "Absolute route path \"" + meta.relativePath + "\" nested under path " + ("\"" + parentPath + "\" is not valid. An absolute child route path ") + "must start with the combined path of all its parent routes.");
      meta.relativePath = meta.relativePath.slice(parentPath.length);
    }
    let path = joinPaths([parentPath, meta.relativePath]);
    let routesMeta = parentsMeta.concat(meta);
    // Add the children before adding this route to the array, so we traverse the
    // route tree depth-first and child routes appear before their parents in
    // the "flattened" version.
    if (route.children && route.children.length > 0) {
      invariant(
      // Our types know better, but runtime JS may not!
      // @ts-expect-error
      route.index !== true, "Index routes must not have child routes. Please remove " + ("all child routes from route path \"" + path + "\"."));
      flattenRoutes(route.children, branches, routesMeta, path);
    }
    // Routes without a path shouldn't ever match by themselves unless they are
    // index routes, so don't add them to the list of possible branches.
    if (route.path == null && !route.index) {
      return;
    }
    branches.push({
      path,
      score: computeScore(path, route.index),
      routesMeta
    });
  };
  routes.forEach((route, index) => {
    var _route$path;
    // coarse-grain check for optional params
    if (route.path === "" || !((_route$path = route.path) != null && _route$path.includes("?"))) {
      flattenRoute(route, index);
    } else {
      for (let exploded of explodeOptionalSegments(route.path)) {
        flattenRoute(route, index, exploded);
      }
    }
  });
  return branches;
}
/**
 * Computes all combinations of optional path segments for a given path,
 * excluding combinations that are ambiguous and of lower priority.
 *
 * For example, `/one/:two?/three/:four?/:five?` explodes to:
 * - `/one/three`
 * - `/one/:two/three`
 * - `/one/three/:four`
 * - `/one/three/:five`
 * - `/one/:two/three/:four`
 * - `/one/:two/three/:five`
 * - `/one/three/:four/:five`
 * - `/one/:two/three/:four/:five`
 */
function explodeOptionalSegments(path) {
  let segments = path.split("/");
  if (segments.length === 0) return [];
  let [first, ...rest] = segments;
  // Optional path segments are denoted by a trailing `?`
  let isOptional = first.endsWith("?");
  // Compute the corresponding required segment: `foo?` -> `foo`
  let required = first.replace(/\?$/, "");
  if (rest.length === 0) {
    // Intepret empty string as omitting an optional segment
    // `["one", "", "three"]` corresponds to omitting `:two` from `/one/:two?/three` -> `/one/three`
    return isOptional ? [required, ""] : [required];
  }
  let restExploded = explodeOptionalSegments(rest.join("/"));
  let result = [];
  // All child paths with the prefix.  Do this for all children before the
  // optional version for all children, so we get consistent ordering where the
  // parent optional aspect is preferred as required.  Otherwise, we can get
  // child sections interspersed where deeper optional segments are higher than
  // parent optional segments, where for example, /:two would explode _earlier_
  // then /:one.  By always including the parent as required _for all children_
  // first, we avoid this issue
  result.push(...restExploded.map(subpath => subpath === "" ? required : [required, subpath].join("/")));
  // Then, if this is an optional value, add all child versions without
  if (isOptional) {
    result.push(...restExploded);
  }
  // for absolute paths, ensure `/` instead of empty segment
  return result.map(exploded => path.startsWith("/") && exploded === "" ? "/" : exploded);
}
function rankRouteBranches(branches) {
  branches.sort((a, b) => a.score !== b.score ? b.score - a.score // Higher score first
  : compareIndexes(a.routesMeta.map(meta => meta.childrenIndex), b.routesMeta.map(meta => meta.childrenIndex)));
}
const paramRe = /^:[\w-]+$/;
const dynamicSegmentValue = 3;
const indexRouteValue = 2;
const emptySegmentValue = 1;
const staticSegmentValue = 10;
const splatPenalty = -2;
const isSplat = s => s === "*";
function computeScore(path, index) {
  let segments = path.split("/");
  let initialScore = segments.length;
  if (segments.some(isSplat)) {
    initialScore += splatPenalty;
  }
  if (index) {
    initialScore += indexRouteValue;
  }
  return segments.filter(s => !isSplat(s)).reduce((score, segment) => score + (paramRe.test(segment) ? dynamicSegmentValue : segment === "" ? emptySegmentValue : staticSegmentValue), initialScore);
}
function compareIndexes(a, b) {
  let siblings = a.length === b.length && a.slice(0, -1).every((n, i) => n === b[i]);
  return siblings ?
  // If two routes are siblings, we should try to match the earlier sibling
  // first. This allows people to have fine-grained control over the matching
  // behavior by simply putting routes with identical paths in the order they
  // want them tried.
  a[a.length - 1] - b[b.length - 1] :
  // Otherwise, it doesn't really make sense to rank non-siblings by index,
  // so they sort equally.
  0;
}
function matchRouteBranch(branch, pathname, allowPartial) {
  if (allowPartial === void 0) {
    allowPartial = false;
  }
  let {
    routesMeta
  } = branch;
  let matchedParams = {};
  let matchedPathname = "/";
  let matches = [];
  for (let i = 0; i < routesMeta.length; ++i) {
    let meta = routesMeta[i];
    let end = i === routesMeta.length - 1;
    let remainingPathname = matchedPathname === "/" ? pathname : pathname.slice(matchedPathname.length) || "/";
    let match = matchPath({
      path: meta.relativePath,
      caseSensitive: meta.caseSensitive,
      end
    }, remainingPathname);
    let route = meta.route;
    if (!match && end && allowPartial && !routesMeta[routesMeta.length - 1].route.index) {
      match = matchPath({
        path: meta.relativePath,
        caseSensitive: meta.caseSensitive,
        end: false
      }, remainingPathname);
    }
    if (!match) {
      return null;
    }
    Object.assign(matchedParams, match.params);
    matches.push({
      // TODO: Can this as be avoided?
      params: matchedParams,
      pathname: joinPaths([matchedPathname, match.pathname]),
      pathnameBase: normalizePathname(joinPaths([matchedPathname, match.pathnameBase])),
      route
    });
    if (match.pathnameBase !== "/") {
      matchedPathname = joinPaths([matchedPathname, match.pathnameBase]);
    }
  }
  return matches;
}
/**
 * Returns a path with params interpolated.
 *
 * @see https://reactrouter.com/utils/generate-path
 */
function generatePath(originalPath, params) {
  if (params === void 0) {
    params = {};
  }
  let path = originalPath;
  if (path.endsWith("*") && path !== "*" && !path.endsWith("/*")) {
    warning(false, "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
    path = path.replace(/\*$/, "/*");
  }
  // ensure `/` is added at the beginning if the path is absolute
  const prefix = path.startsWith("/") ? "/" : "";
  const stringify = p => p == null ? "" : typeof p === "string" ? p : String(p);
  const segments = path.split(/\/+/).map((segment, index, array) => {
    const isLastSegment = index === array.length - 1;
    // only apply the splat if it's the last segment
    if (isLastSegment && segment === "*") {
      const star = "*";
      // Apply the splat
      return stringify(params[star]);
    }
    const keyMatch = segment.match(/^:([\w-]+)(\??)$/);
    if (keyMatch) {
      const [, key, optional] = keyMatch;
      let param = params[key];
      invariant(optional === "?" || param != null, "Missing \":" + key + "\" param");
      return stringify(param);
    }
    // Remove any optional markers from optional static segments
    return segment.replace(/\?$/g, "");
  })
  // Remove empty segments
  .filter(segment => !!segment);
  return prefix + segments.join("/");
}
/**
 * Performs pattern matching on a URL pathname and returns information about
 * the match.
 *
 * @see https://reactrouter.com/utils/match-path
 */
function matchPath(pattern, pathname) {
  if (typeof pattern === "string") {
    pattern = {
      path: pattern,
      caseSensitive: false,
      end: true
    };
  }
  let [matcher, compiledParams] = compilePath(pattern.path, pattern.caseSensitive, pattern.end);
  let match = pathname.match(matcher);
  if (!match) return null;
  let matchedPathname = match[0];
  let pathnameBase = matchedPathname.replace(/(.)\/+$/, "$1");
  let captureGroups = match.slice(1);
  let params = compiledParams.reduce((memo, _ref, index) => {
    let {
      paramName,
      isOptional
    } = _ref;
    // We need to compute the pathnameBase here using the raw splat value
    // instead of using params["*"] later because it will be decoded then
    if (paramName === "*") {
      let splatValue = captureGroups[index] || "";
      pathnameBase = matchedPathname.slice(0, matchedPathname.length - splatValue.length).replace(/(.)\/+$/, "$1");
    }
    const value = captureGroups[index];
    if (isOptional && !value) {
      memo[paramName] = undefined;
    } else {
      memo[paramName] = (value || "").replace(/%2F/g, "/");
    }
    return memo;
  }, {});
  return {
    params,
    pathname: matchedPathname,
    pathnameBase,
    pattern
  };
}
function compilePath(path, caseSensitive, end) {
  if (caseSensitive === void 0) {
    caseSensitive = false;
  }
  if (end === void 0) {
    end = true;
  }
  warning(path === "*" || !path.endsWith("*") || path.endsWith("/*"), "Route path \"" + path + "\" will be treated as if it were " + ("\"" + path.replace(/\*$/, "/*") + "\" because the `*` character must ") + "always follow a `/` in the pattern. To get rid of this warning, " + ("please change the route path to \"" + path.replace(/\*$/, "/*") + "\"."));
  let params = [];
  let regexpSource = "^" + path.replace(/\/*\*?$/, "") // Ignore trailing / and /*, we'll handle it below
  .replace(/^\/*/, "/") // Make sure it has a leading /
  .replace(/[\\.*+^${}|()[\]]/g, "\\$&") // Escape special regex chars
  .replace(/\/:([\w-]+)(\?)?/g, (_, paramName, isOptional) => {
    params.push({
      paramName,
      isOptional: isOptional != null
    });
    return isOptional ? "/?([^\\/]+)?" : "/([^\\/]+)";
  });
  if (path.endsWith("*")) {
    params.push({
      paramName: "*"
    });
    regexpSource += path === "*" || path === "/*" ? "(.*)$" // Already matched the initial /, just match the rest
    : "(?:\\/(.+)|\\/*)$"; // Don't include the / in params["*"]
  } else if (end) {
    // When matching to the end, ignore trailing slashes
    regexpSource += "\\/*$";
  } else if (path !== "" && path !== "/") {
    // If our path is non-empty and contains anything beyond an initial slash,
    // then we have _some_ form of path in our regex, so we should expect to
    // match only if we find the end of this path segment.  Look for an optional
    // non-captured trailing slash (to match a portion of the URL) or the end
    // of the path (if we've matched to the end).  We used to do this with a
    // word boundary but that gives false positives on routes like
    // /user-preferences since `-` counts as a word boundary.
    regexpSource += "(?:(?=\\/|$))";
  } else ;
  let matcher = new RegExp(regexpSource, caseSensitive ? undefined : "i");
  return [matcher, params];
}
function decodePath(value) {
  try {
    return value.split("/").map(v => decodeURIComponent(v).replace(/\//g, "%2F")).join("/");
  } catch (error) {
    warning(false, "The URL path \"" + value + "\" could not be decoded because it is is a " + "malformed URL segment. This is probably due to a bad percent " + ("encoding (" + error + ")."));
    return value;
  }
}
/**
 * @private
 */
function stripBasename(pathname, basename) {
  if (basename === "/") return pathname;
  if (!pathname.toLowerCase().startsWith(basename.toLowerCase())) {
    return null;
  }
  // We want to leave trailing slash behavior in the user's control, so if they
  // specify a basename with a trailing slash, we should support it
  let startIndex = basename.endsWith("/") ? basename.length - 1 : basename.length;
  let nextChar = pathname.charAt(startIndex);
  if (nextChar && nextChar !== "/") {
    // pathname does not start with basename/
    return null;
  }
  return pathname.slice(startIndex) || "/";
}
/**
 * Returns a resolved path object relative to the given pathname.
 *
 * @see https://reactrouter.com/utils/resolve-path
 */
function resolvePath(to, fromPathname) {
  if (fromPathname === void 0) {
    fromPathname = "/";
  }
  let {
    pathname: toPathname,
    search = "",
    hash = ""
  } = typeof to === "string" ? parsePath(to) : to;
  let pathname = toPathname ? toPathname.startsWith("/") ? toPathname : resolvePathname(toPathname, fromPathname) : fromPathname;
  return {
    pathname,
    search: normalizeSearch(search),
    hash: normalizeHash(hash)
  };
}
function resolvePathname(relativePath, fromPathname) {
  let segments = fromPathname.replace(/\/+$/, "").split("/");
  let relativeSegments = relativePath.split("/");
  relativeSegments.forEach(segment => {
    if (segment === "..") {
      // Keep the root "" segment so the pathname starts at /
      if (segments.length > 1) segments.pop();
    } else if (segment !== ".") {
      segments.push(segment);
    }
  });
  return segments.length > 1 ? segments.join("/") : "/";
}
function getInvalidPathError(char, field, dest, path) {
  return "Cannot include a '" + char + "' character in a manually specified " + ("`to." + field + "` field [" + JSON.stringify(path) + "].  Please separate it out to the ") + ("`to." + dest + "` field. Alternatively you may provide the full path as ") + "a string in <Link to=\"...\"> and the router will parse it for you.";
}
/**
 * @private
 *
 * When processing relative navigation we want to ignore ancestor routes that
 * do not contribute to the path, such that index/pathless layout routes don't
 * interfere.
 *
 * For example, when moving a route element into an index route and/or a
 * pathless layout route, relative link behavior contained within should stay
 * the same.  Both of the following examples should link back to the root:
 *
 *   <Route path="/">
 *     <Route path="accounts" element={<Link to=".."}>
 *   </Route>
 *
 *   <Route path="/">
 *     <Route path="accounts">
 *       <Route element={<AccountsLayout />}>       // <-- Does not contribute
 *         <Route index element={<Link to=".."} />  // <-- Does not contribute
 *       </Route
 *     </Route>
 *   </Route>
 */
function getPathContributingMatches(matches) {
  return matches.filter((match, index) => index === 0 || match.route.path && match.route.path.length > 0);
}
// Return the array of pathnames for the current route matches - used to
// generate the routePathnames input for resolveTo()
function getResolveToMatches(matches, v7_relativeSplatPath) {
  let pathMatches = getPathContributingMatches(matches);
  // When v7_relativeSplatPath is enabled, use the full pathname for the leaf
  // match so we include splat values for "." links.  See:
  // https://github.com/remix-run/react-router/issues/11052#issuecomment-1836589329
  if (v7_relativeSplatPath) {
    return pathMatches.map((match, idx) => idx === pathMatches.length - 1 ? match.pathname : match.pathnameBase);
  }
  return pathMatches.map(match => match.pathnameBase);
}
/**
 * @private
 */
function resolveTo(toArg, routePathnames, locationPathname, isPathRelative) {
  if (isPathRelative === void 0) {
    isPathRelative = false;
  }
  let to;
  if (typeof toArg === "string") {
    to = parsePath(toArg);
  } else {
    to = _extends({}, toArg);
    invariant(!to.pathname || !to.pathname.includes("?"), getInvalidPathError("?", "pathname", "search", to));
    invariant(!to.pathname || !to.pathname.includes("#"), getInvalidPathError("#", "pathname", "hash", to));
    invariant(!to.search || !to.search.includes("#"), getInvalidPathError("#", "search", "hash", to));
  }
  let isEmptyPath = toArg === "" || to.pathname === "";
  let toPathname = isEmptyPath ? "/" : to.pathname;
  let from;
  // Routing is relative to the current pathname if explicitly requested.
  //
  // If a pathname is explicitly provided in `to`, it should be relative to the
  // route context. This is explained in `Note on `<Link to>` values` in our
  // migration guide from v5 as a means of disambiguation between `to` values
  // that begin with `/` and those that do not. However, this is problematic for
  // `to` values that do not provide a pathname. `to` can simply be a search or
  // hash string, in which case we should assume that the navigation is relative
  // to the current location's pathname and *not* the route pathname.
  if (toPathname == null) {
    from = locationPathname;
  } else {
    let routePathnameIndex = routePathnames.length - 1;
    // With relative="route" (the default), each leading .. segment means
    // "go up one route" instead of "go up one URL segment".  This is a key
    // difference from how <a href> works and a major reason we call this a
    // "to" value instead of a "href".
    if (!isPathRelative && toPathname.startsWith("..")) {
      let toSegments = toPathname.split("/");
      while (toSegments[0] === "..") {
        toSegments.shift();
        routePathnameIndex -= 1;
      }
      to.pathname = toSegments.join("/");
    }
    from = routePathnameIndex >= 0 ? routePathnames[routePathnameIndex] : "/";
  }
  let path = resolvePath(to, from);
  // Ensure the pathname has a trailing slash if the original "to" had one
  let hasExplicitTrailingSlash = toPathname && toPathname !== "/" && toPathname.endsWith("/");
  // Or if this was a link to the current path which has a trailing slash
  let hasCurrentTrailingSlash = (isEmptyPath || toPathname === ".") && locationPathname.endsWith("/");
  if (!path.pathname.endsWith("/") && (hasExplicitTrailingSlash || hasCurrentTrailingSlash)) {
    path.pathname += "/";
  }
  return path;
}
/**
 * @private
 */
function getToPathname(to) {
  // Empty strings should be treated the same as / paths
  return to === "" || to.pathname === "" ? "/" : typeof to === "string" ? parsePath(to).pathname : to.pathname;
}
/**
 * @private
 */
const joinPaths = paths => paths.join("/").replace(/\/\/+/g, "/");
/**
 * @private
 */
const normalizePathname = pathname => pathname.replace(/\/+$/, "").replace(/^\/*/, "/");
/**
 * @private
 */
const normalizeSearch = search => !search || search === "?" ? "" : search.startsWith("?") ? search : "?" + search;
/**
 * @private
 */
const normalizeHash = hash => !hash || hash === "#" ? "" : hash.startsWith("#") ? hash : "#" + hash;
/**
 * This is a shortcut for creating `application/json` responses. Converts `data`
 * to JSON and sets the `Content-Type` header.
 */
const json = function json(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  let headers = new Headers(responseInit.headers);
  if (!headers.has("Content-Type")) {
    headers.set("Content-Type", "application/json; charset=utf-8");
  }
  return new Response(JSON.stringify(data), _extends({}, responseInit, {
    headers
  }));
};
class DataWithResponseInit {
  constructor(data, init) {
    this.type = "DataWithResponseInit";
    this.data = data;
    this.init = init || null;
  }
}
/**
 * Create "responses" that contain `status`/`headers` without forcing
 * serialization into an actual `Response` - used by Remix single fetch
 */
function data(data, init) {
  return new DataWithResponseInit(data, typeof init === "number" ? {
    status: init
  } : init);
}
class AbortedDeferredError extends Error {}
class DeferredData {
  constructor(data, responseInit) {
    this.pendingKeysSet = new Set();
    this.subscribers = new Set();
    this.deferredKeys = [];
    invariant(data && typeof data === "object" && !Array.isArray(data), "defer() only accepts plain objects");
    // Set up an AbortController + Promise we can race against to exit early
    // cancellation
    let reject;
    this.abortPromise = new Promise((_, r) => reject = r);
    this.controller = new AbortController();
    let onAbort = () => reject(new AbortedDeferredError("Deferred data aborted"));
    this.unlistenAbortSignal = () => this.controller.signal.removeEventListener("abort", onAbort);
    this.controller.signal.addEventListener("abort", onAbort);
    this.data = Object.entries(data).reduce((acc, _ref2) => {
      let [key, value] = _ref2;
      return Object.assign(acc, {
        [key]: this.trackPromise(key, value)
      });
    }, {});
    if (this.done) {
      // All incoming values were resolved
      this.unlistenAbortSignal();
    }
    this.init = responseInit;
  }
  trackPromise(key, value) {
    if (!(value instanceof Promise)) {
      return value;
    }
    this.deferredKeys.push(key);
    this.pendingKeysSet.add(key);
    // We store a little wrapper promise that will be extended with
    // _data/_error props upon resolve/reject
    let promise = Promise.race([value, this.abortPromise]).then(data => this.onSettle(promise, key, undefined, data), error => this.onSettle(promise, key, error));
    // Register rejection listeners to avoid uncaught promise rejections on
    // errors or aborted deferred values
    promise.catch(() => {});
    Object.defineProperty(promise, "_tracked", {
      get: () => true
    });
    return promise;
  }
  onSettle(promise, key, error, data) {
    if (this.controller.signal.aborted && error instanceof AbortedDeferredError) {
      this.unlistenAbortSignal();
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      return Promise.reject(error);
    }
    this.pendingKeysSet.delete(key);
    if (this.done) {
      // Nothing left to abort!
      this.unlistenAbortSignal();
    }
    // If the promise was resolved/rejected with undefined, we'll throw an error as you
    // should always resolve with a value or null
    if (error === undefined && data === undefined) {
      let undefinedError = new Error("Deferred data for key \"" + key + "\" resolved/rejected with `undefined`, " + "you must resolve/reject with a value or `null`.");
      Object.defineProperty(promise, "_error", {
        get: () => undefinedError
      });
      this.emit(false, key);
      return Promise.reject(undefinedError);
    }
    if (data === undefined) {
      Object.defineProperty(promise, "_error", {
        get: () => error
      });
      this.emit(false, key);
      return Promise.reject(error);
    }
    Object.defineProperty(promise, "_data", {
      get: () => data
    });
    this.emit(false, key);
    return data;
  }
  emit(aborted, settledKey) {
    this.subscribers.forEach(subscriber => subscriber(aborted, settledKey));
  }
  subscribe(fn) {
    this.subscribers.add(fn);
    return () => this.subscribers.delete(fn);
  }
  cancel() {
    this.controller.abort();
    this.pendingKeysSet.forEach((v, k) => this.pendingKeysSet.delete(k));
    this.emit(true);
  }
  async resolveData(signal) {
    let aborted = false;
    if (!this.done) {
      let onAbort = () => this.cancel();
      signal.addEventListener("abort", onAbort);
      aborted = await new Promise(resolve => {
        this.subscribe(aborted => {
          signal.removeEventListener("abort", onAbort);
          if (aborted || this.done) {
            resolve(aborted);
          }
        });
      });
    }
    return aborted;
  }
  get done() {
    return this.pendingKeysSet.size === 0;
  }
  get unwrappedData() {
    invariant(this.data !== null && this.done, "Can only unwrap data on initialized and settled deferreds");
    return Object.entries(this.data).reduce((acc, _ref3) => {
      let [key, value] = _ref3;
      return Object.assign(acc, {
        [key]: unwrapTrackedPromise(value)
      });
    }, {});
  }
  get pendingKeys() {
    return Array.from(this.pendingKeysSet);
  }
}
function isTrackedPromise(value) {
  return value instanceof Promise && value._tracked === true;
}
function unwrapTrackedPromise(value) {
  if (!isTrackedPromise(value)) {
    return value;
  }
  if (value._error) {
    throw value._error;
  }
  return value._data;
}
const defer = function defer(data, init) {
  if (init === void 0) {
    init = {};
  }
  let responseInit = typeof init === "number" ? {
    status: init
  } : init;
  return new DeferredData(data, responseInit);
};
/**
 * A redirect response. Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirect = function redirect(url, init) {
  if (init === void 0) {
    init = 302;
  }
  let responseInit = init;
  if (typeof responseInit === "number") {
    responseInit = {
      status: responseInit
    };
  } else if (typeof responseInit.status === "undefined") {
    responseInit.status = 302;
  }
  let headers = new Headers(responseInit.headers);
  headers.set("Location", url);
  return new Response(null, _extends({}, responseInit, {
    headers
  }));
};
/**
 * A redirect response that will force a document reload to the new location.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const redirectDocument = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Reload-Document", "true");
  return response;
};
/**
 * A redirect response that will perform a `history.replaceState` instead of a
 * `history.pushState` for client-side navigation redirects.
 * Sets the status code and the `Location` header.
 * Defaults to "302 Found".
 */
const replace = (url, init) => {
  let response = redirect(url, init);
  response.headers.set("X-Remix-Replace", "true");
  return response;
};
/**
 * @private
 * Utility class we use to hold auto-unwrapped 4xx/5xx Response bodies
 *
 * We don't export the class for public use since it's an implementation
 * detail, but we export the interface above so folks can build their own
 * abstractions around instances via isRouteErrorResponse()
 */
class ErrorResponseImpl {
  constructor(status, statusText, data, internal) {
    if (internal === void 0) {
      internal = false;
    }
    this.status = status;
    this.statusText = statusText || "";
    this.internal = internal;
    if (data instanceof Error) {
      this.data = data.toString();
      this.error = data;
    } else {
      this.data = data;
    }
  }
}
/**
 * Check if the given error is an ErrorResponse generated from a 4xx/5xx
 * Response thrown from an action/loader
 */
function isRouteErrorResponse(error) {
  return error != null && typeof error.status === "number" && typeof error.statusText === "string" && typeof error.internal === "boolean" && "data" in error;
}

const validMutationMethodsArr = ["post", "put", "patch", "delete"];
const validMutationMethods = new Set(validMutationMethodsArr);
const validRequestMethodsArr = ["get", ...validMutationMethodsArr];
const validRequestMethods = new Set(validRequestMethodsArr);
const redirectStatusCodes = new Set([301, 302, 303, 307, 308]);
const redirectPreserveMethodStatusCodes = new Set([307, 308]);
const IDLE_NAVIGATION = {
  state: "idle",
  location: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_FETCHER = {
  state: "idle",
  data: undefined,
  formMethod: undefined,
  formAction: undefined,
  formEncType: undefined,
  formData: undefined,
  json: undefined,
  text: undefined
};
const IDLE_BLOCKER = {
  state: "unblocked",
  proceed: undefined,
  reset: undefined,
  location: undefined
};
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
const defaultMapRouteProperties = route => ({
  hasErrorBoundary: Boolean(route.hasErrorBoundary)
});
const TRANSITIONS_STORAGE_KEY = "remix-router-transitions";
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createRouter
////////////////////////////////////////////////////////////////////////////////
/**
 * Create a router and listen to history POP navigations
 */
function createRouter(init) {
  const routerWindow = init.window ? init.window : typeof window !== "undefined" ? window : undefined;
  const isBrowser = typeof routerWindow !== "undefined" && typeof routerWindow.document !== "undefined" && typeof routerWindow.document.createElement !== "undefined";
  const isServer = !isBrowser;
  invariant(init.routes.length > 0, "You must provide a non-empty routes array to createRouter");
  let mapRouteProperties;
  if (init.mapRouteProperties) {
    mapRouteProperties = init.mapRouteProperties;
  } else if (init.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = init.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Routes keyed by ID
  let manifest = {};
  // Routes in tree format for matching
  let dataRoutes = convertRoutesToDataRoutes(init.routes, mapRouteProperties, undefined, manifest);
  let inFlightDataRoutes;
  let basename = init.basename || "/";
  let dataStrategyImpl = init.unstable_dataStrategy || defaultDataStrategy;
  let patchRoutesOnNavigationImpl = init.unstable_patchRoutesOnNavigation;
  // Config driven behavior flags
  let future = _extends({
    v7_fetcherPersist: false,
    v7_normalizeFormMethod: false,
    v7_partialHydration: false,
    v7_prependBasename: false,
    v7_relativeSplatPath: false,
    v7_skipActionErrorRevalidation: false
  }, init.future);
  // Cleanup function for history
  let unlistenHistory = null;
  // Externally-provided functions to call on all state changes
  let subscribers = new Set();
  // FIFO queue of previously discovered routes to prevent re-calling on
  // subsequent navigations to the same path
  let discoveredRoutesMaxSize = 1000;
  let discoveredRoutes = new Set();
  // Externally-provided object to hold scroll restoration locations during routing
  let savedScrollPositions = null;
  // Externally-provided function to get scroll restoration keys
  let getScrollRestorationKey = null;
  // Externally-provided function to get current scroll position
  let getScrollPosition = null;
  // One-time flag to control the initial hydration scroll restoration.  Because
  // we don't get the saved positions from <ScrollRestoration /> until _after_
  // the initial render, we need to manually trigger a separate updateState to
  // send along the restoreScrollPosition
  // Set to true if we have `hydrationData` since we assume we were SSR'd and that
  // SSR did the initial scroll restoration.
  let initialScrollRestored = init.hydrationData != null;
  let initialMatches = matchRoutes(dataRoutes, init.history.location, basename);
  let initialErrors = null;
  if (initialMatches == null && !patchRoutesOnNavigationImpl) {
    // If we do not match a user-provided-route, fall back to the root
    // to allow the error boundary to take over
    let error = getInternalRouterError(404, {
      pathname: init.history.location.pathname
    });
    let {
      matches,
      route
    } = getShortCircuitMatches(dataRoutes);
    initialMatches = matches;
    initialErrors = {
      [route.id]: error
    };
  }
  // In SPA apps, if the user provided a patchRoutesOnNavigation implementation and
  // our initial match is a splat route, clear them out so we run through lazy
  // discovery on hydration in case there's a more accurate lazy route match.
  // In SSR apps (with `hydrationData`), we expect that the server will send
  // up the proper matched routes so we don't want to run lazy discovery on
  // initial hydration and want to hydrate into the splat route.
  if (initialMatches && !init.hydrationData) {
    let fogOfWar = checkFogOfWar(initialMatches, dataRoutes, init.history.location.pathname);
    if (fogOfWar.active) {
      initialMatches = null;
    }
  }
  let initialized;
  if (!initialMatches) {
    initialized = false;
    initialMatches = [];
    // If partial hydration and fog of war is enabled, we will be running
    // `patchRoutesOnNavigation` during hydration so include any partial matches as
    // the initial matches so we can properly render `HydrateFallback`'s
    if (future.v7_partialHydration) {
      let fogOfWar = checkFogOfWar(null, dataRoutes, init.history.location.pathname);
      if (fogOfWar.active && fogOfWar.matches) {
        initialMatches = fogOfWar.matches;
      }
    }
  } else if (initialMatches.some(m => m.route.lazy)) {
    // All initialMatches need to be loaded before we're ready.  If we have lazy
    // functions around still then we'll need to run them in initialize()
    initialized = false;
  } else if (!initialMatches.some(m => m.route.loader)) {
    // If we've got no loaders to run, then we're good to go
    initialized = true;
  } else if (future.v7_partialHydration) {
    // If partial hydration is enabled, we're initialized so long as we were
    // provided with hydrationData for every route with a loader, and no loaders
    // were marked for explicit hydration
    let loaderData = init.hydrationData ? init.hydrationData.loaderData : null;
    let errors = init.hydrationData ? init.hydrationData.errors : null;
    let isRouteInitialized = m => {
      // No loader, nothing to initialize
      if (!m.route.loader) {
        return true;
      }
      // Explicitly opting-in to running on hydration
      if (typeof m.route.loader === "function" && m.route.loader.hydrate === true) {
        return false;
      }
      // Otherwise, initialized if hydrated with data or an error
      return loaderData && loaderData[m.route.id] !== undefined || errors && errors[m.route.id] !== undefined;
    };
    // If errors exist, don't consider routes below the boundary
    if (errors) {
      let idx = initialMatches.findIndex(m => errors[m.route.id] !== undefined);
      initialized = initialMatches.slice(0, idx + 1).every(isRouteInitialized);
    } else {
      initialized = initialMatches.every(isRouteInitialized);
    }
  } else {
    // Without partial hydration - we're initialized if we were provided any
    // hydrationData - which is expected to be complete
    initialized = init.hydrationData != null;
  }
  let router;
  let state = {
    historyAction: init.history.action,
    location: init.history.location,
    matches: initialMatches,
    initialized,
    navigation: IDLE_NAVIGATION,
    // Don't restore on initial updateState() if we were SSR'd
    restoreScrollPosition: init.hydrationData != null ? false : null,
    preventScrollReset: false,
    revalidation: "idle",
    loaderData: init.hydrationData && init.hydrationData.loaderData || {},
    actionData: init.hydrationData && init.hydrationData.actionData || null,
    errors: init.hydrationData && init.hydrationData.errors || initialErrors,
    fetchers: new Map(),
    blockers: new Map()
  };
  // -- Stateful internal variables to manage navigations --
  // Current navigation in progress (to be committed in completeNavigation)
  let pendingAction = Action.Pop;
  // Should the current navigation prevent the scroll reset if scroll cannot
  // be restored?
  let pendingPreventScrollReset = false;
  // AbortController for the active navigation
  let pendingNavigationController;
  // Should the current navigation enable document.startViewTransition?
  let pendingViewTransitionEnabled = false;
  // Store applied view transitions so we can apply them on POP
  let appliedViewTransitions = new Map();
  // Cleanup function for persisting applied transitions to sessionStorage
  let removePageHideEventListener = null;
  // We use this to avoid touching history in completeNavigation if a
  // revalidation is entirely uninterrupted
  let isUninterruptedRevalidation = false;
  // Use this internal flag to force revalidation of all loaders:
  //  - submissions (completed or interrupted)
  //  - useRevalidator()
  //  - X-Remix-Revalidate (from redirect)
  let isRevalidationRequired = false;
  // Use this internal array to capture routes that require revalidation due
  // to a cancelled deferred on action submission
  let cancelledDeferredRoutes = [];
  // Use this internal array to capture fetcher loads that were cancelled by an
  // action navigation and require revalidation
  let cancelledFetcherLoads = new Set();
  // AbortControllers for any in-flight fetchers
  let fetchControllers = new Map();
  // Track loads based on the order in which they started
  let incrementingLoadId = 0;
  // Track the outstanding pending navigation data load to be compared against
  // the globally incrementing load when a fetcher load lands after a completed
  // navigation
  let pendingNavigationLoadId = -1;
  // Fetchers that triggered data reloads as a result of their actions
  let fetchReloadIds = new Map();
  // Fetchers that triggered redirect navigations
  let fetchRedirectIds = new Set();
  // Most recent href/match for fetcher.load calls for fetchers
  let fetchLoadMatches = new Map();
  // Ref-count mounted fetchers so we know when it's ok to clean them up
  let activeFetchers = new Map();
  // Fetchers that have requested a delete when using v7_fetcherPersist,
  // they'll be officially removed after they return to idle
  let deletedFetchers = new Set();
  // Store DeferredData instances for active route matches.  When a
  // route loader returns defer() we stick one in here.  Then, when a nested
  // promise resolves we update loaderData.  If a new navigation starts we
  // cancel active deferreds for eliminated routes.
  let activeDeferreds = new Map();
  // Store blocker functions in a separate Map outside of router state since
  // we don't need to update UI state if they change
  let blockerFunctions = new Map();
  // Map of pending patchRoutesOnNavigation() promises (keyed by path/matches) so
  // that we only kick them off once for a given combo
  let pendingPatchRoutes = new Map();
  // Flag to ignore the next history update, so we can revert the URL change on
  // a POP navigation that was blocked by the user without touching router state
  let unblockBlockerHistoryUpdate = undefined;
  // Initialize the router, all side effects should be kicked off from here.
  // Implemented as a Fluent API for ease of:
  //   let router = createRouter(init).initialize();
  function initialize() {
    // If history informs us of a POP navigation, start the navigation but do not update
    // state.  We'll update our own state once the navigation completes
    unlistenHistory = init.history.listen(_ref => {
      let {
        action: historyAction,
        location,
        delta
      } = _ref;
      // Ignore this event if it was just us resetting the URL from a
      // blocked POP navigation
      if (unblockBlockerHistoryUpdate) {
        unblockBlockerHistoryUpdate();
        unblockBlockerHistoryUpdate = undefined;
        return;
      }
      warning(blockerFunctions.size === 0 || delta != null, "You are trying to use a blocker on a POP navigation to a location " + "that was not created by @remix-run/router. This will fail silently in " + "production. This can happen if you are navigating outside the router " + "via `window.history.pushState`/`window.location.hash` instead of using " + "router navigation APIs.  This can also happen if you are using " + "createHashRouter and the user manually changes the URL.");
      let blockerKey = shouldBlockNavigation({
        currentLocation: state.location,
        nextLocation: location,
        historyAction
      });
      if (blockerKey && delta != null) {
        // Restore the URL to match the current UI, but don't update router state
        let nextHistoryUpdatePromise = new Promise(resolve => {
          unblockBlockerHistoryUpdate = resolve;
        });
        init.history.go(delta * -1);
        // Put the blocker into a blocked state
        updateBlocker(blockerKey, {
          state: "blocked",
          location,
          proceed() {
            updateBlocker(blockerKey, {
              state: "proceeding",
              proceed: undefined,
              reset: undefined,
              location
            });
            // Re-do the same POP navigation we just blocked, after the url
            // restoration is also complete.  See:
            // https://github.com/remix-run/react-router/issues/11613
            nextHistoryUpdatePromise.then(() => init.history.go(delta));
          },
          reset() {
            let blockers = new Map(state.blockers);
            blockers.set(blockerKey, IDLE_BLOCKER);
            updateState({
              blockers
            });
          }
        });
        return;
      }
      return startNavigation(historyAction, location);
    });
    if (isBrowser) {
      // FIXME: This feels gross.  How can we cleanup the lines between
      // scrollRestoration/appliedTransitions persistance?
      restoreAppliedTransitions(routerWindow, appliedViewTransitions);
      let _saveAppliedTransitions = () => persistAppliedTransitions(routerWindow, appliedViewTransitions);
      routerWindow.addEventListener("pagehide", _saveAppliedTransitions);
      removePageHideEventListener = () => routerWindow.removeEventListener("pagehide", _saveAppliedTransitions);
    }
    // Kick off initial data load if needed.  Use Pop to avoid modifying history
    // Note we don't do any handling of lazy here.  For SPA's it'll get handled
    // in the normal navigation flow.  For SSR it's expected that lazy modules are
    // resolved prior to router creation since we can't go into a fallbackElement
    // UI for SSR'd apps
    if (!state.initialized) {
      startNavigation(Action.Pop, state.location, {
        initialHydration: true
      });
    }
    return router;
  }
  // Clean up a router and it's side effects
  function dispose() {
    if (unlistenHistory) {
      unlistenHistory();
    }
    if (removePageHideEventListener) {
      removePageHideEventListener();
    }
    subscribers.clear();
    pendingNavigationController && pendingNavigationController.abort();
    state.fetchers.forEach((_, key) => deleteFetcher(key));
    state.blockers.forEach((_, key) => deleteBlocker(key));
  }
  // Subscribe to state updates for the router
  function subscribe(fn) {
    subscribers.add(fn);
    return () => subscribers.delete(fn);
  }
  // Update our state and notify the calling context of the change
  function updateState(newState, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state = _extends({}, state, newState);
    // Prep fetcher cleanup so we can tell the UI which fetcher data entries
    // can be removed
    let completedFetchers = [];
    let deletedFetchersKeys = [];
    if (future.v7_fetcherPersist) {
      state.fetchers.forEach((fetcher, key) => {
        if (fetcher.state === "idle") {
          if (deletedFetchers.has(key)) {
            // Unmounted from the UI and can be totally removed
            deletedFetchersKeys.push(key);
          } else {
            // Returned to idle but still mounted in the UI, so semi-remains for
            // revalidations and such
            completedFetchers.push(key);
          }
        }
      });
    }
    // Iterate over a local copy so that if flushSync is used and we end up
    // removing and adding a new subscriber due to the useCallback dependencies,
    // we don't get ourselves into a loop calling the new subscriber immediately
    [...subscribers].forEach(subscriber => subscriber(state, {
      deletedFetchers: deletedFetchersKeys,
      unstable_viewTransitionOpts: opts.viewTransitionOpts,
      unstable_flushSync: opts.flushSync === true
    }));
    // Remove idle fetchers from state since we only care about in-flight fetchers.
    if (future.v7_fetcherPersist) {
      completedFetchers.forEach(key => state.fetchers.delete(key));
      deletedFetchersKeys.forEach(key => deleteFetcher(key));
    }
  }
  // Complete a navigation returning the state.navigation back to the IDLE_NAVIGATION
  // and setting state.[historyAction/location/matches] to the new route.
  // - Location is a required param
  // - Navigation will always be set to IDLE_NAVIGATION
  // - Can pass any other state in newState
  function completeNavigation(location, newState, _temp) {
    var _location$state, _location$state2;
    let {
      flushSync
    } = _temp === void 0 ? {} : _temp;
    // Deduce if we're in a loading/actionReload state:
    // - We have committed actionData in the store
    // - The current navigation was a mutation submission
    // - We're past the submitting state and into the loading state
    // - The location being loaded is not the result of a redirect
    let isActionReload = state.actionData != null && state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && state.navigation.state === "loading" && ((_location$state = location.state) == null ? void 0 : _location$state._isRedirect) !== true;
    let actionData;
    if (newState.actionData) {
      if (Object.keys(newState.actionData).length > 0) {
        actionData = newState.actionData;
      } else {
        // Empty actionData -> clear prior actionData due to an action error
        actionData = null;
      }
    } else if (isActionReload) {
      // Keep the current data if we're wrapping up the action reload
      actionData = state.actionData;
    } else {
      // Clear actionData on any other completed navigations
      actionData = null;
    }
    // Always preserve any existing loaderData from re-used routes
    let loaderData = newState.loaderData ? mergeLoaderData(state.loaderData, newState.loaderData, newState.matches || [], newState.errors) : state.loaderData;
    // On a successful navigation we can assume we got through all blockers
    // so we can start fresh
    let blockers = state.blockers;
    if (blockers.size > 0) {
      blockers = new Map(blockers);
      blockers.forEach((_, k) => blockers.set(k, IDLE_BLOCKER));
    }
    // Always respect the user flag.  Otherwise don't reset on mutation
    // submission navigations unless they redirect
    let preventScrollReset = pendingPreventScrollReset === true || state.navigation.formMethod != null && isMutationMethod(state.navigation.formMethod) && ((_location$state2 = location.state) == null ? void 0 : _location$state2._isRedirect) !== true;
    // Commit any in-flight routes at the end of the HMR revalidation "navigation"
    if (inFlightDataRoutes) {
      dataRoutes = inFlightDataRoutes;
      inFlightDataRoutes = undefined;
    }
    if (isUninterruptedRevalidation) ; else if (pendingAction === Action.Pop) ; else if (pendingAction === Action.Push) {
      init.history.push(location, location.state);
    } else if (pendingAction === Action.Replace) {
      init.history.replace(location, location.state);
    }
    let viewTransitionOpts;
    // On POP, enable transitions if they were enabled on the original navigation
    if (pendingAction === Action.Pop) {
      // Forward takes precedence so they behave like the original navigation
      let priorPaths = appliedViewTransitions.get(state.location.pathname);
      if (priorPaths && priorPaths.has(location.pathname)) {
        viewTransitionOpts = {
          currentLocation: state.location,
          nextLocation: location
        };
      } else if (appliedViewTransitions.has(location.pathname)) {
        // If we don't have a previous forward nav, assume we're popping back to
        // the new location and enable if that location previously enabled
        viewTransitionOpts = {
          currentLocation: location,
          nextLocation: state.location
        };
      }
    } else if (pendingViewTransitionEnabled) {
      // Store the applied transition on PUSH/REPLACE
      let toPaths = appliedViewTransitions.get(state.location.pathname);
      if (toPaths) {
        toPaths.add(location.pathname);
      } else {
        toPaths = new Set([location.pathname]);
        appliedViewTransitions.set(state.location.pathname, toPaths);
      }
      viewTransitionOpts = {
        currentLocation: state.location,
        nextLocation: location
      };
    }
    updateState(_extends({}, newState, {
      actionData,
      loaderData,
      historyAction: pendingAction,
      location,
      initialized: true,
      navigation: IDLE_NAVIGATION,
      revalidation: "idle",
      restoreScrollPosition: getSavedScrollPosition(location, newState.matches || state.matches),
      preventScrollReset,
      blockers
    }), {
      viewTransitionOpts,
      flushSync: flushSync === true
    });
    // Reset stateful navigation vars
    pendingAction = Action.Pop;
    pendingPreventScrollReset = false;
    pendingViewTransitionEnabled = false;
    isUninterruptedRevalidation = false;
    isRevalidationRequired = false;
    cancelledDeferredRoutes = [];
  }
  // Trigger a navigation event, which can either be a numerical POP or a PUSH
  // replace with an optional submission
  async function navigate(to, opts) {
    if (typeof to === "number") {
      init.history.go(to);
      return;
    }
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, to, future.v7_relativeSplatPath, opts == null ? void 0 : opts.fromRouteId, opts == null ? void 0 : opts.relative);
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, false, normalizedPath, opts);
    let currentLocation = state.location;
    let nextLocation = createLocation(state.location, path, opts && opts.state);
    // When using navigate as a PUSH/REPLACE we aren't reading an already-encoded
    // URL from window.location, so we need to encode it here so the behavior
    // remains the same as POP and non-data-router usages.  new URL() does all
    // the same encoding we'd get from a history.pushState/window.location read
    // without having to touch history
    nextLocation = _extends({}, nextLocation, init.history.encodeLocation(nextLocation));
    let userReplace = opts && opts.replace != null ? opts.replace : undefined;
    let historyAction = Action.Push;
    if (userReplace === true) {
      historyAction = Action.Replace;
    } else if (userReplace === false) ; else if (submission != null && isMutationMethod(submission.formMethod) && submission.formAction === state.location.pathname + state.location.search) {
      // By default on submissions to the current location we REPLACE so that
      // users don't have to double-click the back button to get to the prior
      // location.  If the user redirects to a different location from the
      // action/loader this will be ignored and the redirect will be a PUSH
      historyAction = Action.Replace;
    }
    let preventScrollReset = opts && "preventScrollReset" in opts ? opts.preventScrollReset === true : undefined;
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let blockerKey = shouldBlockNavigation({
      currentLocation,
      nextLocation,
      historyAction
    });
    if (blockerKey) {
      // Put the blocker into a blocked state
      updateBlocker(blockerKey, {
        state: "blocked",
        location: nextLocation,
        proceed() {
          updateBlocker(blockerKey, {
            state: "proceeding",
            proceed: undefined,
            reset: undefined,
            location: nextLocation
          });
          // Send the same navigation through
          navigate(to, opts);
        },
        reset() {
          let blockers = new Map(state.blockers);
          blockers.set(blockerKey, IDLE_BLOCKER);
          updateState({
            blockers
          });
        }
      });
      return;
    }
    return await startNavigation(historyAction, nextLocation, {
      submission,
      // Send through the formData serialization error if we have one so we can
      // render at the right error boundary after we match routes
      pendingError: error,
      preventScrollReset,
      replace: opts && opts.replace,
      enableViewTransition: opts && opts.unstable_viewTransition,
      flushSync
    });
  }
  // Revalidate all current loaders.  If a navigation is in progress or if this
  // is interrupted by a navigation, allow this to "succeed" by calling all
  // loaders during the next loader round
  function revalidate() {
    interruptActiveLoads();
    updateState({
      revalidation: "loading"
    });
    // If we're currently submitting an action, we don't need to start a new
    // navigation, we'll just let the follow up loader execution call all loaders
    if (state.navigation.state === "submitting") {
      return;
    }
    // If we're currently in an idle state, start a new navigation for the current
    // action/location and mark it as uninterrupted, which will skip the history
    // update in completeNavigation
    if (state.navigation.state === "idle") {
      startNavigation(state.historyAction, state.location, {
        startUninterruptedRevalidation: true
      });
      return;
    }
    // Otherwise, if we're currently in a loading state, just start a new
    // navigation to the navigation.location but do not trigger an uninterrupted
    // revalidation so that history correctly updates once the navigation completes
    startNavigation(pendingAction || state.historyAction, state.navigation.location, {
      overrideNavigation: state.navigation,
      // Proxy through any rending view transition
      enableViewTransition: pendingViewTransitionEnabled === true
    });
  }
  // Start a navigation to the given action/location.  Can optionally provide a
  // overrideNavigation which will override the normalLoad in the case of a redirect
  // navigation
  async function startNavigation(historyAction, location, opts) {
    // Abort any in-progress navigations and start a new one. Unset any ongoing
    // uninterrupted revalidations unless told otherwise, since we want this
    // new navigation to update history normally
    pendingNavigationController && pendingNavigationController.abort();
    pendingNavigationController = null;
    pendingAction = historyAction;
    isUninterruptedRevalidation = (opts && opts.startUninterruptedRevalidation) === true;
    // Save the current scroll position every time we start a new navigation,
    // and track whether we should reset scroll on completion
    saveScrollPosition(state.location, state.matches);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    pendingViewTransitionEnabled = (opts && opts.enableViewTransition) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let loadingNavigation = opts && opts.overrideNavigation;
    let matches = matchRoutes(routesToUse, location, basename);
    let flushSync = (opts && opts.flushSync) === true;
    let fogOfWar = checkFogOfWar(matches, routesToUse, location.pathname);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    // Short circuit with a 404 on the root error boundary if we match nothing
    if (!matches) {
      let {
        error,
        notFoundMatches,
        route
      } = handleNavigational404(location.pathname);
      completeNavigation(location, {
        matches: notFoundMatches,
        loaderData: {},
        errors: {
          [route.id]: error
        }
      }, {
        flushSync
      });
      return;
    }
    // Short circuit if it's only a hash change and not a revalidation or
    // mutation submission.
    //
    // Ignore on initial page loads because since the initial load will always
    // be "same hash".  For example, on /page#hash and submit a <Form method="post">
    // which will default to a navigation to /page
    if (state.initialized && !isRevalidationRequired && isHashChangeOnly(state.location, location) && !(opts && opts.submission && isMutationMethod(opts.submission.formMethod))) {
      completeNavigation(location, {
        matches
      }, {
        flushSync
      });
      return;
    }
    // Create a controller/Request for this navigation
    pendingNavigationController = new AbortController();
    let request = createClientSideRequest(init.history, location, pendingNavigationController.signal, opts && opts.submission);
    let pendingActionResult;
    if (opts && opts.pendingError) {
      // If we have a pendingError, it means the user attempted a GET submission
      // with binary FormData so assign here and skip to handleLoaders.  That
      // way we handle calling loaders above the boundary etc.  It's not really
      // different from an actionError in that sense.
      pendingActionResult = [findNearestBoundary(matches).route.id, {
        type: ResultType.error,
        error: opts.pendingError
      }];
    } else if (opts && opts.submission && isMutationMethod(opts.submission.formMethod)) {
      // Call action if we received an action submission
      let actionResult = await handleAction(request, location, opts.submission, matches, fogOfWar.active, {
        replace: opts.replace,
        flushSync
      });
      if (actionResult.shortCircuited) {
        return;
      }
      // If we received a 404 from handleAction, it's because we couldn't lazily
      // discover the destination route so we don't want to call loaders
      if (actionResult.pendingActionResult) {
        let [routeId, result] = actionResult.pendingActionResult;
        if (isErrorResult(result) && isRouteErrorResponse(result.error) && result.error.status === 404) {
          pendingNavigationController = null;
          completeNavigation(location, {
            matches: actionResult.matches,
            loaderData: {},
            errors: {
              [routeId]: result.error
            }
          });
          return;
        }
      }
      matches = actionResult.matches || matches;
      pendingActionResult = actionResult.pendingActionResult;
      loadingNavigation = getLoadingNavigation(location, opts.submission);
      flushSync = false;
      // No need to do fog of war matching again on loader execution
      fogOfWar.active = false;
      // Create a GET request for the loaders
      request = createClientSideRequest(init.history, request.url, request.signal);
    }
    // Call loaders
    let {
      shortCircuited,
      matches: updatedMatches,
      loaderData,
      errors
    } = await handleLoaders(request, location, matches, fogOfWar.active, loadingNavigation, opts && opts.submission, opts && opts.fetcherSubmission, opts && opts.replace, opts && opts.initialHydration === true, flushSync, pendingActionResult);
    if (shortCircuited) {
      return;
    }
    // Clean up now that the action/loaders have completed.  Don't clean up if
    // we short circuited because pendingNavigationController will have already
    // been assigned to a new controller for the next navigation
    pendingNavigationController = null;
    completeNavigation(location, _extends({
      matches: updatedMatches || matches
    }, getActionDataForCommit(pendingActionResult), {
      loaderData,
      errors
    }));
  }
  // Call the action matched by the leaf route for this navigation and handle
  // redirects/errors
  async function handleAction(request, location, submission, matches, isFogOfWar, opts) {
    if (opts === void 0) {
      opts = {};
    }
    interruptActiveLoads();
    // Put us in a submitting state
    let navigation = getSubmittingNavigation(location, submission);
    updateState({
      navigation
    }, {
      flushSync: opts.flushSync === true
    });
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let {
          boundaryId,
          error
        } = handleDiscoverRouteError(location.pathname, discoverResult);
        return {
          matches: discoverResult.partialMatches,
          pendingActionResult: [boundaryId, {
            type: ResultType.error,
            error
          }]
        };
      } else if (!discoverResult.matches) {
        let {
          notFoundMatches,
          error,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          pendingActionResult: [route.id, {
            type: ResultType.error,
            error
          }]
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    // Call our action and get the result
    let result;
    let actionMatch = getTargetMatch(matches, location);
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      result = {
        type: ResultType.error,
        error: getInternalRouterError(405, {
          method: request.method,
          pathname: location.pathname,
          routeId: actionMatch.route.id
        })
      };
    } else {
      let results = await callDataStrategy("action", state, request, [actionMatch], matches, null);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        return {
          shortCircuited: true
        };
      }
    }
    if (isRedirectResult(result)) {
      let replace;
      if (opts && opts.replace != null) {
        replace = opts.replace;
      } else {
        // If the user didn't explicity indicate replace behavior, replace if
        // we redirected to the exact same location we're currently at to avoid
        // double back-buttons
        let location = normalizeRedirectLocation(result.response.headers.get("Location"), new URL(request.url), basename);
        replace = location === state.location.pathname + state.location.search;
      }
      await startRedirectNavigation(request, result, true, {
        submission,
        replace
      });
      return {
        shortCircuited: true
      };
    }
    if (isDeferredResult(result)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = findNearestBoundary(matches, actionMatch.route.id);
      // By default, all submissions to the current location are REPLACE
      // navigations, but if the action threw an error that'll be rendered in
      // an errorElement, we fall back to PUSH so that the user can use the
      // back button to get back to the pre-submission form location to try
      // again
      if ((opts && opts.replace) !== true) {
        pendingAction = Action.Push;
      }
      return {
        matches,
        pendingActionResult: [boundaryMatch.route.id, result]
      };
    }
    return {
      matches,
      pendingActionResult: [actionMatch.route.id, result]
    };
  }
  // Call all applicable loaders for the given matches, handling redirects,
  // errors, etc.
  async function handleLoaders(request, location, matches, isFogOfWar, overrideNavigation, submission, fetcherSubmission, replace, initialHydration, flushSync, pendingActionResult) {
    // Figure out the right navigation we want to use for data loading
    let loadingNavigation = overrideNavigation || getLoadingNavigation(location, submission);
    // If this was a redirect from an action we don't have a "submission" but
    // we have it on the loading navigation so use that if available
    let activeSubmission = submission || fetcherSubmission || getSubmissionFromNavigation(loadingNavigation);
    // If this is an uninterrupted revalidation, we remain in our current idle
    // state.  If not, we need to switch to our loading state and load data,
    // preserving any new action data or existing action data (in the case of
    // a revalidation interrupting an actionReload)
    // If we have partialHydration enabled, then don't update the state for the
    // initial data load since it's not a "navigation"
    let shouldUpdateNavigationState = !isUninterruptedRevalidation && (!future.v7_partialHydration || !initialHydration);
    // When fog of war is enabled, we enter our `loading` state earlier so we
    // can discover new routes during the `loading` state.  We skip this if
    // we've already run actions since we would have done our matching already.
    // If the children() function threw then, we want to proceed with the
    // partial matches it discovered.
    if (isFogOfWar) {
      if (shouldUpdateNavigationState) {
        let actionData = getUpdatedActionData(pendingActionResult);
        updateState(_extends({
          navigation: loadingNavigation
        }, actionData !== undefined ? {
          actionData
        } : {}), {
          flushSync
        });
      }
      let discoverResult = await discoverRoutes(matches, location.pathname, request.signal);
      if (discoverResult.type === "aborted") {
        return {
          shortCircuited: true
        };
      } else if (discoverResult.type === "error") {
        let {
          boundaryId,
          error
        } = handleDiscoverRouteError(location.pathname, discoverResult);
        return {
          matches: discoverResult.partialMatches,
          loaderData: {},
          errors: {
            [boundaryId]: error
          }
        };
      } else if (!discoverResult.matches) {
        let {
          error,
          notFoundMatches,
          route
        } = handleNavigational404(location.pathname);
        return {
          matches: notFoundMatches,
          loaderData: {},
          errors: {
            [route.id]: error
          }
        };
      } else {
        matches = discoverResult.matches;
      }
    }
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, activeSubmission, location, future.v7_partialHydration && initialHydration === true, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult);
    // Cancel pending deferreds for no-longer-matched routes or routes we're
    // about to reload.  Note that if this is an action reload we would have
    // already cancelled all pending deferreds so this would be a no-op
    cancelActiveDeferreds(routeId => !(matches && matches.some(m => m.route.id === routeId)) || matchesToLoad && matchesToLoad.some(m => m.route.id === routeId));
    pendingNavigationLoadId = ++incrementingLoadId;
    // Short circuit if we have no loaders to run
    if (matchesToLoad.length === 0 && revalidatingFetchers.length === 0) {
      let updatedFetchers = markFetchRedirectsDone();
      completeNavigation(location, _extends({
        matches,
        loaderData: {},
        // Commit pending error if we're short circuiting
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null
      }, getActionDataForCommit(pendingActionResult), updatedFetchers ? {
        fetchers: new Map(state.fetchers)
      } : {}), {
        flushSync
      });
      return {
        shortCircuited: true
      };
    }
    if (shouldUpdateNavigationState) {
      let updates = {};
      if (!isFogOfWar) {
        // Only update navigation/actionNData if we didn't already do it above
        updates.navigation = loadingNavigation;
        let actionData = getUpdatedActionData(pendingActionResult);
        if (actionData !== undefined) {
          updates.actionData = actionData;
        }
      }
      if (revalidatingFetchers.length > 0) {
        updates.fetchers = getUpdatedRevalidatingFetchers(revalidatingFetchers);
      }
      updateState(updates, {
        flushSync
      });
    }
    revalidatingFetchers.forEach(rf => {
      if (fetchControllers.has(rf.key)) {
        abortFetcher(rf.key);
      }
      if (rf.controller) {
        // Fetchers use an independent AbortController so that aborting a fetcher
        // (via deleteFetcher) does not abort the triggering navigation that
        // triggered the revalidation
        fetchControllers.set(rf.key, rf.controller);
      }
    });
    // Proxy navigation abort through to revalidation fetchers
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(f => abortFetcher(f.key));
    if (pendingNavigationController) {
      pendingNavigationController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    }
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, request);
    if (request.signal.aborted) {
      return {
        shortCircuited: true
      };
    }
    // Clean up _after_ loaders have completed.  Don't clean up if we short
    // circuited because fetchControllers would have been aborted and
    // reassigned to new controllers for the next navigation
    if (pendingNavigationController) {
      pendingNavigationController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    }
    revalidatingFetchers.forEach(rf => fetchControllers.delete(rf.key));
    // If any loaders returned a redirect Response, start a new REPLACE navigation
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      await startRedirectNavigation(request, redirect.result, true, {
        replace
      });
      return {
        shortCircuited: true
      };
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, matchesToLoad, loaderResults, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Wire up subscribers to update loaderData as promises settle
    activeDeferreds.forEach((deferredData, routeId) => {
      deferredData.subscribe(aborted => {
        // Note: No need to updateState here since the TrackedPromise on
        // loaderData is stable across resolve/reject
        // Remove this instance if we were aborted or if promises have settled
        if (aborted || deferredData.done) {
          activeDeferreds.delete(routeId);
        }
      });
    });
    // During partial hydration, preserve SSR errors for routes that don't re-run
    if (future.v7_partialHydration && initialHydration && state.errors) {
      Object.entries(state.errors).filter(_ref2 => {
        let [id] = _ref2;
        return !matchesToLoad.some(m => m.route.id === id);
      }).forEach(_ref3 => {
        let [routeId, error] = _ref3;
        errors = Object.assign(errors || {}, {
          [routeId]: error
        });
      });
    }
    let updatedFetchers = markFetchRedirectsDone();
    let didAbortFetchLoads = abortStaleFetchLoads(pendingNavigationLoadId);
    let shouldUpdateFetchers = updatedFetchers || didAbortFetchLoads || revalidatingFetchers.length > 0;
    return _extends({
      matches,
      loaderData,
      errors
    }, shouldUpdateFetchers ? {
      fetchers: new Map(state.fetchers)
    } : {});
  }
  function getUpdatedActionData(pendingActionResult) {
    if (pendingActionResult && !isErrorResult(pendingActionResult[1])) {
      // This is cast to `any` currently because `RouteData`uses any and it
      // would be a breaking change to use any.
      // TODO: v7 - change `RouteData` to use `unknown` instead of `any`
      return {
        [pendingActionResult[0]]: pendingActionResult[1].data
      };
    } else if (state.actionData) {
      if (Object.keys(state.actionData).length === 0) {
        return null;
      } else {
        return state.actionData;
      }
    }
  }
  function getUpdatedRevalidatingFetchers(revalidatingFetchers) {
    revalidatingFetchers.forEach(rf => {
      let fetcher = state.fetchers.get(rf.key);
      let revalidatingFetcher = getLoadingFetcher(undefined, fetcher ? fetcher.data : undefined);
      state.fetchers.set(rf.key, revalidatingFetcher);
    });
    return new Map(state.fetchers);
  }
  // Trigger a fetcher load/submit for the given fetcher key
  function fetch(key, routeId, href, opts) {
    if (isServer) {
      throw new Error("router.fetch() was called during the server render, but it shouldn't be. " + "You are likely calling a useFetcher() method in the body of your component. " + "Try moving it to a useEffect or a callback.");
    }
    if (fetchControllers.has(key)) abortFetcher(key);
    let flushSync = (opts && opts.unstable_flushSync) === true;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let normalizedPath = normalizeTo(state.location, state.matches, basename, future.v7_prependBasename, href, future.v7_relativeSplatPath, routeId, opts == null ? void 0 : opts.relative);
    let matches = matchRoutes(routesToUse, normalizedPath, basename);
    let fogOfWar = checkFogOfWar(matches, routesToUse, normalizedPath);
    if (fogOfWar.active && fogOfWar.matches) {
      matches = fogOfWar.matches;
    }
    if (!matches) {
      setFetcherError(key, routeId, getInternalRouterError(404, {
        pathname: normalizedPath
      }), {
        flushSync
      });
      return;
    }
    let {
      path,
      submission,
      error
    } = normalizeNavigateOptions(future.v7_normalizeFormMethod, true, normalizedPath, opts);
    if (error) {
      setFetcherError(key, routeId, error, {
        flushSync
      });
      return;
    }
    let match = getTargetMatch(matches, path);
    pendingPreventScrollReset = (opts && opts.preventScrollReset) === true;
    if (submission && isMutationMethod(submission.formMethod)) {
      handleFetcherAction(key, routeId, path, match, matches, fogOfWar.active, flushSync, submission);
      return;
    }
    // Store off the match so we can call it's shouldRevalidate on subsequent
    // revalidations
    fetchLoadMatches.set(key, {
      routeId,
      path
    });
    handleFetcherLoader(key, routeId, path, match, matches, fogOfWar.active, flushSync, submission);
  }
  // Call the action for the matched fetcher.submit(), and then handle redirects,
  // errors, and revalidation
  async function handleFetcherAction(key, routeId, path, match, requestMatches, isFogOfWar, flushSync, submission) {
    interruptActiveLoads();
    fetchLoadMatches.delete(key);
    function detectAndHandle405Error(m) {
      if (!m.route.action && !m.route.lazy) {
        let error = getInternalRouterError(405, {
          method: submission.formMethod,
          pathname: path,
          routeId: routeId
        });
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return true;
      }
      return false;
    }
    if (!isFogOfWar && detectAndHandle405Error(match)) {
      return;
    }
    // Put this fetcher into it's submitting state
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getSubmittingFetcher(submission, existingFetcher), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal, submission);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(requestMatches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        let {
          error
        } = handleDiscoverRouteError(path, discoverResult);
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        requestMatches = discoverResult.matches;
        match = getTargetMatch(requestMatches, path);
        if (detectAndHandle405Error(match)) {
          return;
        }
      }
    }
    // Call the action for the fetcher
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let actionResults = await callDataStrategy("action", state, fetchRequest, [match], requestMatches, key);
    let actionResult = actionResults[match.route.id];
    if (fetchRequest.signal.aborted) {
      // We can delete this so long as we weren't aborted by our own fetcher
      // re-submit which would have put _new_ controller is in fetchControllers
      if (fetchControllers.get(key) === abortController) {
        fetchControllers.delete(key);
      }
      return;
    }
    // When using v7_fetcherPersist, we don't want errors bubbling up to the UI
    // or redirects processed for unmounted fetchers so we just revert them to
    // idle
    if (future.v7_fetcherPersist && deletedFetchers.has(key)) {
      if (isRedirectResult(actionResult) || isErrorResult(actionResult)) {
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      }
      // Let SuccessResult's fall through for revalidation
    } else {
      if (isRedirectResult(actionResult)) {
        fetchControllers.delete(key);
        if (pendingNavigationLoadId > originatingLoadId) {
          // A new navigation was kicked off after our action started, so that
          // should take precedence over this redirect navigation.  We already
          // set isRevalidationRequired so all loaders for the new route should
          // fire unless opted out via shouldRevalidate
          updateFetcherState(key, getDoneFetcher(undefined));
          return;
        } else {
          fetchRedirectIds.add(key);
          updateFetcherState(key, getLoadingFetcher(submission));
          return startRedirectNavigation(fetchRequest, actionResult, false, {
            fetcherSubmission: submission
          });
        }
      }
      // Process any non-redirect errors thrown
      if (isErrorResult(actionResult)) {
        setFetcherError(key, routeId, actionResult.error);
        return;
      }
    }
    if (isDeferredResult(actionResult)) {
      throw getInternalRouterError(400, {
        type: "defer-action"
      });
    }
    // Start the data load for current matches, or the next location if we're
    // in the middle of a navigation
    let nextLocation = state.navigation.location || state.location;
    let revalidationRequest = createClientSideRequest(init.history, nextLocation, abortController.signal);
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let matches = state.navigation.state !== "idle" ? matchRoutes(routesToUse, state.navigation.location, basename) : state.matches;
    invariant(matches, "Didn't find any matches after fetcher action");
    let loadId = ++incrementingLoadId;
    fetchReloadIds.set(key, loadId);
    let loadFetcher = getLoadingFetcher(submission, actionResult.data);
    state.fetchers.set(key, loadFetcher);
    let [matchesToLoad, revalidatingFetchers] = getMatchesToLoad(init.history, state, matches, submission, nextLocation, false, future.v7_skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, [match.route.id, actionResult]);
    // Put all revalidating fetchers into the loading state, except for the
    // current fetcher which we want to keep in it's current loading state which
    // contains it's action submission info + action data
    revalidatingFetchers.filter(rf => rf.key !== key).forEach(rf => {
      let staleKey = rf.key;
      let existingFetcher = state.fetchers.get(staleKey);
      let revalidatingFetcher = getLoadingFetcher(undefined, existingFetcher ? existingFetcher.data : undefined);
      state.fetchers.set(staleKey, revalidatingFetcher);
      if (fetchControllers.has(staleKey)) {
        abortFetcher(staleKey);
      }
      if (rf.controller) {
        fetchControllers.set(staleKey, rf.controller);
      }
    });
    updateState({
      fetchers: new Map(state.fetchers)
    });
    let abortPendingFetchRevalidations = () => revalidatingFetchers.forEach(rf => abortFetcher(rf.key));
    abortController.signal.addEventListener("abort", abortPendingFetchRevalidations);
    let {
      loaderResults,
      fetcherResults
    } = await callLoadersAndMaybeResolveData(state, matches, matchesToLoad, revalidatingFetchers, revalidationRequest);
    if (abortController.signal.aborted) {
      return;
    }
    abortController.signal.removeEventListener("abort", abortPendingFetchRevalidations);
    fetchReloadIds.delete(key);
    fetchControllers.delete(key);
    revalidatingFetchers.forEach(r => fetchControllers.delete(r.key));
    let redirect = findRedirect(loaderResults);
    if (redirect) {
      return startRedirectNavigation(revalidationRequest, redirect.result, false);
    }
    redirect = findRedirect(fetcherResults);
    if (redirect) {
      // If this redirect came from a fetcher make sure we mark it in
      // fetchRedirectIds so it doesn't get revalidated on the next set of
      // loader executions
      fetchRedirectIds.add(redirect.key);
      return startRedirectNavigation(revalidationRequest, redirect.result, false);
    }
    // Process and commit output from loaders
    let {
      loaderData,
      errors
    } = processLoaderData(state, matches, matchesToLoad, loaderResults, undefined, revalidatingFetchers, fetcherResults, activeDeferreds);
    // Since we let revalidations complete even if the submitting fetcher was
    // deleted, only put it back to idle if it hasn't been deleted
    if (state.fetchers.has(key)) {
      let doneFetcher = getDoneFetcher(actionResult.data);
      state.fetchers.set(key, doneFetcher);
    }
    abortStaleFetchLoads(loadId);
    // If we are currently in a navigation loading state and this fetcher is
    // more recent than the navigation, we want the newer data so abort the
    // navigation and complete it with the fetcher data
    if (state.navigation.state === "loading" && loadId > pendingNavigationLoadId) {
      invariant(pendingAction, "Expected pending action");
      pendingNavigationController && pendingNavigationController.abort();
      completeNavigation(state.navigation.location, {
        matches,
        loaderData,
        errors,
        fetchers: new Map(state.fetchers)
      });
    } else {
      // otherwise just update with the fetcher data, preserving any existing
      // loaderData for loaders that did not need to reload.  We have to
      // manually merge here since we aren't going through completeNavigation
      updateState({
        errors,
        loaderData: mergeLoaderData(state.loaderData, loaderData, matches, errors),
        fetchers: new Map(state.fetchers)
      });
      isRevalidationRequired = false;
    }
  }
  // Call the matched loader for fetcher.load(), handling redirects, errors, etc.
  async function handleFetcherLoader(key, routeId, path, match, matches, isFogOfWar, flushSync, submission) {
    let existingFetcher = state.fetchers.get(key);
    updateFetcherState(key, getLoadingFetcher(submission, existingFetcher ? existingFetcher.data : undefined), {
      flushSync
    });
    let abortController = new AbortController();
    let fetchRequest = createClientSideRequest(init.history, path, abortController.signal);
    if (isFogOfWar) {
      let discoverResult = await discoverRoutes(matches, path, fetchRequest.signal);
      if (discoverResult.type === "aborted") {
        return;
      } else if (discoverResult.type === "error") {
        let {
          error
        } = handleDiscoverRouteError(path, discoverResult);
        setFetcherError(key, routeId, error, {
          flushSync
        });
        return;
      } else if (!discoverResult.matches) {
        setFetcherError(key, routeId, getInternalRouterError(404, {
          pathname: path
        }), {
          flushSync
        });
        return;
      } else {
        matches = discoverResult.matches;
        match = getTargetMatch(matches, path);
      }
    }
    // Call the loader for this fetcher route match
    fetchControllers.set(key, abortController);
    let originatingLoadId = incrementingLoadId;
    let results = await callDataStrategy("loader", state, fetchRequest, [match], matches, key);
    let result = results[match.route.id];
    // Deferred isn't supported for fetcher loads, await everything and treat it
    // as a normal load.  resolveDeferredData will return undefined if this
    // fetcher gets aborted, so we just leave result untouched and short circuit
    // below if that happens
    if (isDeferredResult(result)) {
      result = (await resolveDeferredData(result, fetchRequest.signal, true)) || result;
    }
    // We can delete this so long as we weren't aborted by our our own fetcher
    // re-load which would have put _new_ controller is in fetchControllers
    if (fetchControllers.get(key) === abortController) {
      fetchControllers.delete(key);
    }
    if (fetchRequest.signal.aborted) {
      return;
    }
    // We don't want errors bubbling up or redirects followed for unmounted
    // fetchers, so short circuit here if it was removed from the UI
    if (deletedFetchers.has(key)) {
      updateFetcherState(key, getDoneFetcher(undefined));
      return;
    }
    // If the loader threw a redirect Response, start a new REPLACE navigation
    if (isRedirectResult(result)) {
      if (pendingNavigationLoadId > originatingLoadId) {
        // A new navigation was kicked off after our loader started, so that
        // should take precedence over this redirect navigation
        updateFetcherState(key, getDoneFetcher(undefined));
        return;
      } else {
        fetchRedirectIds.add(key);
        await startRedirectNavigation(fetchRequest, result, false);
        return;
      }
    }
    // Process any non-redirect errors thrown
    if (isErrorResult(result)) {
      setFetcherError(key, routeId, result.error);
      return;
    }
    invariant(!isDeferredResult(result), "Unhandled fetcher deferred data");
    // Put the fetcher back into an idle state
    updateFetcherState(key, getDoneFetcher(result.data));
  }
  /**
   * Utility function to handle redirects returned from an action or loader.
   * Normally, a redirect "replaces" the navigation that triggered it.  So, for
   * example:
   *
   *  - user is on /a
   *  - user clicks a link to /b
   *  - loader for /b redirects to /c
   *
   * In a non-JS app the browser would track the in-flight navigation to /b and
   * then replace it with /c when it encountered the redirect response.  In
   * the end it would only ever update the URL bar with /c.
   *
   * In client-side routing using pushState/replaceState, we aim to emulate
   * this behavior and we also do not update history until the end of the
   * navigation (including processed redirects).  This means that we never
   * actually touch history until we've processed redirects, so we just use
   * the history action from the original navigation (PUSH or REPLACE).
   */
  async function startRedirectNavigation(request, redirect, isNavigation, _temp2) {
    let {
      submission,
      fetcherSubmission,
      replace
    } = _temp2 === void 0 ? {} : _temp2;
    if (redirect.response.headers.has("X-Remix-Revalidate")) {
      isRevalidationRequired = true;
    }
    let location = redirect.response.headers.get("Location");
    invariant(location, "Expected a Location header on the redirect Response");
    location = normalizeRedirectLocation(location, new URL(request.url), basename);
    let redirectLocation = createLocation(state.location, location, {
      _isRedirect: true
    });
    if (isBrowser) {
      let isDocumentReload = false;
      if (redirect.response.headers.has("X-Remix-Reload-Document")) {
        // Hard reload if the response contained X-Remix-Reload-Document
        isDocumentReload = true;
      } else if (ABSOLUTE_URL_REGEX.test(location)) {
        const url = init.history.createURL(location);
        isDocumentReload =
        // Hard reload if it's an absolute URL to a new origin
        url.origin !== routerWindow.location.origin ||
        // Hard reload if it's an absolute URL that does not match our basename
        stripBasename(url.pathname, basename) == null;
      }
      if (isDocumentReload) {
        if (replace) {
          routerWindow.location.replace(location);
        } else {
          routerWindow.location.assign(location);
        }
        return;
      }
    }
    // There's no need to abort on redirects, since we don't detect the
    // redirect until the action/loaders have settled
    pendingNavigationController = null;
    let redirectHistoryAction = replace === true || redirect.response.headers.has("X-Remix-Replace") ? Action.Replace : Action.Push;
    // Use the incoming submission if provided, fallback on the active one in
    // state.navigation
    let {
      formMethod,
      formAction,
      formEncType
    } = state.navigation;
    if (!submission && !fetcherSubmission && formMethod && formAction && formEncType) {
      submission = getSubmissionFromNavigation(state.navigation);
    }
    // If this was a 307/308 submission we want to preserve the HTTP method and
    // re-submit the GET/POST/PUT/PATCH/DELETE as a submission navigation to the
    // redirected location
    let activeSubmission = submission || fetcherSubmission;
    if (redirectPreserveMethodStatusCodes.has(redirect.response.status) && activeSubmission && isMutationMethod(activeSubmission.formMethod)) {
      await startNavigation(redirectHistoryAction, redirectLocation, {
        submission: _extends({}, activeSubmission, {
          formAction: location
        }),
        // Preserve these flags across redirects
        preventScrollReset: pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    } else {
      // If we have a navigation submission, we will preserve it through the
      // redirect navigation
      let overrideNavigation = getLoadingNavigation(redirectLocation, submission);
      await startNavigation(redirectHistoryAction, redirectLocation, {
        overrideNavigation,
        // Send fetcher submissions through for shouldRevalidate
        fetcherSubmission,
        // Preserve these flags across redirects
        preventScrollReset: pendingPreventScrollReset,
        enableViewTransition: isNavigation ? pendingViewTransitionEnabled : undefined
      });
    }
  }
  // Utility wrapper for calling dataStrategy client-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, state, request, matchesToLoad, matches, fetcherKey) {
    let results;
    let dataResults = {};
    try {
      results = await callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties);
    } catch (e) {
      // If the outer dataStrategy method throws, just return the error for all
      // matches - and it'll naturally bubble to the root
      matchesToLoad.forEach(m => {
        dataResults[m.route.id] = {
          type: ResultType.error,
          error: e
        };
      });
      return dataResults;
    }
    for (let [routeId, result] of Object.entries(results)) {
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        dataResults[routeId] = {
          type: ResultType.redirect,
          response: normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, future.v7_relativeSplatPath)
        };
      } else {
        dataResults[routeId] = await convertDataStrategyResultToDataResult(result);
      }
    }
    return dataResults;
  }
  async function callLoadersAndMaybeResolveData(state, matches, matchesToLoad, fetchersToLoad, request) {
    let currentMatches = state.matches;
    // Kick off loaders and fetchers in parallel
    let loaderResultsPromise = callDataStrategy("loader", state, request, matchesToLoad, matches, null);
    let fetcherResultsPromise = Promise.all(fetchersToLoad.map(async f => {
      if (f.matches && f.match && f.controller) {
        let results = await callDataStrategy("loader", state, createClientSideRequest(init.history, f.path, f.controller.signal), [f.match], f.matches, f.key);
        let result = results[f.match.route.id];
        // Fetcher results are keyed by fetcher key from here on out, not routeId
        return {
          [f.key]: result
        };
      } else {
        return Promise.resolve({
          [f.key]: {
            type: ResultType.error,
            error: getInternalRouterError(404, {
              pathname: f.path
            })
          }
        });
      }
    }));
    let loaderResults = await loaderResultsPromise;
    let fetcherResults = (await fetcherResultsPromise).reduce((acc, r) => Object.assign(acc, r), {});
    await Promise.all([resolveNavigationDeferredResults(matches, loaderResults, request.signal, currentMatches, state.loaderData), resolveFetcherDeferredResults(matches, fetcherResults, fetchersToLoad)]);
    return {
      loaderResults,
      fetcherResults
    };
  }
  function interruptActiveLoads() {
    // Every interruption triggers a revalidation
    isRevalidationRequired = true;
    // Cancel pending route-level deferreds and mark cancelled routes for
    // revalidation
    cancelledDeferredRoutes.push(...cancelActiveDeferreds());
    // Abort in-flight fetcher loads
    fetchLoadMatches.forEach((_, key) => {
      if (fetchControllers.has(key)) {
        cancelledFetcherLoads.add(key);
        abortFetcher(key);
      }
    });
  }
  function updateFetcherState(key, fetcher, opts) {
    if (opts === void 0) {
      opts = {};
    }
    state.fetchers.set(key, fetcher);
    updateState({
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function setFetcherError(key, routeId, error, opts) {
    if (opts === void 0) {
      opts = {};
    }
    let boundaryMatch = findNearestBoundary(state.matches, routeId);
    deleteFetcher(key);
    updateState({
      errors: {
        [boundaryMatch.route.id]: error
      },
      fetchers: new Map(state.fetchers)
    }, {
      flushSync: (opts && opts.flushSync) === true
    });
  }
  function getFetcher(key) {
    if (future.v7_fetcherPersist) {
      activeFetchers.set(key, (activeFetchers.get(key) || 0) + 1);
      // If this fetcher was previously marked for deletion, unmark it since we
      // have a new instance
      if (deletedFetchers.has(key)) {
        deletedFetchers.delete(key);
      }
    }
    return state.fetchers.get(key) || IDLE_FETCHER;
  }
  function deleteFetcher(key) {
    let fetcher = state.fetchers.get(key);
    // Don't abort the controller if this is a deletion of a fetcher.submit()
    // in it's loading phase since - we don't want to abort the corresponding
    // revalidation and want them to complete and land
    if (fetchControllers.has(key) && !(fetcher && fetcher.state === "loading" && fetchReloadIds.has(key))) {
      abortFetcher(key);
    }
    fetchLoadMatches.delete(key);
    fetchReloadIds.delete(key);
    fetchRedirectIds.delete(key);
    deletedFetchers.delete(key);
    cancelledFetcherLoads.delete(key);
    state.fetchers.delete(key);
  }
  function deleteFetcherAndUpdateState(key) {
    if (future.v7_fetcherPersist) {
      let count = (activeFetchers.get(key) || 0) - 1;
      if (count <= 0) {
        activeFetchers.delete(key);
        deletedFetchers.add(key);
      } else {
        activeFetchers.set(key, count);
      }
    } else {
      deleteFetcher(key);
    }
    updateState({
      fetchers: new Map(state.fetchers)
    });
  }
  function abortFetcher(key) {
    let controller = fetchControllers.get(key);
    invariant(controller, "Expected fetch controller: " + key);
    controller.abort();
    fetchControllers.delete(key);
  }
  function markFetchersDone(keys) {
    for (let key of keys) {
      let fetcher = getFetcher(key);
      let doneFetcher = getDoneFetcher(fetcher.data);
      state.fetchers.set(key, doneFetcher);
    }
  }
  function markFetchRedirectsDone() {
    let doneKeys = [];
    let updatedFetchers = false;
    for (let key of fetchRedirectIds) {
      let fetcher = state.fetchers.get(key);
      invariant(fetcher, "Expected fetcher: " + key);
      if (fetcher.state === "loading") {
        fetchRedirectIds.delete(key);
        doneKeys.push(key);
        updatedFetchers = true;
      }
    }
    markFetchersDone(doneKeys);
    return updatedFetchers;
  }
  function abortStaleFetchLoads(landedId) {
    let yeetedKeys = [];
    for (let [key, id] of fetchReloadIds) {
      if (id < landedId) {
        let fetcher = state.fetchers.get(key);
        invariant(fetcher, "Expected fetcher: " + key);
        if (fetcher.state === "loading") {
          abortFetcher(key);
          fetchReloadIds.delete(key);
          yeetedKeys.push(key);
        }
      }
    }
    markFetchersDone(yeetedKeys);
    return yeetedKeys.length > 0;
  }
  function getBlocker(key, fn) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    if (blockerFunctions.get(key) !== fn) {
      blockerFunctions.set(key, fn);
    }
    return blocker;
  }
  function deleteBlocker(key) {
    state.blockers.delete(key);
    blockerFunctions.delete(key);
  }
  // Utility function to update blockers, ensuring valid state transitions
  function updateBlocker(key, newBlocker) {
    let blocker = state.blockers.get(key) || IDLE_BLOCKER;
    // Poor mans state machine :)
    // https://mermaid.live/edit#pako:eNqVkc9OwzAMxl8l8nnjAYrEtDIOHEBIgwvKJTReGy3_lDpIqO27k6awMG0XcrLlnz87nwdonESogKXXBuE79rq75XZO3-yHds0RJVuv70YrPlUrCEe2HfrORS3rubqZfuhtpg5C9wk5tZ4VKcRUq88q9Z8RS0-48cE1iHJkL0ugbHuFLus9L6spZy8nX9MP2CNdomVaposqu3fGayT8T8-jJQwhepo_UtpgBQaDEUom04dZhAN1aJBDlUKJBxE1ceB2Smj0Mln-IBW5AFU2dwUiktt_2Qaq2dBfaKdEup85UV7Yd-dKjlnkabl2Pvr0DTkTreM
    invariant(blocker.state === "unblocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "blocked" || blocker.state === "blocked" && newBlocker.state === "proceeding" || blocker.state === "blocked" && newBlocker.state === "unblocked" || blocker.state === "proceeding" && newBlocker.state === "unblocked", "Invalid blocker state transition: " + blocker.state + " -> " + newBlocker.state);
    let blockers = new Map(state.blockers);
    blockers.set(key, newBlocker);
    updateState({
      blockers
    });
  }
  function shouldBlockNavigation(_ref4) {
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = _ref4;
    if (blockerFunctions.size === 0) {
      return;
    }
    // We ony support a single active blocker at the moment since we don't have
    // any compelling use cases for multi-blocker yet
    if (blockerFunctions.size > 1) {
      warning(false, "A router only supports one blocker at a time");
    }
    let entries = Array.from(blockerFunctions.entries());
    let [blockerKey, blockerFunction] = entries[entries.length - 1];
    let blocker = state.blockers.get(blockerKey);
    if (blocker && blocker.state === "proceeding") {
      // If the blocker is currently proceeding, we don't need to re-check
      // it and can let this navigation continue
      return;
    }
    // At this point, we know we're unblocked/blocked so we need to check the
    // user-provided blocker function
    if (blockerFunction({
      currentLocation,
      nextLocation,
      historyAction
    })) {
      return blockerKey;
    }
  }
  function handleNavigational404(pathname) {
    let error = getInternalRouterError(404, {
      pathname
    });
    let routesToUse = inFlightDataRoutes || dataRoutes;
    let {
      matches,
      route
    } = getShortCircuitMatches(routesToUse);
    // Cancel all pending deferred on 404s since we don't keep any routes
    cancelActiveDeferreds();
    return {
      notFoundMatches: matches,
      route,
      error
    };
  }
  function handleDiscoverRouteError(pathname, discoverResult) {
    return {
      boundaryId: findNearestBoundary(discoverResult.partialMatches).route.id,
      error: getInternalRouterError(400, {
        type: "route-discovery",
        pathname,
        message: discoverResult.error != null && "message" in discoverResult.error ? discoverResult.error : String(discoverResult.error)
      })
    };
  }
  function cancelActiveDeferreds(predicate) {
    let cancelledRouteIds = [];
    activeDeferreds.forEach((dfd, routeId) => {
      if (!predicate || predicate(routeId)) {
        // Cancel the deferred - but do not remove from activeDeferreds here -
        // we rely on the subscribers to do that so our tests can assert proper
        // cleanup via _internalActiveDeferreds
        dfd.cancel();
        cancelledRouteIds.push(routeId);
        activeDeferreds.delete(routeId);
      }
    });
    return cancelledRouteIds;
  }
  // Opt in to capturing and reporting scroll positions during navigations,
  // used by the <ScrollRestoration> component
  function enableScrollRestoration(positions, getPosition, getKey) {
    savedScrollPositions = positions;
    getScrollPosition = getPosition;
    getScrollRestorationKey = getKey || null;
    // Perform initial hydration scroll restoration, since we miss the boat on
    // the initial updateState() because we've not yet rendered <ScrollRestoration/>
    // and therefore have no savedScrollPositions available
    if (!initialScrollRestored && state.navigation === IDLE_NAVIGATION) {
      initialScrollRestored = true;
      let y = getSavedScrollPosition(state.location, state.matches);
      if (y != null) {
        updateState({
          restoreScrollPosition: y
        });
      }
    }
    return () => {
      savedScrollPositions = null;
      getScrollPosition = null;
      getScrollRestorationKey = null;
    };
  }
  function getScrollKey(location, matches) {
    if (getScrollRestorationKey) {
      let key = getScrollRestorationKey(location, matches.map(m => convertRouteMatchToUiMatch(m, state.loaderData)));
      return key || location.key;
    }
    return location.key;
  }
  function saveScrollPosition(location, matches) {
    if (savedScrollPositions && getScrollPosition) {
      let key = getScrollKey(location, matches);
      savedScrollPositions[key] = getScrollPosition();
    }
  }
  function getSavedScrollPosition(location, matches) {
    if (savedScrollPositions) {
      let key = getScrollKey(location, matches);
      let y = savedScrollPositions[key];
      if (typeof y === "number") {
        return y;
      }
    }
    return null;
  }
  function checkFogOfWar(matches, routesToUse, pathname) {
    if (patchRoutesOnNavigationImpl) {
      // Don't bother re-calling patchRouteOnMiss for a path we've already
      // processed.  the last execution would have patched the route tree
      // accordingly so `matches` here are already accurate.
      if (discoveredRoutes.has(pathname)) {
        return {
          active: false,
          matches
        };
      }
      if (!matches) {
        let fogMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
        return {
          active: true,
          matches: fogMatches || []
        };
      } else {
        if (Object.keys(matches[0].params).length > 0) {
          // If we matched a dynamic param or a splat, it might only be because
          // we haven't yet discovered other routes that would match with a
          // higher score.  Call patchRoutesOnNavigation just to be sure
          let partialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
          return {
            active: true,
            matches: partialMatches
          };
        }
      }
    }
    return {
      active: false,
      matches: null
    };
  }
  async function discoverRoutes(matches, pathname, signal) {
    let partialMatches = matches;
    while (true) {
      let isNonHMR = inFlightDataRoutes == null;
      let routesToUse = inFlightDataRoutes || dataRoutes;
      try {
        await loadLazyRouteChildren(patchRoutesOnNavigationImpl, pathname, partialMatches, routesToUse, manifest, mapRouteProperties, pendingPatchRoutes, signal);
      } catch (e) {
        return {
          type: "error",
          error: e,
          partialMatches
        };
      } finally {
        // If we are not in the middle of an HMR revalidation and we changed the
        // routes, provide a new identity so when we `updateState` at the end of
        // this navigation/fetch `router.routes` will be a new identity and
        // trigger a re-run of memoized `router.routes` dependencies.
        // HMR will already update the identity and reflow when it lands
        // `inFlightDataRoutes` in `completeNavigation`
        if (isNonHMR) {
          dataRoutes = [...dataRoutes];
        }
      }
      if (signal.aborted) {
        return {
          type: "aborted"
        };
      }
      let newMatches = matchRoutes(routesToUse, pathname, basename);
      if (newMatches) {
        addToFifoQueue(pathname, discoveredRoutes);
        return {
          type: "success",
          matches: newMatches
        };
      }
      let newPartialMatches = matchRoutesImpl(routesToUse, pathname, basename, true);
      // Avoid loops if the second pass results in the same partial matches
      if (!newPartialMatches || partialMatches.length === newPartialMatches.length && partialMatches.every((m, i) => m.route.id === newPartialMatches[i].route.id)) {
        addToFifoQueue(pathname, discoveredRoutes);
        return {
          type: "success",
          matches: null
        };
      }
      partialMatches = newPartialMatches;
    }
  }
  function addToFifoQueue(path, queue) {
    if (queue.size >= discoveredRoutesMaxSize) {
      let first = queue.values().next().value;
      queue.delete(first);
    }
    queue.add(path);
  }
  function _internalSetRoutes(newRoutes) {
    manifest = {};
    inFlightDataRoutes = convertRoutesToDataRoutes(newRoutes, mapRouteProperties, undefined, manifest);
  }
  function patchRoutes(routeId, children) {
    let isNonHMR = inFlightDataRoutes == null;
    let routesToUse = inFlightDataRoutes || dataRoutes;
    patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties);
    // If we are not in the middle of an HMR revalidation and we changed the
    // routes, provide a new identity and trigger a reflow via `updateState`
    // to re-run memoized `router.routes` dependencies.
    // HMR will already update the identity and reflow when it lands
    // `inFlightDataRoutes` in `completeNavigation`
    if (isNonHMR) {
      dataRoutes = [...dataRoutes];
      updateState({});
    }
  }
  router = {
    get basename() {
      return basename;
    },
    get future() {
      return future;
    },
    get state() {
      return state;
    },
    get routes() {
      return dataRoutes;
    },
    get window() {
      return routerWindow;
    },
    initialize,
    subscribe,
    enableScrollRestoration,
    navigate,
    fetch,
    revalidate,
    // Passthrough to history-aware createHref used by useHref so we get proper
    // hash-aware URLs in DOM paths
    createHref: to => init.history.createHref(to),
    encodeLocation: to => init.history.encodeLocation(to),
    getFetcher,
    deleteFetcher: deleteFetcherAndUpdateState,
    dispose,
    getBlocker,
    deleteBlocker,
    patchRoutes,
    _internalFetchControllers: fetchControllers,
    _internalActiveDeferreds: activeDeferreds,
    // TODO: Remove setRoutes, it's temporary to avoid dealing with
    // updating the tree while validating the update algorithm.
    _internalSetRoutes
  };
  return router;
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region createStaticHandler
////////////////////////////////////////////////////////////////////////////////
const UNSAFE_DEFERRED_SYMBOL = Symbol("deferred");
function createStaticHandler(routes, opts) {
  invariant(routes.length > 0, "You must provide a non-empty routes array to createStaticHandler");
  let manifest = {};
  let basename = (opts ? opts.basename : null) || "/";
  let mapRouteProperties;
  if (opts != null && opts.mapRouteProperties) {
    mapRouteProperties = opts.mapRouteProperties;
  } else if (opts != null && opts.detectErrorBoundary) {
    // If they are still using the deprecated version, wrap it with the new API
    let detectErrorBoundary = opts.detectErrorBoundary;
    mapRouteProperties = route => ({
      hasErrorBoundary: detectErrorBoundary(route)
    });
  } else {
    mapRouteProperties = defaultMapRouteProperties;
  }
  // Config driven behavior flags
  let future = _extends({
    v7_relativeSplatPath: false,
    v7_throwAbortReason: false
  }, opts ? opts.future : null);
  let dataRoutes = convertRoutesToDataRoutes(routes, mapRouteProperties, undefined, manifest);
  /**
   * The query() method is intended for document requests, in which we want to
   * call an optional action and potentially multiple loaders for all nested
   * routes.  It returns a StaticHandlerContext object, which is very similar
   * to the router state (location, loaderData, actionData, errors, etc.) and
   * also adds SSR-specific information such as the statusCode and headers
   * from action/loaders Responses.
   *
   * It _should_ never throw and should report all errors through the
   * returned context.errors object, properly associating errors to their error
   * boundary.  Additionally, it tracks _deepestRenderedBoundaryId which can be
   * used to emulate React error boundaries during SSr by performing a second
   * pass only down to the boundaryId.
   *
   * The one exception where we do not return a StaticHandlerContext is when a
   * redirect response is returned or thrown from any action/loader.  We
   * propagate that out and return the raw Response so the HTTP server can
   * return it directly.
   *
   * - `opts.requestContext` is an optional server context that will be passed
   *   to actions/loaders in the `context` parameter
   * - `opts.skipLoaderErrorBubbling` is an optional parameter that will prevent
   *   the bubbling of errors which allows single-fetch-type implementations
   *   where the client will handle the bubbling and we may need to return data
   *   for the handling route
   */
  async function query(request, _temp3) {
    let {
      requestContext,
      skipLoaderErrorBubbling,
      unstable_dataStrategy
    } = _temp3 === void 0 ? {} : _temp3;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD") {
      let error = getInternalRouterError(405, {
        method
      });
      let {
        matches: methodNotAllowedMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: methodNotAllowedMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    } else if (!matches) {
      let error = getInternalRouterError(404, {
        pathname: location.pathname
      });
      let {
        matches: notFoundMatches,
        route
      } = getShortCircuitMatches(dataRoutes);
      return {
        basename,
        location,
        matches: notFoundMatches,
        loaderData: {},
        actionData: null,
        errors: {
          [route.id]: error
        },
        statusCode: error.status,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    let result = await queryImpl(request, location, matches, requestContext, unstable_dataStrategy || null, skipLoaderErrorBubbling === true, null);
    if (isResponse(result)) {
      return result;
    }
    // When returning StaticHandlerContext, we patch back in the location here
    // since we need it for React Context.  But this helps keep our submit and
    // loadRouteData operating on a Request instead of a Location
    return _extends({
      location,
      basename
    }, result);
  }
  /**
   * The queryRoute() method is intended for targeted route requests, either
   * for fetch ?_data requests or resource route requests.  In this case, we
   * are only ever calling a single action or loader, and we are returning the
   * returned value directly.  In most cases, this will be a Response returned
   * from the action/loader, but it may be a primitive or other value as well -
   * and in such cases the calling context should handle that accordingly.
   *
   * We do respect the throw/return differentiation, so if an action/loader
   * throws, then this method will throw the value.  This is important so we
   * can do proper boundary identification in Remix where a thrown Response
   * must go to the Catch Boundary but a returned Response is happy-path.
   *
   * One thing to note is that any Router-initiated Errors that make sense
   * to associate with a status code will be thrown as an ErrorResponse
   * instance which include the raw Error, such that the calling context can
   * serialize the error as they see fit while including the proper response
   * code.  Examples here are 404 and 405 errors that occur prior to reaching
   * any user-defined loaders.
   *
   * - `opts.routeId` allows you to specify the specific route handler to call.
   *   If not provided the handler will determine the proper route by matching
   *   against `request.url`
   * - `opts.requestContext` is an optional server context that will be passed
   *    to actions/loaders in the `context` parameter
   */
  async function queryRoute(request, _temp4) {
    let {
      routeId,
      requestContext,
      unstable_dataStrategy
    } = _temp4 === void 0 ? {} : _temp4;
    let url = new URL(request.url);
    let method = request.method;
    let location = createLocation("", createPath(url), null, "default");
    let matches = matchRoutes(dataRoutes, location, basename);
    // SSR supports HEAD requests while SPA doesn't
    if (!isValidMethod(method) && method !== "HEAD" && method !== "OPTIONS") {
      throw getInternalRouterError(405, {
        method
      });
    } else if (!matches) {
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let match = routeId ? matches.find(m => m.route.id === routeId) : getTargetMatch(matches, location);
    if (routeId && !match) {
      throw getInternalRouterError(403, {
        pathname: location.pathname,
        routeId
      });
    } else if (!match) {
      // This should never hit I don't think?
      throw getInternalRouterError(404, {
        pathname: location.pathname
      });
    }
    let result = await queryImpl(request, location, matches, requestContext, unstable_dataStrategy || null, false, match);
    if (isResponse(result)) {
      return result;
    }
    let error = result.errors ? Object.values(result.errors)[0] : undefined;
    if (error !== undefined) {
      // If we got back result.errors, that means the loader/action threw
      // _something_ that wasn't a Response, but it's not guaranteed/required
      // to be an `instanceof Error` either, so we have to use throw here to
      // preserve the "error" state outside of queryImpl.
      throw error;
    }
    // Pick off the right state value to return
    if (result.actionData) {
      return Object.values(result.actionData)[0];
    }
    if (result.loaderData) {
      var _result$activeDeferre;
      let data = Object.values(result.loaderData)[0];
      if ((_result$activeDeferre = result.activeDeferreds) != null && _result$activeDeferre[match.route.id]) {
        data[UNSAFE_DEFERRED_SYMBOL] = result.activeDeferreds[match.route.id];
      }
      return data;
    }
    return undefined;
  }
  async function queryImpl(request, location, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch) {
    invariant(request.signal, "query()/queryRoute() requests must contain an AbortController signal");
    try {
      if (isMutationMethod(request.method.toLowerCase())) {
        let result = await submit(request, matches, routeMatch || getTargetMatch(matches, location), requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch != null);
        return result;
      }
      let result = await loadRouteData(request, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch);
      return isResponse(result) ? result : _extends({}, result, {
        actionData: null,
        actionHeaders: {}
      });
    } catch (e) {
      // If the user threw/returned a Response in callLoaderOrAction for a
      // `queryRoute` call, we throw the `DataStrategyResult` to bail out early
      // and then return or throw the raw Response here accordingly
      if (isDataStrategyResult(e) && isResponse(e.result)) {
        if (e.type === ResultType.error) {
          throw e.result;
        }
        return e.result;
      }
      // Redirects are always returned since they don't propagate to catch
      // boundaries
      if (isRedirectResponse(e)) {
        return e;
      }
      throw e;
    }
  }
  async function submit(request, matches, actionMatch, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, isRouteRequest) {
    let result;
    if (!actionMatch.route.action && !actionMatch.route.lazy) {
      let error = getInternalRouterError(405, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: actionMatch.route.id
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    } else {
      let results = await callDataStrategy("action", request, [actionMatch], matches, isRouteRequest, requestContext, unstable_dataStrategy);
      result = results[actionMatch.route.id];
      if (request.signal.aborted) {
        throwStaticHandlerAbortedError(request, isRouteRequest, future);
      }
    }
    if (isRedirectResult(result)) {
      // Uhhhh - this should never happen, we should always throw these from
      // callLoaderOrAction, but the type narrowing here keeps TS happy and we
      // can get back on the "throw all redirect responses" train here should
      // this ever happen :/
      throw new Response(null, {
        status: result.response.status,
        headers: {
          Location: result.response.headers.get("Location")
        }
      });
    }
    if (isDeferredResult(result)) {
      let error = getInternalRouterError(400, {
        type: "defer-action"
      });
      if (isRouteRequest) {
        throw error;
      }
      result = {
        type: ResultType.error,
        error
      };
    }
    if (isRouteRequest) {
      // Note: This should only be non-Response values if we get here, since
      // isRouteRequest should throw any Response received in callLoaderOrAction
      if (isErrorResult(result)) {
        throw result.error;
      }
      return {
        matches: [actionMatch],
        loaderData: {},
        actionData: {
          [actionMatch.route.id]: result.data
        },
        errors: null,
        // Note: statusCode + headers are unused here since queryRoute will
        // return the raw Response or value
        statusCode: 200,
        loaderHeaders: {},
        actionHeaders: {},
        activeDeferreds: null
      };
    }
    // Create a GET request for the loaders
    let loaderRequest = new Request(request.url, {
      headers: request.headers,
      redirect: request.redirect,
      signal: request.signal
    });
    if (isErrorResult(result)) {
      // Store off the pending error - we use it to determine which loaders
      // to call and will commit it when we complete the navigation
      let boundaryMatch = skipLoaderErrorBubbling ? actionMatch : findNearestBoundary(matches, actionMatch.route.id);
      let context = await loadRouteData(loaderRequest, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, null, [boundaryMatch.route.id, result]);
      // action status codes take precedence over loader status codes
      return _extends({}, context, {
        statusCode: isRouteErrorResponse(result.error) ? result.error.status : result.statusCode != null ? result.statusCode : 500,
        actionData: null,
        actionHeaders: _extends({}, result.headers ? {
          [actionMatch.route.id]: result.headers
        } : {})
      });
    }
    let context = await loadRouteData(loaderRequest, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, null);
    return _extends({}, context, {
      actionData: {
        [actionMatch.route.id]: result.data
      }
    }, result.statusCode ? {
      statusCode: result.statusCode
    } : {}, {
      actionHeaders: result.headers ? {
        [actionMatch.route.id]: result.headers
      } : {}
    });
  }
  async function loadRouteData(request, matches, requestContext, unstable_dataStrategy, skipLoaderErrorBubbling, routeMatch, pendingActionResult) {
    let isRouteRequest = routeMatch != null;
    // Short circuit if we have no loaders to run (queryRoute())
    if (isRouteRequest && !(routeMatch != null && routeMatch.route.loader) && !(routeMatch != null && routeMatch.route.lazy)) {
      throw getInternalRouterError(400, {
        method: request.method,
        pathname: new URL(request.url).pathname,
        routeId: routeMatch == null ? void 0 : routeMatch.route.id
      });
    }
    let requestMatches = routeMatch ? [routeMatch] : pendingActionResult && isErrorResult(pendingActionResult[1]) ? getLoaderMatchesUntilBoundary(matches, pendingActionResult[0]) : matches;
    let matchesToLoad = requestMatches.filter(m => m.route.loader || m.route.lazy);
    // Short circuit if we have no loaders to run (query())
    if (matchesToLoad.length === 0) {
      return {
        matches,
        // Add a null for all matched routes for proper revalidation on the client
        loaderData: matches.reduce((acc, m) => Object.assign(acc, {
          [m.route.id]: null
        }), {}),
        errors: pendingActionResult && isErrorResult(pendingActionResult[1]) ? {
          [pendingActionResult[0]]: pendingActionResult[1].error
        } : null,
        statusCode: 200,
        loaderHeaders: {},
        activeDeferreds: null
      };
    }
    let results = await callDataStrategy("loader", request, matchesToLoad, matches, isRouteRequest, requestContext, unstable_dataStrategy);
    if (request.signal.aborted) {
      throwStaticHandlerAbortedError(request, isRouteRequest, future);
    }
    // Process and commit output from loaders
    let activeDeferreds = new Map();
    let context = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling);
    // Add a null for any non-loader matches for proper revalidation on the client
    let executedLoaders = new Set(matchesToLoad.map(match => match.route.id));
    matches.forEach(match => {
      if (!executedLoaders.has(match.route.id)) {
        context.loaderData[match.route.id] = null;
      }
    });
    return _extends({}, context, {
      matches,
      activeDeferreds: activeDeferreds.size > 0 ? Object.fromEntries(activeDeferreds.entries()) : null
    });
  }
  // Utility wrapper for calling dataStrategy server-side without having to
  // pass around the manifest, mapRouteProperties, etc.
  async function callDataStrategy(type, request, matchesToLoad, matches, isRouteRequest, requestContext, unstable_dataStrategy) {
    let results = await callDataStrategyImpl(unstable_dataStrategy || defaultDataStrategy, type, null, request, matchesToLoad, matches, null, manifest, mapRouteProperties, requestContext);
    let dataResults = {};
    await Promise.all(matches.map(async match => {
      if (!(match.route.id in results)) {
        return;
      }
      let result = results[match.route.id];
      if (isRedirectDataStrategyResultResult(result)) {
        let response = result.result;
        // Throw redirects and let the server handle them with an HTTP redirect
        throw normalizeRelativeRoutingRedirectResponse(response, request, match.route.id, matches, basename, future.v7_relativeSplatPath);
      }
      if (isResponse(result.result) && isRouteRequest) {
        // For SSR single-route requests, we want to hand Responses back
        // directly without unwrapping
        throw result;
      }
      dataResults[match.route.id] = await convertDataStrategyResultToDataResult(result);
    }));
    return dataResults;
  }
  return {
    dataRoutes,
    query,
    queryRoute
  };
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Helpers
////////////////////////////////////////////////////////////////////////////////
/**
 * Given an existing StaticHandlerContext and an error thrown at render time,
 * provide an updated StaticHandlerContext suitable for a second SSR render
 */
function getStaticContextFromError(routes, context, error) {
  let newContext = _extends({}, context, {
    statusCode: isRouteErrorResponse(error) ? error.status : 500,
    errors: {
      [context._deepestRenderedBoundaryId || routes[0].id]: error
    }
  });
  return newContext;
}
function throwStaticHandlerAbortedError(request, isRouteRequest, future) {
  if (future.v7_throwAbortReason && request.signal.reason !== undefined) {
    throw request.signal.reason;
  }
  let method = isRouteRequest ? "queryRoute" : "query";
  throw new Error(method + "() call aborted: " + request.method + " " + request.url);
}
function isSubmissionNavigation(opts) {
  return opts != null && ("formData" in opts && opts.formData != null || "body" in opts && opts.body !== undefined);
}
function normalizeTo(location, matches, basename, prependBasename, to, v7_relativeSplatPath, fromRouteId, relative) {
  let contextualMatches;
  let activeRouteMatch;
  if (fromRouteId) {
    // Grab matches up to the calling route so our route-relative logic is
    // relative to the correct source route
    contextualMatches = [];
    for (let match of matches) {
      contextualMatches.push(match);
      if (match.route.id === fromRouteId) {
        activeRouteMatch = match;
        break;
      }
    }
  } else {
    contextualMatches = matches;
    activeRouteMatch = matches[matches.length - 1];
  }
  // Resolve the relative path
  let path = resolveTo(to ? to : ".", getResolveToMatches(contextualMatches, v7_relativeSplatPath), stripBasename(location.pathname, basename) || location.pathname, relative === "path");
  // When `to` is not specified we inherit search/hash from the current
  // location, unlike when to="." and we just inherit the path.
  // See https://github.com/remix-run/remix/issues/927
  if (to == null) {
    path.search = location.search;
    path.hash = location.hash;
  }
  // Add an ?index param for matched index routes if we don't already have one
  if ((to == null || to === "" || to === ".") && activeRouteMatch && activeRouteMatch.route.index && !hasNakedIndexQuery(path.search)) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname.  If
  // this is a root navigation, then just use the raw basename which allows
  // the basename to have full control over the presence of a trailing slash
  // on root actions
  if (prependBasename && basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : joinPaths([basename, path.pathname]);
  }
  return createPath(path);
}
// Normalize navigation options by converting formMethod=GET formData objects to
// URLSearchParams so they behave identically to links with query params
function normalizeNavigateOptions(normalizeFormMethod, isFetcher, path, opts) {
  // Return location verbatim on non-submission navigations
  if (!opts || !isSubmissionNavigation(opts)) {
    return {
      path
    };
  }
  if (opts.formMethod && !isValidMethod(opts.formMethod)) {
    return {
      path,
      error: getInternalRouterError(405, {
        method: opts.formMethod
      })
    };
  }
  let getInvalidBodyError = () => ({
    path,
    error: getInternalRouterError(400, {
      type: "invalid-body"
    })
  });
  // Create a Submission on non-GET navigations
  let rawFormMethod = opts.formMethod || "get";
  let formMethod = normalizeFormMethod ? rawFormMethod.toUpperCase() : rawFormMethod.toLowerCase();
  let formAction = stripHashFromPath(path);
  if (opts.body !== undefined) {
    if (opts.formEncType === "text/plain") {
      // text only support POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      let text = typeof opts.body === "string" ? opts.body : opts.body instanceof FormData || opts.body instanceof URLSearchParams ?
      // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#plain-text-form-data
      Array.from(opts.body.entries()).reduce((acc, _ref5) => {
        let [name, value] = _ref5;
        return "" + acc + name + "=" + value + "\n";
      }, "") : String(opts.body);
      return {
        path,
        submission: {
          formMethod,
          formAction,
          formEncType: opts.formEncType,
          formData: undefined,
          json: undefined,
          text
        }
      };
    } else if (opts.formEncType === "application/json") {
      // json only supports POST/PUT/PATCH/DELETE submissions
      if (!isMutationMethod(formMethod)) {
        return getInvalidBodyError();
      }
      try {
        let json = typeof opts.body === "string" ? JSON.parse(opts.body) : opts.body;
        return {
          path,
          submission: {
            formMethod,
            formAction,
            formEncType: opts.formEncType,
            formData: undefined,
            json,
            text: undefined
          }
        };
      } catch (e) {
        return getInvalidBodyError();
      }
    }
  }
  invariant(typeof FormData === "function", "FormData is not available in this environment");
  let searchParams;
  let formData;
  if (opts.formData) {
    searchParams = convertFormDataToSearchParams(opts.formData);
    formData = opts.formData;
  } else if (opts.body instanceof FormData) {
    searchParams = convertFormDataToSearchParams(opts.body);
    formData = opts.body;
  } else if (opts.body instanceof URLSearchParams) {
    searchParams = opts.body;
    formData = convertSearchParamsToFormData(searchParams);
  } else if (opts.body == null) {
    searchParams = new URLSearchParams();
    formData = new FormData();
  } else {
    try {
      searchParams = new URLSearchParams(opts.body);
      formData = convertSearchParamsToFormData(searchParams);
    } catch (e) {
      return getInvalidBodyError();
    }
  }
  let submission = {
    formMethod,
    formAction,
    formEncType: opts && opts.formEncType || "application/x-www-form-urlencoded",
    formData,
    json: undefined,
    text: undefined
  };
  if (isMutationMethod(submission.formMethod)) {
    return {
      path,
      submission
    };
  }
  // Flatten submission onto URLSearchParams for GET submissions
  let parsedPath = parsePath(path);
  // On GET navigation submissions we can drop the ?index param from the
  // resulting location since all loaders will run.  But fetcher GET submissions
  // only run a single loader so we need to preserve any incoming ?index params
  if (isFetcher && parsedPath.search && hasNakedIndexQuery(parsedPath.search)) {
    searchParams.append("index", "");
  }
  parsedPath.search = "?" + searchParams;
  return {
    path: createPath(parsedPath),
    submission
  };
}
// Filter out all routes below any caught error as they aren't going to
// render so we don't need to load them
function getLoaderMatchesUntilBoundary(matches, boundaryId) {
  let boundaryMatches = matches;
  if (boundaryId) {
    let index = matches.findIndex(m => m.route.id === boundaryId);
    if (index >= 0) {
      boundaryMatches = matches.slice(0, index);
    }
  }
  return boundaryMatches;
}
function getMatchesToLoad(history, state, matches, submission, location, isInitialLoad, skipActionErrorRevalidation, isRevalidationRequired, cancelledDeferredRoutes, cancelledFetcherLoads, deletedFetchers, fetchLoadMatches, fetchRedirectIds, routesToUse, basename, pendingActionResult) {
  let actionResult = pendingActionResult ? isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : pendingActionResult[1].data : undefined;
  let currentUrl = history.createURL(state.location);
  let nextUrl = history.createURL(location);
  // Pick navigation matches that are net-new or qualify for revalidation
  let boundaryId = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[0] : undefined;
  let boundaryMatches = boundaryId ? getLoaderMatchesUntilBoundary(matches, boundaryId) : matches;
  // Don't revalidate loaders by default after action 4xx/5xx responses
  // when the flag is enabled.  They can still opt-into revalidation via
  // `shouldRevalidate` via `actionResult`
  let actionStatus = pendingActionResult ? pendingActionResult[1].statusCode : undefined;
  let shouldSkipRevalidation = skipActionErrorRevalidation && actionStatus && actionStatus >= 400;
  let navigationMatches = boundaryMatches.filter((match, index) => {
    let {
      route
    } = match;
    if (route.lazy) {
      // We haven't loaded this route yet so we don't know if it's got a loader!
      return true;
    }
    if (route.loader == null) {
      return false;
    }
    if (isInitialLoad) {
      if (typeof route.loader !== "function" || route.loader.hydrate) {
        return true;
      }
      return state.loaderData[route.id] === undefined && (
      // Don't re-run if the loader ran and threw an error
      !state.errors || state.errors[route.id] === undefined);
    }
    // Always call the loader on new route instances and pending defer cancellations
    if (isNewLoader(state.loaderData, state.matches[index], match) || cancelledDeferredRoutes.some(id => id === match.route.id)) {
      return true;
    }
    // This is the default implementation for when we revalidate.  If the route
    // provides it's own implementation, then we give them full control but
    // provide this value so they can leverage it if needed after they check
    // their own specific use cases
    let currentRouteMatch = state.matches[index];
    let nextRouteMatch = match;
    return shouldRevalidateLoader(match, _extends({
      currentUrl,
      currentParams: currentRouteMatch.params,
      nextUrl,
      nextParams: nextRouteMatch.params
    }, submission, {
      actionResult,
      actionStatus,
      defaultShouldRevalidate: shouldSkipRevalidation ? false :
      // Forced revalidation due to submission, useRevalidator, or X-Remix-Revalidate
      isRevalidationRequired || currentUrl.pathname + currentUrl.search === nextUrl.pathname + nextUrl.search ||
      // Search params affect all loaders
      currentUrl.search !== nextUrl.search || isNewRouteInstance(currentRouteMatch, nextRouteMatch)
    }));
  });
  // Pick fetcher.loads that need to be revalidated
  let revalidatingFetchers = [];
  fetchLoadMatches.forEach((f, key) => {
    // Don't revalidate:
    //  - on initial load (shouldn't be any fetchers then anyway)
    //  - if fetcher won't be present in the subsequent render
    //    - no longer matches the URL (v7_fetcherPersist=false)
    //    - was unmounted but persisted due to v7_fetcherPersist=true
    if (isInitialLoad || !matches.some(m => m.route.id === f.routeId) || deletedFetchers.has(key)) {
      return;
    }
    let fetcherMatches = matchRoutes(routesToUse, f.path, basename);
    // If the fetcher path no longer matches, push it in with null matches so
    // we can trigger a 404 in callLoadersAndMaybeResolveData.  Note this is
    // currently only a use-case for Remix HMR where the route tree can change
    // at runtime and remove a route previously loaded via a fetcher
    if (!fetcherMatches) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: null,
        match: null,
        controller: null
      });
      return;
    }
    // Revalidating fetchers are decoupled from the route matches since they
    // load from a static href.  They revalidate based on explicit revalidation
    // (submission, useRevalidator, or X-Remix-Revalidate)
    let fetcher = state.fetchers.get(key);
    let fetcherMatch = getTargetMatch(fetcherMatches, f.path);
    let shouldRevalidate = false;
    if (fetchRedirectIds.has(key)) {
      // Never trigger a revalidation of an actively redirecting fetcher
      shouldRevalidate = false;
    } else if (cancelledFetcherLoads.has(key)) {
      // Always mark for revalidation if the fetcher was cancelled
      cancelledFetcherLoads.delete(key);
      shouldRevalidate = true;
    } else if (fetcher && fetcher.state !== "idle" && fetcher.data === undefined) {
      // If the fetcher hasn't ever completed loading yet, then this isn't a
      // revalidation, it would just be a brand new load if an explicit
      // revalidation is required
      shouldRevalidate = isRevalidationRequired;
    } else {
      // Otherwise fall back on any user-defined shouldRevalidate, defaulting
      // to explicit revalidations only
      shouldRevalidate = shouldRevalidateLoader(fetcherMatch, _extends({
        currentUrl,
        currentParams: state.matches[state.matches.length - 1].params,
        nextUrl,
        nextParams: matches[matches.length - 1].params
      }, submission, {
        actionResult,
        actionStatus,
        defaultShouldRevalidate: shouldSkipRevalidation ? false : isRevalidationRequired
      }));
    }
    if (shouldRevalidate) {
      revalidatingFetchers.push({
        key,
        routeId: f.routeId,
        path: f.path,
        matches: fetcherMatches,
        match: fetcherMatch,
        controller: new AbortController()
      });
    }
  });
  return [navigationMatches, revalidatingFetchers];
}
function isNewLoader(currentLoaderData, currentMatch, match) {
  let isNew =
  // [a] -> [a, b]
  !currentMatch ||
  // [a, b] -> [a, c]
  match.route.id !== currentMatch.route.id;
  // Handle the case that we don't have data for a re-used route, potentially
  // from a prior error or from a cancelled pending deferred
  let isMissingData = currentLoaderData[match.route.id] === undefined;
  // Always load if this is a net-new route or we don't yet have data
  return isNew || isMissingData;
}
function isNewRouteInstance(currentMatch, match) {
  let currentPath = currentMatch.route.path;
  return (
    // param change for this match, /users/123 -> /users/456
    currentMatch.pathname !== match.pathname ||
    // splat param changed, which is not present in match.path
    // e.g. /files/images/avatar.jpg -> files/finances.xls
    currentPath != null && currentPath.endsWith("*") && currentMatch.params["*"] !== match.params["*"]
  );
}
function shouldRevalidateLoader(loaderMatch, arg) {
  if (loaderMatch.route.shouldRevalidate) {
    let routeChoice = loaderMatch.route.shouldRevalidate(arg);
    if (typeof routeChoice === "boolean") {
      return routeChoice;
    }
  }
  return arg.defaultShouldRevalidate;
}
/**
 * Idempotent utility to execute patchRoutesOnNavigation() to lazily load route
 * definitions and update the routes/routeManifest
 */
async function loadLazyRouteChildren(patchRoutesOnNavigationImpl, path, matches, routes, manifest, mapRouteProperties, pendingRouteChildren, signal) {
  let key = [path, ...matches.map(m => m.route.id)].join("-");
  try {
    let pending = pendingRouteChildren.get(key);
    if (!pending) {
      pending = patchRoutesOnNavigationImpl({
        path,
        matches,
        patch: (routeId, children) => {
          if (!signal.aborted) {
            patchRoutesImpl(routeId, children, routes, manifest, mapRouteProperties);
          }
        }
      });
      pendingRouteChildren.set(key, pending);
    }
    if (pending && isPromise(pending)) {
      await pending;
    }
  } finally {
    pendingRouteChildren.delete(key);
  }
}
function patchRoutesImpl(routeId, children, routesToUse, manifest, mapRouteProperties) {
  if (routeId) {
    var _route$children;
    let route = manifest[routeId];
    invariant(route, "No route found to patch children into: routeId = " + routeId);
    let dataChildren = convertRoutesToDataRoutes(children, mapRouteProperties, [routeId, "patch", String(((_route$children = route.children) == null ? void 0 : _route$children.length) || "0")], manifest);
    if (route.children) {
      route.children.push(...dataChildren);
    } else {
      route.children = dataChildren;
    }
  } else {
    let dataChildren = convertRoutesToDataRoutes(children, mapRouteProperties, ["patch", String(routesToUse.length || "0")], manifest);
    routesToUse.push(...dataChildren);
  }
}
/**
 * Execute route.lazy() methods to lazily load route modules (loader, action,
 * shouldRevalidate) and update the routeManifest in place which shares objects
 * with dataRoutes so those get updated as well.
 */
async function loadLazyRouteModule(route, mapRouteProperties, manifest) {
  if (!route.lazy) {
    return;
  }
  let lazyRoute = await route.lazy();
  // If the lazy route function was executed and removed by another parallel
  // call then we can return - first lazy() to finish wins because the return
  // value of lazy is expected to be static
  if (!route.lazy) {
    return;
  }
  let routeToUpdate = manifest[route.id];
  invariant(routeToUpdate, "No route found in manifest");
  // Update the route in place.  This should be safe because there's no way
  // we could yet be sitting on this route as we can't get there without
  // resolving lazy() first.
  //
  // This is different than the HMR "update" use-case where we may actively be
  // on the route being updated.  The main concern boils down to "does this
  // mutation affect any ongoing navigations or any current state.matches
  // values?".  If not, it should be safe to update in place.
  let routeUpdates = {};
  for (let lazyRouteProperty in lazyRoute) {
    let staticRouteValue = routeToUpdate[lazyRouteProperty];
    let isPropertyStaticallyDefined = staticRouteValue !== undefined &&
    // This property isn't static since it should always be updated based
    // on the route updates
    lazyRouteProperty !== "hasErrorBoundary";
    warning(!isPropertyStaticallyDefined, "Route \"" + routeToUpdate.id + "\" has a static property \"" + lazyRouteProperty + "\" " + "defined but its lazy function is also returning a value for this property. " + ("The lazy route property \"" + lazyRouteProperty + "\" will be ignored."));
    if (!isPropertyStaticallyDefined && !immutableRouteKeys.has(lazyRouteProperty)) {
      routeUpdates[lazyRouteProperty] = lazyRoute[lazyRouteProperty];
    }
  }
  // Mutate the route with the provided updates.  Do this first so we pass
  // the updated version to mapRouteProperties
  Object.assign(routeToUpdate, routeUpdates);
  // Mutate the `hasErrorBoundary` property on the route based on the route
  // updates and remove the `lazy` function so we don't resolve the lazy
  // route again.
  Object.assign(routeToUpdate, _extends({}, mapRouteProperties(routeToUpdate), {
    lazy: undefined
  }));
}
// Default implementation of `dataStrategy` which fetches all loaders in parallel
async function defaultDataStrategy(_ref6) {
  let {
    matches
  } = _ref6;
  let matchesToLoad = matches.filter(m => m.shouldLoad);
  let results = await Promise.all(matchesToLoad.map(m => m.resolve()));
  return results.reduce((acc, result, i) => Object.assign(acc, {
    [matchesToLoad[i].route.id]: result
  }), {});
}
async function callDataStrategyImpl(dataStrategyImpl, type, state, request, matchesToLoad, matches, fetcherKey, manifest, mapRouteProperties, requestContext) {
  let loadRouteDefinitionsPromises = matches.map(m => m.route.lazy ? loadLazyRouteModule(m.route, mapRouteProperties, manifest) : undefined);
  let dsMatches = matches.map((match, i) => {
    let loadRoutePromise = loadRouteDefinitionsPromises[i];
    let shouldLoad = matchesToLoad.some(m => m.route.id === match.route.id);
    // `resolve` encapsulates route.lazy(), executing the loader/action,
    // and mapping return values/thrown errors to a `DataStrategyResult`.  Users
    // can pass a callback to take fine-grained control over the execution
    // of the loader/action
    let resolve = async handlerOverride => {
      if (handlerOverride && request.method === "GET" && (match.route.lazy || match.route.loader)) {
        shouldLoad = true;
      }
      return shouldLoad ? callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, requestContext) : Promise.resolve({
        type: ResultType.data,
        result: undefined
      });
    };
    return _extends({}, match, {
      shouldLoad,
      resolve
    });
  });
  // Send all matches here to allow for a middleware-type implementation.
  // handler will be a no-op for unneeded routes and we filter those results
  // back out below.
  let results = await dataStrategyImpl({
    matches: dsMatches,
    request,
    params: matches[0].params,
    fetcherKey,
    context: requestContext
  });
  // Wait for all routes to load here but 'swallow the error since we want
  // it to bubble up from the `await loadRoutePromise` in `callLoaderOrAction` -
  // called from `match.resolve()`
  try {
    await Promise.all(loadRouteDefinitionsPromises);
  } catch (e) {
    // No-op
  }
  return results;
}
// Default logic for calling a loader/action is the user has no specified a dataStrategy
async function callLoaderOrAction(type, request, match, loadRoutePromise, handlerOverride, staticContext) {
  let result;
  let onReject;
  let runHandler = handler => {
    // Setup a promise we can race against so that abort signals short circuit
    let reject;
    // This will never resolve so safe to type it as Promise<DataStrategyResult> to
    // satisfy the function return value
    let abortPromise = new Promise((_, r) => reject = r);
    onReject = () => reject();
    request.signal.addEventListener("abort", onReject);
    let actualHandler = ctx => {
      if (typeof handler !== "function") {
        return Promise.reject(new Error("You cannot call the handler for a route which defines a boolean " + ("\"" + type + "\" [routeId: " + match.route.id + "]")));
      }
      return handler({
        request,
        params: match.params,
        context: staticContext
      }, ...(ctx !== undefined ? [ctx] : []));
    };
    let handlerPromise = (async () => {
      try {
        let val = await (handlerOverride ? handlerOverride(ctx => actualHandler(ctx)) : actualHandler());
        return {
          type: "data",
          result: val
        };
      } catch (e) {
        return {
          type: "error",
          result: e
        };
      }
    })();
    return Promise.race([handlerPromise, abortPromise]);
  };
  try {
    let handler = match.route[type];
    // If we have a route.lazy promise, await that first
    if (loadRoutePromise) {
      if (handler) {
        // Run statically defined handler in parallel with lazy()
        let handlerError;
        let [value] = await Promise.all([
        // If the handler throws, don't let it immediately bubble out,
        // since we need to let the lazy() execution finish so we know if this
        // route has a boundary that can handle the error
        runHandler(handler).catch(e => {
          handlerError = e;
        }), loadRoutePromise]);
        if (handlerError !== undefined) {
          throw handlerError;
        }
        result = value;
      } else {
        // Load lazy route module, then run any returned handler
        await loadRoutePromise;
        handler = match.route[type];
        if (handler) {
          // Handler still runs even if we got interrupted to maintain consistency
          // with un-abortable behavior of handler execution on non-lazy or
          // previously-lazy-loaded routes
          result = await runHandler(handler);
        } else if (type === "action") {
          let url = new URL(request.url);
          let pathname = url.pathname + url.search;
          throw getInternalRouterError(405, {
            method: request.method,
            pathname,
            routeId: match.route.id
          });
        } else {
          // lazy() route has no loader to run.  Short circuit here so we don't
          // hit the invariant below that errors on returning undefined.
          return {
            type: ResultType.data,
            result: undefined
          };
        }
      }
    } else if (!handler) {
      let url = new URL(request.url);
      let pathname = url.pathname + url.search;
      throw getInternalRouterError(404, {
        pathname
      });
    } else {
      result = await runHandler(handler);
    }
    invariant(result.result !== undefined, "You defined " + (type === "action" ? "an action" : "a loader") + " for route " + ("\"" + match.route.id + "\" but didn't return anything from your `" + type + "` ") + "function. Please return a value or `null`.");
  } catch (e) {
    // We should already be catching and converting normal handler executions to
    // DataStrategyResults and returning them, so anything that throws here is an
    // unexpected error we still need to wrap
    return {
      type: ResultType.error,
      result: e
    };
  } finally {
    if (onReject) {
      request.signal.removeEventListener("abort", onReject);
    }
  }
  return result;
}
async function convertDataStrategyResultToDataResult(dataStrategyResult) {
  let {
    result,
    type
  } = dataStrategyResult;
  if (isResponse(result)) {
    let data;
    try {
      let contentType = result.headers.get("Content-Type");
      // Check between word boundaries instead of startsWith() due to the last
      // paragraph of https://httpwg.org/specs/rfc9110.html#field.content-type
      if (contentType && /\bapplication\/json\b/.test(contentType)) {
        if (result.body == null) {
          data = null;
        } else {
          data = await result.json();
        }
      } else {
        data = await result.text();
      }
    } catch (e) {
      return {
        type: ResultType.error,
        error: e
      };
    }
    if (type === ResultType.error) {
      return {
        type: ResultType.error,
        error: new ErrorResponseImpl(result.status, result.statusText, data),
        statusCode: result.status,
        headers: result.headers
      };
    }
    return {
      type: ResultType.data,
      data,
      statusCode: result.status,
      headers: result.headers
    };
  }
  if (type === ResultType.error) {
    if (isDataWithResponseInit(result)) {
      var _result$init2;
      if (result.data instanceof Error) {
        var _result$init;
        return {
          type: ResultType.error,
          error: result.data,
          statusCode: (_result$init = result.init) == null ? void 0 : _result$init.status
        };
      }
      // Convert thrown unstable_data() to ErrorResponse instances
      result = new ErrorResponseImpl(((_result$init2 = result.init) == null ? void 0 : _result$init2.status) || 500, undefined, result.data);
    }
    return {
      type: ResultType.error,
      error: result,
      statusCode: isRouteErrorResponse(result) ? result.status : undefined
    };
  }
  if (isDeferredData(result)) {
    var _result$init3, _result$init4;
    return {
      type: ResultType.deferred,
      deferredData: result,
      statusCode: (_result$init3 = result.init) == null ? void 0 : _result$init3.status,
      headers: ((_result$init4 = result.init) == null ? void 0 : _result$init4.headers) && new Headers(result.init.headers)
    };
  }
  if (isDataWithResponseInit(result)) {
    var _result$init5, _result$init6;
    return {
      type: ResultType.data,
      data: result.data,
      statusCode: (_result$init5 = result.init) == null ? void 0 : _result$init5.status,
      headers: (_result$init6 = result.init) != null && _result$init6.headers ? new Headers(result.init.headers) : undefined
    };
  }
  return {
    type: ResultType.data,
    data: result
  };
}
// Support relative routing in internal redirects
function normalizeRelativeRoutingRedirectResponse(response, request, routeId, matches, basename, v7_relativeSplatPath) {
  let location = response.headers.get("Location");
  invariant(location, "Redirects returned/thrown from loaders/actions must have a Location header");
  if (!ABSOLUTE_URL_REGEX.test(location)) {
    let trimmedMatches = matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1);
    location = normalizeTo(new URL(request.url), trimmedMatches, basename, true, location, v7_relativeSplatPath);
    response.headers.set("Location", location);
  }
  return response;
}
function normalizeRedirectLocation(location, currentUrl, basename) {
  if (ABSOLUTE_URL_REGEX.test(location)) {
    // Strip off the protocol+origin for same-origin + same-basename absolute redirects
    let normalizedLocation = location;
    let url = normalizedLocation.startsWith("//") ? new URL(currentUrl.protocol + normalizedLocation) : new URL(normalizedLocation);
    let isSameBasename = stripBasename(url.pathname, basename) != null;
    if (url.origin === currentUrl.origin && isSameBasename) {
      return url.pathname + url.search + url.hash;
    }
  }
  return location;
}
// Utility method for creating the Request instances for loaders/actions during
// client-side navigations and fetches.  During SSR we will always have a
// Request instance from the static handler (query/queryRoute)
function createClientSideRequest(history, location, signal, submission) {
  let url = history.createURL(stripHashFromPath(location)).toString();
  let init = {
    signal
  };
  if (submission && isMutationMethod(submission.formMethod)) {
    let {
      formMethod,
      formEncType
    } = submission;
    // Didn't think we needed this but it turns out unlike other methods, patch
    // won't be properly normalized to uppercase and results in a 405 error.
    // See: https://fetch.spec.whatwg.org/#concept-method
    init.method = formMethod.toUpperCase();
    if (formEncType === "application/json") {
      init.headers = new Headers({
        "Content-Type": formEncType
      });
      init.body = JSON.stringify(submission.json);
    } else if (formEncType === "text/plain") {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.text;
    } else if (formEncType === "application/x-www-form-urlencoded" && submission.formData) {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = convertFormDataToSearchParams(submission.formData);
    } else {
      // Content-Type is inferred (https://fetch.spec.whatwg.org/#dom-request)
      init.body = submission.formData;
    }
  }
  return new Request(url, init);
}
function convertFormDataToSearchParams(formData) {
  let searchParams = new URLSearchParams();
  for (let [key, value] of formData.entries()) {
    // https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#converting-an-entry-list-to-a-list-of-name-value-pairs
    searchParams.append(key, typeof value === "string" ? value : value.name);
  }
  return searchParams;
}
function convertSearchParamsToFormData(searchParams) {
  let formData = new FormData();
  for (let [key, value] of searchParams.entries()) {
    formData.append(key, value);
  }
  return formData;
}
function processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, skipLoaderErrorBubbling) {
  // Fill in loaderData/errors from our loaders
  let loaderData = {};
  let errors = null;
  let statusCode;
  let foundError = false;
  let loaderHeaders = {};
  let pendingError = pendingActionResult && isErrorResult(pendingActionResult[1]) ? pendingActionResult[1].error : undefined;
  // Process loader results into state.loaderData/state.errors
  matches.forEach(match => {
    if (!(match.route.id in results)) {
      return;
    }
    let id = match.route.id;
    let result = results[id];
    invariant(!isRedirectResult(result), "Cannot handle redirect results in processLoaderData");
    if (isErrorResult(result)) {
      let error = result.error;
      // If we have a pending action error, we report it at the highest-route
      // that throws a loader error, and then clear it out to indicate that
      // it was consumed
      if (pendingError !== undefined) {
        error = pendingError;
        pendingError = undefined;
      }
      errors = errors || {};
      if (skipLoaderErrorBubbling) {
        errors[id] = error;
      } else {
        // Look upwards from the matched route for the closest ancestor error
        // boundary, defaulting to the root match.  Prefer higher error values
        // if lower errors bubble to the same boundary
        let boundaryMatch = findNearestBoundary(matches, id);
        if (errors[boundaryMatch.route.id] == null) {
          errors[boundaryMatch.route.id] = error;
        }
      }
      // Clear our any prior loaderData for the throwing route
      loaderData[id] = undefined;
      // Once we find our first (highest) error, we set the status code and
      // prevent deeper status codes from overriding
      if (!foundError) {
        foundError = true;
        statusCode = isRouteErrorResponse(result.error) ? result.error.status : 500;
      }
      if (result.headers) {
        loaderHeaders[id] = result.headers;
      }
    } else {
      if (isDeferredResult(result)) {
        activeDeferreds.set(id, result.deferredData);
        loaderData[id] = result.deferredData.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode != null && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      } else {
        loaderData[id] = result.data;
        // Error status codes always override success status codes, but if all
        // loaders are successful we take the deepest status code.
        if (result.statusCode && result.statusCode !== 200 && !foundError) {
          statusCode = result.statusCode;
        }
        if (result.headers) {
          loaderHeaders[id] = result.headers;
        }
      }
    }
  });
  // If we didn't consume the pending action error (i.e., all loaders
  // resolved), then consume it here.  Also clear out any loaderData for the
  // throwing route
  if (pendingError !== undefined && pendingActionResult) {
    errors = {
      [pendingActionResult[0]]: pendingError
    };
    loaderData[pendingActionResult[0]] = undefined;
  }
  return {
    loaderData,
    errors,
    statusCode: statusCode || 200,
    loaderHeaders
  };
}
function processLoaderData(state, matches, matchesToLoad, results, pendingActionResult, revalidatingFetchers, fetcherResults, activeDeferreds) {
  let {
    loaderData,
    errors
  } = processRouteLoaderData(matches, results, pendingActionResult, activeDeferreds, false // This method is only called client side so we always want to bubble
  );
  // Process results from our revalidating fetchers
  revalidatingFetchers.forEach(rf => {
    let {
      key,
      match,
      controller
    } = rf;
    let result = fetcherResults[key];
    invariant(result, "Did not find corresponding fetcher result");
    // Process fetcher non-redirect errors
    if (controller && controller.signal.aborted) {
      // Nothing to do for aborted fetchers
      return;
    } else if (isErrorResult(result)) {
      let boundaryMatch = findNearestBoundary(state.matches, match == null ? void 0 : match.route.id);
      if (!(errors && errors[boundaryMatch.route.id])) {
        errors = _extends({}, errors, {
          [boundaryMatch.route.id]: result.error
        });
      }
      state.fetchers.delete(key);
    } else if (isRedirectResult(result)) {
      // Should never get here, redirects should get processed above, but we
      // keep this to type narrow to a success result in the else
      invariant(false, "Unhandled fetcher revalidation redirect");
    } else if (isDeferredResult(result)) {
      // Should never get here, deferred data should be awaited for fetchers
      // in resolveDeferredResults
      invariant(false, "Unhandled fetcher deferred data");
    } else {
      let doneFetcher = getDoneFetcher(result.data);
      state.fetchers.set(key, doneFetcher);
    }
  });
  return {
    loaderData,
    errors
  };
}
function mergeLoaderData(loaderData, newLoaderData, matches, errors) {
  let mergedLoaderData = _extends({}, newLoaderData);
  for (let match of matches) {
    let id = match.route.id;
    if (newLoaderData.hasOwnProperty(id)) {
      if (newLoaderData[id] !== undefined) {
        mergedLoaderData[id] = newLoaderData[id];
      }
    } else if (loaderData[id] !== undefined && match.route.loader) {
      // Preserve existing keys not included in newLoaderData and where a loader
      // wasn't removed by HMR
      mergedLoaderData[id] = loaderData[id];
    }
    if (errors && errors.hasOwnProperty(id)) {
      // Don't keep any loader data below the boundary
      break;
    }
  }
  return mergedLoaderData;
}
function getActionDataForCommit(pendingActionResult) {
  if (!pendingActionResult) {
    return {};
  }
  return isErrorResult(pendingActionResult[1]) ? {
    // Clear out prior actionData on errors
    actionData: {}
  } : {
    actionData: {
      [pendingActionResult[0]]: pendingActionResult[1].data
    }
  };
}
// Find the nearest error boundary, looking upwards from the leaf route (or the
// route specified by routeId) for the closest ancestor error boundary,
// defaulting to the root match
function findNearestBoundary(matches, routeId) {
  let eligibleMatches = routeId ? matches.slice(0, matches.findIndex(m => m.route.id === routeId) + 1) : [...matches];
  return eligibleMatches.reverse().find(m => m.route.hasErrorBoundary === true) || matches[0];
}
function getShortCircuitMatches(routes) {
  // Prefer a root layout route if present, otherwise shim in a route object
  let route = routes.length === 1 ? routes[0] : routes.find(r => r.index || !r.path || r.path === "/") || {
    id: "__shim-error-route__"
  };
  return {
    matches: [{
      params: {},
      pathname: "",
      pathnameBase: "",
      route
    }],
    route
  };
}
function getInternalRouterError(status, _temp5) {
  let {
    pathname,
    routeId,
    method,
    type,
    message
  } = _temp5 === void 0 ? {} : _temp5;
  let statusText = "Unknown Server Error";
  let errorMessage = "Unknown @remix-run/router error";
  if (status === 400) {
    statusText = "Bad Request";
    if (type === "route-discovery") {
      errorMessage = "Unable to match URL \"" + pathname + "\" - the `unstable_patchRoutesOnNavigation()` " + ("function threw the following error:\n" + message);
    } else if (method && pathname && routeId) {
      errorMessage = "You made a " + method + " request to \"" + pathname + "\" but " + ("did not provide a `loader` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (type === "defer-action") {
      errorMessage = "defer() is not supported in actions";
    } else if (type === "invalid-body") {
      errorMessage = "Unable to encode submission body";
    }
  } else if (status === 403) {
    statusText = "Forbidden";
    errorMessage = "Route \"" + routeId + "\" does not match URL \"" + pathname + "\"";
  } else if (status === 404) {
    statusText = "Not Found";
    errorMessage = "No route matches URL \"" + pathname + "\"";
  } else if (status === 405) {
    statusText = "Method Not Allowed";
    if (method && pathname && routeId) {
      errorMessage = "You made a " + method.toUpperCase() + " request to \"" + pathname + "\" but " + ("did not provide an `action` for route \"" + routeId + "\", ") + "so there is no way to handle the request.";
    } else if (method) {
      errorMessage = "Invalid request method \"" + method.toUpperCase() + "\"";
    }
  }
  return new ErrorResponseImpl(status || 500, statusText, new Error(errorMessage), true);
}
// Find any returned redirect errors, starting from the lowest match
function findRedirect(results) {
  let entries = Object.entries(results);
  for (let i = entries.length - 1; i >= 0; i--) {
    let [key, result] = entries[i];
    if (isRedirectResult(result)) {
      return {
        key,
        result
      };
    }
  }
}
function stripHashFromPath(path) {
  let parsedPath = typeof path === "string" ? parsePath(path) : path;
  return createPath(_extends({}, parsedPath, {
    hash: ""
  }));
}
function isHashChangeOnly(a, b) {
  if (a.pathname !== b.pathname || a.search !== b.search) {
    return false;
  }
  if (a.hash === "") {
    // /page -> /page#hash
    return b.hash !== "";
  } else if (a.hash === b.hash) {
    // /page#hash -> /page#hash
    return true;
  } else if (b.hash !== "") {
    // /page#hash -> /page#other
    return true;
  }
  // If the hash is removed the browser will re-perform a request to the server
  // /page#hash -> /page
  return false;
}
function isPromise(val) {
  return typeof val === "object" && val != null && "then" in val;
}
function isDataStrategyResult(result) {
  return result != null && typeof result === "object" && "type" in result && "result" in result && (result.type === ResultType.data || result.type === ResultType.error);
}
function isRedirectDataStrategyResultResult(result) {
  return isResponse(result.result) && redirectStatusCodes.has(result.result.status);
}
function isDeferredResult(result) {
  return result.type === ResultType.deferred;
}
function isErrorResult(result) {
  return result.type === ResultType.error;
}
function isRedirectResult(result) {
  return (result && result.type) === ResultType.redirect;
}
function isDataWithResponseInit(value) {
  return typeof value === "object" && value != null && "type" in value && "data" in value && "init" in value && value.type === "DataWithResponseInit";
}
function isDeferredData(value) {
  let deferred = value;
  return deferred && typeof deferred === "object" && typeof deferred.data === "object" && typeof deferred.subscribe === "function" && typeof deferred.cancel === "function" && typeof deferred.resolveData === "function";
}
function isResponse(value) {
  return value != null && typeof value.status === "number" && typeof value.statusText === "string" && typeof value.headers === "object" && typeof value.body !== "undefined";
}
function isRedirectResponse(result) {
  if (!isResponse(result)) {
    return false;
  }
  let status = result.status;
  let location = result.headers.get("Location");
  return status >= 300 && status <= 399 && location != null;
}
function isValidMethod(method) {
  return validRequestMethods.has(method.toLowerCase());
}
function isMutationMethod(method) {
  return validMutationMethods.has(method.toLowerCase());
}
async function resolveNavigationDeferredResults(matches, results, signal, currentMatches, currentLoaderData) {
  let entries = Object.entries(results);
  for (let index = 0; index < entries.length; index++) {
    let [routeId, result] = entries[index];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    let currentMatch = currentMatches.find(m => m.route.id === match.route.id);
    let isRevalidatingLoader = currentMatch != null && !isNewRouteInstance(currentMatch, match) && (currentLoaderData && currentLoaderData[match.route.id]) !== undefined;
    if (isDeferredResult(result) && isRevalidatingLoader) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      await resolveDeferredData(result, signal, false).then(result => {
        if (result) {
          results[routeId] = result;
        }
      });
    }
  }
}
async function resolveFetcherDeferredResults(matches, results, revalidatingFetchers) {
  for (let index = 0; index < revalidatingFetchers.length; index++) {
    let {
      key,
      routeId,
      controller
    } = revalidatingFetchers[index];
    let result = results[key];
    let match = matches.find(m => (m == null ? void 0 : m.route.id) === routeId);
    // If we don't have a match, then we can have a deferred result to do
    // anything with.  This is for revalidating fetchers where the route was
    // removed during HMR
    if (!match) {
      continue;
    }
    if (isDeferredResult(result)) {
      // Note: we do not have to touch activeDeferreds here since we race them
      // against the signal in resolveDeferredData and they'll get aborted
      // there if needed
      invariant(controller, "Expected an AbortController for revalidating fetcher deferred result");
      await resolveDeferredData(result, controller.signal, true).then(result => {
        if (result) {
          results[key] = result;
        }
      });
    }
  }
}
async function resolveDeferredData(result, signal, unwrap) {
  if (unwrap === void 0) {
    unwrap = false;
  }
  let aborted = await result.deferredData.resolveData(signal);
  if (aborted) {
    return;
  }
  if (unwrap) {
    try {
      return {
        type: ResultType.data,
        data: result.deferredData.unwrappedData
      };
    } catch (e) {
      // Handle any TrackedPromise._error values encountered while unwrapping
      return {
        type: ResultType.error,
        error: e
      };
    }
  }
  return {
    type: ResultType.data,
    data: result.deferredData.data
  };
}
function hasNakedIndexQuery(search) {
  return new URLSearchParams(search).getAll("index").some(v => v === "");
}
function getTargetMatch(matches, location) {
  let search = typeof location === "string" ? parsePath(location).search : location.search;
  if (matches[matches.length - 1].route.index && hasNakedIndexQuery(search || "")) {
    // Return the leaf index route when index is present
    return matches[matches.length - 1];
  }
  // Otherwise grab the deepest "path contributing" match (ignoring index and
  // pathless layout routes)
  let pathMatches = getPathContributingMatches(matches);
  return pathMatches[pathMatches.length - 1];
}
function getSubmissionFromNavigation(navigation) {
  let {
    formMethod,
    formAction,
    formEncType,
    text,
    formData,
    json
  } = navigation;
  if (!formMethod || !formAction || !formEncType) {
    return;
  }
  if (text != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json: undefined,
      text
    };
  } else if (formData != null) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData,
      json: undefined,
      text: undefined
    };
  } else if (json !== undefined) {
    return {
      formMethod,
      formAction,
      formEncType,
      formData: undefined,
      json,
      text: undefined
    };
  }
}
function getLoadingNavigation(location, submission) {
  if (submission) {
    let navigation = {
      state: "loading",
      location,
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text
    };
    return navigation;
  } else {
    let navigation = {
      state: "loading",
      location,
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined
    };
    return navigation;
  }
}
function getSubmittingNavigation(location, submission) {
  let navigation = {
    state: "submitting",
    location,
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text
  };
  return navigation;
}
function getLoadingFetcher(submission, data) {
  if (submission) {
    let fetcher = {
      state: "loading",
      formMethod: submission.formMethod,
      formAction: submission.formAction,
      formEncType: submission.formEncType,
      formData: submission.formData,
      json: submission.json,
      text: submission.text,
      data
    };
    return fetcher;
  } else {
    let fetcher = {
      state: "loading",
      formMethod: undefined,
      formAction: undefined,
      formEncType: undefined,
      formData: undefined,
      json: undefined,
      text: undefined,
      data
    };
    return fetcher;
  }
}
function getSubmittingFetcher(submission, existingFetcher) {
  let fetcher = {
    state: "submitting",
    formMethod: submission.formMethod,
    formAction: submission.formAction,
    formEncType: submission.formEncType,
    formData: submission.formData,
    json: submission.json,
    text: submission.text,
    data: existingFetcher ? existingFetcher.data : undefined
  };
  return fetcher;
}
function getDoneFetcher(data) {
  let fetcher = {
    state: "idle",
    formMethod: undefined,
    formAction: undefined,
    formEncType: undefined,
    formData: undefined,
    json: undefined,
    text: undefined,
    data
  };
  return fetcher;
}
function restoreAppliedTransitions(_window, transitions) {
  try {
    let sessionPositions = _window.sessionStorage.getItem(TRANSITIONS_STORAGE_KEY);
    if (sessionPositions) {
      let json = JSON.parse(sessionPositions);
      for (let [k, v] of Object.entries(json || {})) {
        if (v && Array.isArray(v)) {
          transitions.set(k, new Set(v || []));
        }
      }
    }
  } catch (e) {
    // no-op, use default empty object
  }
}
function persistAppliedTransitions(_window, transitions) {
  if (transitions.size > 0) {
    let json = {};
    for (let [k, v] of transitions) {
      json[k] = [...v];
    }
    try {
      _window.sessionStorage.setItem(TRANSITIONS_STORAGE_KEY, JSON.stringify(json));
    } catch (error) {
      warning(false, "Failed to save applied view transitions in sessionStorage (" + error + ").");
    }
  }
}
//#endregion


//# sourceMappingURL=router.js.map


/***/ }),

/***/ "./src/components/Card/index.jsx":
/*!***************************************!*\
  !*** ./src/components/Card/index.jsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Card({
  cardList,
  cardPlace,
  cardCol
}) {
  const cardListing = card => {
    return card.map((carditem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-cardbody",
        key: index
      }, carditem.iconSvg || carditem.imageurl && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon"
      }, carditem.iconSvg && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
        className: "cw-icon-svg"
      }, carditem.iconSvg), carditem.imageurl && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      })) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
        src: carditem.imageurl,
        className: "cw-img"
      }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-text-wrap"
      }, carditem.heading && (cardPlace === 'starter' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "starter"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)) : (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
        className: "cw-heading"
      }, carditem.heading)), carditem.para && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
        className: "cw-text"
      }, carditem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, carditem.buttonUrl && carditem.buttonText && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "cw-btn"
      }, carditem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "arrow"
      }))), cardPlace === 'starter' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        target: "_blank",
        href: carditem.buttonUrl,
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "preview"
      })))), cardPlace === 'cw-pro' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-icon-two"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "icon"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
        icon: "lock"
      }))));
    });
  };
  const classes = `cw-card ${cardPlace} ${cardCol}`;
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: classes
  }, cardListing(cardList)));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);

/***/ }),

/***/ "./src/components/Heading/index.jsx":
/*!******************************************!*\
  !*** ./src/components/Heading/index.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Heading)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");


function Heading({
  heading,
  buttonText,
  buttonUrl,
  openInNewTab
}) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, heading), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: buttonUrl,
    className: "cw-btn",
    target: openInNewTab ? "_blank" : "_self"
  }, buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "arrow"
  }))));
}

/***/ }),

/***/ "./src/components/Icon/index.jsx":
/*!***************************************!*\
  !*** ./src/components/Icon/index.jsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

const icons = {
  globe: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_336)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665C12.0844 3.94846 13.269 6.90987 13.3333 9.99984C13.269 13.0898 12.0844 16.0512 10 18.3332M10 1.6665C7.9156 3.94846 6.73104 6.90987 6.66667 9.99984C6.73104 13.0898 7.9156 16.0512 10 18.3332M10 1.6665C5.39763 1.6665 1.66667 5.39746 1.66667 9.99984C1.66667 14.6022 5.39763 18.3332 10 18.3332M10 1.6665C14.6024 1.6665 18.3333 5.39746 18.3333 9.99984C18.3333 14.6022 14.6024 18.3332 10 18.3332M2.08335 7.49984H17.9167M2.08334 12.4998H17.9167",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_336"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20"
  })))),
  site: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1212)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.16669 13.5H24.1667M14.1667 13.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1212",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  colorsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1220)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2353_1220)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.66669 16C7.66669 20.6024 11.3976 24.3334 16 24.3334C17.3807 24.3334 18.5 23.2141 18.5 21.8334V21.4167C18.5 21.0297 18.5 20.8362 18.5214 20.6737C18.6691 19.5519 19.5519 18.6691 20.6737 18.5214C20.8362 18.5 21.0297 18.5 21.4167 18.5H21.8334C23.2141 18.5 24.3334 17.3807 24.3334 16C24.3334 11.3976 20.6024 7.66669 16 7.66669C11.3976 7.66669 7.66669 11.3976 7.66669 16Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11.8334 16.8334C12.2936 16.8334 12.6667 16.4603 12.6667 16C12.6667 15.5398 12.2936 15.1667 11.8334 15.1667C11.3731 15.1667 11 15.5398 11 16C11 16.4603 11.3731 16.8334 11.8334 16.8334Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.3334 13.5C19.7936 13.5 20.1667 13.1269 20.1667 12.6667C20.1667 12.2064 19.7936 11.8334 19.3334 11.8334C18.8731 11.8334 18.5 12.2064 18.5 12.6667C18.5 13.1269 18.8731 13.5 19.3334 13.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.3334 12.6667C14.7936 12.6667 15.1667 12.2936 15.1667 11.8334C15.1667 11.3731 14.7936 11 14.3334 11C13.8731 11 13.5 11.3731 13.5 11.8334C13.5 12.2936 13.8731 12.6667 14.3334 12.6667Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1220",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F5B841"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF7830"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2353_1220"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "white",
    transform: "translate(6 6)"
  })))),
  typographysetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1228)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66669 11.8333C9.66669 11.0567 9.66669 10.6685 9.79355 10.3622C9.96271 9.95379 10.2872 9.62934 10.6955 9.46018C11.0018 9.33331 11.3901 9.33331 12.1667 9.33331H20.5C21.2766 9.33331 21.6649 9.33331 21.9712 9.46018C22.3795 9.62934 22.704 9.95379 22.8732 10.3622C23 10.6685 23 11.0567 23 11.8333M13 22.6666H19.6667M14.875 9.33331V22.6666M17.7917 9.33331V22.6666",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1228",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#FF0D76"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#590FB7"
  })))),
  layoutsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1237)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M21.25 15.1667H17.0834M21.25 18.5H17.0834M21.25 11.8333H17.0834M14.1667 8.5L14.1667 23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8017 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8017 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7666 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67885 22.6054 9.43917 22.135C9.16669 21.6002 9.16669 20.9001 9.16669 19.5V12.5C9.16669 11.0999 9.16669 10.3998 9.43917 9.86502C9.67885 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7666 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1237",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#F40076"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#DF98FA"
  })))),
  frontpagesetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1245)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M24.3334 13.5H7.66669M17.6667 20.5833L19.75 18.5L17.6667 16.4167M14.3334 16.4167L12.25 18.5L14.3334 20.5833M7.66669 12.5L7.66669 19.5C7.66669 20.9001 7.66669 21.6002 7.93917 22.135C8.17885 22.6054 8.56131 22.9878 9.03171 23.2275C9.56649 23.5 10.2666 23.5 11.6667 23.5H20.3334C21.7335 23.5 22.4336 23.5 22.9683 23.2275C23.4387 22.9878 23.8212 22.6054 24.0609 22.135C24.3334 21.6002 24.3334 20.9001 24.3334 19.5V12.5C24.3334 11.0999 24.3334 10.3998 24.0609 9.86502C23.8212 9.39462 23.4387 9.01217 22.9683 8.77248C22.4336 8.5 21.7335 8.5 20.3334 8.5L11.6667 8.5C10.2666 8.5 9.56649 8.5 9.03171 8.77248C8.56131 9.01217 8.17885 9.39462 7.93917 9.86502C7.66669 10.3998 7.66669 11.0999 7.66669 12.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1245",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#AFD759"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#00B3CC"
  })))),
  generalsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1253)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M14.1626 22.1426L14.6497 23.2379C14.7944 23.564 15.0307 23.841 15.3298 24.0355C15.629 24.2299 15.9781 24.3334 16.3348 24.3333C16.6916 24.3334 17.0407 24.2299 17.3398 24.0355C17.639 23.841 17.8752 23.564 18.02 23.2379L18.5071 22.1426C18.6804 21.7539 18.9721 21.4298 19.3404 21.2166C19.711 21.0028 20.1398 20.9117 20.5654 20.9564L21.7571 21.0833C22.1118 21.1208 22.4698 21.0546 22.7876 20.8927C23.1055 20.7308 23.3695 20.4802 23.5478 20.1713C23.7263 19.8625 23.8113 19.5085 23.7926 19.1524C23.7738 18.7962 23.6521 18.4531 23.4422 18.1648L22.7367 17.1953C22.4855 16.8476 22.3512 16.429 22.3534 16C22.3533 15.5721 22.4888 15.1553 22.7404 14.8092L23.4459 13.8398C23.6558 13.5514 23.7775 13.2084 23.7963 12.8522C23.815 12.496 23.73 12.1421 23.5515 11.8333C23.3733 11.5243 23.1092 11.2737 22.7913 11.1118C22.4735 10.9499 22.1155 10.8837 21.7608 10.9213L20.5691 11.0481C20.1435 11.0928 19.7148 11.0017 19.3441 10.7879C18.975 10.5735 18.6833 10.2478 18.5108 9.85737L18.02 8.762C17.8752 8.43594 17.639 8.15889 17.3398 7.96446C17.0407 7.77003 16.6916 7.66657 16.3348 7.66663C15.9781 7.66657 15.629 7.77003 15.3298 7.96446C15.0307 8.15889 14.7944 8.43594 14.6497 8.762L14.1626 9.85737C13.9901 10.2478 13.6983 10.5735 13.3293 10.7879C12.9586 11.0017 12.5298 11.0928 12.1043 11.0481L10.9089 10.9213C10.5542 10.8837 10.1962 10.9499 9.87834 11.1118C9.56049 11.2737 9.29643 11.5243 9.11817 11.8333C8.93969 12.1421 8.85466 12.496 8.87339 12.8522C8.89213 13.2084 9.01383 13.5514 9.22373 13.8398L9.92928 14.8092C10.1809 15.1553 10.3164 15.5721 10.3163 16C10.3164 16.4278 10.1809 16.8447 9.92928 17.1907L9.22373 18.1601C9.01383 18.4485 8.89213 18.7916 8.87339 19.1477C8.85466 19.5039 8.93969 19.8578 9.11817 20.1666C9.2966 20.4754 9.5607 20.7259 9.8785 20.8878C10.1963 21.0496 10.5542 21.1159 10.9089 21.0787L12.1006 20.9518C12.5261 20.9071 12.9549 20.9982 13.3256 21.212C13.696 21.4258 13.9891 21.7516 14.1626 22.1426Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M16.3333 18.5C17.7141 18.5 18.8333 17.3807 18.8333 16C18.8333 14.6192 17.7141 13.5 16.3333 13.5C14.9526 13.5 13.8333 14.6192 13.8333 16C13.8333 17.3807 14.9526 18.5 16.3333 18.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1253",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#ED7B84"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  instagramsetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666687",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1262)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1667 7.66663H20.1667C22.8334 7.66663 25 9.83329 25 12.5V19.5C25 20.7818 24.4908 22.0112 23.5844 22.9176C22.678 23.8241 21.4486 24.3333 20.1667 24.3333H13.1667C10.5 24.3333 8.33337 22.1666 8.33337 19.5V12.5C8.33337 11.2181 8.8426 9.9887 9.74902 9.08228C10.6555 8.17585 11.8848 7.66663 13.1667 7.66663ZM13 9.33329C12.2044 9.33329 11.4413 9.64936 10.8787 10.212C10.3161 10.7746 10 11.5376 10 12.3333V19.6666C10 21.325 11.3417 22.6666 13 22.6666H20.3334C21.129 22.6666 21.8921 22.3506 22.4547 21.7879C23.0173 21.2253 23.3334 20.4623 23.3334 19.6666V12.3333C23.3334 10.675 21.9917 9.33329 20.3334 9.33329H13ZM21.0417 10.5833C21.318 10.5833 21.5829 10.693 21.7783 10.8884C21.9736 11.0837 22.0834 11.3487 22.0834 11.625C22.0834 11.9012 21.9736 12.1662 21.7783 12.3615C21.5829 12.5569 21.318 12.6666 21.0417 12.6666C20.7654 12.6666 20.5005 12.5569 20.3051 12.3615C20.1098 12.1662 20 11.9012 20 11.625C20 11.3487 20.1098 11.0837 20.3051 10.8884C20.5005 10.693 20.7654 10.5833 21.0417 10.5833ZM16.6667 11.8333C17.7718 11.8333 18.8316 12.2723 19.613 13.0537C20.3944 13.8351 20.8334 14.8949 20.8334 16C20.8334 17.105 20.3944 18.1648 19.613 18.9462C18.8316 19.7276 17.7718 20.1666 16.6667 20.1666C15.5616 20.1666 14.5018 19.7276 13.7204 18.9462C12.939 18.1648 12.5 17.105 12.5 16C12.5 14.8949 12.939 13.8351 13.7204 13.0537C14.5018 12.2723 15.5616 11.8333 16.6667 11.8333ZM16.6667 13.5C16.0037 13.5 15.3678 13.7634 14.8989 14.2322C14.4301 14.701 14.1667 15.3369 14.1667 16C14.1667 16.663 14.4301 17.2989 14.8989 17.7677C15.3678 18.2366 16.0037 18.5 16.6667 18.5C17.3297 18.5 17.9656 18.2366 18.4345 17.7677C18.9033 17.2989 19.1667 16.663 19.1667 16C19.1667 15.3369 18.9033 14.701 18.4345 14.2322C17.9656 13.7634 17.3297 13.5 16.6667 13.5Z",
    fill: "white"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1262",
    x1: "3.00165",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#E233FF"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#FF6B00"
  })))),
  socialmedia: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "32",
    height: "32",
    viewBox: "0 0 32 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1270)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M13.1583 17.2583L18.85 20.575M18.8417 11.425L13.1583 14.7416M23.5 10.1666C23.5 11.5473 22.3807 12.6666 21 12.6666C19.6193 12.6666 18.5 11.5473 18.5 10.1666C18.5 8.78591 19.6193 7.66663 21 7.66663C22.3807 7.66663 23.5 8.78591 23.5 10.1666ZM13.5 16C13.5 17.3807 12.3807 18.5 11 18.5C9.61929 18.5 8.5 17.3807 8.5 16C8.5 14.6192 9.61929 13.5 11 13.5C12.3807 13.5 13.5 14.6192 13.5 16ZM23.5 21.8333C23.5 23.214 22.3807 24.3333 21 24.3333C19.6193 24.3333 18.5 23.214 18.5 21.8333C18.5 20.4526 19.6193 19.3333 21 19.3333C22.3807 19.3333 23.5 20.4526 23.5 21.8333Z",
    stroke: "white",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1270",
    x1: "2.33496",
    y1: "3.5",
    x2: "29.835",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#2F80ED"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#B2FFDA"
  })))),
  footersetting: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.333374",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2353_1278)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.83337 8.5H8.84171M8.83337 16H8.84171M8.83337 19.75H8.84171M8.83337 12.25H8.84171M12.5834 8.5H12.5917M12.5834 16H12.5917M20.0834 8.5H20.0917M20.0834 16H20.0917M16.3334 8.5H16.3417M16.3334 16H16.3417M16.3334 19.75H16.3417M16.3334 12.25H16.3417M23.8334 8.5H23.8417M23.8334 16H23.8417M23.8334 19.75H23.8417M23.8334 12.25H23.8417M23.8334 23.5H8.83337",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2353_1278",
    x1: "2.66833",
    y1: "3.5",
    x2: "30.1683",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#DF98FA"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#9055FF"
  })))),
  home: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.5 8.80433C2.5 8.3257 2.5 8.08639 2.56169 7.866C2.61633 7.67078 2.70614 7.48716 2.82669 7.32417C2.96278 7.14017 3.15168 6.99324 3.52949 6.69939L9.18141 2.30345C9.47418 2.07574 9.62057 1.96189 9.78221 1.91812C9.92484 1.87951 10.0752 1.87951 10.2178 1.91812C10.3794 1.96189 10.5258 2.07574 10.8186 2.30345L16.4705 6.69939C16.8483 6.99324 17.0372 7.14017 17.1733 7.32417C17.2939 7.48716 17.3837 7.67078 17.4383 7.866C17.5 8.08639 17.5 8.3257 17.5 8.80433V14.8334C17.5 15.7669 17.5 16.2336 17.3183 16.5901C17.1586 16.9037 16.9036 17.1587 16.59 17.3185C16.2335 17.5001 15.7668 17.5001 14.8333 17.5001H5.16667C4.23325 17.5001 3.76654 17.5001 3.41002 17.3185C3.09641 17.1587 2.84144 16.9037 2.68166 16.5901C2.5 16.2336 2.5 15.7669 2.5 14.8334V8.80433Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    stroklinecap: "round",
    strokeLinejoin: "round"
  })),
  freePro: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("g", {
    clipPath: "url(#clip0_2386_343)"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10 1.6665L13 4.6665C15 -0.583496 20.5833 4.99984 15.3333 6.99984L18.3333 9.99984L15.3333 12.9998C13.3333 7.74984 7.75001 13.3332 13 15.3332L10 18.3332L7 15.3332C5 20.5832 -0.583328 14.9998 4.66667 12.9998L1.66667 9.99984L4.66667 6.99984C6.66667 12.2498 12.25 6.6665 7 4.6665L10 1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("clipPath", {
    id: "clip0_2386_343"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  })))),
  offers: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66667 6.6665H6.67501M1.66667 4.33317L1.66667 8.06193C1.66667 8.46958 1.66667 8.67341 1.71272 8.86522C1.75355 9.03528 1.82089 9.19786 1.91227 9.34698C2.01534 9.51517 2.15947 9.6593 2.44772 9.94755L8.83824 16.3381C9.82829 17.3281 10.3233 17.8231 10.8941 18.0086C11.3962 18.1718 11.9371 18.1718 12.4392 18.0086C13.01 17.8231 13.5051 17.3281 14.4951 16.3381L16.3382 14.4949C17.3283 13.5049 17.8233 13.0099 18.0088 12.439C18.1719 11.9369 18.1719 11.3961 18.0088 10.894C17.8233 10.3231 17.3283 9.82812 16.3382 8.83808L9.94772 2.44755C9.65947 2.1593 9.51534 2.01517 9.34715 1.9121C9.19802 1.82072 9.03545 1.75338 8.86539 1.71255C8.67358 1.6665 8.46975 1.6665 8.0621 1.6665L4.33334 1.6665C3.39992 1.6665 2.93321 1.6665 2.57669 1.84816C2.26308 2.00795 2.00812 2.26292 1.84833 2.57652C1.66667 2.93304 1.66667 3.39975 1.66667 4.33317ZM7.08334 6.6665C7.08334 6.89662 6.89679 7.08317 6.66667 7.08317C6.43655 7.08317 6.25001 6.89662 6.25001 6.6665C6.25001 6.43639 6.43655 6.24984 6.66667 6.24984C6.89679 6.24984 7.08334 6.43639 7.08334 6.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plugins: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M18.7883 4.96168C18.7012 4.87428 18.5977 4.80494 18.4837 4.75762C18.3698 4.7103 18.2476 4.68595 18.1242 4.68595C18.0008 4.68595 17.8787 4.7103 17.7647 4.75762C17.6508 4.80494 17.5473 4.87428 17.4602 4.96168L15 7.42184L12.5781 4.99997L15.0406 2.53825C15.2168 2.36213 15.3157 2.12326 15.3157 1.87418C15.3157 1.62511 15.2168 1.38624 15.0406 1.21012C14.8645 1.034 14.6256 0.935059 14.3766 0.935059C14.1275 0.935059 13.8886 1.034 13.7125 1.21012L11.25 3.67184L9.41329 1.83668C9.32608 1.74948 9.22255 1.6803 9.10861 1.63311C8.99467 1.58591 8.87255 1.56162 8.74922 1.56162C8.50015 1.56162 8.26128 1.66056 8.08516 1.83668C7.90904 2.01281 7.8101 2.25168 7.8101 2.50075C7.8101 2.74982 7.90904 2.98869 8.08516 3.16481L8.35938 3.43747L4.44454 7.35465C4.12528 7.67386 3.87203 8.05283 3.69925 8.46992C3.52647 8.88701 3.43754 9.33405 3.43754 9.78551C3.43754 10.237 3.52647 10.684 3.69925 11.1011C3.87203 11.5182 4.12528 11.8972 4.44454 12.2164L5.45079 13.2226L1.83672 16.8367C1.74952 16.9239 1.68034 17.0274 1.63315 17.1414C1.58595 17.2553 1.56166 17.3774 1.56166 17.5007C1.56166 17.6241 1.58595 17.7462 1.63315 17.8601C1.68034 17.9741 1.74952 18.0776 1.83672 18.1648C2.01284 18.3409 2.25172 18.4399 2.50079 18.4399C2.62411 18.4399 2.74624 18.4156 2.86018 18.3684C2.97412 18.3212 3.07764 18.252 3.16485 18.1648L6.77891 14.5507L7.78516 15.557C8.10437 15.8763 8.48334 16.1295 8.90043 16.3023C9.31752 16.4751 9.76456 16.564 10.216 16.564C10.6675 16.564 11.1145 16.4751 11.5316 16.3023C11.9487 16.1295 12.3277 15.8763 12.6469 15.557L16.5625 11.6406L16.8367 11.9156C16.9239 12.0028 17.0275 12.072 17.1414 12.1192C17.2553 12.1664 17.3775 12.1907 17.5008 12.1907C17.6241 12.1907 17.7462 12.1664 17.8602 12.1192C17.9741 12.072 18.0776 12.0028 18.1648 11.9156C18.2521 11.8284 18.3212 11.7249 18.3684 11.6109C18.4156 11.497 18.4399 11.3749 18.4399 11.2515C18.4399 11.1282 18.4156 11.0061 18.3684 10.8921C18.3212 10.7782 18.2521 10.6747 18.1648 10.5875L16.3281 8.74997L18.7906 6.28825C18.8776 6.20102 18.9466 6.09751 18.9936 5.98361C19.0406 5.86972 19.0646 5.74768 19.0644 5.62448C19.0642 5.50128 19.0397 5.37933 18.9923 5.2656C18.9449 5.15187 18.8756 5.0486 18.7883 4.96168ZM11.3195 14.2297C11.1744 14.3748 11.0022 14.49 10.8125 14.5685C10.6229 14.6471 10.4197 14.6875 10.2145 14.6875C10.0092 14.6875 9.80598 14.6471 9.61637 14.5685C9.42676 14.49 9.25448 14.3748 9.10938 14.2297L5.77032 10.8906C5.62516 10.7455 5.51001 10.5732 5.43145 10.3836C5.35288 10.194 5.31245 9.99076 5.31245 9.78551C5.31245 9.58027 5.35288 9.37704 5.43145 9.18742C5.51001 8.99781 5.62516 8.82553 5.77032 8.68043L9.68751 4.76559L15.2344 10.3125L11.3195 14.2297Z",
    fill: "currentColor"
  })),
  license: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M5.41667 16.6665H4.16667C3.24619 16.6665 2.5 15.9203 2.5 14.9998V3.33317C2.5 2.4127 3.24619 1.6665 4.16667 1.6665H15.8333C16.7538 1.6665 17.5 2.4127 17.5 3.33317V14.9998C17.5 15.9203 16.7538 16.6665 15.8333 16.6665H14.5833M10 15.8332C11.3807 15.8332 12.5 14.7139 12.5 13.3332C12.5 11.9525 11.3807 10.8332 10 10.8332C8.61929 10.8332 7.5 11.9525 7.5 13.3332C7.5 14.7139 8.61929 15.8332 10 15.8332ZM10 15.8332L10.0179 15.833L7.35723 18.4936L5.0002 16.1366L7.51638 13.6204M10 15.8332L12.6607 18.4936L15.0177 16.1366L12.5015 13.6204M7.5 4.99984H12.5M5.83333 7.9165H14.1667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrow: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "13",
    height: "10",
    viewBox: "0 0 13 10",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.16669 5H11.8334M11.8334 5L7.83335 1M11.8334 5L7.83335 9",
    stroke: "#6266EA",
    strokeWidth: "1.5",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  youtube: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M9.99996 3.3335C10.7125 3.3335 11.4433 3.35183 12.1516 3.38183L12.9883 3.42183L13.7891 3.46933L14.5391 3.52016L15.2241 3.5735C15.9675 3.63039 16.667 3.94762 17.1996 4.46936C17.7321 4.99111 18.0636 5.68395 18.1358 6.426L18.1691 6.78016L18.2316 7.5385C18.29 8.32433 18.3333 9.181 18.3333 10.0002C18.3333 10.8193 18.29 11.676 18.2316 12.4618L18.1691 13.2202C18.1583 13.3418 18.1475 13.4593 18.1358 13.5743C18.0636 14.3165 17.732 15.0095 17.1992 15.5312C16.6665 16.053 15.9668 16.3701 15.2233 16.4268L14.54 16.4793L13.79 16.531L12.9883 16.5785L12.1516 16.6185C11.4348 16.6496 10.7174 16.6658 9.99996 16.6668C9.28248 16.6658 8.5651 16.6496 7.84829 16.6185L7.01163 16.5785L6.21079 16.531L5.46079 16.4793L4.77579 16.4268C4.03242 16.3699 3.33292 16.0527 2.80035 15.531C2.26779 15.0092 1.93627 14.3164 1.86413 13.5743L1.83079 13.2202L1.76829 12.4618C1.70457 11.6428 1.67066 10.8217 1.66663 10.0002C1.66663 9.181 1.70996 8.32433 1.76829 7.5385L1.83079 6.78016C1.84163 6.6585 1.85246 6.541 1.86413 6.426C1.93624 5.68408 2.26764 4.99134 2.80004 4.46962C3.33243 3.94789 4.03173 3.63058 4.77496 3.5735L5.45913 3.52016L6.20913 3.46933L7.01079 3.42183L7.84746 3.38183C8.56454 3.35069 9.2822 3.33458 9.99996 3.3335ZM8.33329 7.97933V12.021C8.33329 12.406 8.74996 12.646 9.08329 12.4543L12.5833 10.4335C12.6595 10.3897 12.7227 10.3265 12.7667 10.2504C12.8107 10.1744 12.8338 10.088 12.8338 10.0002C12.8338 9.91229 12.8107 9.82596 12.7667 9.74988C12.7227 9.67381 12.6595 9.61067 12.5833 9.56683L9.08329 7.54683C9.00726 7.50293 8.92101 7.47983 8.83321 7.47984C8.74542 7.47986 8.65917 7.50299 8.58315 7.54691C8.50713 7.59083 8.44402 7.654 8.40016 7.73005C8.3563 7.8061 8.33324 7.89237 8.33329 7.98016V7.97933Z",
    fill: "currentColor"
  })),
  support: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.33333 6.66853C8.48016 6.25113 8.76998 5.89917 9.15144 5.67498C9.53291 5.45079 9.98141 5.36884 10.4175 5.44364C10.8536 5.51844 11.2492 5.74517 11.5341 6.08367C11.8191 6.42217 11.975 6.8506 11.9744 7.29306C11.9744 8.54213 10.1008 9.16667 10.1008 9.16667M10.1249 11.6667H10.1333M5.83333 15V16.9463C5.83333 17.3903 5.83333 17.6123 5.92436 17.7263C6.00352 17.8255 6.12356 17.8832 6.25045 17.8831C6.39636 17.8829 6.56973 17.7442 6.91646 17.4668L8.90434 15.8765C9.31043 15.5517 9.51347 15.3892 9.73957 15.2737C9.94017 15.1712 10.1537 15.0963 10.3743 15.051C10.6231 15 10.8831 15 11.4031 15H13.5C14.9001 15 15.6002 15 16.135 14.7275C16.6054 14.4878 16.9878 14.1054 17.2275 13.635C17.5 13.1002 17.5 12.4001 17.5 11V6.5C17.5 5.09987 17.5 4.3998 17.2275 3.86502C16.9878 3.39462 16.6054 3.01217 16.135 2.77248C15.6002 2.5 14.9001 2.5 13.5 2.5H6.5C5.09987 2.5 4.3998 2.5 3.86502 2.77248C3.39462 3.01217 3.01217 3.39462 2.77248 3.86502C2.5 4.3998 2.5 5.09987 2.5 6.5V11.6667C2.5 12.4416 2.5 12.8291 2.58519 13.147C2.81635 14.0098 3.49022 14.6836 4.35295 14.9148C4.67087 15 5.05836 15 5.83333 15Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  doc: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "20",
    height: "20",
    fill: "none"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M3.33337 1.6665H10.8334L16.6667 7.49984V18.3332H3.33337V1.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.8334 1.6665V7.49984H16.6667",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 11.6665H13.3333",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M6.66663 15H9.99996",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round"
  })),
  lock: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "17",
    height: "21",
    viewBox: "0 0 17 21",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.82456 21C2.29061 21 1.83352 20.8042 1.45329 20.4125C1.07305 20.0208 0.882935 19.55 0.882935 19V9C0.882935 8.45 1.07305 7.97917 1.45329 7.5875C1.83352 7.19583 2.29061 7 2.82456 7H3.79538V5C3.79538 3.61667 4.26865 2.4375 5.21519 1.4625C6.16174 0.4875 7.30649 0 8.64945 0C9.99241 0 11.1372 0.4875 12.0837 1.4625C13.0302 2.4375 13.5035 3.61667 13.5035 5V7H14.4743C15.0083 7 15.4654 7.19583 15.8456 7.5875C16.2258 7.97917 16.416 8.45 16.416 9V19C16.416 19.55 16.2258 20.0208 15.8456 20.4125C15.4654 20.8042 15.0083 21 14.4743 21H2.82456ZM2.82456 19H14.4743V9H2.82456V19ZM8.64945 16C9.1834 16 9.64049 15.8042 10.0207 15.4125C10.401 15.0208 10.5911 14.55 10.5911 14C10.5911 13.45 10.401 12.9792 10.0207 12.5875C9.64049 12.1958 9.1834 12 8.64945 12C8.1155 12 7.65841 12.1958 7.27817 12.5875C6.89794 12.9792 6.70782 13.45 6.70782 14C6.70782 14.55 6.89794 15.0208 7.27817 15.4125C7.65841 15.8042 8.1155 16 8.64945 16ZM5.73701 7H11.5619V5C11.5619 4.16667 11.2787 3.45833 10.7124 2.875C10.1461 2.29167 9.45846 2 8.64945 2C7.84044 2 7.15278 2.29167 6.58647 2.875C6.02016 3.45833 5.73701 4.16667 5.73701 5V7Z",
    fill: "#D9D9D9"
  })),
  documentation: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "16",
    height: "20",
    viewBox: "0 0 16 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.66671 9.1665H4.66671M6.33337 12.4998H4.66671M11.3334 5.83317H4.66671M14.6667 5.6665V14.3332C14.6667 15.7333 14.6667 16.4334 14.3942 16.9681C14.1545 17.4385 13.7721 17.821 13.3017 18.0607C12.7669 18.3332 12.0668 18.3332 10.6667 18.3332H5.33337C3.93324 18.3332 3.23318 18.3332 2.6984 18.0607C2.22799 17.821 1.84554 17.4385 1.60586 16.9681C1.33337 16.4334 1.33337 15.7333 1.33337 14.3332V5.6665C1.33337 4.26637 1.33337 3.56631 1.60586 3.03153C1.84554 2.56112 2.22799 2.17867 2.6984 1.93899C3.23318 1.6665 3.93324 1.6665 5.33337 1.6665H10.6667C12.0668 1.6665 12.7669 1.6665 13.3017 1.93899C13.7721 2.17867 14.1545 2.56112 14.3942 3.03153C14.6667 3.56631 14.6667 4.26637 14.6667 5.6665Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  supportTwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "18",
    height: "14",
    viewBox: "0 0 18 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.99996 11.1668C9.23607 11.1668 9.43399 11.087 9.59371 10.9272C9.75343 10.7675 9.83329 10.5696 9.83329 10.3335C9.83329 10.0974 9.75343 9.89947 9.59371 9.73975C9.43399 9.58002 9.23607 9.50016 8.99996 9.50016C8.76385 9.50016 8.56593 9.58002 8.40621 9.73975C8.24649 9.89947 8.16662 10.0974 8.16662 10.3335C8.16662 10.5696 8.24649 10.7675 8.40621 10.9272C8.56593 11.087 8.76385 11.1668 8.99996 11.1668ZM8.99996 7.8335C9.23607 7.8335 9.43399 7.75363 9.59371 7.59391C9.75343 7.43419 9.83329 7.23627 9.83329 7.00016C9.83329 6.76405 9.75343 6.56613 9.59371 6.40641C9.43399 6.24669 9.23607 6.16683 8.99996 6.16683C8.76385 6.16683 8.56593 6.24669 8.40621 6.40641C8.24649 6.56613 8.16662 6.76405 8.16662 7.00016C8.16662 7.23627 8.24649 7.43419 8.40621 7.59391C8.56593 7.75363 8.76385 7.8335 8.99996 7.8335ZM8.99996 4.50016C9.23607 4.50016 9.43399 4.4203 9.59371 4.26058C9.75343 4.10086 9.83329 3.90294 9.83329 3.66683C9.83329 3.43072 9.75343 3.2328 9.59371 3.07308C9.43399 2.91336 9.23607 2.8335 8.99996 2.8335C8.76385 2.8335 8.56593 2.91336 8.40621 3.07308C8.24649 3.2328 8.16662 3.43072 8.16662 3.66683C8.16662 3.90294 8.24649 4.10086 8.40621 4.26058C8.56593 4.4203 8.76385 4.50016 8.99996 4.50016ZM15.6666 13.6668H2.33329C1.87496 13.6668 1.4826 13.5036 1.15621 13.1772C0.82982 12.8509 0.666626 12.4585 0.666626 12.0002V8.66683C1.12496 8.66683 1.51732 8.50363 1.84371 8.17725C2.1701 7.85086 2.33329 7.4585 2.33329 7.00016C2.33329 6.54183 2.1701 6.14947 1.84371 5.82308C1.51732 5.49669 1.12496 5.3335 0.666626 5.3335V2.00016C0.666626 1.54183 0.82982 1.14947 1.15621 0.823079C1.4826 0.496691 1.87496 0.333496 2.33329 0.333496H15.6666C16.125 0.333496 16.5173 0.496691 16.8437 0.823079C17.1701 1.14947 17.3333 1.54183 17.3333 2.00016V5.3335C16.875 5.3335 16.4826 5.49669 16.1562 5.82308C15.8298 6.14947 15.6666 6.54183 15.6666 7.00016C15.6666 7.4585 15.8298 7.85086 16.1562 8.17725C16.4826 8.50363 16.875 8.66683 17.3333 8.66683V12.0002C17.3333 12.4585 17.1701 12.8509 16.8437 13.1772C16.5173 13.5036 16.125 13.6668 15.6666 13.6668ZM15.6666 12.0002V9.87516C15.1527 9.56961 14.7465 9.16336 14.4479 8.65641C14.1493 8.14947 14 7.59738 14 7.00016C14 6.40294 14.1493 5.85086 14.4479 5.34391C14.7465 4.83697 15.1527 4.43072 15.6666 4.12516V2.00016H2.33329V4.12516C2.84718 4.43072 3.25343 4.83697 3.55204 5.34391C3.85065 5.85086 3.99996 6.40294 3.99996 7.00016C3.99996 7.59738 3.85065 8.14947 3.55204 8.65641C3.25343 9.16336 2.84718 9.56961 2.33329 9.87516V12.0002H15.6666Z",
    fill: "#5081f5"
  })),
  video: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "22",
    height: "22",
    viewBox: "0 0 22 22",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M11 21C16.5228 21 21 16.5228 21 11C21 5.47715 16.5228 1 11 1C5.47715 1 1 5.47715 1 11C1 16.5228 5.47715 21 11 21Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.5 7.96533C8.5 7.48805 8.5 7.24941 8.59974 7.11618C8.68666 7.00007 8.81971 6.92744 8.96438 6.9171C9.13038 6.90525 9.33112 7.03429 9.73261 7.29239L14.4532 10.3271C14.8016 10.551 14.9758 10.663 15.0359 10.8054C15.0885 10.9298 15.0885 11.0702 15.0359 11.1946C14.9758 11.337 14.8016 11.449 14.4532 11.6729L9.73261 14.7076C9.33112 14.9657 9.13038 15.0948 8.96438 15.0829C8.81971 15.0726 8.68666 14.9999 8.59974 14.8838C8.5 14.7506 8.5 14.512 8.5 14.0347V7.96533Z",
    stroke: "#F8478D",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  arrowtwo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "8",
    height: "12",
    viewBox: "0 0 8 12",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M1.5 11L6.5 6L1.5 1",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  proLogo: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "36",
    height: "32",
    viewBox: "0 0 36 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg",
    xlink: "http://www.w3.org/1999/xlink"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    width: "36",
    height: "32",
    fill: "url(#pattern0_2414_1329)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("pattern", {
    id: "pattern0_2414_1329",
    patternContentUnits: "objectBoundingBox",
    width: "1",
    height: "1"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("use", {
    href: "#image0_2414_1329",
    transform: "matrix(0.0148148 0 0 0.0166667 -0.0037037 0)"
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("image", {
    id: "image0_2414_1329",
    width: "68",
    height: "60",
    href: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEQAAAA8CAMAAADovOwsAAAAV1BMVEXOc5rbY5HlV4roU4foU4foU4foU4foU4foU4foU4fbT4W0THucS3WMVHiETneKY4aDjaKGtb+Izc+IztCIztCIztCIztCIztB/ZYZ8Q26UR3TKT4DnU4fgu8wDAAAAF3RSTlMAECFFeJKvx97w/P399fz4/v7z6D6GwuxpqwkAAAFiSURBVFjDtZeBeoIwDISpIlBwDhCsxb7/c05pxiqMQtPzHuD/kksouST5V6Lr+9u1Vaqpv7+qhzGyyLP0KJLdEv1NvdTUd00aqtK8lKf7OJ0lqGYiWJ0fI8ZkRzZiLIcwuR8jPIixmpKq8TTVtcS46DVRMXK1mN4iVK09qizFnLytqLv2aiBKLviMJ6Vco+xneGoJYDgUhqcb7nZhjGnSxpm02N6PuchceeAZQrtLpWTzZhodoHlDjEIWE2IVMi+FVcjMFUEMpQNFECPC92y5cSm/mzdr2d24/TBn8z4ftiWuKWxL3CFHQP6cvRLkotnOFknLHs4EkYmKhxgMpI33RMYYO0zGQkYMWTbI2kM+QMhTAHmUMM8j5KGG/DIwPy/IbxTzQ4ecFpgjB3JuYQ4/zAmKOYY3U8ryLC/EZwICJqo4oamOCE074tvvnh4+HSRBkXbExIdrJ+Y/c76N+aU/5v8AY+8/zMsnEUwAAAAASUVORK5CYII="
  }))),
  preview: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "14",
    viewBox: "0 0 20 14",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M2.01677 7.59415C1.90328 7.41445 1.84654 7.3246 1.81477 7.18602C1.79091 7.08192 1.79091 6.91775 1.81477 6.81366C1.84654 6.67507 1.90328 6.58522 2.01677 6.40552C2.95461 4.92054 5.74617 1.1665 10.0003 1.1665C14.2545 1.1665 17.0461 4.92054 17.9839 6.40552C18.0974 6.58522 18.1541 6.67507 18.1859 6.81366C18.2098 6.91775 18.2098 7.08192 18.1859 7.18602C18.1541 7.3246 18.0974 7.41445 17.9839 7.59415C17.0461 9.07914 14.2545 12.8332 10.0003 12.8332C5.74617 12.8332 2.95461 9.07914 2.01677 7.59415Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.0003 9.49984C11.381 9.49984 12.5003 8.38055 12.5003 6.99984C12.5003 5.61913 11.381 4.49984 10.0003 4.49984C8.61962 4.49984 7.50034 5.61913 7.50034 6.99984C7.50034 8.38055 8.61962 9.49984 10.0003 9.49984Z",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  hidePassowrd: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8.95245 4.2436C9.29113 4.19353 9.64051 4.16667 10.0003 4.16667C14.2545 4.16667 17.0461 7.9207 17.9839 9.40569C18.0974 9.58542 18.1542 9.67528 18.1859 9.81389C18.2098 9.91799 18.2098 10.0822 18.1859 10.1863C18.1541 10.3249 18.097 10.4154 17.9827 10.5963C17.7328 10.9918 17.3518 11.5476 16.8471 12.1504M5.6036 5.59586C3.80187 6.81808 2.57871 8.51615 2.01759 9.4044C1.90357 9.58489 1.84656 9.67514 1.81478 9.81373C1.79091 9.91783 1.7909 10.082 1.81476 10.1861C1.84652 10.3247 1.90328 10.4146 2.01678 10.5943C2.95462 12.0793 5.74618 15.8333 10.0003 15.8333C11.7157 15.8333 13.1932 15.223 14.4074 14.3972M2.50035 2.5L17.5003 17.5M8.23258 8.23223C7.78017 8.68464 7.50035 9.30964 7.50035 10C7.50035 11.3807 8.61964 12.5 10.0003 12.5C10.6907 12.5 11.3157 12.2202 11.7681 11.7678",
    stroke: "currentColor",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  minus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#5081f5",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  plus: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "24",
    height: "24",
    viewBox: "0 0 24 24",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M12 8V16M8 12H16M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12Z",
    stroke: "#5081f5",
    strokeWidth: "2",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  })),
  pluginList: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "48",
    height: "48",
    viewBox: "0 0 48 48",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M10.6715 41.615C11.0288 41.2231 11.2158 40.7053 11.1914 40.1756C11.1671 39.6458 10.9333 39.1474 10.5415 38.79C7.15342 35.7059 4.92693 31.5521 4.23437 27.0232C3.54182 22.4943 4.42519 17.8649 6.73675 13.9092C9.04831 9.95354 12.6479 6.91143 16.9336 5.29163C21.2192 3.67182 25.9311 3.57254 30.2812 5.01037C34.6313 6.44821 38.3558 9.33599 40.832 13.1908C43.3081 17.0456 44.3857 21.6336 43.8845 26.1877C43.3834 30.7417 41.3338 34.9857 38.0787 38.2097C34.8235 41.4338 30.5601 43.4426 26.0015 43.9V35.96C28.5768 35.8569 31.0129 34.7635 32.8015 32.9078C34.5902 31.052 35.5932 28.5774 35.6015 26V22C35.6015 21.4696 35.3908 20.9609 35.0157 20.5858C34.6406 20.2107 34.1319 20 33.6015 20H30.0015V14C30.0015 13.4696 29.7908 12.9609 29.4157 12.5858C29.0406 12.2107 28.5319 12 28.0015 12C27.4711 12 26.9623 12.2107 26.5873 12.5858C26.2122 12.9609 26.0015 13.4696 26.0015 14V20H22.0015V14C22.0015 13.4696 21.7908 12.9609 21.4157 12.5858C21.0406 12.2107 20.5319 12 20.0015 12C19.4711 12 18.9623 12.2107 18.5873 12.5858C18.2122 12.9609 18.0015 13.4696 18.0015 14V20H14.4015C13.8711 20 13.3623 20.2107 12.9873 20.5858C12.6122 20.9609 12.4015 21.4696 12.4015 22V26C12.4097 28.5774 13.4128 31.052 15.2014 32.9078C16.9901 34.7635 19.4262 35.8569 22.0015 35.96V46C22.0015 46.5304 22.2122 47.0391 22.5873 47.4142C22.9623 47.7893 23.4711 48 24.0015 48C29.6024 47.9997 35.0269 46.0404 39.3353 42.4616C43.6437 38.8827 46.5648 33.9097 47.5925 28.4039C48.6203 22.8981 47.69 17.2061 44.9628 12.314C42.2356 7.42186 37.8833 3.63762 32.6596 1.61671C27.436 -0.404199 21.67 -0.534496 16.3604 1.24839C11.0508 3.03127 6.53197 6.61504 3.58657 11.379C0.641169 16.1429 -0.545284 21.787 0.232704 27.3337C1.01069 32.8803 3.70412 37.9802 7.84649 41.75C8.23903 42.1067 8.75717 42.2928 9.28694 42.2675C9.81672 42.2422 10.3148 42.0075 10.6715 41.615ZM16.4015 26V24H31.6015V26C31.6015 27.5913 30.9693 29.1174 29.8441 30.2426C28.7189 31.3679 27.1928 32 25.6015 32H22.4015C20.8102 32 19.2841 31.3679 18.1588 30.2426C17.0336 29.1174 16.4015 27.5913 16.4015 26Z",
    fill: "#5081f5"
  })),
  sidebar: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "33",
    height: "32",
    viewBox: "0 0 33 32",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("rect", {
    x: "0.666672",
    width: "32",
    height: "32",
    rx: "8",
    fill: "url(#paint0_linear_2820_689)"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M19.1667 8.5V23.5M13.1667 8.5H20.1667C21.5668 8.5 22.2669 8.5 22.8016 8.77248C23.2721 9.01217 23.6545 9.39462 23.8942 9.86502C24.1667 10.3998 24.1667 11.0999 24.1667 12.5V19.5C24.1667 20.9001 24.1667 21.6002 23.8942 22.135C23.6545 22.6054 23.2721 22.9878 22.8016 23.2275C22.2669 23.5 21.5668 23.5 20.1667 23.5H13.1667C11.7665 23.5 11.0665 23.5 10.5317 23.2275C10.0613 22.9878 9.67884 22.6054 9.43916 22.135C9.16667 21.6002 9.16667 20.9001 9.16667 19.5V12.5C9.16667 11.0999 9.16667 10.3998 9.43916 9.86502C9.67884 9.39462 10.0613 9.01217 10.5317 8.77248C11.0665 8.5 11.7665 8.5 13.1667 8.5Z",
    stroke: "white",
    strokeWidth: "1.67",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("defs", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("linearGradient", {
    id: "paint0_linear_2820_689",
    x1: "3.00163",
    y1: "3.5",
    x2: "30.5016",
    y2: "30",
    gradientUnits: "userSpaceOnUse"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    stopColor: "#5081F5"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("stop", {
    offset: "1",
    stopColor: "#A769F5"
  })))),
  star: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "116",
    height: "20",
    viewBox: "0 0 116 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M9.14319 1.42372C9.53185 0.777902 10.4681 0.777901 10.8568 1.42372L13.0731 5.10651C13.2128 5.33853 13.4405 5.504 13.7043 5.56509L17.8918 6.53491C18.6261 6.70498 18.9154 7.59545 18.4213 8.16466L15.6036 11.4106C15.4261 11.6151 15.3391 11.8828 15.3625 12.1526L15.7342 16.4347C15.7994 17.1857 15.0419 17.736 14.3478 17.442L10.3901 15.7653C10.1408 15.6596 9.85924 15.6596 9.60991 15.7653L5.65216 17.442C4.95813 17.736 4.20065 17.1857 4.26582 16.4347L4.63745 12.1526C4.66087 11.8828 4.57387 11.6151 4.39637 11.4106L1.57871 8.16466C1.0846 7.59545 1.37393 6.70498 2.10824 6.53491L6.29567 5.56509C6.55948 5.504 6.78723 5.33853 6.92685 5.10652L9.14319 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M33.1432 1.42372C33.5319 0.777902 34.4681 0.777901 34.8568 1.42372L37.0731 5.10651C37.2128 5.33853 37.4405 5.504 37.7043 5.56509L41.8918 6.53491C42.6261 6.70498 42.9154 7.59545 42.4213 8.16466L39.6036 11.4106C39.4261 11.6151 39.3391 11.8828 39.3625 12.1526L39.7342 16.4347C39.7994 17.1857 39.0419 17.736 38.3478 17.442L34.3901 15.7653C34.1408 15.6596 33.8592 15.6596 33.6099 15.7653L29.6522 17.442C28.9581 17.736 28.2006 17.1857 28.2658 16.4347L28.6375 12.1526C28.6609 11.8828 28.5739 11.6151 28.3964 11.4106L25.5787 8.16466C25.0846 7.59545 25.3739 6.70498 26.1082 6.53491L30.2957 5.56509C30.5595 5.504 30.7872 5.33853 30.9269 5.10652L33.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M57.1432 1.42372C57.5319 0.777902 58.4681 0.777901 58.8568 1.42372L61.0731 5.10651C61.2128 5.33853 61.4405 5.504 61.7043 5.56509L65.8918 6.53491C66.6261 6.70498 66.9154 7.59545 66.4213 8.16466L63.6036 11.4106C63.4261 11.6151 63.3391 11.8828 63.3625 12.1526L63.7342 16.4347C63.7994 17.1857 63.0419 17.736 62.3478 17.442L58.3901 15.7653C58.1408 15.6596 57.8592 15.6596 57.6099 15.7653L53.6522 17.442C52.9581 17.736 52.2006 17.1857 52.2658 16.4347L52.6375 12.1526C52.6609 11.8828 52.5739 11.6151 52.3964 11.4106L49.5787 8.16466C49.0846 7.59545 49.3739 6.70498 50.1082 6.53491L54.2957 5.56509C54.5595 5.504 54.7872 5.33853 54.9269 5.10652L57.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M81.1432 1.42372C81.5319 0.777902 82.4681 0.777901 82.8568 1.42372L85.0731 5.10651C85.2128 5.33853 85.4405 5.504 85.7043 5.56509L89.8918 6.53491C90.6261 6.70498 90.9154 7.59545 90.4213 8.16466L87.6036 11.4106C87.4261 11.6151 87.3391 11.8828 87.3625 12.1526L87.7342 16.4347C87.7994 17.1857 87.0419 17.736 86.3478 17.442L82.3901 15.7653C82.1408 15.6596 81.8592 15.6596 81.6099 15.7653L77.6522 17.442C76.9581 17.736 76.2006 17.1857 76.2658 16.4347L76.6375 12.1526C76.6609 11.8828 76.5739 11.6151 76.3964 11.4106L73.5787 8.16466C73.0846 7.59545 73.3739 6.70498 74.1082 6.53491L78.2957 5.56509C78.5595 5.504 78.7872 5.33853 78.9269 5.10652L81.1432 1.42372Z",
    fill: "#F9B83A"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M105.143 1.42372C105.532 0.777902 106.468 0.777901 106.857 1.42372L109.073 5.10651C109.213 5.33853 109.441 5.504 109.704 5.56509L113.892 6.53491C114.626 6.70498 114.915 7.59545 114.421 8.16466L111.604 11.4106C111.426 11.6151 111.339 11.8828 111.363 12.1526L111.734 16.4347C111.799 17.1857 111.042 17.736 110.348 17.442L106.39 15.7653C106.141 15.6596 105.859 15.6596 105.61 15.7653L101.652 17.442C100.958 17.736 100.201 17.1857 100.266 16.4347L100.637 12.1526C100.661 11.8828 100.574 11.6151 100.396 11.4106L97.5787 8.16466C97.0846 7.59545 97.3739 6.70498 98.1082 6.53491L102.296 5.56509C102.559 5.504 102.787 5.33853 102.927 5.10652L105.143 1.42372Z",
    fill: "#F9B83A"
  })),
  review: () => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("svg", {
    width: "20",
    height: "20",
    viewBox: "0 0 20 20",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("path", {
    d: "M7.56246 11.8748L9.99996 10.3957L12.4375 11.8748L11.7916 9.104L13.9583 7.229L11.1041 6.99984L9.99996 4.37484L8.89579 6.99984L6.04163 7.229L8.20829 9.104L7.56246 11.8748ZM1.66663 18.3332V3.33317C1.66663 2.87484 1.82996 2.48262 2.15663 2.1565C2.48329 1.83039 2.87551 1.66706 3.33329 1.6665H16.6666C17.125 1.6665 17.5175 1.82984 17.8441 2.1565C18.1708 2.48317 18.3338 2.87539 18.3333 3.33317V13.3332C18.3333 13.7915 18.1702 14.184 17.8441 14.5107C17.518 14.8373 17.1255 15.0004 16.6666 14.9998H4.99996L1.66663 18.3332ZM4.29163 13.3332H16.6666V3.33317H3.33329V14.2707L4.29163 13.3332Z",
    fill: "currentColor"
  }))
};
const Icon = ({
  icon,
  tooltip,
  label
}) => {
  const Icon = icons[icon];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, Icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(Icon, null), label && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", {
    className: "cwLabel"
  }, label), tooltip && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "cw-tooltip"
  }, tooltip));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);

/***/ }),

/***/ "./src/components/Sidebar/index.jsx":
/*!******************************************!*\
  !*** ./src/components/Sidebar/index.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon */ "./src/components/Icon/index.jsx");



const Sidebar = ({
  sidebarSettings,
  openInNewTab
}) => {
  const sidebarListing = sidebar => {
    return sidebar.map((sidebaritem, index) => {
      return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-sidebarbody",
        key: index
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, sidebaritem.heading), sidebaritem.icon && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: sidebaritem.icon
      })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, sidebaritem.para), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
        className: "cw-button"
      }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
        href: sidebaritem.buttonUrl,
        target: openInNewTab ? "_blank" : "_self",
        className: "cw-button-btn outline"
      }, sidebaritem.imageurl, sidebaritem.buttonText, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Icon__WEBPACK_IMPORTED_MODULE_1__["default"], {
        icon: "arrowtwo"
      }))));
    });
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-sidebar-list"
  }, sidebarListing(sidebarSettings))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sidebar);

/***/ }),

/***/ "./src/components/TabHeader/index.jsx":
/*!********************************************!*\
  !*** ./src/components/TabHeader/index.jsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const TabHeader = ({
  title
}) => {
  const docLinks = [{
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Website', 'spa-and-salon'),
    link: cw_dashboard.website,
    icon: "globe"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('View Tutorials ', 'spa-and-salon'),
    link: cw_dashboard.videotutorial,
    icon: "youtube"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Contact Support', 'spa-and-salon'),
    link: cw_dashboard.support,
    icon: "support"
  }, {
    name: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Docs', 'spa-and-salon'),
    link: cw_dashboard.docmentation,
    icon: "doc"
  }];
  const docLinkListing = () => {
    return docLinks.map((list, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      key: index,
      href: list.link,
      target: "_blank"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: list.icon,
      tooltip: list.name
    })));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("header", {
    className: "navbar"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h1", null, title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "info"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", {
    className: "version"
  }, cw_dashboard.theme_version), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "doc-links"
  }, docLinkListing()))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TabHeader);

/***/ }),

/***/ "./src/components/Tab/index.jsx":
/*!**************************************!*\
  !*** ./src/components/Tab/index.jsx ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useTabs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useTabs */ "./src/components/Tab/useTabs.jsx");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! .. */ "./src/components/index.js");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);





const Tab = ({
  tabsData,
  onChange,
  activeTabTitle
}) => {
  const {
    renderTabs,
    renderContent
  } = (0,_useTabs__WEBPACK_IMPORTED_MODULE_1__["default"])(tabsData, 0, onChange);
  const GetPro = () => {
    return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
      className: "get-pro"
    }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
      src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
      alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'spa-and-salon')
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h3", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Spa And Salon Pro', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get access to all unlimited features.', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      className: "cw-button-btn primary-btn",
      target: "_blank",
      href: cw_dashboard.get_pro
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Get Pro', 'spa-and-salon'))));
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-container"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "top"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "logo"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_3__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__.__)('Logo', 'spa-and-salon')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, cw_dashboard.blog_name)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-button"
  }, renderTabs())), GetPro())), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(___WEBPACK_IMPORTED_MODULE_2__.TabHeader, {
    title: activeTabTitle
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-tabs-content"
  }, renderContent())));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tab);

/***/ }),

/***/ "./src/components/Tab/useTabs.jsx":
/*!****************************************!*\
  !*** ./src/components/Tab/useTabs.jsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/dist/index.js");



function useTabs(initialTabs, initialActiveTab = 0, onChange) {
  const tabsRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(initialTabs);
  const [activeTab, setActiveTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialActiveTab);
  const navigate = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useNavigate)();
  const handleTabClick = index => {
    if (index !== activeTab) {
      setActiveTab(index);
      const newHash = tabsRef.current[index].title.toLowerCase().replace(/ /g, "-");
      if (onChange) {
        onChange(tabsRef.current[index].title);
      }
      navigate(`/wp-admin/admin.php?page=spa-and-salon-dashboard#${newHash}`);
    }
  };
  const checkHash = () => {
    const hash = window.location.hash.substring(1);
    const tabIndex = tabsRef.current.findIndex(tab => tab.title.toLowerCase().replace(/ /g, "-") === hash);
    if (tabIndex !== -1 && tabIndex !== activeTab) {
      setActiveTab(tabIndex);
      if (onChange) {
        onChange(tabsRef.current[tabIndex].title);
      }
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    checkHash();
    window.addEventListener('hashchange', checkHash);
    return () => {
      window.removeEventListener('hashchange', checkHash);
    };
  }, []);
  const renderTabs = () => {
    return tabsRef.current.map((tab, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
      key: index,
      onClick: () => handleTabClick(index),
      className: activeTab === index ? 'active-tab' : ''
    }, tab.icon, tab.title));
  };
  const renderContent = () => {
    return tabsRef.current[activeTab].content;
  };
  return {
    renderTabs,
    renderContent
  };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useTabs);

/***/ }),

/***/ "./src/components/images.js":
/*!**********************************!*\
  !*** ./src/components/images.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   demo2: () => (/* reexport default export from named module */ _assets_img_demo2_webp__WEBPACK_IMPORTED_MODULE_9__),
/* harmony export */   demo3: () => (/* reexport default export from named module */ _assets_img_demo3_webp__WEBPACK_IMPORTED_MODULE_10__),
/* harmony export */   freevspro: () => (/* reexport default export from named module */ _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_0__),
/* harmony export */   gdpr: () => (/* reexport default export from named module */ _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_1__),
/* harmony export */   logo: () => (/* reexport default export from named module */ _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_2__),
/* harmony export */   mainDemo: () => (/* reexport default export from named module */ _assets_img_mainDemo_webp__WEBPACK_IMPORTED_MODULE_8__),
/* harmony export */   pluginsSetup: () => (/* reexport default export from named module */ _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_3__),
/* harmony export */   seo: () => (/* reexport default export from named module */ _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_4__),
/* harmony export */   themeClub: () => (/* reexport default export from named module */ _assets_img_themeClub_webp__WEBPACK_IMPORTED_MODULE_5__),
/* harmony export */   themeInstallation: () => (/* reexport default export from named module */ _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_6__),
/* harmony export */   vipSupport: () => (/* reexport default export from named module */ _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_7__)
/* harmony export */ });
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _assets_img_GDPR_jpg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../assets/img/GDPR.jpg */ "./src/assets/img/GDPR.jpg");
/* harmony import */ var _assets_img_logo_png__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../assets/img/logo.png */ "./src/assets/img/logo.png");
/* harmony import */ var _assets_img_pluginsSetup_jpg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../assets/img/pluginsSetup.jpg */ "./src/assets/img/pluginsSetup.jpg");
/* harmony import */ var _assets_img_SEO_jpg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../assets/img/SEO.jpg */ "./src/assets/img/SEO.jpg");
/* harmony import */ var _assets_img_themeClub_webp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../assets/img/themeClub.webp */ "./src/assets/img/themeClub.webp");
/* harmony import */ var _assets_img_themeInstallation_jpg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../assets/img/themeInstallation.jpg */ "./src/assets/img/themeInstallation.jpg");
/* harmony import */ var _assets_img_vipSupport_jpg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../assets/img/vipSupport.jpg */ "./src/assets/img/vipSupport.jpg");
/* harmony import */ var _assets_img_mainDemo_webp__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../assets/img/mainDemo.webp */ "./src/assets/img/mainDemo.webp");
/* harmony import */ var _assets_img_demo2_webp__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../assets/img/demo2.webp */ "./src/assets/img/demo2.webp");
/* harmony import */ var _assets_img_demo3_webp__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../assets/img/demo3.webp */ "./src/assets/img/demo3.webp");












/***/ }),

/***/ "./src/components/index.js":
/*!*********************************!*\
  !*** ./src/components/index.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: () => (/* reexport safe */ _Card__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   Heading: () => (/* reexport safe */ _Heading__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   Icon: () => (/* reexport safe */ _Icon__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Sidebar: () => (/* reexport safe */ _Sidebar__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   Tab: () => (/* reexport safe */ _Tab__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   TabHeader: () => (/* reexport safe */ _TabHeader__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _Icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Icon */ "./src/components/Icon/index.jsx");
/* harmony import */ var _Tab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Tab */ "./src/components/Tab/index.jsx");
/* harmony import */ var _Sidebar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Sidebar */ "./src/components/Sidebar/index.jsx");
/* harmony import */ var _TabHeader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TabHeader */ "./src/components/TabHeader/index.jsx");
/* harmony import */ var _Card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Card */ "./src/components/Card/index.jsx");
/* harmony import */ var _Heading__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Heading */ "./src/components/Heading/index.jsx");







/***/ }),

/***/ "./src/pages/FAQ/index.jsx":
/*!*********************************!*\
  !*** ./src/pages/FAQ/index.jsx ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");




function FAQ() {
  const faqContent = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What is the difference between Free and Pro?', 'spa-and-salon'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Both the Free and Pro version of the themes are coded well and are developed with best coding practices. However, the Pro version of the theme comes with extended features and dedicated support team to help you solve your queries. The Pro theme comes with multiple layouts to help you create a unique and attractive website. Also, the Pro themes are fully compatible with Polylang and WPML plugin to help you create a multilingual blog and get wide reach.')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Overall, you will have more control over the customization and editing of your website with the Pro version.', 'spa-and-salon')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('What are the perks of upgrading to the Premium version?', 'spa-and-salon'),
    description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Along with the additional features and regular updates, you get dedicated and quick support with the premium theme. If you run into any issue while creating a website with the premium theme, you will get a quicker response compared to the free support.', 'spa-and-salon')
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Upgrading to the Pro version- will I lose my changes?', 'spa-and-salon'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('When you upgrade to the Pro theme, your posts, pages, media, categories, and other data will remain intact-- all your data is saved.', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('However, since the Pro version comes with added features and settings, you will need to set up the additional features in the customizer. This process is simple and only takes a few minutes.', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('The Pro version is built with lots of flexibility in mind for future upgrades. Therefore, it is slightly different than the free theme but extremely flexible and easy-to-use.', 'spa-and-salon')))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How do I change the copyright text?', 'spa-and-salon'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('You can change the copyright text going to %1$s Appearance > Customize > Footer Settings. %2$s However, if you want to hide the author credit text, please %3$s.', 'spa-and-salon'), '<b>', '</b>', `<a target="_blank" href=${cw_dashboard.get_pro}>upgrade to the Pro version</a>`)
      }
    })
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Why is my theme not working well?', 'spa-and-salon'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If your customizer is not loading properly or you are having issues with the theme, it might be due to the plugin conflict.', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('To solve the issue, deactivate all the plugins first, except the ones recommended by the theme. Then, hard reload your website using %1$s "Ctrl+Shift+R" %2$s on Windows and %1$s "Cmd+Shift+R" %2$s on Mac. If the issues are fixed, start activating the plugins one by one, and reload and check your site each time. This will help you find out the plugin that is causing the problem.', 'spa-and-salon'), '<b>', '</b>')
      }
    }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
      dangerouslySetInnerHTML: {
        __html: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.sprintf)((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('If this didn\'t help, please contact us via our %s', 'spa-and-salon'), `<a target="_blank" href=${cw_dashboard.support}>Support Ticket.</a>`)
      }
    }))
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('How can I solve my issues quickly and get faster support?', 'spa-and-salon'),
    description: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Please ensure that you have updated to the latest version of the theme before you submit a support ticket for any issue. We might have already fixed the bug in the previous theme update.', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Also, when you submit the support ticket, please try to provide maximum details so that we can look into your issue in detail and solve it in minimum time. We recommend you to send us a screenshot(s) with issues explained and your website\'s address (URL). You can contact us ', 'spa-and-salon'), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
      href: cw_dashboard.support,
      target: "_blank"
    }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('here.', 'spa-and-salon'))))
  }];
  const [openIndex, setOpenIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
  const [height, setHeight] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('0px');
  const contentRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    setHeight(openIndex !== -1 ? `${contentRef.current.scrollHeight}px` : '0px');
  }, [openIndex]);
  const toggleDescription = index => {
    setOpenIndex(index === openIndex ? -1 : index);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, faqContent.map((content, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-item",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-title",
    onClick: () => toggleDescription(index)
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, content.title), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
    icon: openIndex === index ? 'minus' : 'plus'
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "faq-description",
    ref: openIndex === index ? contentRef : null,
    style: {
      maxHeight: openIndex === index ? height : '0px',
      overflow: 'hidden',
      transition: 'max-height 0.5s ease'
    }
  }, typeof content.description === 'string' ? (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", null, content.description) : content.description))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FAQ);

/***/ }),

/***/ "./src/pages/FreePro/index.jsx":
/*!*************************************!*\
  !*** ./src/pages/FreePro/index.jsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../assets/img/freevspro.webp */ "./src/assets/img/freevspro.webp");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const FreePro = () => {
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('We Value Your Feedback!', 'spa-and-salon'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Leave a Review', 'spa-and-salon'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Knowledge Base', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Explore', 'spa-and-salon'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Need Assistance? ', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Submit a Ticket', 'spa-and-salon'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    className: "freepro",
    src: _assets_img_freevspro_webp__WEBPACK_IMPORTED_MODULE_1__,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Free vs Pro image", "spa-and-salon")
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_2__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FreePro);

/***/ }),

/***/ "./src/pages/Home/index.jsx":
/*!**********************************!*\
  !*** ./src/pages/Home/index.jsx ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);



const Homepage = () => {
  const cardLists = [{
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "site"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Site Identity', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.custom_logo
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "colorsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Default Settings", 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.colors
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "layoutsetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Header section Settings", 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.header
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "frontpagesetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Home Page Settings", 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.frontpage
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "socialmedia"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Social Settings"),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.social
  }, {
    iconSvg: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "footersetting"
    }),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Footer Settings', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Customize', 'spa-and-salon'),
    buttonUrl: cw_dashboard.footer
  }];
  const proSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Header Layouts', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose from different unique header layouts.', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Layouts', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose layouts for blogs, banners, posts and more.', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Multiple Sidebar', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Set different sidebars for posts and pages.', 'spa-and-salon'),
    buttonText: "Learn More",
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Boost your website performance with ease.', 'spa-and-salon'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Performance Settings', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Choose typography for different heading tags.', 'spa-and-salon'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Typography Settings', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.get_pro
  }, {
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Import the demo content to kickstart your site.', 'spa-and-salon'),
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('One Click Demo Import', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn More', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.get_pro
  }];
  const sidebarSettings = [{
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('We Value Your Feedback!', 'spa-and-salon'),
    icon: "star",
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "review"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Leave a Review', 'spa-and-salon'),
    buttonUrl: cw_dashboard.review
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Knowledge Base', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("Need help using our theme? Visit our well-organized Knowledge Base!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "documentation"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Explore', 'spa-and-salon'),
    buttonUrl: cw_dashboard.docmentation
  }, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Need Assistance? ', 'spa-and-salon'),
    para: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'spa-and-salon'),
    imageurl: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "supportTwo"
    }),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Submit a Ticket', 'spa-and-salon'),
    buttonUrl: cw_dashboard.support
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "customizer-settings"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-customizer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Quick Customizer Settings', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: cardLists,
    cardPlace: "customizer",
    cardCol: "three-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Heading, {
    heading: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('More features with Pro version', 'spa-and-salon'),
    buttonText: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Go To Customizer', 'spa-and-salon'),
    buttonUrl: cw_dashboard?.customizer_url,
    openInNewTab: true
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Card, {
    cardList: proSettings,
    cardPlace: "cw-pro",
    cardCol: "two-col"
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard?.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn long-button"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__.__)('Learn more about the Pro version', 'spa-and-salon')))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Sidebar, {
    sidebarSettings: sidebarSettings,
    openInNewTab: true
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Homepage);

/***/ }),

/***/ "./src/pages/Offers/index.jsx":
/*!************************************!*\
  !*** ./src/pages/Offers/index.jsx ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");



const Offers = () => {
  const offerBannerLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeClub,
    imageUrl: cw_dashboard.theme_club_upgrade,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Club", "spa-and-salon")
  }];
  const offerCardLists = [{
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.themeInstallation,
    imageUrl: cw_dashboard.theme_install,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Theme Installation & Setup", "spa-and-salon")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.gdpr,
    imageUrl: cw_dashboard.gdpr_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("GDPR Compliance", "spa-and-salon")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.seo,
    imageUrl: cw_dashboard.seo_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have SEO Setup", "spa-and-salon")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.pluginsSetup,
    imageUrl: cw_dashboard.plugin_setup,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("Must Have Plugins Setup", "spa-and-salon")
  }, {
    image: _components_images__WEBPACK_IMPORTED_MODULE_2__.vipSupport,
    imageUrl: cw_dashboard.vip_support,
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)("VIP Support", "spa-and-salon")
  }];
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-offer"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "banner-section"
  }, offerBannerLists.map((banner, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: banner.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: banner.image,
    alt: banner.title
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "card-section"
  }, offerCardLists.map((card, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    className: "image-link",
    href: card.imageUrl,
    key: index,
    target: "_blank"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: card.image,
    alt: card.title
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Offers);

/***/ }),

/***/ "./src/pages/StarterSites/index.jsx":
/*!******************************************!*\
  !*** ./src/pages/StarterSites/index.jsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_images__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/images */ "./src/components/images.js");
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");




const StarterSites = () => {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "starter-sites"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.demo2,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo image', 'spa-and-salon')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.demo2,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo reverse image', 'spa-and-salon')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.mainDemo,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo image', 'spa-and-salon')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.mainDemo,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo reverse image', 'spa-and-salon')
  }))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.demo3,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo image', 'spa-and-salon')
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "reverse-image"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("img", {
    src: _components_images__WEBPACK_IMPORTED_MODULE_2__.demo3,
    alt: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Demo reverse image', 'spa-and-salon')
  })))), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-wrapper"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("h2", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('One Click Demo Import', 'spa-and-salon')), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    dangerouslySetInnerHTML: {
      __html: sprintf((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Get started effortlessly! Use our one-click demo import feature to set up your site instantly with all the sample data and settings. Please note that importing demo content will overwrite your existing site content and settings. %s Not recommended if you have existing content. %s', 'spa-and-salon'), '<b>', '</b>')
    }
  }), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-button"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("a", {
    href: cw_dashboard.get_pro,
    target: "_blank",
    className: "cw-button-btn primary-btn"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Get Starter Sites', 'spa-and-salon'), " ", (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_3__.Icon, {
    icon: "arrow"
  }))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StarterSites);

/***/ }),

/***/ "./src/pages/UsefulPlugins/index.jsx":
/*!*******************************************!*\
  !*** ./src/pages/UsefulPlugins/index.jsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components */ "./src/components/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




const pluginList = [{
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Contact Form 7', 'spa-and-salon'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Just another contact form plugin. Simple but flexible.", "spa-and-salon"),
  slug: "contact-form-7"
}, {
  pluginName: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Rara One Click Demo Import', 'spa-and-salon'),
  description: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)("Make your website look like the live demo of the theme with a click!", "spa-and-salon"),
  slug: "rara-one-click-demo-import"
}];
const objectExistsInArray = (obj, array) => {
  return array.some(el => el.slug === obj.slug);
};
const UsefulPlugins = () => {
  const [buttonState, setButtonState] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)(() => {
    const initialState = {};
    pluginList.forEach(plugin => {
      initialState[plugin.slug] = 'Install';
    });
    return initialState;
  });
  const [activateUrls, setActivateUrls] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useState)({});
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    const activePlugins = cw_dashboard.activePlugins;
    const inactivePlugins = cw_dashboard.inactivePlugins;
    const newButtonState = {};

    // Set state for active plugins
    activePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activated';
      }
    });

    // Set state for inactive plugins
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        newButtonState[plugin.slug] = 'Activate';
      }
    });
    setButtonState(prevState => ({
      ...prevState,
      ...newButtonState
    }));
    const urls = {};
    inactivePlugins.forEach(plugin => {
      if (objectExistsInArray(plugin, pluginList)) {
        const url = plugin.url.replace(/&amp;/g, '&');
        urls[plugin.slug] = url;
      }
    });
    setActivateUrls(urls);
  }, []);
  const installPlugin = slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Installing...'
    }));
    wp.updates.installPlugin({
      slug: slug,
      success: response => {
        setActivateUrls(prevUrls => ({
          ...prevUrls,
          [slug]: response.activateUrl
        }));
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      },
      error: error => {
        console.error(error);
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Install'
        }));
      }
    });
  };
  const activatePlugin = async slug => {
    setButtonState(prevState => ({
      ...prevState,
      [slug]: 'Activating...'
    }));
    const url = activateUrls[slug];
    if (url) {
      try {
        const response = await fetch(url, {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
          },
          body: new URLSearchParams({
            _wpnonce: new URL(url).searchParams.get('_wpnonce'),
            action: 'activate',
            plugin: new URL(url).searchParams.get('plugin')
          }).toString()
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activated'
        }));
      } catch (error) {
        setButtonState(prevState => ({
          ...prevState,
          [slug]: 'Activate'
        }));
      }
    }
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list-wrapper"
  }, pluginList.map((plugin, index) => (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-list",
    key: index
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "plugin-detail"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "cw-plugin-title"
  }, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
    icon: "pluginList",
    label: plugin.pluginName
  })), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "description"
  }, plugin.description)), (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "insert-button"
  }, buttonState[plugin.slug] === 'Install' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => installPlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Install', 'spa-and-salon')), buttonState[plugin.slug] === 'Installing...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Installing...', 'spa-and-salon')), buttonState[plugin.slug] === 'Activate' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    onClick: () => activatePlugin(plugin.slug)
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activate', 'spa-and-salon')), buttonState[plugin.slug] === 'Activating...' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn outline",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activating...', 'spa-and-salon')), buttonState[plugin.slug] === 'Activated' && (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)("button", {
    className: "cw-button-btn primary-btn deactivate",
    disabled: true
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Activated', 'spa-and-salon'))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UsefulPlugins);

/***/ }),

/***/ "./src/pages/index.js":
/*!****************************!*\
  !*** ./src/pages/index.js ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components */ "./src/components/index.js");
/* harmony import */ var _FreePro__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FreePro */ "./src/pages/FreePro/index.jsx");
/* harmony import */ var _Home__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Home */ "./src/pages/Home/index.jsx");
/* harmony import */ var _Offers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Offers */ "./src/pages/Offers/index.jsx");
/* harmony import */ var _UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./UsefulPlugins */ "./src/pages/UsefulPlugins/index.jsx");
/* harmony import */ var _FAQ__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FAQ */ "./src/pages/FAQ/index.jsx");
/* harmony import */ var _StarterSites__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./StarterSites */ "./src/pages/StarterSites/index.jsx");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__);










function Dashboard() {
  const [activeTabTitle, setActiveTabTitle] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Home');
  const tabsData = [{
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Home', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "home"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Home__WEBPACK_IMPORTED_MODULE_3__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Starter Sites', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "globe"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_StarterSites__WEBPACK_IMPORTED_MODULE_7__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Free vs Pro', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "freePro"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FreePro__WEBPACK_IMPORTED_MODULE_2__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Offers', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "offers"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_Offers__WEBPACK_IMPORTED_MODULE_4__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('FAQs', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "support"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_FAQ__WEBPACK_IMPORTED_MODULE_6__["default"], null)
  }, {
    title: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__.__)('Useful Plugins', 'spa-and-salon'),
    icon: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Icon, {
      icon: "plugins"
    }),
    content: (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_UsefulPlugins__WEBPACK_IMPORTED_MODULE_5__["default"], null)
  }];
  const handleTabChange = title => {
    setActiveTabTitle(title);
  };
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_components__WEBPACK_IMPORTED_MODULE_1__.Tab, {
    tabsData: tabsData,
    onChange: handleTabChange,
    activeTabTitle: activeTabTitle
  }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashboard);

/***/ }),

/***/ "./src/scss/style.scss":
/*!*****************************!*\
  !*** ./src/scss/style.scss ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "./node_modules/react-router-dom/dist/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/react-router-dom/dist/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.AbortedDeferredError),
/* harmony export */   Await: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Await),
/* harmony export */   BrowserRouter: () => (/* binding */ BrowserRouter),
/* harmony export */   Form: () => (/* binding */ Form),
/* harmony export */   HashRouter: () => (/* binding */ HashRouter),
/* harmony export */   Link: () => (/* binding */ Link),
/* harmony export */   MemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.MemoryRouter),
/* harmony export */   NavLink: () => (/* binding */ NavLink),
/* harmony export */   Navigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.Action),
/* harmony export */   Outlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Outlet),
/* harmony export */   Route: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Route),
/* harmony export */   Router: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.Routes),
/* harmony export */   ScrollRestoration: () => (/* binding */ ScrollRestoration),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext),
/* harmony export */   UNSAFE_ErrorResponseImpl: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_ErrorResponseImpl),
/* harmony export */   UNSAFE_FetchersContext: () => (/* binding */ FetchersContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext),
/* harmony export */   UNSAFE_ViewTransitionContext: () => (/* binding */ ViewTransitionContext),
/* harmony export */   UNSAFE_useRouteId: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRouteId),
/* harmony export */   UNSAFE_useScrollRestoration: () => (/* binding */ useScrollRestoration),
/* harmony export */   createBrowserRouter: () => (/* binding */ createBrowserRouter),
/* harmony export */   createHashRouter: () => (/* binding */ createHashRouter),
/* harmony export */   createMemoryRouter: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.createRoutesFromElements),
/* harmony export */   createSearchParams: () => (/* binding */ createSearchParams),
/* harmony export */   defer: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.redirectDocument),
/* harmony export */   renderMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_2__.resolvePath),
/* harmony export */   unstable_HistoryRouter: () => (/* binding */ HistoryRouter),
/* harmony export */   unstable_usePrompt: () => (/* binding */ usePrompt),
/* harmony export */   unstable_useViewTransitionState: () => (/* binding */ useViewTransitionState),
/* harmony export */   useActionData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useActionData),
/* harmony export */   useAsyncError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useAsyncError),
/* harmony export */   useAsyncValue: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useAsyncValue),
/* harmony export */   useBeforeUnload: () => (/* binding */ useBeforeUnload),
/* harmony export */   useBlocker: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useBlocker),
/* harmony export */   useFetcher: () => (/* binding */ useFetcher),
/* harmony export */   useFetchers: () => (/* binding */ useFetchers),
/* harmony export */   useFormAction: () => (/* binding */ useFormAction),
/* harmony export */   useHref: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useHref),
/* harmony export */   useInRouterContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useInRouterContext),
/* harmony export */   useLinkClickHandler: () => (/* binding */ useLinkClickHandler),
/* harmony export */   useLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useLoaderData),
/* harmony export */   useLocation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation),
/* harmony export */   useMatch: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useMatch),
/* harmony export */   useMatches: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useMatches),
/* harmony export */   useNavigate: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate),
/* harmony export */   useNavigation: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigation),
/* harmony export */   useNavigationType: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigationType),
/* harmony export */   useOutlet: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useOutlet),
/* harmony export */   useOutletContext: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useOutletContext),
/* harmony export */   useParams: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useParams),
/* harmony export */   useResolvedPath: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath),
/* harmony export */   useRevalidator: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRevalidator),
/* harmony export */   useRouteError: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* reexport safe */ react_router__WEBPACK_IMPORTED_MODULE_3__.useRoutes),
/* harmony export */   useSearchParams: () => (/* binding */ useSearchParams),
/* harmony export */   useSubmit: () => (/* binding */ useSubmit)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/index.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router DOM v6.26.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */







function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

const defaultMethod = "get";
const defaultEncType = "application/x-www-form-urlencoded";
function isHtmlElement(object) {
  return object != null && typeof object.tagName === "string";
}
function isButtonElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "button";
}
function isFormElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "form";
}
function isInputElement(object) {
  return isHtmlElement(object) && object.tagName.toLowerCase() === "input";
}
function isModifiedEvent(event) {
  return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}
function shouldProcessLinkClick(event, target) {
  return event.button === 0 && (
  // Ignore everything but left clicks
  !target || target === "_self") &&
  // Let browser handle "target=_blank" etc.
  !isModifiedEvent(event) // Ignore clicks with modifier keys
  ;
}
/**
 * Creates a URLSearchParams object using the given initializer.
 *
 * This is identical to `new URLSearchParams(init)` except it also
 * supports arrays as values in the object form of the initializer
 * instead of just strings. This is convenient when you need multiple
 * values for a given key, but don't want to use an array initializer.
 *
 * For example, instead of:
 *
 *   let searchParams = new URLSearchParams([
 *     ['sort', 'name'],
 *     ['sort', 'price']
 *   ]);
 *
 * you can do:
 *
 *   let searchParams = createSearchParams({
 *     sort: ['name', 'price']
 *   });
 */
function createSearchParams(init) {
  if (init === void 0) {
    init = "";
  }
  return new URLSearchParams(typeof init === "string" || Array.isArray(init) || init instanceof URLSearchParams ? init : Object.keys(init).reduce((memo, key) => {
    let value = init[key];
    return memo.concat(Array.isArray(value) ? value.map(v => [key, v]) : [[key, value]]);
  }, []));
}
function getSearchParamsForLocation(locationSearch, defaultSearchParams) {
  let searchParams = createSearchParams(locationSearch);
  if (defaultSearchParams) {
    // Use `defaultSearchParams.forEach(...)` here instead of iterating of
    // `defaultSearchParams.keys()` to work-around a bug in Firefox related to
    // web extensions. Relevant Bugzilla tickets:
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1414602
    // https://bugzilla.mozilla.org/show_bug.cgi?id=1023984
    defaultSearchParams.forEach((_, key) => {
      if (!searchParams.has(key)) {
        defaultSearchParams.getAll(key).forEach(value => {
          searchParams.append(key, value);
        });
      }
    });
  }
  return searchParams;
}
// One-time check for submitter support
let _formDataSupportsSubmitter = null;
function isFormDataSubmitterSupported() {
  if (_formDataSupportsSubmitter === null) {
    try {
      new FormData(document.createElement("form"),
      // @ts-expect-error if FormData supports the submitter parameter, this will throw
      0);
      _formDataSupportsSubmitter = false;
    } catch (e) {
      _formDataSupportsSubmitter = true;
    }
  }
  return _formDataSupportsSubmitter;
}
const supportedFormEncTypes = new Set(["application/x-www-form-urlencoded", "multipart/form-data", "text/plain"]);
function getFormEncType(encType) {
  if (encType != null && !supportedFormEncTypes.has(encType)) {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "\"" + encType + "\" is not a valid `encType` for `<Form>`/`<fetcher.Form>` " + ("and will default to \"" + defaultEncType + "\"")) : 0;
    return null;
  }
  return encType;
}
function getFormSubmissionInfo(target, basename) {
  let method;
  let action;
  let encType;
  let formData;
  let body;
  if (isFormElement(target)) {
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("enctype")) || defaultEncType;
    formData = new FormData(target);
  } else if (isButtonElement(target) || isInputElement(target) && (target.type === "submit" || target.type === "image")) {
    let form = target.form;
    if (form == null) {
      throw new Error("Cannot submit a <button> or <input type=\"submit\"> without a <form>");
    }
    // <button>/<input type="submit"> may override attributes of <form>
    // When grabbing the action from the element, it will have had the basename
    // prefixed to ensure non-JS scenarios work, so strip it since we'll
    // re-prefix in the router
    let attr = target.getAttribute("formaction") || form.getAttribute("action");
    action = attr ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(attr, basename) : null;
    method = target.getAttribute("formmethod") || form.getAttribute("method") || defaultMethod;
    encType = getFormEncType(target.getAttribute("formenctype")) || getFormEncType(form.getAttribute("enctype")) || defaultEncType;
    // Build a FormData object populated from a form and submitter
    formData = new FormData(form, target);
    // If this browser doesn't support the `FormData(el, submitter)` format,
    // then tack on the submitter value at the end.  This is a lightweight
    // solution that is not 100% spec compliant.  For complete support in older
    // browsers, consider using the `formdata-submitter-polyfill` package
    if (!isFormDataSubmitterSupported()) {
      let {
        name,
        type,
        value
      } = target;
      if (type === "image") {
        let prefix = name ? name + "." : "";
        formData.append(prefix + "x", "0");
        formData.append(prefix + "y", "0");
      } else if (name) {
        formData.append(name, value);
      }
    }
  } else if (isHtmlElement(target)) {
    throw new Error("Cannot submit element that is not <form>, <button>, or " + "<input type=\"submit|image\">");
  } else {
    method = defaultMethod;
    action = null;
    encType = defaultEncType;
    body = target;
  }
  // Send body for <Form encType="text/plain" so we encode it into text
  if (formData && encType === "text/plain") {
    body = formData;
    formData = undefined;
  }
  return {
    action,
    method: method.toLowerCase(),
    encType,
    formData,
    body
  };
}

const _excluded = ["onClick", "relative", "reloadDocument", "replace", "state", "target", "to", "preventScrollReset", "unstable_viewTransition"],
  _excluded2 = ["aria-current", "caseSensitive", "className", "end", "style", "to", "unstable_viewTransition", "children"],
  _excluded3 = ["fetcherKey", "navigate", "reloadDocument", "replace", "state", "method", "action", "onSubmit", "relative", "preventScrollReset", "unstable_viewTransition"];
// HEY YOU! DON'T TOUCH THIS VARIABLE!
//
// It is replaced with the proper version at build time via a babel plugin in
// the rollup config.
//
// Export a global property onto the window for React Router detection by the
// Core Web Vitals Technology Report.  This way they can configure the `wappalyzer`
// to detect and properly classify live websites as being built with React Router:
// https://github.com/HTTPArchive/wappalyzer/blob/main/src/technologies/r.json
const REACT_ROUTER_VERSION = "6";
try {
  window.__reactRouterVersion = REACT_ROUTER_VERSION;
} catch (e) {
  // no-op
}
function createBrowserRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createBrowserHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnNavigation: opts == null ? void 0 : opts.unstable_patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function createHashRouter(routes, opts) {
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createHashHistory)({
      window: opts == null ? void 0 : opts.window
    }),
    hydrationData: (opts == null ? void 0 : opts.hydrationData) || parseHydrationData(),
    routes,
    mapRouteProperties: react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnNavigation: opts == null ? void 0 : opts.unstable_patchRoutesOnNavigation,
    window: opts == null ? void 0 : opts.window
  }).initialize();
}
function parseHydrationData() {
  var _window;
  let state = (_window = window) == null ? void 0 : _window.__staticRouterHydrationData;
  if (state && state.errors) {
    state = _extends({}, state, {
      errors: deserializeErrors(state.errors)
    });
  }
  return state;
}
function deserializeErrors(errors) {
  if (!errors) return null;
  let entries = Object.entries(errors);
  let serialized = {};
  for (let [key, val] of entries) {
    // Hey you!  If you change this, please change the corresponding logic in
    // serializeErrors in react-router-dom/server.tsx :)
    if (val && val.__type === "RouteErrorResponse") {
      serialized[key] = new react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_ErrorResponseImpl(val.status, val.statusText, val.data, val.internal === true);
    } else if (val && val.__type === "Error") {
      // Attempt to reconstruct the right type of Error (i.e., ReferenceError)
      if (val.__subType) {
        let ErrorConstructor = window[val.__subType];
        if (typeof ErrorConstructor === "function") {
          try {
            // @ts-expect-error
            let error = new ErrorConstructor(val.message);
            // Wipe away the client-side stack trace.  Nothing to fill it in with
            // because we don't serialize SSR stack traces for security reasons
            error.stack = "";
            serialized[key] = error;
          } catch (e) {
            // no-op - fall through and create a normal Error
          }
        }
      }
      if (serialized[key] == null) {
        let error = new Error(val.message);
        // Wipe away the client-side stack trace.  Nothing to fill it in with
        // because we don't serialize SSR stack traces for security reasons
        error.stack = "";
        serialized[key] = error;
      }
    } else {
      serialized[key] = val;
    }
  }
  return serialized;
}
const ViewTransitionContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  isTransitioning: false
});
if (true) {
  ViewTransitionContext.displayName = "ViewTransition";
}
const FetchersContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(new Map());
if (true) {
  FetchersContext.displayName = "Fetchers";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Components
////////////////////////////////////////////////////////////////////////////////
/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];
const FLUSH_SYNC = "flushSync";
const flushSyncImpl = react_dom__WEBPACK_IMPORTED_MODULE_1__[FLUSH_SYNC];
const USE_ID = "useId";
const useIdImpl = react__WEBPACK_IMPORTED_MODULE_0__[USE_ID];
function startTransitionSafe(cb) {
  if (startTransitionImpl) {
    startTransitionImpl(cb);
  } else {
    cb();
  }
}
function flushSyncSafe(cb) {
  if (flushSyncImpl) {
    flushSyncImpl(cb);
  } else {
    cb();
  }
}
class Deferred {
  constructor() {
    this.status = "pending";
    this.promise = new Promise((resolve, reject) => {
      this.resolve = value => {
        if (this.status === "pending") {
          this.status = "resolved";
          resolve(value);
        }
      };
      this.reject = reason => {
        if (this.status === "pending") {
          this.status = "rejected";
          reject(reason);
        }
      };
    });
  }
}
/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let [pendingState, setPendingState] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [vtContext, setVtContext] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    isTransitioning: false
  });
  let [renderDfd, setRenderDfd] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [transition, setTransition] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let [interruption, setInterruption] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useRef(new Map());
  let {
    v7_startTransition
  } = future || {};
  let optInStartTransition = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(cb => {
    if (v7_startTransition) {
      startTransitionSafe(cb);
    } else {
      cb();
    }
  }, [v7_startTransition]);
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((newState, _ref2) => {
    let {
      deletedFetchers,
      unstable_flushSync: flushSync,
      unstable_viewTransitionOpts: viewTransitionOpts
    } = _ref2;
    deletedFetchers.forEach(key => fetcherData.current.delete(key));
    newState.fetchers.forEach((fetcher, key) => {
      if (fetcher.data !== undefined) {
        fetcherData.current.set(key, fetcher.data);
      }
    });
    let isViewTransitionUnavailable = router.window == null || router.window.document == null || typeof router.window.document.startViewTransition !== "function";
    // If this isn't a view transition or it's not available in this browser,
    // just update and be done with it
    if (!viewTransitionOpts || isViewTransitionUnavailable) {
      if (flushSync) {
        flushSyncSafe(() => setStateImpl(newState));
      } else {
        optInStartTransition(() => setStateImpl(newState));
      }
      return;
    }
    // flushSync + startViewTransition
    if (flushSync) {
      // Flush through the context to mark DOM elements as transition=ing
      flushSyncSafe(() => {
        // Cancel any pending transitions
        if (transition) {
          renderDfd && renderDfd.resolve();
          transition.skipTransition();
        }
        setVtContext({
          isTransitioning: true,
          flushSync: true,
          currentLocation: viewTransitionOpts.currentLocation,
          nextLocation: viewTransitionOpts.nextLocation
        });
      });
      // Update the DOM
      let t = router.window.document.startViewTransition(() => {
        flushSyncSafe(() => setStateImpl(newState));
      });
      // Clean up after the animation completes
      t.finished.finally(() => {
        flushSyncSafe(() => {
          setRenderDfd(undefined);
          setTransition(undefined);
          setPendingState(undefined);
          setVtContext({
            isTransitioning: false
          });
        });
      });
      flushSyncSafe(() => setTransition(t));
      return;
    }
    // startTransition + startViewTransition
    if (transition) {
      // Interrupting an in-progress transition, cancel and let everything flush
      // out, and then kick off a new transition from the interruption state
      renderDfd && renderDfd.resolve();
      transition.skipTransition();
      setInterruption({
        state: newState,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    } else {
      // Completed navigation update with opted-in view transitions, let 'er rip
      setPendingState(newState);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: viewTransitionOpts.currentLocation,
        nextLocation: viewTransitionOpts.nextLocation
      });
    }
  }, [router.window, transition, renderDfd, fetcherData, optInStartTransition]);
  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  // When we start a view transition, create a Deferred we can use for the
  // eventual "completed" render
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (vtContext.isTransitioning && !vtContext.flushSync) {
      setRenderDfd(new Deferred());
    }
  }, [vtContext]);
  // Once the deferred is created, kick off startViewTransition() to update the
  // DOM and then wait on the Deferred to resolve (indicating the DOM update has
  // happened)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && router.window) {
      let newState = pendingState;
      let renderPromise = renderDfd.promise;
      let transition = router.window.document.startViewTransition(async () => {
        optInStartTransition(() => setStateImpl(newState));
        await renderPromise;
      });
      transition.finished.finally(() => {
        setRenderDfd(undefined);
        setTransition(undefined);
        setPendingState(undefined);
        setVtContext({
          isTransitioning: false
        });
      });
      setTransition(transition);
    }
  }, [optInStartTransition, pendingState, renderDfd, router.window]);
  // When the new location finally renders and is committed to the DOM, this
  // effect will run to resolve the transition
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (renderDfd && pendingState && state.location.key === pendingState.location.key) {
      renderDfd.resolve();
    }
  }, [renderDfd, transition, state.location, pendingState]);
  // If we get interrupted with a new navigation during a transition, we skip
  // the active transition, let it cleanup, then kick it off again here
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (!vtContext.isTransitioning && interruption) {
      setPendingState(interruption.state);
      setVtContext({
        isTransitioning: true,
        flushSync: false,
        currentLocation: interruption.currentLocation,
        nextLocation: interruption.nextLocation
      });
      setInterruption(undefined);
    }
  }, [vtContext.isTransitioning, interruption]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);
  let routerFuture = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    v7_relativeSplatPath: router.future.v7_relativeSplatPath
  }), [router.future.v7_relativeSplatPath]);
  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(FetchersContext.Provider, {
    value: fetcherData.current
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ViewTransitionContext.Provider, {
    value: vtContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: routerFuture
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(MemoizedDataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))))), null);
}
// Memoize to avoid re-renders when updating `ViewTransitionContext`
const MemoizedDataRoutes = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.memo(DataRoutes);
function DataRoutes(_ref3) {
  let {
    routes,
    future,
    state
  } = _ref3;
  return (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRoutesImpl)(routes, undefined, state, future);
}
/**
 * A `<Router>` for use in web browsers. Provides the cleanest URLs.
 */
function BrowserRouter(_ref4) {
  let {
    basename,
    children,
    future,
    window
  } = _ref4;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createBrowserHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` for use in web browsers. Stores the location in the hash
 * portion of the URL so it is not sent to the server.
 */
function HashRouter(_ref5) {
  let {
    basename,
    children,
    future,
    window
  } = _ref5;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createHashHistory)({
      window,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * A `<Router>` that accepts a pre-instantiated history object. It's important
 * to note that using your own history object is highly discouraged and may add
 * two versions of the history library to your bundles unless you use the same
 * version of the history library that React Router uses internally.
 */
function HistoryRouter(_ref6) {
  let {
    basename,
    children,
    future,
    history
  } = _ref6;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router__WEBPACK_IMPORTED_MODULE_3__.Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
if (true) {
  HistoryRouter.displayName = "unstable_HistoryRouter";
}
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined";
const ABSOLUTE_URL_REGEX = /^(?:[a-z][a-z0-9+.-]*:|\/\/)/i;
/**
 * The public API for rendering a history-aware `<a>`.
 */
const Link = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function LinkWithRef(_ref7, ref) {
  let {
      onClick,
      relative,
      reloadDocument,
      replace,
      state,
      target,
      to,
      preventScrollReset,
      unstable_viewTransition
    } = _ref7,
    rest = _objectWithoutPropertiesLoose(_ref7, _excluded);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  // Rendered into <a href> for absolute URLs
  let absoluteHref;
  let isExternal = false;
  if (typeof to === "string" && ABSOLUTE_URL_REGEX.test(to)) {
    // Render the absolute href server- and client-side
    absoluteHref = to;
    // Only check for external origins client-side
    if (isBrowser) {
      try {
        let currentUrl = new URL(window.location.href);
        let targetUrl = to.startsWith("//") ? new URL(currentUrl.protocol + to) : new URL(to);
        let path = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(targetUrl.pathname, basename);
        if (targetUrl.origin === currentUrl.origin && path != null) {
          // Strip the protocol/origin/basename for same-origin absolute URLs
          to = path + targetUrl.search + targetUrl.hash;
        } else {
          isExternal = true;
        }
      } catch (e) {
        // We can't do external URL detection without a valid URL
         true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "<Link to=\"" + to + "\"> contains an invalid URL which will probably break " + "when clicked - please update to a valid URL path.") : 0;
      }
    }
  }
  // Rendered into <a href> for relative URLs
  let href = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useHref)(to, {
    relative
  });
  let internalOnClick = useLinkClickHandler(to, {
    replace,
    state,
    target,
    preventScrollReset,
    relative,
    unstable_viewTransition
  });
  function handleClick(event) {
    if (onClick) onClick(event);
    if (!event.defaultPrevented) {
      internalOnClick(event);
    }
  }
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/anchor-has-content
    react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", _extends({}, rest, {
      href: absoluteHref || href,
      onClick: isExternal || reloadDocument ? onClick : handleClick,
      ref: ref,
      target: target
    }))
  );
});
if (true) {
  Link.displayName = "Link";
}
/**
 * A `<Link>` wrapper that knows if it's "active" or not.
 */
const NavLink = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function NavLinkWithRef(_ref8, ref) {
  let {
      "aria-current": ariaCurrentProp = "page",
      caseSensitive = false,
      className: classNameProp = "",
      end = false,
      style: styleProp,
      to,
      unstable_viewTransition,
      children
    } = _ref8,
    rest = _objectWithoutPropertiesLoose(_ref8, _excluded2);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative: rest.relative
  });
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let routerState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext);
  let {
    navigator,
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let isTransitioning = routerState != null &&
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  useViewTransitionState(path) && unstable_viewTransition === true;
  let toPathname = navigator.encodeLocation ? navigator.encodeLocation(path).pathname : path.pathname;
  let locationPathname = location.pathname;
  let nextLocationPathname = routerState && routerState.navigation && routerState.navigation.location ? routerState.navigation.location.pathname : null;
  if (!caseSensitive) {
    locationPathname = locationPathname.toLowerCase();
    nextLocationPathname = nextLocationPathname ? nextLocationPathname.toLowerCase() : null;
    toPathname = toPathname.toLowerCase();
  }
  if (nextLocationPathname && basename) {
    nextLocationPathname = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(nextLocationPathname, basename) || nextLocationPathname;
  }
  // If the `to` has a trailing slash, look at that exact spot.  Otherwise,
  // we're looking for a slash _after_ what's in `to`.  For example:
  //
  // <NavLink to="/users"> and <NavLink to="/users/">
  // both want to look for a / at index 6 to match URL `/users/matt`
  const endSlashPosition = toPathname !== "/" && toPathname.endsWith("/") ? toPathname.length - 1 : toPathname.length;
  let isActive = locationPathname === toPathname || !end && locationPathname.startsWith(toPathname) && locationPathname.charAt(endSlashPosition) === "/";
  let isPending = nextLocationPathname != null && (nextLocationPathname === toPathname || !end && nextLocationPathname.startsWith(toPathname) && nextLocationPathname.charAt(toPathname.length) === "/");
  let renderProps = {
    isActive,
    isPending,
    isTransitioning
  };
  let ariaCurrent = isActive ? ariaCurrentProp : undefined;
  let className;
  if (typeof classNameProp === "function") {
    className = classNameProp(renderProps);
  } else {
    // If the className prop is not a function, we use a default `active`
    // class for <NavLink />s that are active. In v5 `active` was the default
    // value for `activeClassName`, but we are removing that API and can still
    // use the old default behavior for a cleaner upgrade path and keep the
    // simple styling rules working as they currently do.
    className = [classNameProp, isActive ? "active" : null, isPending ? "pending" : null, isTransitioning ? "transitioning" : null].filter(Boolean).join(" ");
  }
  let style = typeof styleProp === "function" ? styleProp(renderProps) : styleProp;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Link, _extends({}, rest, {
    "aria-current": ariaCurrent,
    className: className,
    ref: ref,
    style: style,
    to: to,
    unstable_viewTransition: unstable_viewTransition
  }), typeof children === "function" ? children(renderProps) : children);
});
if (true) {
  NavLink.displayName = "NavLink";
}
/**
 * A `@remix-run/router`-aware `<form>`. It behaves like a normal form except
 * that the interaction with the server is with `fetch` instead of new document
 * requests, allowing components to add nicer UX to the page as the form is
 * submitted and returns with data.
 */
const Form = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((_ref9, forwardedRef) => {
  let {
      fetcherKey,
      navigate,
      reloadDocument,
      replace,
      state,
      method = defaultMethod,
      action,
      onSubmit,
      relative,
      preventScrollReset,
      unstable_viewTransition
    } = _ref9,
    props = _objectWithoutPropertiesLoose(_ref9, _excluded3);
  let submit = useSubmit();
  let formAction = useFormAction(action, {
    relative
  });
  let formMethod = method.toLowerCase() === "get" ? "get" : "post";
  let submitHandler = event => {
    onSubmit && onSubmit(event);
    if (event.defaultPrevented) return;
    event.preventDefault();
    let submitter = event.nativeEvent.submitter;
    let submitMethod = (submitter == null ? void 0 : submitter.getAttribute("formmethod")) || method;
    submit(submitter || event.currentTarget, {
      fetcherKey,
      method: submitMethod,
      navigate,
      replace,
      state,
      relative,
      preventScrollReset,
      unstable_viewTransition
    });
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", _extends({
    ref: forwardedRef,
    method: formMethod,
    action: formAction,
    onSubmit: reloadDocument ? onSubmit : submitHandler
  }, props));
});
if (true) {
  Form.displayName = "Form";
}
/**
 * This component will emulate the browser's scroll restoration on location
 * changes.
 */
function ScrollRestoration(_ref10) {
  let {
    getKey,
    storageKey
  } = _ref10;
  useScrollRestoration({
    getKey,
    storageKey
  });
  return null;
}
if (true) {
  ScrollRestoration.displayName = "ScrollRestoration";
}
//#endregion
////////////////////////////////////////////////////////////////////////////////
//#region Hooks
////////////////////////////////////////////////////////////////////////////////
var DataRouterHook;
(function (DataRouterHook) {
  DataRouterHook["UseScrollRestoration"] = "useScrollRestoration";
  DataRouterHook["UseSubmit"] = "useSubmit";
  DataRouterHook["UseSubmitFetcher"] = "useSubmitFetcher";
  DataRouterHook["UseFetcher"] = "useFetcher";
  DataRouterHook["useViewTransitionState"] = "useViewTransitionState";
})(DataRouterHook || (DataRouterHook = {}));
var DataRouterStateHook;
(function (DataRouterStateHook) {
  DataRouterStateHook["UseFetcher"] = "useFetcher";
  DataRouterStateHook["UseFetchers"] = "useFetchers";
  DataRouterStateHook["UseScrollRestoration"] = "useScrollRestoration";
})(DataRouterStateHook || (DataRouterStateHook = {}));
// Internal hooks
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterContext);
  !ctx ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_DataRouterStateContext);
  !state ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
// External hooks
/**
 * Handles the click behavior for router `<Link>` components. This is useful if
 * you need to create custom `<Link>` components with the same click behavior we
 * use in our exported `<Link>`.
 */
function useLinkClickHandler(to, _temp) {
  let {
    target,
    replace: replaceProp,
    state,
    preventScrollReset,
    relative,
    unstable_viewTransition
  } = _temp === void 0 ? {} : _temp;
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate)();
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative
  });
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(event => {
    if (shouldProcessLinkClick(event, target)) {
      event.preventDefault();
      // If the URL hasn't changed, a regular <a> will do a replace instead of
      // a push, so do the same here unless the replace prop is explicitly set
      let replace = replaceProp !== undefined ? replaceProp : (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(location) === (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(path);
      navigate(to, {
        replace,
        state,
        preventScrollReset,
        relative,
        unstable_viewTransition
      });
    }
  }, [location, navigate, path, replaceProp, state, target, to, preventScrollReset, relative, unstable_viewTransition]);
}
/**
 * A convenient wrapper for reading and writing search parameters via the
 * URLSearchParams interface.
 */
function useSearchParams(defaultInit) {
   true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(typeof URLSearchParams !== "undefined", "You cannot use the `useSearchParams` hook in a browser that does not " + "support the URLSearchParams API. If you need to support Internet " + "Explorer 11, we recommend you load a polyfill such as " + "https://github.com/ungap/url-search-params.") : 0;
  let defaultSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(createSearchParams(defaultInit));
  let hasSetSearchParamsRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let searchParams = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() =>
  // Only merge in the defaults if we haven't yet called setSearchParams.
  // Once we call that we want those to take precedence, otherwise you can't
  // remove a param with setSearchParams({}) if it has an initial value
  getSearchParamsForLocation(location.search, hasSetSearchParamsRef.current ? null : defaultSearchParamsRef.current), [location.search]);
  let navigate = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigate)();
  let setSearchParams = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((nextInit, navigateOptions) => {
    const newSearchParams = createSearchParams(typeof nextInit === "function" ? nextInit(searchParams) : nextInit);
    hasSetSearchParamsRef.current = true;
    navigate("?" + newSearchParams, navigateOptions);
  }, [navigate, searchParams]);
  return [searchParams, setSearchParams];
}
function validateClientSideSubmission() {
  if (typeof document === "undefined") {
    throw new Error("You are calling submit during the server render. " + "Try calling submit within a `useEffect` or callback instead.");
  }
}
let fetcherId = 0;
let getUniqueFetcherId = () => "__" + String(++fetcherId) + "__";
/**
 * Returns a function that may be used to programmatically submit a form (or
 * some arbitrary data) to the server.
 */
function useSubmit() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseSubmit);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let currentRouteId = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_useRouteId)();
  return react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (target, options) {
    if (options === void 0) {
      options = {};
    }
    validateClientSideSubmission();
    let {
      action,
      method,
      encType,
      formData,
      body
    } = getFormSubmissionInfo(target, basename);
    if (options.navigate === false) {
      let key = options.fetcherKey || getUniqueFetcherId();
      router.fetch(key, currentRouteId, options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        unstable_flushSync: options.unstable_flushSync
      });
    } else {
      router.navigate(options.action || action, {
        preventScrollReset: options.preventScrollReset,
        formData,
        body,
        formMethod: options.method || method,
        formEncType: options.encType || encType,
        replace: options.replace,
        state: options.state,
        fromRouteId: currentRouteId,
        unstable_flushSync: options.unstable_flushSync,
        unstable_viewTransition: options.unstable_viewTransition
      });
    }
  }, [router, basename, currentRouteId]);
}
// v7: Eventually we should deprecate this entirely in favor of using the
// router method directly?
function useFormAction(action, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let routeContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext);
  !routeContext ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFormAction must be used inside a RouteContext") : 0 : void 0;
  let [match] = routeContext.matches.slice(-1);
  // Shallow clone path so we can modify it below, otherwise we modify the
  // object referenced by useMemo inside useResolvedPath
  let path = _extends({}, (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(action ? action : ".", {
    relative
  }));
  // If no action was specified, browsers will persist current search params
  // when determining the path, so match that behavior
  // https://github.com/remix-run/remix/issues/927
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  if (action == null) {
    // Safe to write to this directly here since if action was undefined, we
    // would have called useResolvedPath(".") which will never include a search
    path.search = location.search;
    // When grabbing search params from the URL, remove any included ?index param
    // since it might not apply to our contextual route.  We add it back based
    // on match.route.index below
    let params = new URLSearchParams(path.search);
    if (params.has("index") && params.get("index") === "") {
      params.delete("index");
      path.search = params.toString() ? "?" + params.toString() : "";
    }
  }
  if ((!action || action === ".") && match.route.index) {
    path.search = path.search ? path.search.replace(/^\?/, "?index&") : "?index";
  }
  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the form action.  If this is a root navigation, then just use
  // the raw basename which allows the basename to have full control over the
  // presence of a trailing slash on root actions
  if (basename !== "/") {
    path.pathname = path.pathname === "/" ? basename : (0,react_router__WEBPACK_IMPORTED_MODULE_2__.joinPaths)([basename, path.pathname]);
  }
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.createPath)(path);
}
// TODO: (v7) Change the useFetcher generic default from `any` to `unknown`
/**
 * Interacts with route loaders and actions without causing a navigation. Great
 * for any interaction that stays on the same page.
 */
function useFetcher(_temp3) {
  var _route$matches;
  let {
    key
  } = _temp3 === void 0 ? {} : _temp3;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseFetcher);
  let state = useDataRouterState(DataRouterStateHook.UseFetcher);
  let fetcherData = react__WEBPACK_IMPORTED_MODULE_0__.useContext(FetchersContext);
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_RouteContext);
  let routeId = (_route$matches = route.matches[route.matches.length - 1]) == null ? void 0 : _route$matches.route.id;
  !fetcherData ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher must be used inside a FetchersContext") : 0 : void 0;
  !route ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher must be used inside a RouteContext") : 0 : void 0;
  !(routeId != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "useFetcher can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  // Fetcher key handling
  // OK to call conditionally to feature detect `useId`
  // eslint-disable-next-line react-hooks/rules-of-hooks
  let defaultKey = useIdImpl ? useIdImpl() : "";
  let [fetcherKey, setFetcherKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState(key || defaultKey);
  if (key && key !== fetcherKey) {
    setFetcherKey(key);
  } else if (!fetcherKey) {
    // We will only fall through here when `useId` is not available
    setFetcherKey(getUniqueFetcherId());
  }
  // Registration/cleanup
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    router.getFetcher(fetcherKey);
    return () => {
      // Tell the router we've unmounted - if v7_fetcherPersist is enabled this
      // will not delete immediately but instead queue up a delete after the
      // fetcher returns to an `idle` state
      router.deleteFetcher(fetcherKey);
    };
  }, [router, fetcherKey]);
  // Fetcher additions
  let load = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((href, opts) => {
    !routeId ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "No routeId available for fetcher.load()") : 0 : void 0;
    router.fetch(fetcherKey, routeId, href, opts);
  }, [fetcherKey, routeId, router]);
  let submitImpl = useSubmit();
  let submit = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((target, opts) => {
    submitImpl(target, _extends({}, opts, {
      navigate: false,
      fetcherKey
    }));
  }, [fetcherKey, submitImpl]);
  let FetcherForm = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let FetcherForm = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Form, _extends({}, props, {
        navigate: false,
        fetcherKey: fetcherKey,
        ref: ref
      }));
    });
    if (true) {
      FetcherForm.displayName = "fetcher.Form";
    }
    return FetcherForm;
  }, [fetcherKey]);
  // Exposed FetcherWithComponents
  let fetcher = state.fetchers.get(fetcherKey) || react_router__WEBPACK_IMPORTED_MODULE_2__.IDLE_FETCHER;
  let data = fetcherData.get(fetcherKey);
  let fetcherWithComponents = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => _extends({
    Form: FetcherForm,
    submit,
    load
  }, fetcher, {
    data
  }), [FetcherForm, submit, load, fetcher, data]);
  return fetcherWithComponents;
}
/**
 * Provides all fetchers currently on the page. Useful for layouts and parent
 * routes that need to provide pending/optimistic UI regarding the fetch.
 */
function useFetchers() {
  let state = useDataRouterState(DataRouterStateHook.UseFetchers);
  return Array.from(state.fetchers.entries()).map(_ref11 => {
    let [key, fetcher] = _ref11;
    return _extends({}, fetcher, {
      key
    });
  });
}
const SCROLL_RESTORATION_STORAGE_KEY = "react-router-scroll-positions";
let savedScrollPositions = {};
/**
 * When rendered inside a RouterProvider, will restore scroll positions on navigations
 */
function useScrollRestoration(_temp4) {
  let {
    getKey,
    storageKey
  } = _temp4 === void 0 ? {} : _temp4;
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseScrollRestoration);
  let {
    restoreScrollPosition,
    preventScrollReset
  } = useDataRouterState(DataRouterStateHook.UseScrollRestoration);
  let {
    basename
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(react_router__WEBPACK_IMPORTED_MODULE_3__.UNSAFE_NavigationContext);
  let location = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useLocation)();
  let matches = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useMatches)();
  let navigation = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useNavigation)();
  // Trigger manual scroll restoration while we're active
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    window.history.scrollRestoration = "manual";
    return () => {
      window.history.scrollRestoration = "auto";
    };
  }, []);
  // Save positions on pagehide
  usePageHide(react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
    if (navigation.state === "idle") {
      let key = (getKey ? getKey(location, matches) : null) || location.key;
      savedScrollPositions[key] = window.scrollY;
    }
    try {
      sessionStorage.setItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY, JSON.stringify(savedScrollPositions));
    } catch (error) {
       true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_warning)(false, "Failed to save scroll positions in sessionStorage, <ScrollRestoration /> will not work properly (" + error + ").") : 0;
    }
    window.history.scrollRestoration = "auto";
  }, [storageKey, getKey, navigation.state, location, matches]));
  // Read in any saved scroll locations
  if (typeof document !== "undefined") {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      try {
        let sessionPositions = sessionStorage.getItem(storageKey || SCROLL_RESTORATION_STORAGE_KEY);
        if (sessionPositions) {
          savedScrollPositions = JSON.parse(sessionPositions);
        }
      } catch (e) {
        // no-op, use default empty object
      }
    }, [storageKey]);
    // Enable scroll restoration in the router
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      let getKeyWithoutBasename = getKey && basename !== "/" ? (location, matches) => getKey( // Strip the basename to match useLocation()
      _extends({}, location, {
        pathname: (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(location.pathname, basename) || location.pathname
      }), matches) : getKey;
      let disableScrollRestoration = router == null ? void 0 : router.enableScrollRestoration(savedScrollPositions, () => window.scrollY, getKeyWithoutBasename);
      return () => disableScrollRestoration && disableScrollRestoration();
    }, [router, basename, getKey]);
    // Restore scrolling when state.restoreScrollPosition changes
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => {
      // Explicit false means don't do anything (used for submissions)
      if (restoreScrollPosition === false) {
        return;
      }
      // been here before, scroll to it
      if (typeof restoreScrollPosition === "number") {
        window.scrollTo(0, restoreScrollPosition);
        return;
      }
      // try to scroll to the hash
      if (location.hash) {
        let el = document.getElementById(decodeURIComponent(location.hash.slice(1)));
        if (el) {
          el.scrollIntoView();
          return;
        }
      }
      // Don't reset if this navigation opted out
      if (preventScrollReset === true) {
        return;
      }
      // otherwise go to the top on new locations
      window.scrollTo(0, 0);
    }, [location, restoreScrollPosition, preventScrollReset]);
  }
}
/**
 * Setup a callback to be fired on the window's `beforeunload` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function useBeforeUnload(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("beforeunload", callback, opts);
    return () => {
      window.removeEventListener("beforeunload", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Setup a callback to be fired on the window's `pagehide` event. This is
 * useful for saving some data to `window.localStorage` just before the page
 * refreshes.  This event is better supported than beforeunload across browsers.
 *
 * Note: The `callback` argument should be a function created with
 * `React.useCallback()`.
 */
function usePageHide(callback, options) {
  let {
    capture
  } = options || {};
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let opts = capture != null ? {
      capture
    } : undefined;
    window.addEventListener("pagehide", callback, opts);
    return () => {
      window.removeEventListener("pagehide", callback, opts);
    };
  }, [callback, capture]);
}
/**
 * Wrapper around useBlocker to show a window.confirm prompt to users instead
 * of building a custom UI with useBlocker.
 *
 * Warning: This has *a lot of rough edges* and behaves very differently (and
 * very incorrectly in some cases) across browsers if user click addition
 * back/forward navigations while the confirm is open.  Use at your own risk.
 */
function usePrompt(_ref12) {
  let {
    when,
    message
  } = _ref12;
  let blocker = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useBlocker)(when);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked") {
      let proceed = window.confirm(message);
      if (proceed) {
        // This timeout is needed to avoid a weird "race" on POP navigations
        // between the `window.history` revert navigation and the result of
        // `window.confirm`
        setTimeout(blocker.proceed, 0);
      } else {
        blocker.reset();
      }
    }
  }, [blocker, message]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blocker.state === "blocked" && !when) {
      blocker.reset();
    }
  }, [blocker, when]);
}
/**
 * Return a boolean indicating if there is an active view transition to the
 * given href.  You can use this value to render CSS classes or viewTransitionName
 * styles onto your elements
 *
 * @param href The destination href
 * @param [opts.relative] Relative routing type ("route" | "path")
 */
function useViewTransitionState(to, opts) {
  if (opts === void 0) {
    opts = {};
  }
  let vtContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ViewTransitionContext);
  !(vtContext != null) ?  true ? (0,react_router__WEBPACK_IMPORTED_MODULE_2__.UNSAFE_invariant)(false, "`unstable_useViewTransitionState` must be used within `react-router-dom`'s `RouterProvider`.  " + "Did you accidentally import `RouterProvider` from `react-router`?") : 0 : void 0;
  let {
    basename
  } = useDataRouterContext(DataRouterHook.useViewTransitionState);
  let path = (0,react_router__WEBPACK_IMPORTED_MODULE_3__.useResolvedPath)(to, {
    relative: opts.relative
  });
  if (!vtContext.isTransitioning) {
    return false;
  }
  let currentPath = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(vtContext.currentLocation.pathname, basename) || vtContext.currentLocation.pathname;
  let nextPath = (0,react_router__WEBPACK_IMPORTED_MODULE_2__.stripBasename)(vtContext.nextLocation.pathname, basename) || vtContext.nextLocation.pathname;
  // Transition is active if we're going to or coming from the indicated
  // destination.  This ensures that other PUSH navigations that reverse
  // an indicated transition apply.  I.e., on the list view you have:
  //
  //   <NavLink to="/details/1" unstable_viewTransition>
  //
  // If you click the breadcrumb back to the list view:
  //
  //   <NavLink to="/list" unstable_viewTransition>
  //
  // We should apply the transition because it's indicated as active going
  // from /list -> /details/1 and therefore should be active on the reverse
  // (even though this isn't strictly a POP reverse)
  return (0,react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath)(path.pathname, nextPath) != null || (0,react_router__WEBPACK_IMPORTED_MODULE_2__.matchPath)(path.pathname, currentPath) != null;
}
//#endregion


//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/react-router/dist/index.js":
/*!*************************************************!*\
  !*** ./node_modules/react-router/dist/index.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortedDeferredError: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError),
/* harmony export */   Await: () => (/* binding */ Await),
/* harmony export */   MemoryRouter: () => (/* binding */ MemoryRouter),
/* harmony export */   Navigate: () => (/* binding */ Navigate),
/* harmony export */   NavigationType: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action),
/* harmony export */   Outlet: () => (/* binding */ Outlet),
/* harmony export */   Route: () => (/* binding */ Route),
/* harmony export */   Router: () => (/* binding */ Router),
/* harmony export */   RouterProvider: () => (/* binding */ RouterProvider),
/* harmony export */   Routes: () => (/* binding */ Routes),
/* harmony export */   UNSAFE_DataRouterContext: () => (/* binding */ DataRouterContext),
/* harmony export */   UNSAFE_DataRouterStateContext: () => (/* binding */ DataRouterStateContext),
/* harmony export */   UNSAFE_LocationContext: () => (/* binding */ LocationContext),
/* harmony export */   UNSAFE_NavigationContext: () => (/* binding */ NavigationContext),
/* harmony export */   UNSAFE_RouteContext: () => (/* binding */ RouteContext),
/* harmony export */   UNSAFE_mapRouteProperties: () => (/* binding */ mapRouteProperties),
/* harmony export */   UNSAFE_useRouteId: () => (/* binding */ useRouteId),
/* harmony export */   UNSAFE_useRoutesImpl: () => (/* binding */ useRoutesImpl),
/* harmony export */   createMemoryRouter: () => (/* binding */ createMemoryRouter),
/* harmony export */   createPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createPath),
/* harmony export */   createRoutesFromChildren: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   createRoutesFromElements: () => (/* binding */ createRoutesFromChildren),
/* harmony export */   defer: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.defer),
/* harmony export */   generatePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.generatePath),
/* harmony export */   isRouteErrorResponse: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse),
/* harmony export */   json: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.json),
/* harmony export */   matchPath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath),
/* harmony export */   matchRoutes: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes),
/* harmony export */   parsePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath),
/* harmony export */   redirect: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirect),
/* harmony export */   redirectDocument: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.redirectDocument),
/* harmony export */   renderMatches: () => (/* binding */ renderMatches),
/* harmony export */   replace: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.replace),
/* harmony export */   resolvePath: () => (/* reexport safe */ _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolvePath),
/* harmony export */   useActionData: () => (/* binding */ useActionData),
/* harmony export */   useAsyncError: () => (/* binding */ useAsyncError),
/* harmony export */   useAsyncValue: () => (/* binding */ useAsyncValue),
/* harmony export */   useBlocker: () => (/* binding */ useBlocker),
/* harmony export */   useHref: () => (/* binding */ useHref),
/* harmony export */   useInRouterContext: () => (/* binding */ useInRouterContext),
/* harmony export */   useLoaderData: () => (/* binding */ useLoaderData),
/* harmony export */   useLocation: () => (/* binding */ useLocation),
/* harmony export */   useMatch: () => (/* binding */ useMatch),
/* harmony export */   useMatches: () => (/* binding */ useMatches),
/* harmony export */   useNavigate: () => (/* binding */ useNavigate),
/* harmony export */   useNavigation: () => (/* binding */ useNavigation),
/* harmony export */   useNavigationType: () => (/* binding */ useNavigationType),
/* harmony export */   useOutlet: () => (/* binding */ useOutlet),
/* harmony export */   useOutletContext: () => (/* binding */ useOutletContext),
/* harmony export */   useParams: () => (/* binding */ useParams),
/* harmony export */   useResolvedPath: () => (/* binding */ useResolvedPath),
/* harmony export */   useRevalidator: () => (/* binding */ useRevalidator),
/* harmony export */   useRouteError: () => (/* binding */ useRouteError),
/* harmony export */   useRouteLoaderData: () => (/* binding */ useRouteLoaderData),
/* harmony export */   useRoutes: () => (/* binding */ useRoutes)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _remix_run_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @remix-run/router */ "./node_modules/@remix-run/router/dist/router.js");
/**
 * React Router v6.26.2
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */




function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}

// Create react-specific types from the agnostic types in @remix-run/router to
// export from react-router
const DataRouterContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterContext.displayName = "DataRouter";
}
const DataRouterStateContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  DataRouterStateContext.displayName = "DataRouterState";
}
const AwaitContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  AwaitContext.displayName = "Await";
}

/**
 * A Navigator is a "location changer"; it's how you get to different locations.
 *
 * Every history instance conforms to the Navigator interface, but the
 * distinction is useful primarily when it comes to the low-level `<Router>` API
 * where both the location and a navigator must be provided separately in order
 * to avoid "tearing" that may occur in a suspense-enabled app if the action
 * and/or location were to be read directly from the history instance.
 */

const NavigationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  NavigationContext.displayName = "Navigation";
}
const LocationContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  LocationContext.displayName = "Location";
}
const RouteContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext({
  outlet: null,
  matches: [],
  isDataRoute: false
});
if (true) {
  RouteContext.displayName = "Route";
}
const RouteErrorContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
if (true) {
  RouteErrorContext.displayName = "RouteError";
}

/**
 * Returns the full href for the given "to" value. This is useful for building
 * custom links that are also accessible and preserve right-click behavior.
 *
 * @see https://reactrouter.com/hooks/use-href
 */
function useHref(to, _temp) {
  let {
    relative
  } = _temp === void 0 ? {} : _temp;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useHref() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    basename,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    hash,
    pathname,
    search
  } = useResolvedPath(to, {
    relative
  });
  let joinedPathname = pathname;

  // If we're operating within a basename, prepend it to the pathname prior
  // to creating the href.  If this is a root navigation, then just use the raw
  // basename which allows the basename to have full control over the presence
  // of a trailing slash on root links
  if (basename !== "/") {
    joinedPathname = pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, pathname]);
  }
  return navigator.createHref({
    pathname: joinedPathname,
    search,
    hash
  });
}

/**
 * Returns true if this component is a descendant of a `<Router>`.
 *
 * @see https://reactrouter.com/hooks/use-in-router-context
 */
function useInRouterContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext) != null;
}

/**
 * Returns the current location object, which represents the current URL in web
 * browsers.
 *
 * Note: If you're using this it may mean you're doing some of your own
 * "routing" in your app, and we'd like to know what your use case is. We may
 * be able to provide something higher-level to better suit your needs.
 *
 * @see https://reactrouter.com/hooks/use-location
 */
function useLocation() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useLocation() may be used only in the context of a <Router> component.") : 0 : void 0;
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).location;
}

/**
 * Returns the current navigation action which describes how the router came to
 * the current location, either by a pop, push, or replace on the history stack.
 *
 * @see https://reactrouter.com/hooks/use-navigation-type
 */
function useNavigationType() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(LocationContext).navigationType;
}

/**
 * Returns a PathMatch object if the given pattern matches the current URL.
 * This is useful for components that need to know "active" state, e.g.
 * `<NavLink>`.
 *
 * @see https://reactrouter.com/hooks/use-match
 */
function useMatch(pattern) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useMatch() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    pathname
  } = useLocation();
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchPath)(pattern, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_decodePath)(pathname)), [pathname, pattern]);
}

/**
 * The interface for the navigate() function returned from useNavigate().
 */

const navigateEffectWarning = "You should call navigate() in a React.useEffect(), not when " + "your component is first rendered.";

// Mute warnings for calls to useNavigate in SSR environments
function useIsomorphicLayoutEffect(cb) {
  let isStatic = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext).static;
  if (!isStatic) {
    // We should be able to get rid of this once react 18.3 is released
    // See: https://github.com/facebook/react/pull/26395
    // eslint-disable-next-line react-hooks/rules-of-hooks
    react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(cb);
  }
}

/**
 * Returns an imperative method for changing the location. Used by `<Link>`s, but
 * may also be used by other elements to change the location.
 *
 * @see https://reactrouter.com/hooks/use-navigate
 */
function useNavigate() {
  let {
    isDataRoute
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  // Conditional usage is OK here because the usage of a data router is static
  // eslint-disable-next-line react-hooks/rules-of-hooks
  return isDataRoute ? useNavigateStable() : useNavigateUnstable();
}
function useNavigateUnstable() {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useNavigate() may be used only in the context of a <Router> component.") : 0 : void 0;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  let {
    basename,
    future,
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our history listener yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      navigator.go(to);
      return;
    }
    let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, options.relative === "path");

    // If we're operating within a basename, prepend it to the pathname prior
    // to handing off to history (but only if we're not in a data router,
    // otherwise it'll prepend the basename inside of the router).
    // If this is a root navigation, then we navigate to the raw basename
    // which allows the basename to have full control over the presence of a
    // trailing slash on root links
    if (dataRouterContext == null && basename !== "/") {
      path.pathname = path.pathname === "/" ? basename : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([basename, path.pathname]);
    }
    (!!options.replace ? navigator.replace : navigator.push)(path, options.state, options);
  }, [basename, navigator, routePathnamesJson, locationPathname, dataRouterContext]);
  return navigate;
}
const OutletContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);

/**
 * Returns the context (if provided) for the child route at this level of the route
 * hierarchy.
 * @see https://reactrouter.com/hooks/use-outlet-context
 */
function useOutletContext() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(OutletContext);
}

/**
 * Returns the element for the child route at this level of the route
 * hierarchy. Used internally by `<Outlet>` to render child routes.
 *
 * @see https://reactrouter.com/hooks/use-outlet
 */
function useOutlet(context) {
  let outlet = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext).outlet;
  if (outlet) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(OutletContext.Provider, {
      value: context
    }, outlet);
  }
  return outlet;
}

/**
 * Returns an object of key/value pairs of the dynamic params from the current
 * URL that were matched by the route path.
 *
 * @see https://reactrouter.com/hooks/use-params
 */
function useParams() {
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = matches[matches.length - 1];
  return routeMatch ? routeMatch.params : {};
}

/**
 * Resolves the pathname of the given `to` value against the current location.
 *
 * @see https://reactrouter.com/hooks/use-resolved-path
 */
function useResolvedPath(to, _temp2) {
  let {
    relative
  } = _temp2 === void 0 ? {} : _temp2;
  let {
    future
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let routePathnamesJson = JSON.stringify((0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath));
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, JSON.parse(routePathnamesJson), locationPathname, relative === "path"), [to, routePathnamesJson, locationPathname, relative]);
}

/**
 * Returns the element of the route that matched the current location, prepared
 * with the correct context to render the remainder of the route tree. Route
 * elements in the tree must render an `<Outlet>` to render their child route's
 * element.
 *
 * @see https://reactrouter.com/hooks/use-routes
 */
function useRoutes(routes, locationArg) {
  return useRoutesImpl(routes, locationArg);
}

// Internal implementation with accept optional param for RouterProvider usage
function useRoutesImpl(routes, locationArg, dataRouterState, future) {
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of the
  // router loaded. We can help them understand how to avoid that.
  "useRoutes() may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    navigator
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
  let {
    matches: parentMatches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let routeMatch = parentMatches[parentMatches.length - 1];
  let parentParams = routeMatch ? routeMatch.params : {};
  let parentPathname = routeMatch ? routeMatch.pathname : "/";
  let parentPathnameBase = routeMatch ? routeMatch.pathnameBase : "/";
  let parentRoute = routeMatch && routeMatch.route;
  if (true) {
    // You won't get a warning about 2 different <Routes> under a <Route>
    // without a trailing *, but this is a best-effort warning anyway since we
    // cannot even give the warning unless they land at the parent route.
    //
    // Example:
    //
    // <Routes>
    //   {/* This route path MUST end with /* because otherwise
    //       it will never match /blog/post/123 */}
    //   <Route path="blog" element={<Blog />} />
    //   <Route path="blog/feed" element={<BlogFeed />} />
    // </Routes>
    //
    // function Blog() {
    //   return (
    //     <Routes>
    //       <Route path="post/:id" element={<Post />} />
    //     </Routes>
    //   );
    // }
    let parentPath = parentRoute && parentRoute.path || "";
    warningOnce(parentPathname, !parentRoute || parentPath.endsWith("*"), "You rendered descendant <Routes> (or called `useRoutes()`) at " + ("\"" + parentPathname + "\" (under <Route path=\"" + parentPath + "\">) but the ") + "parent route path has no trailing \"*\". This means if you navigate " + "deeper, the parent won't match anymore and therefore the child " + "routes will never render.\n\n" + ("Please change the parent <Route path=\"" + parentPath + "\"> to <Route ") + ("path=\"" + (parentPath === "/" ? "*" : parentPath + "/*") + "\">."));
  }
  let locationFromContext = useLocation();
  let location;
  if (locationArg) {
    var _parsedLocationArg$pa;
    let parsedLocationArg = typeof locationArg === "string" ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationArg) : locationArg;
    !(parentPathnameBase === "/" || ((_parsedLocationArg$pa = parsedLocationArg.pathname) == null ? void 0 : _parsedLocationArg$pa.startsWith(parentPathnameBase))) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "When overriding the location using `<Routes location>` or `useRoutes(routes, location)`, " + "the location pathname must begin with the portion of the URL pathname that was " + ("matched by all parent routes. The current pathname base is \"" + parentPathnameBase + "\" ") + ("but pathname \"" + parsedLocationArg.pathname + "\" was given in the `location` prop.")) : 0 : void 0;
    location = parsedLocationArg;
  } else {
    location = locationFromContext;
  }
  let pathname = location.pathname || "/";
  let remainingPathname = pathname;
  if (parentPathnameBase !== "/") {
    // Determine the remaining pathname by removing the # of URL segments the
    // parentPathnameBase has, instead of removing based on character count.
    // This is because we can't guarantee that incoming/outgoing encodings/
    // decodings will match exactly.
    // We decode paths before matching on a per-segment basis with
    // decodeURIComponent(), but we re-encode pathnames via `new URL()` so they
    // match what `window.location.pathname` would reflect.  Those don't 100%
    // align when it comes to encoded URI characters such as % and &.
    //
    // So we may end up with:
    //   pathname:           "/descendant/a%25b/match"
    //   parentPathnameBase: "/descendant/a%b"
    //
    // And the direct substring removal approach won't work :/
    let parentSegments = parentPathnameBase.replace(/^\//, "").split("/");
    let segments = pathname.replace(/^\//, "").split("/");
    remainingPathname = "/" + segments.slice(parentSegments.length).join("/");
  }
  let matches = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.matchRoutes)(routes, {
    pathname: remainingPathname
  });
  if (true) {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(parentRoute || matches != null, "No routes matched location \"" + location.pathname + location.search + location.hash + "\" ") : 0;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(matches == null || matches[matches.length - 1].route.element !== undefined || matches[matches.length - 1].route.Component !== undefined || matches[matches.length - 1].route.lazy !== undefined, "Matched leaf route at location \"" + location.pathname + location.search + location.hash + "\" " + "does not have an element or Component. This means it will render an <Outlet /> with a " + "null value by default resulting in an \"empty\" page.") : 0;
  }
  let renderedMatches = _renderMatches(matches && matches.map(match => Object.assign({}, match, {
    params: Object.assign({}, parentParams, match.params),
    pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathname).pathname : match.pathname]),
    pathnameBase: match.pathnameBase === "/" ? parentPathnameBase : (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.joinPaths)([parentPathnameBase,
    // Re-encode pathnames that were decoded inside matchRoutes
    navigator.encodeLocation ? navigator.encodeLocation(match.pathnameBase).pathname : match.pathnameBase])
  })), parentMatches, dataRouterState, future);

  // When a user passes in a `locationArg`, the associated routes need to
  // be wrapped in a new `LocationContext.Provider` in order for `useLocation`
  // to use the scoped location instead of the global location.
  if (locationArg && renderedMatches) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
      value: {
        location: _extends({
          pathname: "/",
          search: "",
          hash: "",
          state: null,
          key: "default"
        }, location),
        navigationType: _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop
      }
    }, renderedMatches);
  }
  return renderedMatches;
}
function DefaultErrorComponent() {
  let error = useRouteError();
  let message = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.isRouteErrorResponse)(error) ? error.status + " " + error.statusText : error instanceof Error ? error.message : JSON.stringify(error);
  let stack = error instanceof Error ? error.stack : null;
  let lightgrey = "rgba(200,200,200, 0.5)";
  let preStyles = {
    padding: "0.5rem",
    backgroundColor: lightgrey
  };
  let codeStyles = {
    padding: "2px 4px",
    backgroundColor: lightgrey
  };
  let devInfo = null;
  if (true) {
    console.error("Error handled by React Router default ErrorBoundary:", error);
    devInfo = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "\uD83D\uDCBF Hey developer \uD83D\uDC4B"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, "You can provide a way better UX than this when your app throws errors by providing your own ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "ErrorBoundary"), " or", " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("code", {
      style: codeStyles
    }, "errorElement"), " prop on your route."));
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, "Unexpected Application Error!"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", {
    style: {
      fontStyle: "italic"
    }
  }, message), stack ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", {
    style: preStyles
  }, stack) : null, devInfo);
}
const defaultErrorElement = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DefaultErrorComponent, null);
class RenderErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      location: props.location,
      revalidation: props.revalidation,
      error: props.error
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error: error
    };
  }
  static getDerivedStateFromProps(props, state) {
    // When we get into an error state, the user will likely click "back" to the
    // previous page that didn't have an error. Because this wraps the entire
    // application, that will have no effect--the error page continues to display.
    // This gives us a mechanism to recover from the error when the location changes.
    //
    // Whether we're in an error state or not, we update the location in state
    // so that when we are in an error state, it gets reset when a new location
    // comes in and the user recovers from the error.
    if (state.location !== props.location || state.revalidation !== "idle" && props.revalidation === "idle") {
      return {
        error: props.error,
        location: props.location,
        revalidation: props.revalidation
      };
    }

    // If we're not changing locations, preserve the location but still surface
    // any new errors that may come through. We retain the existing error, we do
    // this because the error provided from the app state may be cleared without
    // the location changing.
    return {
      error: props.error !== undefined ? props.error : state.error,
      location: state.location,
      revalidation: props.revalidation || state.revalidation
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("React Router caught the following error during render", error, errorInfo);
  }
  render() {
    return this.state.error !== undefined ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
      value: this.props.routeContext
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteErrorContext.Provider, {
      value: this.state.error,
      children: this.props.component
    })) : this.props.children;
  }
}
function RenderedRoute(_ref) {
  let {
    routeContext,
    match,
    children
  } = _ref;
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);

  // Track how deep we got in our render pass to emulate SSR componentDidCatch
  // in a DataStaticRouter
  if (dataRouterContext && dataRouterContext.static && dataRouterContext.staticContext && (match.route.errorElement || match.route.ErrorBoundary)) {
    dataRouterContext.staticContext._deepestRenderedBoundaryId = match.route.id;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RouteContext.Provider, {
    value: routeContext
  }, children);
}
function _renderMatches(matches, parentMatches, dataRouterState, future) {
  var _dataRouterState;
  if (parentMatches === void 0) {
    parentMatches = [];
  }
  if (dataRouterState === void 0) {
    dataRouterState = null;
  }
  if (future === void 0) {
    future = null;
  }
  if (matches == null) {
    var _future;
    if (!dataRouterState) {
      return null;
    }
    if (dataRouterState.errors) {
      // Don't bail if we have data router errors so we can render them in the
      // boundary.  Use the pre-matched (or shimmed) matches
      matches = dataRouterState.matches;
    } else if ((_future = future) != null && _future.v7_partialHydration && parentMatches.length === 0 && !dataRouterState.initialized && dataRouterState.matches.length > 0) {
      // Don't bail if we're initializing with partial hydration and we have
      // router matches.  That means we're actively running `patchRoutesOnNavigation`
      // so we should render down the partial matches to the appropriate
      // `HydrateFallback`.  We only do this if `parentMatches` is empty so it
      // only impacts the root matches for `RouterProvider` and no descendant
      // `<Routes>`
      matches = dataRouterState.matches;
    } else {
      return null;
    }
  }
  let renderedMatches = matches;

  // If we have data errors, trim matches to the highest error boundary
  let errors = (_dataRouterState = dataRouterState) == null ? void 0 : _dataRouterState.errors;
  if (errors != null) {
    let errorIndex = renderedMatches.findIndex(m => m.route.id && (errors == null ? void 0 : errors[m.route.id]) !== undefined);
    !(errorIndex >= 0) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "Could not find a matching route for errors on route IDs: " + Object.keys(errors).join(",")) : 0 : void 0;
    renderedMatches = renderedMatches.slice(0, Math.min(renderedMatches.length, errorIndex + 1));
  }

  // If we're in a partial hydration mode, detect if we need to render down to
  // a given HydrateFallback while we load the rest of the hydration data
  let renderFallback = false;
  let fallbackIndex = -1;
  if (dataRouterState && future && future.v7_partialHydration) {
    for (let i = 0; i < renderedMatches.length; i++) {
      let match = renderedMatches[i];
      // Track the deepest fallback up until the first route without data
      if (match.route.HydrateFallback || match.route.hydrateFallbackElement) {
        fallbackIndex = i;
      }
      if (match.route.id) {
        let {
          loaderData,
          errors
        } = dataRouterState;
        let needsToRunLoader = match.route.loader && loaderData[match.route.id] === undefined && (!errors || errors[match.route.id] === undefined);
        if (match.route.lazy || needsToRunLoader) {
          // We found the first route that's not ready to render (waiting on
          // lazy, or has a loader that hasn't run yet).  Flag that we need to
          // render a fallback and render up until the appropriate fallback
          renderFallback = true;
          if (fallbackIndex >= 0) {
            renderedMatches = renderedMatches.slice(0, fallbackIndex + 1);
          } else {
            renderedMatches = [renderedMatches[0]];
          }
          break;
        }
      }
    }
  }
  return renderedMatches.reduceRight((outlet, match, index) => {
    // Only data routers handle errors/fallbacks
    let error;
    let shouldRenderHydrateFallback = false;
    let errorElement = null;
    let hydrateFallbackElement = null;
    if (dataRouterState) {
      error = errors && match.route.id ? errors[match.route.id] : undefined;
      errorElement = match.route.errorElement || defaultErrorElement;
      if (renderFallback) {
        if (fallbackIndex < 0 && index === 0) {
          warningOnce("route-fallback", false, "No `HydrateFallback` element provided to render during initial hydration");
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = null;
        } else if (fallbackIndex === index) {
          shouldRenderHydrateFallback = true;
          hydrateFallbackElement = match.route.hydrateFallbackElement || null;
        }
      }
    }
    let matches = parentMatches.concat(renderedMatches.slice(0, index + 1));
    let getChildren = () => {
      let children;
      if (error) {
        children = errorElement;
      } else if (shouldRenderHydrateFallback) {
        children = hydrateFallbackElement;
      } else if (match.route.Component) {
        // Note: This is a de-optimized path since React won't re-use the
        // ReactElement since it's identity changes with each new
        // React.createElement call.  We keep this so folks can use
        // `<Route Component={...}>` in `<Routes>` but generally `Component`
        // usage is only advised in `RouterProvider` when we can convert it to
        // `element` ahead of time.
        children = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(match.route.Component, null);
      } else if (match.route.element) {
        children = match.route.element;
      } else {
        children = outlet;
      }
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderedRoute, {
        match: match,
        routeContext: {
          outlet,
          matches,
          isDataRoute: dataRouterState != null
        },
        children: children
      });
    };
    // Only wrap in an error boundary within data router usages when we have an
    // ErrorBoundary/errorElement on this route.  Otherwise let it bubble up to
    // an ancestor ErrorBoundary/errorElement
    return dataRouterState && (match.route.ErrorBoundary || match.route.errorElement || index === 0) ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(RenderErrorBoundary, {
      location: dataRouterState.location,
      revalidation: dataRouterState.revalidation,
      component: errorElement,
      error: error,
      children: getChildren(),
      routeContext: {
        outlet: null,
        matches,
        isDataRoute: true
      }
    }) : getChildren();
  }, null);
}
var DataRouterHook = /*#__PURE__*/function (DataRouterHook) {
  DataRouterHook["UseBlocker"] = "useBlocker";
  DataRouterHook["UseRevalidator"] = "useRevalidator";
  DataRouterHook["UseNavigateStable"] = "useNavigate";
  return DataRouterHook;
}(DataRouterHook || {});
var DataRouterStateHook = /*#__PURE__*/function (DataRouterStateHook) {
  DataRouterStateHook["UseBlocker"] = "useBlocker";
  DataRouterStateHook["UseLoaderData"] = "useLoaderData";
  DataRouterStateHook["UseActionData"] = "useActionData";
  DataRouterStateHook["UseRouteError"] = "useRouteError";
  DataRouterStateHook["UseNavigation"] = "useNavigation";
  DataRouterStateHook["UseRouteLoaderData"] = "useRouteLoaderData";
  DataRouterStateHook["UseMatches"] = "useMatches";
  DataRouterStateHook["UseRevalidator"] = "useRevalidator";
  DataRouterStateHook["UseNavigateStable"] = "useNavigate";
  DataRouterStateHook["UseRouteId"] = "useRouteId";
  return DataRouterStateHook;
}(DataRouterStateHook || {});
function getDataRouterConsoleError(hookName) {
  return hookName + " must be used within a data router.  See https://reactrouter.com/routers/picking-a-router.";
}
function useDataRouterContext(hookName) {
  let ctx = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterContext);
  !ctx ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return ctx;
}
function useDataRouterState(hookName) {
  let state = react__WEBPACK_IMPORTED_MODULE_0__.useContext(DataRouterStateContext);
  !state ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return state;
}
function useRouteContext(hookName) {
  let route = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  !route ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, getDataRouterConsoleError(hookName)) : 0 : void 0;
  return route;
}

// Internal version with hookName-aware debugging
function useCurrentRouteId(hookName) {
  let route = useRouteContext(hookName);
  let thisRoute = route.matches[route.matches.length - 1];
  !thisRoute.route.id ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, hookName + " can only be used on routes that contain a unique \"id\"") : 0 : void 0;
  return thisRoute.route.id;
}

/**
 * Returns the ID for the nearest contextual route
 */
function useRouteId() {
  return useCurrentRouteId(DataRouterStateHook.UseRouteId);
}

/**
 * Returns the current navigation, defaulting to an "idle" navigation when
 * no navigation is in progress
 */
function useNavigation() {
  let state = useDataRouterState(DataRouterStateHook.UseNavigation);
  return state.navigation;
}

/**
 * Returns a revalidate function for manually triggering revalidation, as well
 * as the current state of any manual revalidations
 */
function useRevalidator() {
  let dataRouterContext = useDataRouterContext(DataRouterHook.UseRevalidator);
  let state = useDataRouterState(DataRouterStateHook.UseRevalidator);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    revalidate: dataRouterContext.router.revalidate,
    state: state.revalidation
  }), [dataRouterContext.router.revalidate, state.revalidation]);
}

/**
 * Returns the active route matches, useful for accessing loaderData for
 * parent/child routes or the route "handle" property
 */
function useMatches() {
  let {
    matches,
    loaderData
  } = useDataRouterState(DataRouterStateHook.UseMatches);
  return react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => matches.map(m => (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_convertRouteMatchToUiMatch)(m, loaderData)), [matches, loaderData]);
}

/**
 * Returns the loader data for the nearest ancestor Route loader
 */
function useLoaderData() {
  let state = useDataRouterState(DataRouterStateHook.UseLoaderData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  if (state.errors && state.errors[routeId] != null) {
    console.error("You cannot `useLoaderData` in an errorElement (routeId: " + routeId + ")");
    return undefined;
  }
  return state.loaderData[routeId];
}

/**
 * Returns the loaderData for the given routeId
 */
function useRouteLoaderData(routeId) {
  let state = useDataRouterState(DataRouterStateHook.UseRouteLoaderData);
  return state.loaderData[routeId];
}

/**
 * Returns the action data for the nearest ancestor Route action
 */
function useActionData() {
  let state = useDataRouterState(DataRouterStateHook.UseActionData);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseLoaderData);
  return state.actionData ? state.actionData[routeId] : undefined;
}

/**
 * Returns the nearest ancestor Route error, which could be a loader/action
 * error or a render error.  This is intended to be called from your
 * ErrorBoundary/errorElement to display a proper error message.
 */
function useRouteError() {
  var _state$errors;
  let error = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteErrorContext);
  let state = useDataRouterState(DataRouterStateHook.UseRouteError);
  let routeId = useCurrentRouteId(DataRouterStateHook.UseRouteError);

  // If this was a render error, we put it in a RouteError context inside
  // of RenderErrorBoundary
  if (error !== undefined) {
    return error;
  }

  // Otherwise look for errors from our data router state
  return (_state$errors = state.errors) == null ? void 0 : _state$errors[routeId];
}

/**
 * Returns the happy-path data from the nearest ancestor `<Await />` value
 */
function useAsyncValue() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._data;
}

/**
 * Returns the error from the nearest ancestor `<Await />` value
 */
function useAsyncError() {
  let value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(AwaitContext);
  return value == null ? void 0 : value._error;
}
let blockerId = 0;

/**
 * Allow the application to block navigations within the SPA and present the
 * user a confirmation dialog to confirm the navigation.  Mostly used to avoid
 * using half-filled form data.  This does not handle hard-reloads or
 * cross-origin navigations.
 */
function useBlocker(shouldBlock) {
  let {
    router,
    basename
  } = useDataRouterContext(DataRouterHook.UseBlocker);
  let state = useDataRouterState(DataRouterStateHook.UseBlocker);
  let [blockerKey, setBlockerKey] = react__WEBPACK_IMPORTED_MODULE_0__.useState("");
  let blockerFunction = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(arg => {
    if (typeof shouldBlock !== "function") {
      return !!shouldBlock;
    }
    if (basename === "/") {
      return shouldBlock(arg);
    }

    // If they provided us a function and we've got an active basename, strip
    // it from the locations we expose to the user to match the behavior of
    // useLocation
    let {
      currentLocation,
      nextLocation,
      historyAction
    } = arg;
    return shouldBlock({
      currentLocation: _extends({}, currentLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(currentLocation.pathname, basename) || currentLocation.pathname
      }),
      nextLocation: _extends({}, nextLocation, {
        pathname: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(nextLocation.pathname, basename) || nextLocation.pathname
      }),
      historyAction
    });
  }, [basename, shouldBlock]);

  // This effect is in charge of blocker key assignment and deletion (which is
  // tightly coupled to the key)
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    let key = String(++blockerId);
    setBlockerKey(key);
    return () => router.deleteBlocker(key);
  }, [router]);

  // This effect handles assigning the blockerFunction.  This is to handle
  // unstable blocker function identities, and happens only after the prior
  // effect so we don't get an orphaned blockerFunction in the router with a
  // key of "".  Until then we just have the IDLE_BLOCKER.
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
    if (blockerKey !== "") {
      router.getBlocker(blockerKey, blockerFunction);
    }
  }, [router, blockerKey, blockerFunction]);

  // Prefer the blocker from `state` not `router.state` since DataRouterContext
  // is memoized so this ensures we update on blocker state updates
  return blockerKey && state.blockers.has(blockerKey) ? state.blockers.get(blockerKey) : _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.IDLE_BLOCKER;
}

/**
 * Stable version of useNavigate that is used when we are in the context of
 * a RouterProvider.
 */
function useNavigateStable() {
  let {
    router
  } = useDataRouterContext(DataRouterHook.UseNavigateStable);
  let id = useCurrentRouteId(DataRouterStateHook.UseNavigateStable);
  let activeRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(false);
  useIsomorphicLayoutEffect(() => {
    activeRef.current = true;
  });
  let navigate = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(function (to, options) {
    if (options === void 0) {
      options = {};
    }
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(activeRef.current, navigateEffectWarning) : 0;

    // Short circuit here since if this happens on first render the navigate
    // is useless because we haven't wired up our router subscriber yet
    if (!activeRef.current) return;
    if (typeof to === "number") {
      router.navigate(to);
    } else {
      router.navigate(to, _extends({
        fromRouteId: id
      }, options));
    }
  }, [router, id]);
  return navigate;
}
const alreadyWarned = {};
function warningOnce(key, cond, message) {
  if (!cond && !alreadyWarned[key]) {
    alreadyWarned[key] = true;
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, message) : 0;
  }
}

/**
  Webpack + React 17 fails to compile on any of the following because webpack
  complains that `startTransition` doesn't exist in `React`:
  * import { startTransition } from "react"
  * import * as React from from "react";
    "startTransition" in React ? React.startTransition(() => setState()) : setState()
  * import * as React from from "react";
    "startTransition" in React ? React["startTransition"](() => setState()) : setState()

  Moving it to a constant such as the following solves the Webpack/React 17 issue:
  * import * as React from from "react";
    const START_TRANSITION = "startTransition";
    START_TRANSITION in React ? React[START_TRANSITION](() => setState()) : setState()

  However, that introduces webpack/terser minification issues in production builds
  in React 18 where minification/obfuscation ends up removing the call of
  React.startTransition entirely from the first half of the ternary.  Grabbing
  this exported reference once up front resolves that issue.

  See https://github.com/remix-run/react-router/issues/10579
*/
const START_TRANSITION = "startTransition";
const startTransitionImpl = react__WEBPACK_IMPORTED_MODULE_0__[START_TRANSITION];

/**
 * Given a Remix Router instance, render the appropriate UI
 */
function RouterProvider(_ref) {
  let {
    fallbackElement,
    router,
    future
  } = _ref;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState(router.state);
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    if (v7_startTransition && startTransitionImpl) {
      startTransitionImpl(() => setStateImpl(newState));
    } else {
      setStateImpl(newState);
    }
  }, [setStateImpl, v7_startTransition]);

  // Need to use a layout effect here so we are subscribed early enough to
  // pick up on any render-driven redirects/navigations (useEffect/<Navigate>)
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => router.subscribe(setState), [router, setState]);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
     true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(fallbackElement == null || !router.future.v7_partialHydration, "`<RouterProvider fallbackElement>` is deprecated when using " + "`v7_partialHydration`, use a `HydrateFallback` component instead") : 0;
    // Only log this once on initial mount
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  let navigator = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    return {
      createHref: router.createHref,
      encodeLocation: router.encodeLocation,
      go: n => router.navigate(n),
      push: (to, state, opts) => router.navigate(to, {
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      }),
      replace: (to, state, opts) => router.navigate(to, {
        replace: true,
        state,
        preventScrollReset: opts == null ? void 0 : opts.preventScrollReset
      })
    };
  }, [router]);
  let basename = router.basename || "/";
  let dataRouterContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    router,
    navigator,
    static: false,
    basename
  }), [router, navigator, basename]);

  // The fragment and {null} here are important!  We need them to keep React 18's
  // useId happy when we are server-rendering since we may have a <script> here
  // containing the hydrated server-side staticContext (from StaticRouterProvider).
  // useId relies on the component tree structure to generate deterministic id's
  // so we need to ensure it remains the same on the client even though
  // we don't need the <script> tag
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterContext.Provider, {
    value: dataRouterContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRouterStateContext.Provider, {
    value: state
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    location: state.location,
    navigationType: state.historyAction,
    navigator: navigator,
    future: {
      v7_relativeSplatPath: router.future.v7_relativeSplatPath
    }
  }, state.initialized || router.future.v7_partialHydration ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(DataRoutes, {
    routes: router.routes,
    future: router.future,
    state: state
  }) : fallbackElement))), null);
}
function DataRoutes(_ref2) {
  let {
    routes,
    future,
    state
  } = _ref2;
  return useRoutesImpl(routes, undefined, state, future);
}
/**
 * A `<Router>` that stores all entries in memory.
 *
 * @see https://reactrouter.com/router-components/memory-router
 */
function MemoryRouter(_ref3) {
  let {
    basename,
    children,
    initialEntries,
    initialIndex,
    future
  } = _ref3;
  let historyRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef();
  if (historyRef.current == null) {
    historyRef.current = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries,
      initialIndex,
      v5Compat: true
    });
  }
  let history = historyRef.current;
  let [state, setStateImpl] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
    action: history.action,
    location: history.location
  });
  let {
    v7_startTransition
  } = future || {};
  let setState = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(newState => {
    v7_startTransition && startTransitionImpl ? startTransitionImpl(() => setStateImpl(newState)) : setStateImpl(newState);
  }, [setStateImpl, v7_startTransition]);
  react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect(() => history.listen(setState), [history, setState]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Router, {
    basename: basename,
    children: children,
    location: state.location,
    navigationType: state.action,
    navigator: history,
    future: future
  });
}
/**
 * Changes the current location.
 *
 * Note: This API is mostly useful in React.Component subclasses that are not
 * able to use hooks. In functional components, we recommend you use the
 * `useNavigate` hook instead.
 *
 * @see https://reactrouter.com/components/navigate
 */
function Navigate(_ref4) {
  let {
    to,
    replace,
    state,
    relative
  } = _ref4;
  !useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, // TODO: This error is probably because they somehow have 2 versions of
  // the router loaded. We can help them understand how to avoid that.
  "<Navigate> may be used only in the context of a <Router> component.") : 0 : void 0;
  let {
    future,
    static: isStatic
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(NavigationContext);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(!isStatic, "<Navigate> must not be used on the initial render in a <StaticRouter>. " + "This is a no-op, but you should modify your code so the <Navigate> is " + "only ever rendered in response to some user interaction or state change.") : 0;
  let {
    matches
  } = react__WEBPACK_IMPORTED_MODULE_0__.useContext(RouteContext);
  let {
    pathname: locationPathname
  } = useLocation();
  let navigate = useNavigate();

  // Resolve the path outside of the effect so that when effects run twice in
  // StrictMode they navigate to the same place
  let path = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.resolveTo)(to, (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_getResolveToMatches)(matches, future.v7_relativeSplatPath), locationPathname, relative === "path");
  let jsonPath = JSON.stringify(path);
  react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => navigate(JSON.parse(jsonPath), {
    replace,
    state,
    relative
  }), [navigate, jsonPath, relative, replace, state]);
  return null;
}
/**
 * Renders the child route's element, if there is one.
 *
 * @see https://reactrouter.com/components/outlet
 */
function Outlet(props) {
  return useOutlet(props.context);
}
/**
 * Declares an element that should be rendered at a certain URL path.
 *
 * @see https://reactrouter.com/components/route
 */
function Route(_props) {
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "A <Route> is only ever to be used as the child of <Routes> element, " + "never rendered directly. Please wrap your <Route> in a <Routes>.") : 0 ;
}
/**
 * Provides location context for the rest of the app.
 *
 * Note: You usually won't render a `<Router>` directly. Instead, you'll render a
 * router that is more specific to your environment such as a `<BrowserRouter>`
 * in web browsers or a `<StaticRouter>` for server rendering.
 *
 * @see https://reactrouter.com/router-components/router
 */
function Router(_ref5) {
  let {
    basename: basenameProp = "/",
    children = null,
    location: locationProp,
    navigationType = _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.Action.Pop,
    navigator,
    static: staticProp = false,
    future
  } = _ref5;
  !!useInRouterContext() ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "You cannot render a <Router> inside another <Router>." + " You should never have more than one in your app.") : 0 : void 0;

  // Preserve trailing slashes on basename, so we can let the user control
  // the enforcement of trailing slashes throughout the app
  let basename = basenameProp.replace(/^\/*/, "/");
  let navigationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
    basename,
    navigator,
    static: staticProp,
    future: _extends({
      v7_relativeSplatPath: false
    }, future)
  }), [basename, future, navigator, staticProp]);
  if (typeof locationProp === "string") {
    locationProp = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.parsePath)(locationProp);
  }
  let {
    pathname = "/",
    search = "",
    hash = "",
    state = null,
    key = "default"
  } = locationProp;
  let locationContext = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
    let trailingPathname = (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.stripBasename)(pathname, basename);
    if (trailingPathname == null) {
      return null;
    }
    return {
      location: {
        pathname: trailingPathname,
        search,
        hash,
        state,
        key
      },
      navigationType
    };
  }, [basename, pathname, search, hash, state, key, navigationType]);
   true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(locationContext != null, "<Router basename=\"" + basename + "\"> is not able to match the URL " + ("\"" + pathname + search + hash + "\" because it does not start with the ") + "basename, so the <Router> won't render anything.") : 0;
  if (locationContext == null) {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(NavigationContext.Provider, {
    value: navigationContext
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(LocationContext.Provider, {
    children: children,
    value: locationContext
  }));
}
/**
 * A container for a nested tree of `<Route>` elements that renders the branch
 * that best matches the current location.
 *
 * @see https://reactrouter.com/components/routes
 */
function Routes(_ref6) {
  let {
    children,
    location
  } = _ref6;
  return useRoutes(createRoutesFromChildren(children), location);
}
/**
 * Component to use for rendering lazily loaded data from returning defer()
 * in a loader function
 */
function Await(_ref7) {
  let {
    children,
    errorElement,
    resolve
  } = _ref7;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitErrorBoundary, {
    resolve: resolve,
    errorElement: errorElement
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ResolveAwait, null, children));
}
var AwaitRenderStatus = /*#__PURE__*/function (AwaitRenderStatus) {
  AwaitRenderStatus[AwaitRenderStatus["pending"] = 0] = "pending";
  AwaitRenderStatus[AwaitRenderStatus["success"] = 1] = "success";
  AwaitRenderStatus[AwaitRenderStatus["error"] = 2] = "error";
  return AwaitRenderStatus;
}(AwaitRenderStatus || {});
const neverSettledPromise = new Promise(() => {});
class AwaitErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null
    };
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch(error, errorInfo) {
    console.error("<Await> caught the following error during render", error, errorInfo);
  }
  render() {
    let {
      children,
      errorElement,
      resolve
    } = this.props;
    let promise = null;
    let status = AwaitRenderStatus.pending;
    if (!(resolve instanceof Promise)) {
      // Didn't get a promise - provide as a resolved promise
      status = AwaitRenderStatus.success;
      promise = Promise.resolve();
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_data", {
        get: () => resolve
      });
    } else if (this.state.error) {
      // Caught a render error, provide it as a rejected promise
      status = AwaitRenderStatus.error;
      let renderError = this.state.error;
      promise = Promise.reject().catch(() => {}); // Avoid unhandled rejection warnings
      Object.defineProperty(promise, "_tracked", {
        get: () => true
      });
      Object.defineProperty(promise, "_error", {
        get: () => renderError
      });
    } else if (resolve._tracked) {
      // Already tracked promise - check contents
      promise = resolve;
      status = "_error" in promise ? AwaitRenderStatus.error : "_data" in promise ? AwaitRenderStatus.success : AwaitRenderStatus.pending;
    } else {
      // Raw (untracked) promise - track it
      status = AwaitRenderStatus.pending;
      Object.defineProperty(resolve, "_tracked", {
        get: () => true
      });
      promise = resolve.then(data => Object.defineProperty(resolve, "_data", {
        get: () => data
      }), error => Object.defineProperty(resolve, "_error", {
        get: () => error
      }));
    }
    if (status === AwaitRenderStatus.error && promise._error instanceof _remix_run_router__WEBPACK_IMPORTED_MODULE_1__.AbortedDeferredError) {
      // Freeze the UI by throwing a never resolved promise
      throw neverSettledPromise;
    }
    if (status === AwaitRenderStatus.error && !errorElement) {
      // No errorElement, throw to the nearest route-level error boundary
      throw promise._error;
    }
    if (status === AwaitRenderStatus.error) {
      // Render via our errorElement
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: errorElement
      });
    }
    if (status === AwaitRenderStatus.success) {
      // Render children with resolved value
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AwaitContext.Provider, {
        value: promise,
        children: children
      });
    }

    // Throw to the suspense boundary
    throw promise;
  }
}

/**
 * @private
 * Indirection to leverage useAsyncValue for a render-prop API on `<Await>`
 */
function ResolveAwait(_ref8) {
  let {
    children
  } = _ref8;
  let data = useAsyncValue();
  let toRender = typeof children === "function" ? children(data) : children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, toRender);
}

///////////////////////////////////////////////////////////////////////////////
// UTILS
///////////////////////////////////////////////////////////////////////////////

/**
 * Creates a route config from a React "children" object, which is usually
 * either a `<Route>` element or an array of them. Used internally by
 * `<Routes>` to create a route config from its children.
 *
 * @see https://reactrouter.com/utils/create-routes-from-children
 */
function createRoutesFromChildren(children, parentPath) {
  if (parentPath === void 0) {
    parentPath = [];
  }
  let routes = [];
  react__WEBPACK_IMPORTED_MODULE_0__.Children.forEach(children, (element, index) => {
    if (! /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(element)) {
      // Ignore non-elements. This allows people to more easily inline
      // conditionals in their route config.
      return;
    }
    let treePath = [...parentPath, index];
    if (element.type === react__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
      // Transparently support React.Fragment and its children.
      routes.push.apply(routes, createRoutesFromChildren(element.props.children, treePath));
      return;
    }
    !(element.type === Route) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "[" + (typeof element.type === "string" ? element.type : element.type.name) + "] is not a <Route> component. All component children of <Routes> must be a <Route> or <React.Fragment>") : 0 : void 0;
    !(!element.props.index || !element.props.children) ?  true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_invariant)(false, "An index route cannot have child routes.") : 0 : void 0;
    let route = {
      id: element.props.id || treePath.join("-"),
      caseSensitive: element.props.caseSensitive,
      element: element.props.element,
      Component: element.props.Component,
      index: element.props.index,
      path: element.props.path,
      loader: element.props.loader,
      action: element.props.action,
      errorElement: element.props.errorElement,
      ErrorBoundary: element.props.ErrorBoundary,
      hasErrorBoundary: element.props.ErrorBoundary != null || element.props.errorElement != null,
      shouldRevalidate: element.props.shouldRevalidate,
      handle: element.props.handle,
      lazy: element.props.lazy
    };
    if (element.props.children) {
      route.children = createRoutesFromChildren(element.props.children, treePath);
    }
    routes.push(route);
  });
  return routes;
}

/**
 * Renders the result of `matchRoutes()` into a React element.
 */
function renderMatches(matches) {
  return _renderMatches(matches);
}

function mapRouteProperties(route) {
  let updates = {
    // Note: this check also occurs in createRoutesFromChildren so update
    // there if you change this -- please and thank you!
    hasErrorBoundary: route.ErrorBoundary != null || route.errorElement != null
  };
  if (route.Component) {
    if (true) {
      if (route.element) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `Component` and `element` on your route - " + "`Component` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      element: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.Component),
      Component: undefined
    });
  }
  if (route.HydrateFallback) {
    if (true) {
      if (route.hydrateFallbackElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `HydrateFallback` and `hydrateFallbackElement` on your route - " + "`HydrateFallback` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      hydrateFallbackElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.HydrateFallback),
      HydrateFallback: undefined
    });
  }
  if (route.ErrorBoundary) {
    if (true) {
      if (route.errorElement) {
         true ? (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.UNSAFE_warning)(false, "You should not include both `ErrorBoundary` and `errorElement` on your route - " + "`ErrorBoundary` will be used.") : 0;
      }
    }
    Object.assign(updates, {
      errorElement: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(route.ErrorBoundary),
      ErrorBoundary: undefined
    });
  }
  return updates;
}
function createMemoryRouter(routes, opts) {
  return (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createRouter)({
    basename: opts == null ? void 0 : opts.basename,
    future: _extends({}, opts == null ? void 0 : opts.future, {
      v7_prependBasename: true
    }),
    history: (0,_remix_run_router__WEBPACK_IMPORTED_MODULE_1__.createMemoryHistory)({
      initialEntries: opts == null ? void 0 : opts.initialEntries,
      initialIndex: opts == null ? void 0 : opts.initialIndex
    }),
    hydrationData: opts == null ? void 0 : opts.hydrationData,
    routes,
    mapRouteProperties,
    unstable_dataStrategy: opts == null ? void 0 : opts.unstable_dataStrategy,
    unstable_patchRoutesOnNavigation: opts == null ? void 0 : opts.unstable_patchRoutesOnNavigation
  }).initialize();
}


//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./src/assets/img/GDPR.jpg":
/*!*********************************!*\
  !*** ./src/assets/img/GDPR.jpg ***!
  \*********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/GDPR.d1985fe1.jpg";

/***/ }),

/***/ "./src/assets/img/SEO.jpg":
/*!********************************!*\
  !*** ./src/assets/img/SEO.jpg ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/SEO.137b0311.jpg";

/***/ }),

/***/ "./src/assets/img/demo2.webp":
/*!***********************************!*\
  !*** ./src/assets/img/demo2.webp ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/demo2.881b9fe2.webp";

/***/ }),

/***/ "./src/assets/img/demo3.webp":
/*!***********************************!*\
  !*** ./src/assets/img/demo3.webp ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/demo3.1b6a748e.webp";

/***/ }),

/***/ "./src/assets/img/freevspro.webp":
/*!***************************************!*\
  !*** ./src/assets/img/freevspro.webp ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/freevspro.0c413593.webp";

/***/ }),

/***/ "./src/assets/img/logo.png":
/*!*********************************!*\
  !*** ./src/assets/img/logo.png ***!
  \*********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/logo.b6274c9c.png";

/***/ }),

/***/ "./src/assets/img/mainDemo.webp":
/*!**************************************!*\
  !*** ./src/assets/img/mainDemo.webp ***!
  \**************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/mainDemo.9a0660f0.webp";

/***/ }),

/***/ "./src/assets/img/pluginsSetup.jpg":
/*!*****************************************!*\
  !*** ./src/assets/img/pluginsSetup.jpg ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/pluginsSetup.504fe50e.jpg";

/***/ }),

/***/ "./src/assets/img/themeClub.webp":
/*!***************************************!*\
  !*** ./src/assets/img/themeClub.webp ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/themeClub.05fad285.webp";

/***/ }),

/***/ "./src/assets/img/themeInstallation.jpg":
/*!**********************************************!*\
  !*** ./src/assets/img/themeInstallation.jpg ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/themeInstallation.adb57799.jpg";

/***/ }),

/***/ "./src/assets/img/vipSupport.jpg":
/*!***************************************!*\
  !*** ./src/assets/img/vipSupport.jpg ***!
  \***************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__.p + "images/vipSupport.361dc737.jpg";

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "React" ***!
  \************************/
/***/ ((module) => {

module.exports = window["React"];

/***/ }),

/***/ "react-dom":
/*!***************************!*\
  !*** external "ReactDOM" ***!
  \***************************/
/***/ ((module) => {

module.exports = window["ReactDOM"];

/***/ }),

/***/ "@wordpress/dom-ready":
/*!**********************************!*\
  !*** external ["wp","domReady"] ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["wp"]["domReady"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ ((module) => {

module.exports = window["wp"]["i18n"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		var scriptUrl;
/******/ 		if (__webpack_require__.g.importScripts) scriptUrl = __webpack_require__.g.location + "";
/******/ 		var document = __webpack_require__.g.document;
/******/ 		if (!scriptUrl && document) {
/******/ 			if (document.currentScript && document.currentScript.tagName.toUpperCase() === 'SCRIPT')
/******/ 				scriptUrl = document.currentScript.src;
/******/ 			if (!scriptUrl) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				if(scripts.length) {
/******/ 					var i = scripts.length - 1;
/******/ 					while (i > -1 && (!scriptUrl || !/^http(s?):/.test(scriptUrl))) scriptUrl = scripts[i--].src;
/******/ 				}
/******/ 			}
/******/ 		}
/******/ 		// When supporting browsers where an automatic publicPath is not supported you must specify an output.publicPath manually via configuration
/******/ 		// or pass an empty string ("") and set the __webpack_public_path__ variable from your code to use your own logic.
/******/ 		if (!scriptUrl) throw new Error("Automatic publicPath is not supported in this browser");
/******/ 		scriptUrl = scriptUrl.replace(/#.*$/, "").replace(/\?.*$/, "").replace(/\/[^\/]+$/, "/");
/******/ 		__webpack_require__.p = scriptUrl;
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "@wordpress/dom-ready");
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/dist/index.js");
/* harmony import */ var _pages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pages */ "./src/pages/index.js");
/* harmony import */ var _scss_style_scss__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./scss/style.scss */ "./src/scss/style.scss");






_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1___default()(() => {
  const root = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createRoot)(document.getElementById('cw-dashboard'));
  root.render((0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(react_router_dom__WEBPACK_IMPORTED_MODULE_5__.BrowserRouter, null, (0,react__WEBPACK_IMPORTED_MODULE_0__.createElement)(_pages__WEBPACK_IMPORTED_MODULE_3__["default"], null))));
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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