<?php
get_header();
?>

	<div id="container">
		<div id="content" role="main">

	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

		<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
			<?php soft_team_postdate()?>
			<h2 class="page_title">
				<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a>
			</h2>
			<small>by <?php the_author() ?></small>
			<div class="entry">
            		<?php if ( has_post_thumbnail() ) { 
                            echo "<a href=\"" . get_permalink() . "\">";
                            the_post_thumbnail();
                            echo "</a>";
                    } ?>
				<?php the_content('<p>Read the rest of this entry &raquo;</p>'); ?>
				<?php wp_link_pages(array('before' => '<p class="clear">Pages: ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
				<?php the_tags( '<p class="postmetadata clear">Tags: ', ', ', '</p>'); ?>

				<p class="postmetadata clear">
					Categories: <?php the_category(', ') ?> | 
					<?php comments_popup_link( 'No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
                     <?php edit_post_link(  __( 'Edit', 'soft_team' ), '| <span class="edit-link">', '</span>') ?>	
				</p>
				<hr class="divider" />
                <div class="navigation">
                    <div class="alignleft"><?php previous_post_link('&laquo; %link') ?></div>
                    <div class="alignright"><?php next_post_link('%link &raquo;') ?></div>
                </div>	
			</div>
			<?php comments_template(); ?>
		</div>

	<?php endwhile; else: ?>

		<h2 class="page_title">Not Found</h2>
		<p>Sorry, no posts matched your criteria.</p>
		<?php get_search_form(); ?>

<?php endif; ?>

	</div>
	</div>

<?php get_footer(); ?>
