<?php

/* Front page (index / blog page) template */

get_header(); ?>

		<section id="container">
			<div id="content" role="main">
				
				<?php /* Start the Loop */ ?>
				<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>
		<?php get_template_part( 'content', get_post_format() );?>

			<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
				<?php soft_team_postdate()?>
				<h2 class="page_title">
					<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a>
				</h2>
				<small>by <?php the_author() ?></small>
				<div class="entry">
					<?php if ( has_post_thumbnail() ) { 
                            echo "<a href=\"" . get_permalink() . "\">";
                            the_post_thumbnail();
                            echo "</a>";
                    } ?>
					<?php the_content( 'Read the rest of this entry' . ' &raquo;'); ?>
					<?php wp_link_pages(array('before' => '<p class="clear">Pages: ', 'after' => '</p>', 'next_or_number' => 'number')); ?>

					<p class="postmetadata clear">
						Categories: <?php the_category(', ') ?> | 
						<?php comments_popup_link( 'No Comments' . ' &#187;', '1 ' . 'Comment' . ' &#187;', '% ' . 'Comments' . ' &#187;'); ?>
                         <?php edit_post_link(  __( 'Edit', 'soft_team' ), '| <span class="edit-link">', '</span>') ?>	
					</p>
				
				</div>
			</div>
			<hr class="divider" />
            
            		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Older Entries' ) ?></div>
			<div class="alignright"><?php previous_posts_link( 'Newer Entries &raquo;') ?></div>
		</div>

	<?php else : ?>

		<h2 class="page_title">Not Found</h2>
		<p>Sorry, no posts matched your criteria.</p>
		<?php get_search_form(); ?>

	<?php endif; ?>
	</div><!-- #content -->
	</section><!--#container -->
<?php get_footer(); ?>

		

			