<?php
require( get_template_directory() . '/inc/register-sidebars.php' );


if ( ! function_exists( 'soft_team_setup' ) ):
function soft_team_setup() {
	
//   This theme styles the visual editor with editor-style.css to match the theme style.
	     add_editor_style();

//   Set the content width based on the theme's design and stylesheet.
 
            if ( ! isset( $content_width ) )
	          $content_width = 700;
			  
// Add default posts and comments RSS feed links to <head>
	
	add_theme_support( 'automatic-feed-links' );
	
//  Add support for Post Formats
	add_theme_support( 'post-formats', array( 'aside', 'gallery', 'link', 'video', 'image', 'quote' ) );
	
add_theme_support('post-thumbnails');
set_post_thumbnail_size( 160, 120, true );	
	
//  Add support for custom beckgrounds.

   add_theme_support( 'custom-background', array(
	// Background color default
	'default-color' => 'CCCCCC',
) );

//   Custom menus
	     register_nav_menus( array(
		'header_menu' => __( 'Header Menu', 'soft_team' )
	) );
	}
endif;
add_action( 'after_setup_theme', 'soft_team_setup' );

//  Adds Title

	function soft_team_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() )
		return $title;

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'soft_team' ), max( $paged, $page ) );

	return $title;
}
add_filter( 'wp_title', 'soft_team_wp_title', 10, 2 );

 
 
//   Template for comments and pingbacks.


if ( ! function_exists( 'soft_team_comment' ) ) :

function soft_team_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'os_slider' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( 'Edit', 'soft_team' ), '<span class="edit-link">', '</span>' ); ?></p>
	<?php
			break;
		default :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<article id="comment-<?php comment_ID(); ?>" class="comment">
			<footer class="comment-meta">
				<div class="comment-author vcard">
					<?php
						$avatar_size = 68;
						if ( '0' != $comment->comment_parent )
							$avatar_size = 20;

						echo get_avatar( $comment, $avatar_size );

						/* translators: 1: comment author, 2: date and time */
						printf( __( '%1$s on %2$s <span class="says">said:</span>', 'soft_team' ),
							sprintf( '<span class="fn">%s</span>', get_comment_author_link() ),
							sprintf( '<a href="%1$s"><time datetime="%2$s">%3$s</time></a>',
								esc_url( get_comment_link( $comment->comment_ID ) ),
								get_comment_time( 'c' ),
								/* translators: 1: date, 2: time */
								sprintf( __( '%1$s at %2$s', 'soft_team' ), get_comment_date(), get_comment_time() )
							)
						);
					?>

					<?php edit_comment_link( __( 'Edit', 'soft_team' ), '<span class="edit-link">', '</span>' ); ?>
				</div><!-- .comment-author .vcard -->

				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'soft_team' ); ?></em>
					<br />
				<?php endif; ?>

			</footer>

			<div class="comment-content"><?php comment_text(); ?></div>

			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply <span>&darr;</span>', 'soft_team' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
		</article><!-- #comment-## -->

	<?php
			break;
	endswitch;
}
endif; 
function soft_team_scripts() {
	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'soft_team_scripts' );


// Returns a "Continue Reading" link for excerpts
 
function soft_team_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'soft_team' ) . '</a>';
}


function soft_team_postdate() {
	?>
    <div class="postdate">
	<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">
		<span class="post-day"><?php the_time('j'); ?></span>
    	<span class="post-month"><?php the_time('M'); ?></span>
		<span class="post-year"><?php the_time('Y'); ?></span>
    </a>
    </div>
	<?php
}
 /*Adds the individual sections for custom logo*/

 function soft_team_theme_customizer( $wp_customize ) {
   $wp_customize->add_section( 'soft_team_logo_section' , array(
    'title'       => __( 'Logo', 'soft_team' ),
    'priority'    => 30,
    'description' => 'Upload a logo',
) );
$wp_customize->add_setting( 'soft_team_logo' );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'soft_team_logo', array(
    'label'    => __( 'Choose your logo (ideal width is 100-300px and ideal height is 40-100px)', 'soft_team' ),
    'section'  => 'soft_team_logo_section',
    'settings' => 'soft_team_logo',
) ) );
}
add_action('customize_register', 'soft_team_theme_customizer');
function soft_team_wp() {
	?><div class="colophon">
    Theme by <a href="http://organiksoft.com/web-development/">Organiksoft</a> | 
	Copyright <?php echo date('Y'); ?> <?php bloginfo('name'); ?> | 
	Powered by WordPress |
    </div> <!-- end div.colophon --><?php
}