<?php
/**
 * Template for displaying search forms
 *
 * @package Smart Construction
 */

?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    <div class="search-form-wrapper">
        <span class="screen-reader-text"><?php echo esc_html_x( 'Search for:', 'label', 'smart-construction' ) ?></span>
        <input type="text" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'smart-construction' ) ?>" id="search" class="search-field" value="<?php the_search_query(); ?>" placeholder="<?php echo esc_attr_x( 'Search ...', 'placeholder', 'smart-construction' ) ?>"/>
        <button type="submit" class="search-submit">
            <i class="fa fa-search"></i>
        </button>
    </div>
</form>