<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Smart Construction
 */

get_header(); ?>
	<div id="primary" class="content-area">
		<main id="main" class="site-main blog-posts-wrapper" role="main">
			<section class="blog-section">
				<div class="blog-container">
					<div class="container">
						
							<?php
							if ( have_posts() ) : ?>

								<header class="page-header">
									<div class="container">
										<h1 class="entry-title">
										<?php esc_html_e( 'Search Results', 'smart-construction' ); ?></h1>
									</div>
								</header>
								<div class="page-content">
									<?php
									/* Start the Loop */
									while ( have_posts() ) : the_post();
										$post_link = get_permalink();
									?>
										<article class="post">
											<div class="post-image-wrapper">
												<?php 
													if ( has_post_thumbnail() ) { 
														printf( '<a href="%s">%s</a>', esc_url( $post_link ), get_the_post_thumbnail( $post, 'large' ) );
													}
													else {
												?>
													<img class="default-thumb" src="<?php echo esc_url( get_template_directory_uri() . '/assets/img/post-dummy.png' ); ?>" alt="<?php esc_attr_e( 'Post Image', 'smart-construction' ); ?>">
												<?php
													}
												?>
											</div>
											<div class="post-title-wrapper">
												<?php
												printf( '<h2 class="%s"><a href="%s">%s</a></h2>', 'entry-title', esc_url( $post_link ), esc_html( get_the_title() ) );
												?>
											</div>
											<div class="post-content-wrapper">
												<?php
													the_excerpt();
												?>
											</div>
											<div class="read-more-container">
												<a class="read-more" href="<?php the_permalink();?>"><?php echo esc_html_x( 'Read More', 'label', 'smart-construction' ) ?></a>
											</div>
										</article>
								<?php
									endwhile;
									wp_link_pages();
								?>

								</div>
							<?php
							else :
								get_template_part( 'template-parts/content/no-search' );

							endif; ?>
						
					</div>
				</div>
			</section>
		<?php the_posts_pagination(); ?>
		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();
