<?php
/**
 * Smart Construction Options Panel
 *
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Start Class
if ( ! class_exists( 'Smart_Construction_Options' ) ) {

	class Smart_Construction_Options {

		/**
		 * Returns single theme option
		 *
		 * @since 1.0.0
		 */
		public static function get_theme_option( $id ) {

			if ( get_theme_mod($id) != '' ) {
				return get_theme_mod($id);
			}
			else {
				return null;
			}
		}

		/**
		 * Register Theme settings on Customizer
		 *
		 * @since 1.0.0
		 */
		public static function scto_register( $wp_customize ) {

			$wp_customize->add_section( 'smart_construction_options', 
				array(
					'title'       => __( 'Theme Options', 'smart-construction' ),
					'priority'    => 35,
					'capability'  => 'edit_theme_options',
					'description' => __('Phone Number, Address, Social Media Links and Copyright', 'smart-construction'),
				)
			);

			// Phone Number
			$wp_customize->add_setting( 'smart_construction_phone_number_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_phone_number_text',
			        array(
			            'label'    => __( 'Phone Number', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_phone_number_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			// Address
			$wp_customize->add_setting( 'smart_construction_address_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_address_text',
			        array(
			            'label'    => __( 'Address', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_address_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			// Social Media links
			$wp_customize->add_setting( 'smart_construction_facebook_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_facebook_text',
			        array(
			            'label'    => __( 'Facebook Link', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_facebook_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			$wp_customize->add_setting( 'smart_construction_instagram_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_instagram_text',
			        array(
			            'label'    => __( 'Instagram Link', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_instagram_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			$wp_customize->add_setting( 'smart_construction_twitter_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_twitter_text',
			        array(
			            'label'    => __( 'Twitter Link', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_twitter_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			$wp_customize->add_setting( 'smart_construction_googleplus_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_googleplus_text',
			        array(
			            'label'    => __( 'Google Plus Link', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_googleplus_text_block',
			            'type'     => 'text'
			        )
			    )
			);

			// Copyright
			$wp_customize->add_setting( 'smart_construction_copyright_text_block', array(
				'sanitize_callback' => 'sanitize_text_field'
			) );

			$wp_customize->add_control( new WP_Customize_Control(
			    $wp_customize,
			    'smart_construction_copyright_text',
			        array(
			            'label'    => __( 'Copyright', 'smart-construction' ),
			            'section'  => 'smart_construction_options',
			            'settings' => 'smart_construction_copyright_text_block',
			            'type'     => 'textarea'
			        )
			    )
			);

		}
	}	
}

// Setup the Theme Customizer settings and controls...
add_action( 'customize_register' , array( 'smart_construction_options' , 'scto_register' ) );


// Helper function to use in theme to return a theme option value
function smart_construction_get_theme_option( $id = '' , $is_link = false) {

	if($is_link) {
		$chars = array('-', ' ', '(', ')');
		return str_replace($chars, "", Smart_Construction_Options::get_theme_option( $id ));
	}
	else {
		return Smart_Construction_Options::get_theme_option( $id );
	}

	return false;
}

// Helper function to use in theme to check if any of the option has value
function smart_construction_check_options( $ids = array() ) {
	$has_value = 0;

	foreach($ids as $id) {

		if( Smart_Construction_Options::get_theme_option( $id ) ){
			$has_value++;
		}
	}

	if($has_value == 0) {
		return false;
	}
	else {
		return true;
	}
}