<?php
/**
 * Custom page walker for this theme.
 *
 * @package WordPress
 * @subpackage Smart Construction
 * @since Smart Construction 1.0
 */

if ( ! class_exists( 'Smart_Construction_Walker_Page' ) ) {
	/**
	 * CUSTOM PAGE WALKER
	 * A custom walker for pages.
	 */
	class Smart_Construction_Walker_Page extends Walker_Nav_Menu {

		function start_el(&$output, $item, $depth=0, $args=[], $id=0) {
				if(!$item->classes) {
					$css_class = array('page_item', 'page-item-' . $item->ID);
			        if (!empty($current_page) && $item->ID == $current_page) {
			            $css_class[] = 'current_page_item';
			        }

			        if (isset($args['has_children']) && $args['has_children']) {
			            $css_class[] = 'menu-item-has-children';
			        }
				}
				else {
					$css_class = $item->classes;
				}

				$output .= "<li class='" .  implode(" ", $css_class) . "'>";

				if ($item->url) {
					$output .= '<a href="' . $item->url . '">';
				} else {
					$output .= '<span>';
				}
		 
				$output .= $item->title;
		 
				if ($item->url) {
					$output .= '</a>';
				} else {
					$output .= '</span>';
				}
		 
				if ( is_object( $args ) && isset( $args->walker ) && isset( $args->walker->has_children ) && $args->walker->has_children ) {
					$output .= '<button type="button" class="sub-menu-toggle fill-children-current-color"><span class="screen-reader-text">' . __( 'Show sub menu', 'smart-construction' ) . '</span>' . '<i class="fa fa-chevron-down"></i>' . '</button>';
				}
		}
	}
}
