<?php
/**
 * The template for displaying the header
 *
 * This is the template that displays all of the <head> section, opens the <body> tag and adds the site's header.
 *
 * @package Smart Construction
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php wp_body_open(); ?>
<a class="skip-link screen-reader-text" href="#main_content">
<?php _e( 'Skip to content', 'smart-construction' ); ?></a>
<?php
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	$site_name = get_bloginfo( 'name' );
	$tagline   = get_bloginfo( 'description', 'display' );
	$header_nav_menu = wp_nav_menu(
		array(
			'theme_location' => 'primary',
			'fallback_cb' => false,
			'echo' => false,
			'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
			'container'      => false,
			'menu_class'     => 'main-navigation',
			'walker'   		 => new Smart_Construction_Walker_Page(),
		)
	);

	?>
	<header id="site-header" class="site-header dynamic-header menu-dropdown-tablet" role="banner">
		<div id="top-header">
			<div class="container header-inner">
				<div class="site-branding">
					<div class="site-branding-col logo">
						<?php
						if ( has_custom_logo() ) {
							the_custom_logo();
						} elseif ( $site_name ) {
							?>
							<h1 class="site-title">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php esc_attr_e( 'Home', 'smart-construction' ); ?>" rel="home">
									<?php echo esc_html( $site_name ); ?>
								</a>
							</h1>
							<p class="site-description">
								<?php
								if ( $tagline ) {
									echo esc_html( $tagline );
								}
								?>
							</p>
						<?php } ?>
					</div>

					<?php if(smart_construction_get_theme_option('smart_construction_phone_number_text_block')): ?>
					<div class="site-branding-col">
						<div class="header-widgets">
							<div class="icon-wrapper">
								<i class="fa fa-phone-alt"></i>
							</div>
							<div class="content-wrapper">
								<h3 class="widget-title"><?php esc_html_e( 'Call us for more information:', 'smart-construction' ); ?></h3>
								<div class="textwidget-icon">
									<a href="tel:<?php echo esc_url(smart_construction_get_theme_option('smart_construction_phone_number_text_block', true)); ?>"><h5><?php echo esc_html(smart_construction_get_theme_option('smart_construction_phone_number_text_block')); ?></h5></a>
								</div>
							</div>
						</div>
					</div>
					<?php endif; ?>

					<?php if(smart_construction_get_theme_option('smart_construction_address_text_block')): ?>
					<div class="site-branding-col">
						<div class="header-widgets">
							<div class="icon-wrapper">
								<i class="fa fa-map-marker"></i>
							</div>
							<div class="content-wrapper">
								<h3 class="widget-title"><?php esc_html_e( 'Address', 'smart-construction' ); ?></h3>
								<div class="textwidget-icon">
									<?php echo esc_html(smart_construction_get_theme_option('smart_construction_address_text_block')); ?>
								</div>
							</div>
						</div>
					</div>
					<?php endif; ?>

					<?php if(
						smart_construction_get_theme_option('smart_construction_instagram_text_block') || 
						smart_construction_get_theme_option('smart_construction_facebook_text_block') || 
						smart_construction_get_theme_option('smart_construction_twitter_text_block') || 
						smart_construction_get_theme_option('smart_construction_googleplus_text_block')
					): ?>

					<div class="site-branding-col">
						<h3 class="widget-title">Follow us</h3>
						<ul class="social-media-header">
						<?php 
							$items = array(
								'smart_construction_instagram_text_block'	=>	'fa-instagram', 
								'smart_construction_facebook_text_block'	=>	'fa-facebook', 
								'smart_construction_twitter_text_block'		=>	'fa-twitter', 
							);

							foreach($items as $item => $class):

								if(smart_construction_get_theme_option($item) != ''):
						?>
								<li>
									<a href="<?php echo esc_url(smart_construction_get_theme_option($item)); ?>" class="social-lnk-item">
										<i class="fa <?php echo $class; ?>"></i>
									</a>
								</li>
						<?php
								endif;
							endforeach;
						?>
						</ul>
					</div>
					<?php endif; ?>

				</div>
			</div>
		</div>
		<div class="site-branding-col">
			<div id="menu-header">
				<div class="container header-inner-menu">
					<div class="main-navigation-wrapper">
						<?php if ( $header_nav_menu ) : ?>
							<button class="site-navigation-toggle-holder">
								<div class="site-navigation-toggle">
									<i class="eicon-menu-bar"></i>
									<span class="elementor-screen-only"><?php echo __( 'Menu', 'smart-construction' ); ?></span>
								</div>
							</button>
							<nav class="site-navigation" role="navigation" aria-label="<?php _e( 'Main Menu', 'smart-construction' ); ?>">
								<div class="menu-primary-navigation-container">
									<?php echo $header_nav_menu; ?>
								</div>
							</nav>
						<?php else: ?>
							<button class="site-navigation-toggle-holder">
								<div class="site-navigation-toggle">
									<i class="eicon-menu-bar"></i>
									<span class="elementor-screen-only"><?php echo __( 'Menu', 'smart-construction' ); ?></span>
								</div>
							</button>
							<nav class="site-navigation" role="navigation" aria-label="<?php _e( 'Main Menu', 'smart-construction' ); ?>">
								<div class="menu-primary-navigation-container">
									<ul id="menu-primary-navigation" class="main-navigation">
										<?php 
											wp_nav_menu(array(
												'fallback_cb' => smart_construction_fallback_to_wp_list_pages()
											));
										?>
									</ul>
								</div>
							</nav>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</header>

	<div class="mobile-menu-modal" id="mobile_modal">

		<div class="modal-inner">
			<div class="align-right">
				<button class="site-navigation-toggle-holder mobile-close">
					<div class="site-navigation-toggle">
						<span><?php echo __( 'Close Menu', 'smart-construction' ); ?></span>
						<i class="eicon-close"></i>
					</div>
				</button>
			</div>
			
			<nav class="site-navigation-mobile" aria-label="Mobile">
				<?php
					if ( $header_nav_menu ){
						echo $header_nav_menu;
					}
					else {
				?>
					<ul id="menu-primary-navigation" class="main-navigation">
						<?php 
							wp_nav_menu(array(
								'fallback_cb' => smart_construction_fallback_to_wp_list_pages()
							));
						?>
					</ul>
				<?php
					} 
				?>
			</nav>
		</div>
	</div>