<?php
/**
 * Theme functions and definitions
 *
 * @package Smart Construction
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

define( 'SMART_CONSTRUCTION_VERSION', '1.0' );
define( 'SMART_CONSTRUCTION_THEME_NAME', 'Smart Construction' );
define( 'SMART_CONSTRUCTION_THEME_SLUG', 'smart-construction' );

if ( ! function_exists( 'smart_construction_setup' ) ) {

    function smart_construction_setup() {
        register_nav_menus( array(
            'primary' => __( 'Primary Menu', 'smart-construction' ),
            'footer' => __( 'Footer Menu', 'smart-construction' )
        ));

        register_sidebar( array(
            'name' => __( 'Footer Widget 1', 'smart-construction' ),
            'id' => 'footer-sidebar-1',
            'description' => 'Appears in the footer area',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ));

        register_sidebar( array(
            'name' => __( 'Social Media Footer ', 'smart-construction' ),
            'id' => 'footer-social-links',
            'description' => 'Appears in the footer area',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ));

        add_editor_style('/assets/css/editor-style');

        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'automatic-feed-links' );
        add_theme_support( 'title-tag' );
        add_theme_support(
            'html5',
            [
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
            ]
        );

        add_theme_support( 'custom-background', apply_filters( 'smart_construction_custom_background_args', array(
            'default-color' => 'fff',
            'default-image' => '',
        ) ) );

        add_theme_support(
            'custom-logo',
            [
                'height'      => 100,
                'width'       => 350,
                'flex-height' => true,
                'flex-width'  => true,
            ]
        );

        add_theme_support( "responsive-embeds" );
        add_theme_support( 'align-wide' );
        add_theme_support( 'wp-block-styles' );
    }

    add_filter('excerpt_more','__return_false');
}
add_action( 'after_setup_theme', 'smart_construction_setup' );

remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' );

if ( ! function_exists( 'smart_construction_widgets_init' ) ) {
    
    function smart_construction_widgets_init() {
        register_sidebar( array (
            'name' => __( 'Main Sidebar', 'smart-construction' ),
            'id' => 'sidebar-1',
            'description' => __( 'Appears on posts and pages except the optional Front Page template, which has its own widgets', 'smart-construction' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ));
    }
}
add_action( 'widgets_init', 'smart_construction_widgets_init' );

if ( ! function_exists( 'smart_construction_scripts_styles' ) ) {

    function smart_construction_scripts_styles() {

        wp_enqueue_style(
            'smart_construction',
            get_template_directory_uri() . '/style.css',
            [],
            SMART_CONSTRUCTION_VERSION
        );

        wp_enqueue_style(
            'smart_construction-style',
            get_template_directory_uri() . '/theme.min.css',
            [],
            SMART_CONSTRUCTION_VERSION
        );

        wp_enqueue_style(
            'font-awesome',
            get_template_directory_uri() . '/assets/css/font-awesome.css',
            [],
            SMART_CONSTRUCTION_VERSION
        );

        wp_enqueue_script( 
            'smart_construction-custom_script', 
            get_stylesheet_directory_uri() . '/assets/js/smart_construction_script.js', 
            array( 'jquery' ), 
            SMART_CONSTRUCTION_VERSION
        );

    }
}
add_action( 'wp_enqueue_scripts', 'smart_construction_scripts_styles' );

add_filter('wp_list_pages_args', function ($args) {
    unset($args['title_li']); // Ensure no unwanted title is added
    return $args;
});

function smart_construction_fallback_to_wp_list_pages() {
    wp_list_pages(array(
        'title_li' => '', // Removes the default title
        'walker' => new Smart_Construction_Walker_Page(),
        'echo'     => false,
    ));
}

/*Plugin Recommendation*/
require get_template_directory() . '/includes/tgm/class-tgm-plugin-activation.php';
require get_template_directory() . '/includes/tgm/hook-tgm.php';  

/*Theme Options*/
require get_template_directory() . '/includes/smart-construction-theme-options.php';
require get_template_directory() . '/includes/class-smart-construction-walker-page.php';
