<?php
/**
 * The template for displaying the footer.
 *
 * Contains the body & html closing tags.
 *
 * @package Smart Construction
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

	$footer_nav_menu = wp_nav_menu( [
		'theme_location' => 'footer',
		'fallback_cb' => false,
		'echo' => false,
	] );
	?>
	<footer id="site-footer" class="site-footer dynamic-footer" role="contentinfo">
		<div class="container">

			<div class="footer-inner">
			    <div id="footer-widgets" class="clearfix">
					<?php
					for ( $i=1; $i <= 2; $i++ ) :
						echo '<div class="footer-widget">';
						dynamic_sidebar( 'footer-sidebar-'.$i );
						echo '</div> <!-- end .footer-widget -->';
					endfor;
					?>

					<div class="footer-widget">

						<?php if(smart_construction_get_theme_option('smart_construction_phone_number_text_block')): ?>
						<div class="footer-widgets">
							<div class="icon-wrapper">
								<i class="fa fa-phone-alt"></i>
							</div>
							<div class="content-wrapper">
								<h3 class="widget-title"><?php esc_html_e( 'Get in Touch', 'smart-construction' ); ?></h3>
								<div class="textwidget-icon">
									<a href="tel:<?php echo esc_url(smart_construction_get_theme_option('smart_construction_phone_number_text_block', true)); ?>"><?php echo esc_html(smart_construction_get_theme_option('smart_construction_phone_number_text_block')); ?></a>
								</div>
							</div>
						</div>
						<?php endif; ?>

						<?php if(smart_construction_get_theme_option('smart_construction_address_text_block')): ?>
						<div class="footer-widgets address">
							<div class="icon-wrapper">
								<i class="fa fa-map-marker"></i>
							</div>
							<div class="content-wrapper">
								<div class="textwidget-icon">
									<?php echo esc_html(smart_construction_get_theme_option('smart_construction_address_text_block')); ?>
								</div>
							</div>
						</div>
						<?php endif; ?>

					</div>

			    </div> <!-- #footer-widgets -->
			</div>  

			<?php if ( $footer_nav_menu ) : ?>
				<nav class="footer-navigation" role="navigation">
					<?php echo $footer_nav_menu; ?>
				</nav>
			<?php endif; ?>
			
		</div>

		<?php if(smart_construction_get_theme_option('smart_construction_copyright_text_block')): ?>
		<div id="footer_bottom">
			<div class="container">
				<div class="footer-content">
					<?php echo esc_html(smart_construction_get_theme_option('smart_construction_copyright_text_block')); ?>
				</div>
			</div>
		</div>
		<?php endif; ?>

	</footer>

<?php wp_footer(); ?>

</body>
</html>
