<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Smart Agency
 */
$smart_agency_categories = get_the_category();
if ($smart_agency_categories) {
	$smart_agency_category = $smart_agency_categories[mt_rand(0, count($smart_agency_categories) - 1)];
} else {
	$smart_agency_category = '';
}
if (has_post_thumbnail()) {
	$smart_agency_imgclass = 'nx-has-img';
} else {
	$smart_agency_imgclass = 'nx-no-img';
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('nx-list-item'); ?>>
	<div class="single-nx-list-item <?php echo esc_attr($smart_agency_imgclass); ?>">
		<?php if (has_post_thumbnail()) : ?>
			<div class="nx-single-list-img">
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail('medium_large'); ?>
				</a>
			</div>
		<?php endif; ?>
		<div class="nx-single-list-details">
			<?php if ($smart_agency_category) : ?>
				<a href="<?php echo esc_url(get_category_link($smart_agency_category)); ?>" class="nx-list-categories"><?php echo esc_html($smart_agency_category->name); ?></a>
			<?php endif; ?>
			<?php the_title('<h2 class="nx-list-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
			<?php the_excerpt(); ?>
			<a class="smart-agency-readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('READ MORE', 'smart-agency'); ?> <i class="fas fa-long-arrow-alt-right"></i></a>

		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->