<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Smart Agency
 */
$smart_agency_blog_layout = get_theme_mod('smart_agency_blog_layout', 'rightside');
if ($smart_agency_blog_layout == 'fullwidth' || !is_active_sidebar('sidebar-1')) {
	$smart_agency_grid = 4;
} else {
	$smart_agency_grid = 6;
}
$smart_agency_categories = get_the_category();
if ($smart_agency_categories) {
	$smart_agency_category = $smart_agency_categories[mt_rand(0, count($smart_agency_categories) - 1)];
} else {
	$smart_agency_category = '';
}
?>
<div class="col-lg-<?php echo esc_attr($smart_agency_grid); ?> grid-item mb-5">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<div class="grid-item-post">
			<?php if (has_post_thumbnail()) : ?>
				<div class="grid-item-img">
					<a class="grid-item-img-link" href="<?php the_permalink(); ?>">
						<?php the_post_thumbnail(); ?>
					</a>
				</div>
			<?php endif; ?>
			<div class="grid-item-details">
				<?php if ($smart_agency_category) : ?>
					<a class="catimg-top" href="<?php echo esc_url(get_category_link($smart_agency_category)); ?>"><?php echo esc_html($smart_agency_category->name); ?></a>
				<?php endif; ?>
				<?php the_title('<h2 class="grid-item-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
				<?php if ('post' === get_post_type()) :
				?>
					<div class="entry-meta grid-meta">
						<?php
						smart_agency_posted_by();
						?>
						<span class="grid-meta-date"><?php echo get_the_date(); ?></span>
						<?php the_excerpt(); ?>
					</div><!-- .entry-meta -->
				<?php endif; ?>

			</div>
		</div>
	</article><!-- #post-<?php the_ID(); ?> -->
</div>