<?php
/**
 * Magical Plugin Activation - Example Implementation
 * 
 * This file demonstrates how to integrate the Magical Plugin Activation toolkit
 * into your WordPress theme. This is a complete example showing various use cases
 * and implementation patterns.
 * 
 * @package magical_plugin_activation
 * @version 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}


/**
 * STEP 2: Define your theme's required and recommended plugins
 * Use the main filter to define your complete plugin list
 */

function wowmart_pro_recommended_plugins($plugins) {
    $theme_plugins = array(

            'elementor' => array(
                'name' => __('Elementor', 'smart-agency'),
                'slug' => 'elementor',
                'file' => 'elementor/elementor.php',
                'description' => __('Create beautiful pages with drag & drop page builder. Perfect for creating stunning layouts with your theme.', 'smart-agency'),
                'category' => 'Page Builder',
                'required' => false,
                'featured' => false,
                'is_local' => false
            ),
            'magical-addons-for-elementor' => array(
                'name' => __('Magical Addons', 'smart-agency'),
                'slug' => 'magical-addons-for-elementor',
                'file' => 'magical-addons-for-elementor/magical-addons-for-elementor.php',
                'description' => __('Enhance your site with a collection of magical addons for Elementor.', 'smart-agency'),
                'category' => 'Essential',
                'required' => false,
                'featured' => true,
                'is_local' => false
            ),
            'magical-posts-display' => array(
                'name' => __('Magical Posts', 'smart-agency'),
                'slug' => 'magical-posts-display',
                'file' => 'magical-posts-display/magical-posts-display.php',
                'description' => __('Enhance your site with a collection of magical Posts widgets for Elementor.', 'smart-agency'),
                'category' => 'Essential',
                'required' => false,
                'featured' => false,
                'is_local' => false
            ),
            'magical-blocks' => array(
                'name' => __('Magical Posts', 'smart-agency'),
                'slug' => 'magical-blocks',
                'file' => 'magical-blocks/magical-blocks.php',
                'description' => __('Enhance your site with a collection of magical Posts widgets for Elementor.', 'smart-agency'),
                'category' => 'Essential',
                'required' => false,
                'featured' => false,
                'is_local' => false
            ),
           
        
    );

    return array_merge($plugins, $theme_plugins);
}
add_filter('magical_plugin_activation_recommended_plugins', 'wowmart_pro_recommended_plugins');

