<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Smart Agency
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */

function smart_agency_body_classes($classes)
{
	// Adds a class of hfeed to non-singular pages.
	if (!is_singular()) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if (!is_active_sidebar('sidebar-1')) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter('body_class', 'smart_agency_body_classes');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function smart_agency_pingback_header()
{
	if (is_singular() && pings_open()) {
		printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
	}
}
add_action('wp_head', 'smart_agency_pingback_header');


function smart_agency_fmain_output()
{
?>
	<br>
	<a href="<?php echo esc_url(__('https://wordpress.org/', 'smart-agency')); ?>">
		<?php
		/* translators: %s: CMS name, i.e. WordPress. */
		printf(esc_html__('Proudly powered by %s', 'smart-agency'), 'WordPress');
		?>
	</a>
	<span class="sep"> | </span>
<?php
	/* translators: 1: Theme name, 2: Theme author. */
	printf(esc_html__('%1$s by %2$s.', 'smart-agency'), '<a href="https://wpthemespace.com/product/smart-agency/">Smart Agency</a>', 'Wp Theme Space');
}
add_action('smart_agency_fmain', 'smart_agency_fmain_output');
