<?php

/**
 * Smart Agency Theme Customizer
 *
 * @package Smart Agency
 */


// adctive call back function for header social
if (!function_exists('smart_agency_header_social_callback')) :
	function smart_agency_header_social_callback()
	{
		if (get_theme_mod('smart_agency_header_social_show') == 1 && get_theme_mod('smart_agency_headertop_show') == 1) {
			return true;
		} else {
			return false;
		}
	}
endif;
// adctive call back function for header social
if (!function_exists('smart_agency_header_top_callback')) :
	function smart_agency_header_top_callback()
	{
		if (get_theme_mod('smart_agency_headertop_show') == 1) {
			return true;
		} else {
			return false;
		}
	}
endif;
// adctive call back function for header social
if (!function_exists('smart_agency_menubar_callback')) :
	function smart_agency_menubar_callback()
	{
		if (get_theme_mod('smart_agency_menubar_show') == 1) {
			return true;
		} else {
			return false;
		}
	}
endif;

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function smart_agency_customize_register($wp_customize)
{
	$wp_customize->get_setting('blogname')->transport         = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

	//select sanitization function
	function smart_agency_sanitize_select($input, $setting)
	{
		$input = sanitize_key($input);
		$choices = $setting->manager->get_control($setting->id)->choices;
		return (array_key_exists($input, $choices) ? $input : $setting->default);
	}
	function smart_agency_sanitize_image($file, $setting)
	{
		$mimes = array(
			'jpg|jpeg|jpe' => 'image/jpeg',
			'gif'          => 'image/gif',
			'png'          => 'image/png',
			'bmp'          => 'image/bmp',
			'tif|tiff'     => 'image/tiff',
			'ico'          => 'image/x-icon'
		);
		//check file type from file name
		$file_ext = wp_check_filetype($file, $mimes);
		//if file has a valid mime type return it, otherwise return default
		return ($file_ext['ext'] ? $file : $setting->default);
	}

	$wp_customize->add_setting('smart_agency_hide_tagline', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  ' ',
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hide_tagline', array(
		'label'      => __('Hide Site Tagline?', 'smart-agency'),
		'section'    => 'title_tagline',
		'settings'   => 'smart_agency_hide_tagline',
		'type'       => 'checkbox',
	));

	$wp_customize->add_panel('smart_agency_settings', array(
		'priority'       => 50,
		'title'          => __('Smart Agency Theme settings', 'smart-agency'),
		'description'    => __('All Smart Agency theme settings', 'smart-agency'),
	));
	$wp_customize->add_section('smart_agency_header', array(
		'title' => __('Smart Agency Header Settings', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'description'     => __('Smart Agency theme header settings', 'smart-agency'),
		'panel'    => 'smart_agency_settings',

	));

	$wp_customize->add_setting('smart_agency_headertop_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  '',
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_headertop_show', array(
		'label'      => __('Show Header Top?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_headertop_show',
		'type'       => 'checkbox',
	));
	$wp_customize->add_setting('smart_agency_mlogo_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  '1',
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_mlogo_show', array(
		'label'      => __('Show Header Top Logo?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_mlogo_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_header_top_callback',

	));
	$wp_customize->add_setting('smart_agency_search_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  '1',
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_search_show', array(
		'label'      => __('Show Header Search?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_search_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_header_top_callback',

	));
	$wp_customize->add_setting('smart_agency_header_social_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  '',
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_header_social_show', array(
		'label'      => __('Show Header Social?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_header_social_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_header_top_callback',

	));
	// header social link start
	// Header facebook url
	$wp_customize->add_setting('smart_agency_hfacebook_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hfacebook_link', array(
		'label'      => __('Header Facebook url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_hfacebook_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header twitter url
	$wp_customize->add_setting('smart_agency_htwitter_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_htwitter_link', array(
		'label'      => __('Header Twitter url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_htwitter_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header linkedin url
	$wp_customize->add_setting('smart_agency_hlinkedin_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hlinkedin_link', array(
		'label'      => __('Header Linkedin url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_hlinkedin_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header linkedin url
	$wp_customize->add_setting('smart_agency_hyoutube_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hyoutube_link', array(
		'label'      => __('Header Youtube url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_hyoutube_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header pinterest url
	$wp_customize->add_setting('smart_agency_hpinterest_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hpinterest_link', array(
		'label'      => __('Header Pinterest url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_hpinterest_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header INSTAGRAM url
	$wp_customize->add_setting('smart_agency_hinstagram_link', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_hinstagram_link', array(
		'label'      => __('Header Instagram url', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_hinstagram_link',
		'type'       => 'url',
		'active_callback' => 'smart_agency_header_social_callback',
	));
	// Header Menu bar

	$wp_customize->add_setting('smart_agency_menubar_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  1,
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_menubar_show', array(
		'label'      => __('Show Menubar Section?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_menubar_show',
		'type'       => 'checkbox',
	));

	$wp_customize->add_setting('smart_agency_menubarlogo_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  1,
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_menubarlogo_show', array(
		'label'      => __('Show Menubar Logo?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_menubarlogo_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_menubar_callback',

	));
	$wp_customize->add_setting('smart_agency_mainmenu_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  1,
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_mainmenu_show', array(
		'label'      => __('Show Main Menu?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_mainmenu_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_menubar_callback',

	));
	$wp_customize->add_setting('smart_agency_menusearch_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  1,
		'sanitize_callback' => 'absint',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_menusearch_show', array(
		'label'      => __('Show Menubar Search Icon?', 'smart-agency'),
		'section'    => 'smart_agency_header',
		'settings'   => 'smart_agency_menusearch_show',
		'type'       => 'checkbox',
		'active_callback' => 'smart_agency_menubar_callback',
	));

	//Smart agency Home intro
	$wp_customize->add_section('smart_agency_intro', array(
		'title' => __('Agency Intro Settings', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'description'     => __('Agency Intro section settings', 'smart-agency'),
		'panel'    => 'smart_agency_settings',
	));
	$wp_customize->add_setting('smart_agency_intro_show', array(
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'default'       =>  1,
		'sanitize_callback' => 'absint',
		'transport'     => 'refresh',
	));
	$wp_customize->add_control('smart_agency_intro_show', array(
		'label'      => __('Show Agency Intro? ', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_intro_show',
		'type'       => 'checkbox',
	));
	$wp_customize->add_setting('smart_agency_intro_img', array(
		'capability'        => 'edit_theme_options',
		'default'           => get_template_directory_uri() . '/assets/img/smart-man.png',
		'sanitize_callback' => 'smart_agency_sanitize_image',
	));
	$wp_customize->add_control(new WP_Customize_Image_Control(
		$wp_customize,
		'smart_agency_intro_img',
		array(
			'label'    => __('Upload Profile Image', 'smart-agency'),
			'description'    => __('Image size should be 450px width & 460px height for better view.', 'smart-agency'),
			'section'  => 'smart_agency_intro',
			'settings' => 'smart_agency_intro_img',
		)
	));
	$wp_customize->add_setting('smart_agency_intro_subtitle', array(
		'default' => __('Best Marketing Agency', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'sanitize_text_field',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_intro_subtitle', array(
		'label'      => __('Intro Subtitle', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_intro_subtitle',
		'type'       => 'text',
	));
	$wp_customize->add_setting('smart_agency_intro_title', array(
		'default' => __('Creative Consulting Agency', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'sanitize_text_field',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_intro_title', array(
		'label'      => __('Intro Title', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_intro_title',
		'type'       => 'text',
	));
	$wp_customize->add_setting('smart_agency_intro_desc', array(
		'default' => '',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'wp_kses_post',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_intro_desc', array(
		'label'      => __('Intro Description', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_intro_desc',
		'type'       => 'textarea',
	));
	$wp_customize->add_setting('smart_agency_btn_text_one', array(
		'default' => __('LEARN MORE', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'sanitize_text_field',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control('smart_agency_btn_text_one', array(
		'label'      => __('Button one text', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_btn_text_one',
		'type'       => 'text',
	));

	$wp_customize->add_setting('smart_agency_btn_url_one', array(
		'default' => '#',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_btn_url_one', array(
		'label'      => __('Button one url', 'smart-agency'),
		'description'      => __('Keep url empty for hide this button', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_btn_url_one',
		'type'       => 'url',
	));
	$wp_customize->add_setting('smart_agency_btn_text_two', array(
		'default'     => __('EXPLORE MORE', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'sanitize_text_field',
		'transport' => 'postMessage',
	));
	$wp_customize->add_control('smart_agency_btn_text_two', array(
		'label'      => __('Button two text', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_btn_text_two',
		'type'       => 'text',
	));

	$wp_customize->add_setting('smart_agency_btn_url_two', array(
		'default' => '',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'esc_url_raw',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_btn_url_two', array(
		'label'      => __('Button two url', 'smart-agency'),
		'description'      => __('Keep url empty for hide this button', 'smart-agency'),
		'section'    => 'smart_agency_intro',
		'settings'   => 'smart_agency_btn_url_two',
		'type'       => 'text',
	));


	//Smart Agency PLus blog settings
	$wp_customize->add_section('smart_agency_blog', array(
		'title' => __('Smart Agency Blog Settings', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'description'     => __('Smart Agency theme blog settings', 'smart-agency'),
		'panel'    => 'smart_agency_settings',

	));
	$wp_customize->add_setting('smart_agency_blog_container', array(
		'default'        => 'container',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'smart_agency_sanitize_select',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_blog_container', array(
		'label'      => __('Container type', 'smart-agency'),
		'description' => __('You can set standard container or full width container. ', 'smart-agency'),
		'section'    => 'smart_agency_blog',
		'settings'   => 'smart_agency_blog_container',
		'type'       => 'select',
		'choices'    => array(
			'container' => __('Standard Container', 'smart-agency'),
			'container-fluid' => __('Full width Container', 'smart-agency'),
		),
	));

	$wp_customize->add_setting('smart_agency_blog_layout', array(
		'default'        => 'rightside',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'smart_agency_sanitize_select',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_blog_layout', array(
		'label'      => __('Select Blog Layout', 'smart-agency'),
		'description' => __('Right and Left sidebar only show when sidebar widget is available. ', 'smart-agency'),
		'section'    => 'smart_agency_blog',
		'settings'   => 'smart_agency_blog_layout',
		'type'       => 'select',
		'choices'    => array(
			'rightside' => __('Right Sidebar', 'smart-agency'),
			'leftside' => __('Left Sidebar', 'smart-agency'),
			'fullwidth' => __('No Sidebar', 'smart-agency'),
		),
	));
	$wp_customize->add_setting('smart_agency_blog_style', array(
		'default'        => 'grid',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'smart_agency_sanitize_select',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_blog_style', array(
		'label'      => __('Select Blog Style', 'smart-agency'),
		'section'    => 'smart_agency_blog',
		'settings'   => 'smart_agency_blog_style',
		'type'       => 'select',
		'choices'    => array(
			'grid' => __('Grid Style', 'smart-agency'),
			'list' => __('List Style', 'smart-agency'),
			'classic' => __('Classic Style', 'smart-agency'),
		),
	));
	//Smart Agency page settings
	$wp_customize->add_section('smart_agency_page', array(
		'title' => __('Smart Agency Page Settings', 'smart-agency'),
		'capability'     => 'edit_theme_options',
		'description'     => __('Smart Agency theme blog settings', 'smart-agency'),
		'panel'    => 'smart_agency_settings',

	));
	$wp_customize->add_setting('smart_agency_page_container', array(
		'default'        => 'container',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'smart_agency_sanitize_select',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_page_container', array(
		'label'      => __('Page Container type', 'smart-agency'),
		'description' => __('You can set standard container or full width container for page. ', 'smart-agency'),
		'section'    => 'smart_agency_page',
		'settings'   => 'smart_agency_page_container',
		'type'       => 'select',
		'choices'    => array(
			'container' => __('Standard Container', 'smart-agency'),
			'container-fluid' => __('Full width Container', 'smart-agency'),
		),
	));
	$wp_customize->add_setting('smart_agency_page_header', array(
		'default'        => 'show',
		'capability'     => 'edit_theme_options',
		'type'           => 'theme_mod',
		'sanitize_callback' => 'smart_agency_sanitize_select',
		'transport' => 'refresh',
	));
	$wp_customize->add_control('smart_agency_page_header', array(
		'label'      => __('Show Page header', 'smart-agency'),
		'section'    => 'smart_agency_page',
		'settings'   => 'smart_agency_page_header',
		'type'       => 'select',
		'choices'    => array(
			'show' => __('Show all pages', 'smart-agency'),
			'hide-home' => __('Hide Only Front Page', 'smart-agency'),
			'hide' => __('Hide All Pages', 'smart-agency'),
		),
	));




	if (isset($wp_customize->selective_refresh)) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'smart_agency_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'smart_agency_customize_partial_blogdescription',
			)
		);
	}
}
add_action('customize_register', 'smart_agency_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function smart_agency_customize_partial_blogname()
{
	echo esc_html(get_bloginfo('name', 'display'));
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function smart_agency_customize_partial_blogdescription()
{
	echo esc_html(get_bloginfo('description', 'display'));
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function smart_agency_customize_preview_js()
{
	wp_enqueue_script('smart-agency-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array('customize-preview'), SMART_AGENCY_VERSION, true);
}
add_action('customize_preview_init', 'smart_agency_customize_preview_js');
