<?php

/**
 * About setup
 *
 * @package Smart Agency
 */

require_once trailingslashit(get_template_directory()) . 'inc/about/class.about.php';

if (!function_exists('smart_agency_about_setup')) :

	/**
	 * About setup.
	 *
	 * @since 1.0.0
	 */
	function smart_agency_about_setup()
	{
		$theme = wp_get_theme();
		$xtheme_name = $theme->get('Name');
		$xtheme_domain = $theme->get('TextDomain');
		if ($xtheme_domain == 'x-magazine') {
			$theme_slug = $xtheme_domain;
		} else {
			$theme_slug = 'smart-agency';
		}



		$config = array(
			// Menu name under Appearance.
			'menu_name'               => sprintf(esc_html__('%s Info', 'smart-agency'), $xtheme_name),
			// Page title.
			'page_name'               => sprintf(esc_html__('%s Info', 'smart-agency'), $xtheme_name),
			/* translators: Main welcome title */
			'welcome_title'         => sprintf(esc_html__('Welcome to %s! - Version ', 'smart-agency'), $theme['Name']),
			// Main welcome content
			// Welcome content.
			'welcome_content' => sprintf(esc_html__('%1$s is now installed and ready to use. We want to make sure you have the best experience using the theme and that is why we gathered here all the necessary information for you. Thanks for using our theme!', 'smart-agency'), $theme['Name']),

			// Tabs.
			'tabs' => array(
				'getting_started' => esc_html__('Getting Started', 'smart-agency'),
				'recommended_actions' => esc_html__('Recommended Actions', 'smart-agency'),
				'useful_plugins'  => esc_html__('Useful Plugins', 'smart-agency'),
				'free_pro'  => esc_html__('Free Vs Pro', 'smart-agency'),
			),

			// Quick links.
			'quick_links' => array(
				'xmagazine_url' => array(
					'text'   => esc_html__('UPGRADE Smart Agency PRO', 'smart-agency'),
					'url'    => 'https://wpthemespace.com/product/smart-agency-pro/?add-to-cart=8160',
					'button' => 'danger',
				),
				'update_url' => array(
					'text'   => esc_html__('View demo', 'smart-agency'),
					'url'    => 'https://sag.fullsitediting.com/demos',
					'button' => 'primery',
				),

			),

			// Getting started.
			'getting_started' => array(
				'one' => array(
					'title'       => esc_html__('Demo Content', 'smart-agency'),
					'icon'        => 'dashicons dashicons-layout',
					'description' => sprintf(esc_html__('Demo content is pro feature. To import sample demo content, %1$s plugin should be installed and activated. After plugin is activated, visit Import Demo Data menu under Appearance.', 'smart-agency'), esc_html__('One Click Demo Import', 'smart-agency')),
					'button_text' => esc_html__('UPGRADE For  Demo Content', 'smart-agency'),
					'button_url'  => 'https://wpthemespace.com/product/smart-agency-pro/?add-to-cart=8160',
					'button_type' => 'primary',
					'is_new_tab'  => true,
				),

				'two' => array(
					'title'       => esc_html__('Theme Options', 'smart-agency'),
					'icon'        => 'dashicons dashicons-admin-customizer',
					'description' => esc_html__('Theme uses Customizer API for theme options. Using the Customizer you can easily customize different aspects of the theme.', 'smart-agency'),
					'button_text' => esc_html__('Customize', 'smart-agency'),
					'button_url'  => wp_customize_url(),
					'button_type' => 'primary',
				),
				'three' => array(
					'title'       => esc_html__('Show Video', 'smart-agency'),
					'icon'        => 'dashicons dashicons-layout',
					'description' => sprintf(esc_html__('You may show Smart Agency short video for better understanding', 'smart-agency'), esc_html__('One Click Demo Import', 'smart-agency')),
					'button_text' => esc_html__('Show video', 'smart-agency'),
					'button_url'  => 'https://www.youtube.com/watch?v=pNlm-ArOHTM&t=18s',
					'button_type' => 'primary',
					'is_new_tab'  => true,
				),
				'five' => array(
					'title'       => esc_html__('Set Widgets', 'smart-agency'),
					'icon'        => 'dashicons dashicons-tagcloud',
					'description' => esc_html__('Set widgets in your sidebar, Offcanvas as well as footer.', 'smart-agency'),
					'button_text' => esc_html__('Add Widgets', 'smart-agency'),
					'button_url'  => admin_url() . '/widgets.php',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
				'six' => array(
					'title'       => esc_html__('Theme Preview', 'smart-agency'),
					'icon'        => 'dashicons dashicons-welcome-view-site',
					'description' => esc_html__('You can check out the theme demos for reference to find out what you can achieve using the theme and how it can be customized. Theme demo only work in pro theme', 'smart-agency'),
					'button_text' => esc_html__('View Demo', 'smart-agency'),
					'button_url'  => 'https://sag.fullsitediting.com/demos',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
				'seven' => array(
					'title'       => esc_html__('Contact Support', 'smart-agency'),
					'icon'        => 'dashicons dashicons-sos',
					'description' => esc_html__('Got theme support question or found bug or got some feedbacks? Best place to ask your query is the dedicated Support forum for the theme.', 'smart-agency'),
					'button_text' => esc_html__('Contact Support', 'smart-agency'),
					'button_url'  => 'https://wpthemespace.com/support/',
					'button_type' => 'link',
					'is_new_tab'  => true,
				),
			),

			'useful_plugins'        => array(
				'description' => esc_html__('Theme supports some helpful WordPress plugins to enhance your site. But, please enable only those plugins which you need in your site. For example, enable WooCommerce only if you are using e-commerce.', 'smart-agency'),
				'already_activated_message' => esc_html__('Already activated', 'smart-agency'),
				'version_label' => esc_html__('Version: ', 'smart-agency'),
				'install_label' => esc_html__('Install and Activate', 'smart-agency'),
				'activate_label' => esc_html__('Activate', 'smart-agency'),
				'deactivate_label' => esc_html__('Deactivate', 'smart-agency'),
				'content'                   => array(
					array(
						'slug' => 'magical-addons-for-elementor',
						'icon' => 'svg',
					),
					array(
						'slug' => 'magical-products-display'
					),
					array(
						'slug' => 'magical-posts-display'
					),
					array(
						'slug' => 'click-to-top'
					),
					array(
						'slug' => 'gallery-box',
						'icon' => 'svg',
					),
					array(
						'slug' => 'magical-blocks'
					),
					array(
						'slug' => 'easy-share-solution',
						'icon' => 'svg',
					),
					array(
						'slug' => 'wp-edit-password-protected',
						'icon' => 'svg',
					),
				),
			),
			// Required actions array.
			'recommended_actions'        => array(
				'install_label' => esc_html__('Install and Activate', 'smart-agency'),
				'activate_label' => esc_html__('Activate', 'smart-agency'),
				'deactivate_label' => esc_html__('Deactivate', 'smart-agency'),
				'content'            => array(
					'magical-blocks' => array(
						'title'       => __('Magical Posts Display', 'smart-agency'),
						'description' => __('Now you can add or update your site elements very easily by Magical Products Display. Supercharge your Elementor block with highly customizable Magical Blocks For WooCommerce.', 'smart-agency'),
						'plugin_slug' => 'magical-products-display',
						'id' => 'magical-posts-display'
					),
					'go-pro' => array(
						'title'       => '<a target="_blank" class="activate-now button button-danger" href="https://wpthemespace.com/product/smart-agency-pro/?add-to-cart=8160">' . __('UPGRADE Smart Agency PRO', 'smart-agency') . '</a>',
						'description' => __('You will get more frequent updates and quicker support with the Pro version.', 'smart-agency'),
						//'plugin_slug' => 'x-instafeed',
						'id' => 'go-pro'
					),

				),
			),
			// Free vs pro array.
			'free_pro'                => array(
				'free_theme_name'     => $xtheme_name,
				'pro_theme_name'      => $xtheme_name . __(' Pro', 'smart-agency'),
				'pro_theme_link'      => 'https://wpthemespace.com/product/smart-agency-pro/',
				/* translators: View link */
				'get_pro_theme_label' => sprintf(__('Get %s', 'smart-agency'), 'Smart Agency Pro'),
				'features'            => array(
					array(
						'title'       => esc_html__('Daring Design for Devoted Readers', 'smart-agency'),
						'description' => esc_html__('Smart Agency\'s design helps you stand out from the crowd and create an experience that your readers will love and talk about. With a flexible home page you have the chance to easily showcase appealing content with ease.', 'smart-agency'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Mobile-Ready For All Devices', 'smart-agency'),
						'description' => esc_html__('Smart Agency makes room for your readers to enjoy your articles on the go, no matter the device their using. We shaped everything to look amazing to your audience.', 'smart-agency'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Home slider', 'smart-agency'),
						'description' => esc_html__('Smart Agency gives you extra slider feature. You can create awesome home slider in this theme.', 'smart-agency'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Widgetized Sidebars To Keep Attention', 'smart-agency'),
						'description' => esc_html__('Smart Agency comes with a widget-based flexible system which allows you to add your favorite widgets over the Sidebar as well as on offcanvas too.', 'smart-agency'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Auto Set-up Feature', 'smart-agency'),
						'description' => esc_html__('You can import demo site only one click so you can setup your site like demo very easily.', 'smart-agency'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Multiple Header Layout', 'smart-agency'),
						'description' => esc_html__('Smart Agency gives you extra ways to showcase your header with miltiple layout option you can change it on the basis of your requirement', 'smart-agency'),
						'is_in_lite'  => 'true',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('One Click Demo install', 'smart-agency'),
						'description' => esc_html__('You can import demo site only one click so you can setup your site like demo very easily.', 'smart-agency'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Extra Drag and drop support', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advanced Portfolio Filter', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Testimonial Carousel', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Diffrent Style Blog', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Flexible Home Page Design', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Pro Service Section', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Animation Home Text', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advance Customizer Options', 'smart-agency'),
						'description' => esc_html__('Advance control for each element gives you different way of customization and maintained you site as you like and makes you feel different.', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('Advance Pagination', 'smart-agency'),
						'description' => esc_html__('Multiple Option of pagination via customizer can be obtained on your site like Infinite scroll, Ajax Button On Click, Number as well as classical option are available.', 'smart-agency'),
						'is_in_lite'  => 'ture',
						'is_in_pro'   => 'true',
					),

					array(
						'title'       => esc_html__('Premium Support and Assistance', 'smart-agency'),
						'description' => esc_html__('We offer ongoing customer support to help you get things done in due time. This way, you save energy and time, and focus on what brings you happiness. We know our products inside-out and we can lend a hand to help you save resources of all kinds.', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
					array(
						'title'       => esc_html__('No Credit Footer Link', 'smart-agency'),
						'description' => esc_html__('You can easily remove the Theme: Smart Agency by Smart Agency copyright from the footer area and make the theme yours from start to finish.', 'smart-agency'),
						'is_in_lite'  => 'false',
						'is_in_pro'   => 'true',
					),
				),
			),

		);

		smart_agency_About::init($config);
	}

endif;

add_action('after_setup_theme', 'smart_agency_about_setup');


/**
 * Pro notice text
 *
 */
function newspaper_eye_pnotice_output()
{
?>

	<div class="mgadin-hero">
		<div class="mge-info-content">
			<div class="mge-info-hello">
				<?php
				$current_theme = wp_get_theme();
				$current_theme_name = $current_theme->get('Name');
				$current_user = wp_get_current_user();

				$demo_link = esc_url('https://wpthemespace.com/product/smart-agency-pro/');
				$pro_link = esc_url('https://wpthemespace.com/product/smart-agency-pro/?add-to-cart=8160');


				esc_html_e('Hello, ', 'smart-agency');
				echo esc_html($current_user->display_name);
				?>
				<?php esc_html_e('👋🏻', 'smart-agency'); ?>
				<span class="mge-badge"><?php esc_html_e('LIMITED OFFER', 'smart-agency'); ?></span>
			</div>
			<div class="mge-info-desc">
				<div>
					<?php esc_html_e('🚀 ', 'smart-agency'); ?>
					<strong><?php esc_html_e('Unlock the Full Potential of Your Website!', 'smart-agency'); ?></strong>
					<?php esc_html_e(' Upgrade to ', 'smart-agency'); ?>
					<span class="mge-highlight"><?php echo esc_html($current_theme_name); ?> Pro</span>
					<?php esc_html_e(' and get:', 'smart-agency'); ?>
				</div>
				<div style="margin: 12px 0 12px 20px; line-height: 1.8;">
					✓ <strong><?php esc_html_e('One-Click Demo Import', 'smart-agency'); ?></strong> - <?php esc_html_e('Launch your site in minutes', 'smart-agency'); ?><br>
					✓ <strong><?php esc_html_e('Premium Elementor Widgets', 'smart-agency'); ?></strong> - <?php esc_html_e('Advanced design elements', 'smart-agency'); ?><br>
					✓ <strong><?php esc_html_e('SEO Optimized', 'smart-agency'); ?></strong> - <?php esc_html_e('Rank higher in search results', 'smart-agency'); ?><br>
					✓ <strong><?php esc_html_e('Lightning Fast Performance', 'smart-agency'); ?></strong> - <?php esc_html_e('Superior user experience', 'smart-agency'); ?><br>
					✓ <strong><?php esc_html_e('Priority Support', 'smart-agency'); ?></strong> - <?php esc_html_e('Get help when you need it', 'smart-agency'); ?><br>
					✓ <strong><?php esc_html_e('Regular Updates', 'smart-agency'); ?></strong> - <?php esc_html_e('Stay secure & up-to-date', 'smart-agency'); ?>
				</div>
				<div class="mge-offer">
					⚡ <?php esc_html_e('Don\'t let your competitors get ahead! Upgrade now and transform your website today!', 'smart-agency'); ?>
				</div>
			</div>
			<div class="mge-info-actions">
				<a href="<?php echo esc_url($pro_link); ?>" target="_blank" class="button button-primary upgrade-btn">
					<?php esc_html_e('🎯 Upgrade to Pro Now', 'smart-agency'); ?>
				</a>
				<a href="<?php echo esc_url($demo_link); ?>" target="_blank" class="button button-primary demo-btn">
					<?php esc_html_e('👀 View Pro Features', 'smart-agency'); ?>
				</a>
				<button class="button button-info btnend"><?php esc_html_e('Maybe Later', 'smart-agency') ?></button>
			</div>

		</div>

	</div>
<?php
}
//Admin notice 
function newspaper_eye_new_optins_texts()
{
	$hide_date = get_option('smart_agency_info');
	if (!empty($hide_date)) {
		$clickhide = round((time() - strtotime($hide_date)) / 24 / 60 / 60);
		if ($clickhide < 25) {
			return;
		}
	}
?>
	<div class="mgadin-notice notice notice-info mgadin-theme-dashboard mgadin-theme-dashboard-notice mge is-dismissible meis-dismissible">
		<?php newspaper_eye_pnotice_output(); ?>
	</div>
<?php

}
add_action('admin_notices', 'newspaper_eye_new_optins_texts');

function newspaper_eye_new_optins_texts_init()
{
	if (isset($_GET['xbnotice']) && $_GET['xbnotice'] == 1) {
		update_option('smart_agency_info', current_time('mysql'));
	}
}
add_action('init', 'newspaper_eye_new_optins_texts_init');
