<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Smart Agency
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php echo esc_attr(get_bloginfo('charset')); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'smart-agency'); ?></a>
		<header class="header" id="header">
			<?php do_action('smart_agency_mobile_menu'); ?>

			<?php
			if (get_theme_mod('smart_agency_headertop_show')) {
				do_action('smart_agency_header_logo');
			}

			?>
			<?php do_action('smart_agency_main_menu'); ?>
		</header>
		<?php
		$smart_agency_intro_show = get_theme_mod('smart_agency_intro_show', 1);
		if ($smart_agency_intro_show && (is_home() || is_front_page())) {
			do_action('smart_agency_profile_intro');
		}

		?>