<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Smart Agency
 */

?>

<footer id="colophon" class="site-footer pt-3 pb-3">
	<div class="container">
		<div class="info-news site-info text-center">
			&copy;
			<?php
			/* translators: Copyright date format, see https://www.php.net/date */
			echo esc_html(wp_date('Y'));
			?>
			<a href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html(get_bloginfo('name', 'display')); ?></a>
			<?php

			do_action('smart_agency_fmain');

			?>
		</div>
	</div><!-- .container -->
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>