<?php
/*
*
* Home intro section for Smart Agency section
*
*
*/



function smart_agency_intro_section_output()
{
  $smart_agency_dfimgh = get_template_directory_uri() . '/assets/img/smart-man.png';
  $smart_agency_intro_img = get_theme_mod('smart_agency_intro_img', $smart_agency_dfimgh);
  $smart_agency_intro_subtitle = get_theme_mod('smart_agency_intro_subtitle', __('Best Marketing Agency', 'smart-agency'));
  $smart_agency_intro_title = get_theme_mod('smart_agency_intro_title', __('Creative Consulting Agency', 'smart-agency'));
  $smart_agency_intro_desc = get_theme_mod('smart_agency_intro_desc');
  $smart_agency_btn_text_one = get_theme_mod('smart_agency_btn_text_one', __('LEARN MORE', 'smart-agency'));
  $smart_agency_btn_url_one = get_theme_mod('smart_agency_btn_url_one', '#');
  $smart_agency_btn_text_two = get_theme_mod('smart_agency_btn_text_two', __('EXPLORE MORE', 'smart-agency'));
  $smart_agency_btn_url_two = get_theme_mod('smart_agency_btn_url_two');
?>
  <!-- home -->
  <section class="home-intro" id="sa-home">
    <div class="container">
      <div class="home-all-content">
        <div class="row">
          <div class="col-lg-6">
            <div class="content">
              <?php if ($smart_agency_intro_subtitle) : ?>
                <h5><?php echo esc_html($smart_agency_intro_subtitle); ?></h5>
              <?php endif; ?>
              <?php if ($smart_agency_intro_title) : ?>
                <h1><?php echo esc_html($smart_agency_intro_title); ?></h1>
              <?php endif; ?>
              <?php if ($smart_agency_intro_desc) : ?>
                <p><?php echo esc_html($smart_agency_intro_desc); ?></p>
              <?php endif; ?>
              <?php if ($smart_agency_btn_url_one) : ?>
                <a href="<?php echo esc_url($smart_agency_btn_url_one); ?>" class="btn btn-hero agbtn1"><?php echo esc_html($smart_agency_btn_text_one); ?></a>
              <?php endif; ?>
              <?php if ($smart_agency_btn_url_two) : ?>
                <a href="<?php echo esc_url($smart_agency_btn_url_two); ?>" class="btn btn-hero agbtn2"><?php echo esc_html($smart_agency_btn_text_two); ?></a>
              <?php endif; ?>
            </div>

          </div>

          <div class="col-lg-6">
            <?php if ($smart_agency_intro_img) : ?>
              <div class="hero-img">
                <img src="<?php echo esc_url($smart_agency_intro_img); ?>" alt="<?php esc_attr($smart_agency_intro_title); ?>">
              <?php else : ?>
                <div class="hero-img px-noimg">
                <?php endif; ?>
                </div>

              </div>

          </div>
        </div>
      </div>
  </section>

<?php
}
add_action('smart_agency_profile_intro', 'smart_agency_intro_section_output');
